package sim.util;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class BubbleListener implements MouseListener
{
	private Component parent;
	
	private long bubbleInterval;
	private String text;
	public static BubbleWaitThread WAIT_THREAD;
	
	public BubbleListener(Component source, String help, long wait)
	{
		this.parent = source;
		this.bubbleInterval = wait;
		this.text = help;
	}
	
	public void mouseEntered(MouseEvent event)
	{
		BubbleListener.WAIT_THREAD.reset(this.text, this.parent, this.bubbleInterval);
	}

	public void mousePressed(MouseEvent event)
	{
		BubbleListener.WAIT_THREAD.halt();
	}

	public void mouseExited(MouseEvent event)
	{
		BubbleListener.WAIT_THREAD.halt();
	}
	
	public void mouseClicked(MouseEvent event)
	{
	}
	
	public void mouseReleased(MouseEvent event)
	{
	}
}