package sim.lib.wires;

import java.awt.*;

import sim.*;
import sim.engine.*;

public class ThinWire extends Wire
{
/* ==================================================================
	Creation Part
	================================================================= */
	public Image getIcon()
	{
		return GuiFileLink.getImage("sim/lib/wires/WireIcon.gif");
	}
	
	public Wrapper createWrapper()
	{
		return (new ThinWire());
	}
	
	public Wrapper createWrapper(Point gridPosition)
	{
		ThinWire result = new ThinWire();
		result.setGridLocation(gridPosition);
		return result;
	}
	
	public String getBubbleHelp()
	{
		return "Wire";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public ThinWire()
	{
		super();
		this.setNumberOfNodes(1);
	}

	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			g.setColor(this.brush);
			Dimension size = this.getSize();
			int increment = Wire.THICKNESS / 2;
		
			if(this.orientation == Wire.HORIZONTAL_ORIENTATION)
				g.drawLine(0, increment, size.width, increment);
			else
				g.fillRect(increment, 0, 1, size.height);
		}
	}

/* ==================================================================
	Wire Responce to Signal
	================================================================= */
	public void respondToUndefined()
	{
		this.changeColor(Color.black);
	}
	
	public void respondToTrue()
	{
		this.changeColor(SimulationProperties.ONE_COLOR);
	}
	
	public void respondToFalse()
	{
		this.changeColor(SimulationProperties.ZERO_COLOR);
	}
	
	public void reset()
	{
		this.changeColor(Color.black);
	}
}