package sim;

import java.awt.*;
import java.awt.event.*;

import sim.util.DialogButton;
import sim.util.ImagePanel;

public class AboutWindow extends Dialog implements ActionListener
{
	private ImagePanel about = new ImagePanel(GuiFileLink.getImage("sim/images/About.gif"));

	public AboutWindow()
	{
		super(MainWindow.MAIN_WINDOW, "About");

		this.setSize(481, 260);
		this.setLocation(MainWindow.getMiddleOfScreen(this));

		this.setLayout(new GridBagLayout());
		this.setModal(true);
		this.setResizable(false);

		GridBagConstraints c = new GridBagConstraints();

		c.fill = GridBagConstraints.NONE;
		c.weightx = 1;
		c.weighty = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		c.anchor = GridBagConstraints.EAST;
		c.gridx = 0;

		c.gridy = 0;
		c.insets = new Insets(10, 15, 10, 15);
		this.add(this.about, c);

		DialogButton b = new DialogButton("OK");
		b.addActionListener(this);

		c.gridy = 1;
		c.insets = new Insets(10, 15, 10, 15);
		this.add(b, c);

		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				setVisible(false);
			}
		});
	}

	public void addNotify()
	{
		super.addNotify();

		int width = 30 + this.about.getSize().width + this.getInsets().left + this.getInsets().right;
		int height = 40 + this.about.getSize().height + DialogButton.HEIGHT + this.getInsets().top + this.getInsets().bottom;
		this.setSize(width, height);
		this.doLayout();

		this.setLocation(MainWindow.getMiddleOfScreen(this));
	}

	public void actionPerformed(ActionEvent e)
	{
		this.setVisible(false);
	}
}