package sim;

import java.awt.*;
import java.io.*;
import java.awt.event.*;

import gjt.BulletinLayout;

import sim.util.ImagePanel;
import sim.util.DialogButton;

public class LibraryDialog extends Dialog implements MouseListener, ActionListener
{
	private Choice libraryList;
	private Panel libraries;
	private Panel nameHolder = new Panel(new GridBagLayout());
	private ScrollPane scroller = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);

	private DialogButton remove = new DialogButton("Remove");
	private DialogButton add = new DialogButton("Add");
	private DialogButton ok = new DialogButton("OK");

	private Label selected = null;

	public LibraryDialog(Choice list, Panel library)
	{
		super(MainWindow.MAIN_WINDOW);
		this.setLayout(new GridBagLayout());
		this.setTitle("Libraries");
		this.setSize(300, 370);
		this.setResizable(false);
		this.setModal(true);

		this.libraries = library;
		this.libraryList = list;

		Panel p = new Panel(new FlowLayout(FlowLayout.RIGHT, 10, 0));
		p.add(this.add);
		p.add(this.remove);
		p.add(this.ok);

		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.EAST;
		c.weightx = 0;
		c.weighty = 0;
		c.gridx = 0;
		c.gridy = 2;
		c.gridwidth = 1;
		c.gridheight = 1;
		c.insets = new Insets(10, 0, 10, 0);
		this.add(p, c);

		c.gridy = 0;
		c.anchor = GridBagConstraints.WEST;
		c.insets = new Insets(10, 0, 0, 0);
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 10, 0));
		p.add(new ImagePanel(GuiFileLink.getImage("sim/images/Library.gif")));
		p.add(new Label("Component Sets"));
		this.add(p, c);

		c.gridy = 1;
		c.weightx = 1;
		c.weighty = 1;
		c.anchor = GridBagConstraints.CENTER;
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(10, 10, 10, 10);

		p = new Panel(new BulletinLayout());
		p.add(this.nameHolder);
		p.setBackground(Color.white);
		this.nameHolder.setBackground(Color.white);
		this.nameHolder.setLocation(0, 0);
		this.scroller.add(p);
		this.add(this.scroller, c);

		this.remove.addActionListener(this);
		this.add.addActionListener(this);
		this.ok.addActionListener(this);

		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent event)
			{
				setVisible(false);
			}
		});
	}

	public void setVisible(boolean visible)
	{
		if (visible) {
			int index, count = this.libraryList.getItemCount() - 1;
		
			GridBagConstraints c = new GridBagConstraints();
			c.gridy = GridBagConstraints.RELATIVE;
			c.gridx = 0;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.anchor = GridBagConstraints.NORTHWEST;
			c.weightx = 1;
			c.weighty = 1;
			c.gridheight = 1;
			c.gridwidth = 1;
		
			this.nameHolder.removeAll();
			this.remove.setEnabled(false);
		
			Label name;
		
			for(index = 0; index < count; index++)
			{
				name = new Label(this.libraryList.getItem(index), Label.LEFT);
				name.addMouseListener(this);
				this.nameHolder.add(name, c);
			}
		
			if(this.nameHolder.getComponentCount() != 0)
				this.select((Label)this.nameHolder.getComponent(0));
		
			this.setLocation(MainWindow.getMiddleOfScreen(this));
		}
		super.setVisible(visible);
	}

	private void select(Label l)
	{
		if(l != this.selected)
		{
			this.deselect(true);
			this.selected = l;
			this.selected.setForeground(Color.blue);

			CardLayout cl = (CardLayout)this.libraries.getLayout();

			this.libraryList.select(l.getText());
			cl.show(this.libraries, l.getText());



			this.libraries.validate();
			this.scroller.validate();
		}
	}

	private void deselect(boolean enableDelete)
	{
		if(this.selected != null)
		{
			this.selected.setForeground(Color.black);
			this.selected = null;
		}

		this.remove.setEnabled(enableDelete);
	}

	public void mouseClicked(MouseEvent e)
	{
		this.select((Label)e.getSource());
	}

	public void mouseEntered(MouseEvent e)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent e)
	{
	}

	public void mouseReleased(MouseEvent e)
	{
	}

	public void actionPerformed(ActionEvent e)
	{
		int index;
		boolean finish = false;
		Component source = (Component)e.getSource();

		if(source == this.ok)
		{
			this.setVisible(false);
		}
		else if(source == this.remove)
		{
			for(index = 0; (index < this.libraryList.getItemCount()) && !finish; index++)
			{
				if(this.libraryList.getItem(index).equals(this.selected.getText()))
				{
					finish = true;
					this.libraryList.remove(index);
					this.libraries.remove(index);
					this.nameHolder.remove(index);

					if(this.nameHolder.getComponentCount() > index)
						this.select((Label)this.nameHolder.getComponent(index));
					else if(this.nameHolder.getComponentCount() != 0)
						this.select((Label)this.nameHolder.getComponent(index - 1));
					else
						this.deselect(false);
				}
			}
		}
		else if(source == this.add)
		{
			SaveLoadShortcut.FILEDIALOG.setTitle("Load Library");
			SaveLoadShortcut.FILEDIALOG.setMode(FileDialog.LOAD);
			SaveLoadShortcut.FILEDIALOG.setFile("*.lib");
			SaveLoadShortcut.FILEDIALOG.setVisible(true);

			String inFile = SaveLoadShortcut.FILEDIALOG.getFile();

			if(inFile != null)
			{
				try
				{
					inFile = SaveLoadShortcut.FILEDIALOG.getDirectory() + inFile;
					Reader inStream = new BufferedReader(new FileReader(inFile));
					ModulePanel loaded = SaveLoadShortcut.GUI_FILE_LINK.loadLibrary(inStream);
					inStream.close();


					for(index = 0; (index < this.libraryList.getItemCount()) && !finish; index++)
					{
						if(this.libraryList.getItem(index).equals(loaded.getName()))
							finish = true;
					}

					if(finish)
					{
						MainWindow.OK_WINDOW.setDescription("Cannot load " + loaded.getName());
						MainWindow.OK_WINDOW.setMessage("It is already loaded");
						MainWindow.OK_WINDOW.setVisible(true);
					}
					else
					{
						GridBagConstraints c = new GridBagConstraints();
						c.gridy = GridBagConstraints.RELATIVE;
						c.gridx = 0;
						c.fill = GridBagConstraints.HORIZONTAL;
						c.anchor = GridBagConstraints.NORTHWEST;
						c.weightx = 1;
						c.weighty = 1;
						c.gridheight = 1;
						c.gridwidth = 1;

						this.libraryList.insert(loaded.getName(), this.libraryList.getItemCount() - 1);
						this.libraries.add(loaded.getName(), loaded);

						Label l = new Label(loaded.getName(), Label.LEFT);
						l.addMouseListener(this);
						this.nameHolder.add(l, c);

						this.select(l);
					}
				}
				catch(IOException exc)
				{
					MainWindow.OK_WINDOW.setDescription("Cannot load library");
					MainWindow.OK_WINDOW.setMessage("IO exception has occured");
					MainWindow.OK_WINDOW.setVisible(true);
				}

				catch(SimException exc)
				{
					MainWindow.OK_WINDOW.setDescription("Cannot load library");
					MainWindow.OK_WINDOW.setMessage(exc.getMessage());
					MainWindow.OK_WINDOW.setVisible(true);
				}

				this.requestFocus();
			}
		}
	}
}
