package sim;

import java.awt.*;
import java.awt.event.*;

public class WrapperMenu extends PopupMenu implements ActionListener
{
	private MenuItem delete = new MenuItem("Delete");
	
	private Menu angles;
	private MenuItem rotateLeft = new MenuItem("Rotate Left");
	private MenuItem rotateRight = new MenuItem("Rotate Right");
	private MenuItem flipHorizontal = new MenuItem("Flip Horizontal");
	private MenuItem flipVertical = new MenuItem("Flip Vertical");
	private MenuItem properties = new MenuItem("Properties");
	
	public static PropertyDialog PROPERTY_DIALOG;
	
	private Wrapper target;
	
	public WrapperMenu()
	{
		super();
		
		WrapperMenu.PROPERTY_DIALOG = new PropertyDialog();
		
		this.angles = new Menu("Rotate to...");
		
		MenuItem mi = new MenuItem("0");
		mi.addActionListener(this);
		this.angles.add(mi);
		
		mi = new MenuItem("90");
		mi.addActionListener(this);
		this.angles.add(mi);
		
		mi = new MenuItem("180");
		mi.addActionListener(this);
		this.angles.add(mi);
		
		mi = new MenuItem("270");
		mi.addActionListener(this);
		this.angles.add(mi);
		
		this.delete.addActionListener(this);
		this.rotateLeft.addActionListener(this);
		this.rotateRight.addActionListener(this);
		this.flipHorizontal.addActionListener(this);
		this.flipVertical.addActionListener(this);
		this.properties.addActionListener(this);
		
		this.add(this.delete);
		this.addSeparator();
		this.add(this.rotateRight);
		this.add(this.rotateLeft);
		this.add(this.flipVertical);
		this.add(this.flipHorizontal);
		this.add(this.angles);
		this.addSeparator();
		this.add(this.properties);
	}
	
	public void setUp(WrapperList w)
	{
		int loop;
		for(loop = 8; this.getItemCount() > 9; loop ++)
			this.remove(loop);
		
		if(w.getSize() == 1)
		{
			this.target = w.getItemAt(0);
			
			this.rotateLeft.setEnabled(this.target.canRotate());
			this.rotateRight.setEnabled(this.target.canRotate());
			this.angles.setEnabled(this.target.canRotate());
			this.flipHorizontal.setEnabled(this.target.canFlip());
			this.flipVertical.setEnabled(this.target.canFlip());
			
			int insert = this.target.getNumberOfMenuItems();
			MenuItem mi;
			
			for(loop = 0; loop < insert; loop++)
			{
				mi = new MenuItem(this.target.getMenuItemName(loop));
				mi.addActionListener(this);
				this.insert(mi, 8 + loop);
			}
			
			this.properties.setEnabled(this.target.hasProperties());
		}
		else
		{
			this.delete.setEnabled(true);
			this.angles.setEnabled(false);
			this.rotateLeft.setEnabled(false);
			this.rotateRight.setEnabled(false);
			this.flipHorizontal.setEnabled(false);
			this.flipVertical.setEnabled(false);
			this.properties.setEnabled(false);
		}
	}
	
	public void actionPerformed(ActionEvent e)
	{
		MenuItem source = (MenuItem)e.getSource();
		
		if(source == this.delete)
			NorthPanel.EDIT_SHORTCUT.deleteSelected();
		else if(source == this.rotateLeft)
			NorthPanel.EDIT_SHORTCUT.rotateLeft();
		else if(source == this.rotateRight)
			NorthPanel.EDIT_SHORTCUT.rotateRight();
		else if(source == this.flipHorizontal)
			NorthPanel.EDIT_SHORTCUT.flipHorizontal();
		else if(source == this.flipVertical)
			NorthPanel.EDIT_SHORTCUT.flipVertical();
		else if(source.getLabel().equals("0"))
			NorthPanel.EDIT_SHORTCUT.rotateTo(0);
		else if(source.getLabel().equals("90"))
			NorthPanel.EDIT_SHORTCUT.rotateTo(90);
		else if(source.getLabel().equals("180"))
			NorthPanel.EDIT_SHORTCUT.rotateTo(180);
		else if(source.getLabel().equals("270"))
			NorthPanel.EDIT_SHORTCUT.rotateTo(270);
		else if(source == this.properties)
			WrapperMenu.PROPERTY_DIALOG.activate(this.target);
		else
			this.target.respondToMenuItem(source.getLabel());
	}
}
