package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;
import sim.lib.wires.Junction;

public abstract class Function2in1fat1thinOut extends Function
{
/* ==================================================================
	GUI part
	================================================================= */
	public Function2in1fat1thinOut()
	{
		super();
	}
	
	public void initializeGridSize()
	{
		this.setGridSize(6, 4);
	}
	
/* ==================================================================
	Maintanance Part
	================================================================= */
	private Junction inputX = null;
	private Junction inputY = null;
	private Junction output = null;
	private Junction overflow = null;
	
	public boolean canDrop()
	{
		boolean result = Wrapper.canDropJuncion(this.gridLocation.x, this.gridLocation.y + 2, 1);
		result = result && Wrapper.canDropJuncion(this.gridLocation.x + 2, this.gridLocation.y, this.busSize);
		result = result && Wrapper.canDropJuncion(this.gridLocation.x + 3, this.gridLocation.y + 4, this.busSize);
		result = result && Wrapper.canDropJuncion(this.gridLocation.x + 4, this.gridLocation.y, this.busSize);
		
		return result;
	}
		
	public void droped()
	{
		this.overflow = Wrapper.setPinAt(this.gridLocation.x, this.gridLocation.y + 2, 1);
		this.inputX = Wrapper.setPinAt(this.gridLocation.x + 2, this.gridLocation.y, this.busSize);
		this.inputY = Wrapper.setPinAt(this.gridLocation.x + 4, this.gridLocation.y, this.busSize);
		this.output = Wrapper.setPinAt(this.gridLocation.x + 3, this.gridLocation.y + 4, this.busSize);
		
		this.changeColor(Color.black);
		this.oldBusSize = 0;
	}
	
	public void selected()
	{
		this.output.removePin();
		this.overflow.removePin();
		this.inputX.removePin();
		this.inputY.removePin();
		
		this.changeColor(Color.green);
	}
	
	public void checkAfterSelected()
	{
		Wrapper.checkPin(this.output);
		Wrapper.checkPin(this.overflow);
		Wrapper.checkPin(this.inputX);
		Wrapper.checkPin(this.inputY);
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void createEnginePeer(EnginePeerList epl)
	{
		int loop;		
		EnginePeer ep = new EnginePeer(2 * this.busSize, this.busSize + 1, this);
		
		for(loop = 0; loop < this.busSize; loop++)
		{
			ep.setInputPin(loop, this.inputX.getNodes().getItemAt(loop));
			ep.setInputPin(loop + this.busSize, this.inputY.getNodes().getItemAt(loop));
			ep.setOutputPin(loop, this.output.getNodes().getItemAt(loop));
		}
		
		ep.setOutputPin(this.busSize, this.overflow.getNodes().getItemAt(0));
		
		epl.insertItem(ep);
	}
}
