package sim.util;

import java.awt.*;

public class SimSeparator extends Component
{
    public SimSeparator()
	{
        super();
		
        this.setSize(2, 2);
    }
	
	public void setWidth(int width)
	{
		this.setSize(width, 2);
	}
	
	public void setHeight(int height)
	{
		this.setSize(2, height);
	}
	
	public Dimension getPreferredSize()
	{
		return this.getSize();
    }
	
    public void paint(Graphics g)
	{	
		Dimension size = this.getSize();
		Color brighter = SystemColor.controlLtHighlight;
		
		g.setColor(SystemColor.controlShadow);
		
		if(size.width > size.height)
		{	
			size.height = size.height / 2 - 1;
			
			g.drawLine(0, size.height, size.width, size.height);
			g.setColor(brighter);
			g.drawLine(0, size.height + 1, size.width, size.height + 1);
		}
		else
		{
			size.width = size.width / 2 - 1;
			
			g.drawLine(size.width, 0, size.width, size.height);
			g.setColor(brighter);
			g.drawLine(size.width + 1, 0, size.width + 1, size.height);
		}
    }
}
