package sim.lib;

import java.awt.*;
import java.awt.event.*;

import sim.util.SimSeparator;

public class EditDelay extends Container implements ActionListener
{
	private TextField editDelay = new TextField(10);
	private Label simulation = new Label("Simulation");
	private double old;
	
	public EditDelay(double initial)
	{
		super();
		this.setLayout(new BorderLayout(0, 15));
		
		this.old = initial;
		
		Panel p = new Panel(new BorderLayout());
		p.add(this.simulation, BorderLayout.WEST);
		p.add(new SimSeparator(), BorderLayout.CENTER);
		this.add(p, BorderLayout.NORTH);
		
		p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		p.add(new Label("Propagation Delay"));
		p.add(this.editDelay);
		this.add(p, BorderLayout.CENTER);
		
		this.editDelay.addActionListener(this);
		this.editDelay.setText(Double.toString(initial));
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.setSize(290, this.editDelay.getPreferredSize().height + this.simulation.getPreferredSize().height + 15);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		double newDelay;
		
		try
		{
			newDelay = Double.valueOf(this.editDelay.getText()).doubleValue();
			
			if(newDelay < 0)
				this.editDelay.setText(Double.toString(this.old));
			else
				this.old = newDelay;
		}
		catch(NumberFormatException nfe)
		{
			this.editDelay.setText(Double.toString(this.old));
		}
	}
	
	public double getDelay()
	{
		double newDelay;
		
		try
		{
			newDelay = Double.valueOf(this.editDelay.getText()).doubleValue();
			
			if(newDelay >= 0)
				this.old = newDelay;
		}
		catch(NumberFormatException nfe)
		{
		}
		
		return this.old;
	}
	
	public Dimension getPreferredSize()
	{
		return this.getSize();
	}
	
	public Dimension getMinimumSize()
	{
		return this.getSize();
	}

	public Dimension getMaximumSize()
	{
		return this.getSize();
	}
}
