package sim.util;

import java.awt.*;

public class ImagePanel extends Panel
{
	private Image icon;
	
	public ImagePanel()
	{
		super();
		this.icon = null;
	}
	
	public ImagePanel(Image i)
	{
		super();
		this.icon = i;
		this.setSize(i.getWidth(this), i.getHeight(this));
	}
	
	public void setImage(Image i)
	{
		this.icon = i;
		this.setSize(i.getWidth(this), i.getHeight(this));
	}
	
	public void paint(Graphics g)
	{
		g.drawImage(this.icon, 0, 0, this);
	}
	
	public Dimension getPreferredSize()
	{
		return (new Dimension(this.icon.getWidth(this), this.icon.getHeight(this)));
	}
	
	public Dimension getMinimumSize()
	{
		return (new Dimension(this.icon.getWidth(this), this.icon.getHeight(this)));
	}
	
	public Dimension getMaximumSize()
	{
		return (new Dimension(this.icon.getWidth(this), this.icon.getHeight(this)));
	}
	
}
