package sim.util;

import java.awt.*;
import java.awt.event.*;


public class LightButton extends Component
{
	private String text;
	private boolean isRaised = true;
	private boolean armed = false;
	private ActionListener action = null;
	
	public LightButton(int width, int height)
	{
		super();
		this.setSize(width, height);
		this.text = null;
	}

	public LightButton(int width, int height, String s)
	{
		super();
		this.setSize(width, height);
		this.text = s;
	}

    public boolean isRaised()
	{ 
		return this.isRaised;
	}
	
	public void setRaised()
	{
		this.isRaised = true;
	}
	
    public boolean isInset()
	{ 
		return (!this.isRaised);
	}
	
	public void setInset()
	{
		this.isRaised = false;
	}
	
	public String getText()
	{
		return this.text;
	}
	
	public void setText(String s)
	{
		this.text = s;
	}

    public void paint(Graphics g)
	{
		Dimension size = this.getSize();
		
		g.setColor(this.getBackground());
		
		g.fillRect(0, 0, size.width, size.height);
		
        if(this.isRaised)
		{
			g.setColor(this.getBackground().brighter());
			g.drawLine(0, 0, 0, size.height - 1);
			g.drawLine(0, 0, size.width - 1, 0);
			
			g.setColor(this.getBackground().darker());
			g.drawLine(0, size.height - 1, size.width, size.height - 1);
			g.drawLine(size.width - 1, 1, size.width - 1, size.height);
		}
        else
		{
			g.setColor(this.getBackground().darker());
			g.fillRect(0, 0, size.width, 2);
			g.fillRect(0, 0, 2, size.height);
			
			g.setColor(this.getBackground().brighter());
			g.drawLine(1, size.height - 1, size.width, size.height - 1);
			g.drawLine(size.width - 1, 1, size.width - 1, size.height);
		}
		
		if(this.text != null)
		{
			//draw string	
		}
    }
	
	public void setArmed(boolean b)
	{
		this.armed = b;
	}
	
	public boolean isArmed()
	{
		return this.armed;
	}
	
	public synchronized void addActionListener(ActionListener listener)
	{
		this.action = AWTEventMulticaster.add(this.action, listener);
    }
	
    public synchronized void removeActionListener(ActionListener listener)
	{
		this.action = AWTEventMulticaster.remove(this.action, listener);
    }
	
	public void processActionEvent()
	{
		if(this.action != null)
			this.action.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "LightButton Action"));
		
		this.setArmed(false);
	}
}