
/*********************************************************************/
/*  File:  Robotersimulation                                         */
/*                                                                   */
/*  Author: Rainer Pollak                                            */
/*********************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/X.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h> 
#include <search.h>

#include "rs_Daten.h"
#include "rs_Kin.h"
#include "rs_X.h"


extern double sqrt ();

/* ************************ Funktionen **************************** */ 

void Winkelberechnung ( x,y,z,wy,wx,d )
double x;     /* neues Projektionszentrum   */
double y;
double z;
double *wy;   /* Rotationswinkel um Y-Achse */
double *wx;   /* Rotationswinkel um X-Achse */
double *d;    /* Position auf der Z-Achse   */
{
 double betrag;
 double hx,hy,hz;

 betrag = sqrt ( x*x + z*z );

 /* Berechnung des Winkelbetrages wy */
 if ( betrag == 0 ) {
                     *wy = 0.0;
                    }
 else               {
                     *wy = acos( z / betrag );
                    }

 /* Berechnung des Vorzeichens von wy */
 if (  x > 0 ) *wy = -*wy;

 /* Rotation um die Y-Achse */
 hx = cos(*wy)*x + sin(*wy)*z;
 hy = y;
 hz = cos(*wy)*z - sin(*wy)*x;

 betrag = sqrt ( hx*hx + hy*hy + hz*hz );

 /* Berechnung des Winkelbetrages wx */
 *wx = acos( (hz)/betrag );

 /* Berechnung des Vorzeichens von wx */
 if ( hy < 0 ) *wx = -*wx;

 /* Rotation um X-Achse */
 x = hx;
 y = cos(*wx)*hy - sin(*wx)*hz;
 z = sin(*wx)*hy + cos(*wx)*hz;

 /* Test ob neues Projektionszentrum nahe genug
    an der Z-Achse liegt                        */
 if ((fabs(x)<0.01)&&(fabs(y)<0.01)) {
                                       *d = z;
                                      }
 else                                 {
                                       exit(1);
                                      }      
}

/* ---------------------------------------------------------------- */

void Projektion ( pl,ph,fl,fpl,ebene,clipp,Anzahl_Pkte,Anzahl_Fl,wy,wx,d,stdpkt )
Points pl[];
Points ph[]; 
Flaechen fl[];
Flaechen_Punkte_Liste fpl[];
XPoint ebene[5];
int *clipp;
int Anzahl_Pkte;
int Anzahl_Fl;
double wy;
double wx;
double d;
short stdpkt;
{
 int i,anfang,merker,j,indx;
 double m,x,y,z;
 static double c_wy,s_wy,s_wxs_wy,c_wx,c_wxs_wy,
               s_wx,c_wxc_wy,s_wxc_wy;
 Points ebene3D[5];
 

  c_wy = cos(wy);
  c_wx = cos(wx);
  s_wy = sin(wy);
  s_wx = sin(wx);
  s_wxs_wy = s_wx * s_wy;
  s_wxc_wy = s_wx * c_wy;
  c_wxs_wy = c_wx * s_wy;
  c_wxc_wy = c_wx * c_wy;
  anfang = 0;

/* ---------------------------------------------------
     Rotation der Punkte, so dass Betrachter auf der
     Z-Achse steht.
   --------------------------------------------------- */

errvariable = 0;

 for ( i=anfang;i<Anzahl_Pkte;i++)
  {
   ph[i].x = c_wy * pl[i].x + s_wy * pl[i].z;
   ph[i].y = s_wxs_wy * pl[i].x + c_wx * pl[i].y - s_wxc_wy * pl[i].z;
   ph[i].z = s_wx * pl[i].y - c_wxs_wy * pl[i].x + c_wxc_wy * pl[i].z;

   if ( ph[i].z >= ( d-2.0) ) errvariable = 1;

  }

/* ------------------------------------------------------
   Initialisierung der Flaechen_Punkte_Liste
   ------------------------------------------------------ */
   
   for ( i=0 ; i<Anzahl_Fl ; i++ )
    {
     fpl[i].p[0].x = ph[ fl[i].p1 ].x;
     fpl[i].p[0].y = ph[ fl[i].p1 ].y;
     fpl[i].p[0].z = ph[ fl[i].p1 ].z;
     fpl[i].zmin = fpl[i].p[0].z;

     fpl[i].p[1].x = ph[ fl[i].p2 ].x;
     fpl[i].p[1].y = ph[ fl[i].p2 ].y;
     fpl[i].p[1].z = ph[ fl[i].p2 ].z; 
     if ( fpl[i].zmin > fpl[i].p[1].z ) fpl[i].zmin = fpl[i].p[1].z;


     fpl[i].p[2].x = ph[ fl[i].p3 ].x;
     fpl[i].p[2].y = ph[ fl[i].p3 ].y;
     fpl[i].p[2].z = ph[ fl[i].p3 ].z;
     if ( fpl[i].zmin > fpl[i].p[2].z ) fpl[i].zmin = fpl[i].p[2].z;

     
     fpl[i].p[3].x = ph[ fl[i].p4 ].x;
     fpl[i].p[3].y = ph[ fl[i].p4 ].y;
     fpl[i].p[3].z = ph[ fl[i].p4 ].z; 
     if ( fpl[i].zmin > fpl[i].p[3].z ) fpl[i].zmin = fpl[i].p[3].z; 
    }   

/* --------------------------------------------------------
    3 D - Clippingalgorithmus fuer die Ebene
   -------------------------------------------------------- */
    
    indx = 0;
    for ( i=0 ; i<4; i++ )
    {
     if ( i == 3 ) j = 0;
     else j = i + 1;

     if ( fpl[0].p[i].z < (d-2) ) 
     {
      ebene3D[indx].x = fpl[0].p[i].x;
      ebene3D[indx].y = fpl[0].p[i].y;
      ebene3D[indx].z = fpl[0].p[i].z;
      indx++;
      if ( fpl[0].p[j].z >= (d-2))
      {     /* Es muss geclippt werden */
       m = ( (d-2) - fpl[0].p[i].z ) / ( fpl[0].p[j].z - fpl[0].p[i].z);
       ebene3D[indx].x = fpl[0].p[i].x + m * ( fpl[0].p[j].x - fpl[0].p[i].x);
       ebene3D[indx].y = fpl[0].p[i].y + m * ( fpl[0].p[j].y - fpl[0].p[i].y);
       ebene3D[indx].z = fpl[0].p[i].z + m * ( fpl[0].p[j].z - fpl[0].p[i].z);
       indx++;
      }
     }
     else  /* fpl[0].p[i].z >= ( d-2) */
     {
      if ( fpl[0].p[j].z < (d-2) )
      { /* Es muss geclippt werden */
       m = ( (d-2) - fpl[0].p[i].z ) / ( fpl[0].p[j].z - fpl[0].p[i].z);
       ebene3D[indx].x = fpl[0].p[i].x + m * ( fpl[0].p[j].x - fpl[0].p[i].x);
       ebene3D[indx].y = fpl[0].p[i].y + m * ( fpl[0].p[j].y - fpl[0].p[i].y);
       ebene3D[indx].z = fpl[0].p[i].z + m * ( fpl[0].p[j].z - fpl[0].p[i].z);
       indx++;

      }
     }
    }

   *clipp = indx;
   for ( i=0; i<indx; i++ )
   {
     m = ((-30.0) / (ebene3D[i].z - d )) * 5.0;
     ebene[i].x = (short)( 250.0 + m * ebene3D[i].x);
     ebene[i].y = (short)( 200.0 - m * ebene3D[i].y);
   } 

/* --------------------------------------------------------
   Ermittlung des Schnittpunktes mit der Projektions-
   ebene
   -------------------------------------------------------- */

   for ( i=1 ; i<Anzahl_Fl ; i++ )
    {
     
      m = ((-30.0) / (fpl[i].p[0].z - d )) * 5.0;
      fpl[i].pp[0].x = (short)( 250.0 + m * fpl[i].p[0].x);
      fpl[i].pp[0].y = (short)( 200.0 - m * fpl[i].p[0].y);

      m = ((-30.0) / (fpl[i].p[1].z - d)) * 5.0;
      fpl[i].pp[1].x = (short)( 250.0 + m * fpl[i].p[1].x);
      fpl[i].pp[1].y = (short)( 200.0 - m * fpl[i].p[1].y);
 
      m = ((-30.0) / (fpl[i].p[2].z - d )) * 5.0;
      fpl[i].pp[2].x = (short)( 250.0 + m * fpl[i].p[2].x);
      fpl[i].pp[2].y = (short)( 200.0 - m * fpl[i].p[2].y);
 
      m = ((-30.0) / (fpl[i].p[3].z - d)) * 5.0;
      fpl[i].pp[3].x = (short)( 250.0 + m * fpl[i].p[3].x);
      fpl[i].pp[3].y = (short)( 200.0 - m * fpl[i].p[3].y);

      fpl[i].C = fpl[i].pp[0].x * ( fpl[i].pp[1].y - fpl[i].pp[2].y )
                +fpl[i].pp[1].x * ( fpl[i].pp[2].y - fpl[i].pp[0].y )
                +fpl[i].pp[2].x * ( fpl[i].pp[0].y - fpl[i].pp[1].y );
      fpl[i].C = -fpl[i].C;
    }

   }


/* ---------------------------------------------------------------- */

double Z_min ( fpl,anfang,ende )
Flaechen_Punkte_Liste fpl[];
int anfang;
int ende;
{
 int i;
 double hilf;

 hilf = fpl[anfang].zmin;
 for( i=anfang+1 ; i<ende+1 ; i++ )
 {
  if ( hilf > fpl[i].zmin ) hilf = fpl[i].zmin;
 } 
 return( hilf );
}

/* ---------------------------------------------------------------- */

void Shift ( k,pos )
sort k[];
int pos;
{
 int i;

 for ( i=5 ; i>pos-1 ; i=i-1 ) {
                                k[i+1].teil = k[i].teil;
                                k[i+1].z = k[i].z;
                               }
}
/* ---------------------------------------------------------------- */

void Test ( fpl,ph,fnr,d,anfang,ende,merker )
Flaechen_Punkte_Liste fpl[];
Points ph[];
int fnr;
double d;
int anfang;
int ende;
int *merker;
{
 double A,B,C,k;
 double Nenner,m;
 int i;

    /* Berechnung der Flaechenparameter */

 A = fpl[fnr].p[0].y * ( fpl[fnr].p[1].z - fpl[fnr].p[2].z )
    +fpl[fnr].p[1].y * ( fpl[fnr].p[2].z - fpl[fnr].p[0].z )
    +fpl[fnr].p[2].y * ( fpl[fnr].p[0].z - fpl[fnr].p[1].z );

 B = fpl[fnr].p[0].z * ( fpl[fnr].p[1].x - fpl[fnr].p[2].x )
    +fpl[fnr].p[1].z * ( fpl[fnr].p[2].x - fpl[fnr].p[0].x )
    +fpl[fnr].p[2].z * ( fpl[fnr].p[0].x - fpl[fnr].p[1].x ); 

 C = fpl[fnr].p[0].x * ( fpl[fnr].p[1].y - fpl[fnr].p[2].y )
    +fpl[fnr].p[1].x * ( fpl[fnr].p[2].y - fpl[fnr].p[0].y )
    +fpl[fnr].p[2].x * ( fpl[fnr].p[0].y - fpl[fnr].p[1].y );

 k = A * fpl[fnr].p[0].x + B * fpl[fnr].p[0].y + C * fpl[fnr].p[0].z;


    /* Schleife ueber alle Punkte des Vergleichkoerpers */

  *merker = 0;
  for ( i=anfang ; i<ende+1 ; i++ )
  {
   Nenner = A * (-ph[i].x) + B * (-ph[i].y) + C * (d-ph[i].z) ;
   if ( Nenner != 0.0 )
    {
     m = ( k - ( A * ph[i].x + B * ph[i].y + C * ph[i].z )) / Nenner;
     if ( m > 0.035 && m < 0.999 ){
                                    *merker = 1;
                                    break;
                                   } 
     /* Ist merker == 1, so muss zuerst der Vergleichkoerper gezeichnet werden und
        dann erst die Ebene. */
    } 
  } 


}
/* ---------------------------------------------------------------- */
void Sortiere_Koerper ( fpl,ph,rf,wy,wx,d )
Flaechen_Punkte_Liste fpl[];
Points ph[];
char rf[];
double wy;
double wx;
double d;
{
 sort koerper[7];
 int i,merker;
 double zmin,y;

 sort links[7];
 double A,B,C;
 int merker2,j;

 for ( i=0 ; i<7 ; i++ ) koerper[i].teil = 'x';


/* Reihenfolge von Gelenk 3 und Link 3 festlegen */

 Test ( fpl,ph,69,d,116,131,&merker );
 
 if (merker == 1) {
                   koerper[0].teil = 'i';
                   koerper[0].z = Z_min ( fpl,70,83 );
                   koerper[1].teil = '3';
                   koerper[1].z = Z_min ( fpl,64,69 );
                  }
 else
  {
   koerper[0].teil = '3';
   koerper[0].z = Z_min ( fpl,64,69 );
   koerper[1].teil = 'i';
   koerper[1].z = Z_min ( fpl,70,83 );
  }

/* Reihenfolge von Gelenk 3 und Hand festlegen */

 Test ( fpl,ph,88,d,114,115,&merker );

 zmin = Z_min ( fpl,84,99 );
 if (merker == 0)
  {
   /* zuerst Hand, dann Gelenk zeichnen */
 
   i = 0;
   while ( koerper[i].teil != 'i' &&
           koerper[i].z < zmin       ) {
                                        i++;
                                       } 
   Shift ( koerper,i );
   koerper[i].teil = 'j';
   koerper[i].z = zmin;
  }
 else
 {
  /* zuerst Gelenk, dann Hand zeichnen */

  i = 0;
  while ( koerper[i].teil != 'i' ) { i++; }
  i++;
  while ( koerper[i].teil != 'x' &&
          koerper[i].z < zmin      ) { i++; }
   Shift ( koerper,i );
   koerper[i].teil = 'j';
   koerper[i].z = zmin;
 }

/* Reihenfolge Gelenk 2 und Link 3 festlegen */

 Test ( fpl,ph,68,d,94,103,&merker );

 zmin = Z_min ( fpl,49,63 );
 if (merker == 1)
  {
   /* zuerst Gelenk 2, dann Link 3 zeichnen */
 
   i = 0;
   while ( koerper[i].teil != '3' &&
           koerper[i].z < zmin       ) {
                                        i++;
                                       } 
   Shift ( koerper,i );
   koerper[i].teil = 'h';
   koerper[i].z = zmin;
  }
 else
 {
  /* zuerst Link 3, dann Gelenk 2 zeichnen */

  i = 0;
  while ( koerper[i].teil != '3' ) { i++; }
  i++;
  while ( koerper[i].teil != 'x' &&
          koerper[i].z < zmin      ) { i++; }
   Shift ( koerper,i );
   koerper[i].teil = 'h';
   koerper[i].z = zmin;
 }

/* Reihenfolge Gelenk 2 und Link 2 festlegen */

 Test ( fpl,ph,48,d,94,103,&merker );

 zmin = Z_min ( fpl,44,48 );
 if (merker == 0)
  {
   /* zuerst Link 2, dann Gelenk 2 zeichnen */
 
   i = 0;
   while ( koerper[i].teil != 'h' &&
           koerper[i].z < zmin       ) {
                                        i++;
                                       } 
   Shift ( koerper,i );
   koerper[i].teil = '2';
   koerper[i].z = zmin;
  }
 else
 {
  /* zuerst Gelenk 2, dann Link 2 zeichnen */

  i = 0;
  while ( koerper[i].teil != 'h' ) { i++; }
  i++;
  while ( koerper[i].teil != 'x' &&
          koerper[i].z < zmin      ) { i++; }
   Shift ( koerper,i );
   koerper[i].teil = '2';
   koerper[i].z = zmin;
 }

/* Reihenfolge Link2 und Gelenk 1 festlegen */

 Test ( fpl,ph,47,d,66,73,&merker );

 Z_min ( fpl,38,42 );
 if (merker == 1)
  {
   /* zuerst Gelenk 1 zeichnen, dann Link 2 */
 
   i = 0;
   while ( koerper[i].teil != '2' &&
           koerper[i].z < zmin       ) {
                                        i++;
                                       } 
   Shift ( koerper,i );
   koerper[i].teil = 'c';
   koerper[i].z = zmin;
  }
 else
  {
   /* zuerts Link 2 zeichnen, dann Gelenk1 */
 
  i = 0;
  while ( koerper[i].teil != '2' ) { i++; }
  i++;
  while ( koerper[i].teil != 'x' &&
          koerper[i].z < zmin      ) { i++; }
   Shift ( koerper,i );
   koerper[i].teil = 'c';
   koerper[i].z = zmin;
  }


/* Reihenfolge Link 1 und Gelenk 1 festlegen */

 y = sin( wx ) * d;
 zmin = Z_min ( fpl,23,27 );

 if ( y < linkl[0] )
  {
   /* zuerst Gelenk 1 zeichnen, dann Link 1 */

   i=0;
   while ( koerper[i].teil != 'c' ) { i++; }
   i++;
   while ( koerper[i].teil != 'x' &&
           koerper[i].z < zmin      ) { i++; }
    Shift ( koerper,i );
    koerper[i].teil = '1';
    koerper[i].z = zmin;
  }
 else
 {
  /* zuerst Link 1 zeichnen, dann Gelenk 1 */

  i = 0;
   while ( koerper[i].teil != 'c' &&
           koerper[i].z < zmin       ) {
                                        i++;
                                       } 
   Shift ( koerper,i );
   koerper[i].teil = '1';
   koerper[i].z = zmin;

 }

/* -------------------------------------------------------- 

     Aufbau der Reihenfolge-Liste
   -------------------------------------------------------- */

 merker = 0;
 if ( wx > 0.0 ) {
                  rf[merker] = 'e';
                  merker = 1;
                 }
 else {
       rf[15] = 'e';
      }
 for ( i=0 ; i<7 ; i++ )
 {
  if ( koerper[i].teil == '2' ||
       koerper[i].teil == '3' ||
       koerper[i].teil == 'i'    ) {
                                    rf[merker] = koerper[i].teil;
                                    merker++;
                                   }

  if ( koerper[i].teil == 'j' )
         {
          /* minimaler Z-wert der Handgrundflaeche */
     
           A = Z_min ( fpl,84,89 );
         
          /* minimaler Z-Wert von Greifer 1 */

           B = Z_min ( fpl,90,94 );
           
          /* minimaler Z-Wert von Greifer 2 */

           C = Z_min ( fpl,95,99 );
          
          /* Reihenfolge Greifer,Handflaeche bestimmen */
          
           Test ( fpl,ph,88,d,142,153,&merker2 );

          if ( merker2 == 0 ) A = (-fabs(A)) - fabs(B) - fabs(C) - 1.0;
          else A = A + fabs(B) + fabs(C) + 1.0;

          /* Reihenfolge der Geifer bestimmen */

           Test ( fpl,ph,94,d,148,153,&merker2 );

           

          if ( A<=B || A<=C )
           {
            if ( ph[146].z <= ph[153].z ||
                 merker2 == 0             ) B =- fabs(C)-1.0;
            else C= -fabs(B)-1.0;
            if ( B<=C ) {
                        rf[merker] = 'j';
                        merker++;
                        rf[merker] = 'k';
                        merker++;
                        rf[merker] = 'l';
                        merker++;
                       }
            else {
                        rf[merker] = 'j';
                        merker++;
                        rf[merker] = 'l';
                        merker++;
                        rf[merker] = 'k';
                        merker++;
                       }
 
           } 
           else 
           {
            if ( ph[146].z <= ph[153].z ||
                 merker2 == 0             ) B =- fabs(C)-1.0;
            else C = -fabs(B)-1.0;
            if ( B<=C ) {
                        rf[merker] = 'k';
                        merker++;
                        rf[merker] = 'l';
                        merker++;
                        rf[merker] = 'j';
                        merker++;
                       }
            else {
                        rf[merker] = 'l';
                        merker++;
                        rf[merker] = 'k';
                        merker++;
                        rf[merker] = 'j';
                        merker++;
                       }
 
           } 



         }
    if ( koerper[i].teil == 'h')
         {
                    if ( ph[94].z <= ph[95].z ) {
                                                     rf[merker] ='f';
                                                     merker++;
                                                     rf[merker] ='h';
                                                     merker++;
                                                     rf[merker] ='g';
                                                     merker++;
                                                    } 
                         else { 
                                            rf[merker] ='g';
                                            merker++;
                                            rf[merker] ='h';
                                            merker++;
                                            rf[merker] ='f';
                                            merker++;
                                                    }

         }
     if ( koerper[i].teil == 'c' )
          { 
                        if ( ph[64].z <= ph[65].z ) {
                                                     rf[merker] ='a';
                                                     merker++;
                                                     rf[merker] ='c';
                                                     merker++;
                                                     rf[merker] ='b';
                                                     merker++;
                                                    } 
                         else { 
                                            rf[merker] ='b';
                                            merker++;
                                            rf[merker] ='c';
                                            merker++;
                                            rf[merker] ='a';
                                            merker++;
                                                    }
         }

    if ( koerper[i].teil == '1' )
        {  
        if ( y < 3.0 && wx >= 0.0 ) {  
                                    
                                    rf[merker] = '1';
                                    merker++;
                                    rf[merker] = 'd';
                                    merker++;
                                    rf[merker] = 's';
                                    merker++;
                                   }
       if ( y >= 3.0 && wx >= 0.0 ) { 
                                   rf[merker] = 's';
                                   merker++;
                                   rf[merker] = 'd';
                                   merker++;
                                   rf[merker] = '1'; 
                                   merker++;
                                  }
        
       if ( wx < 0.0 ) {
                        rf[merker] = '1' ;
                        merker++;
                        rf[merker] = 'd';
                        merker++;
                        rf[merker] = 's';
                        merker++;
                       }
       }
 }       
}
/* ---------------------------------------------------------------- */

void Nvektor ( pl,fl,fpl,anfang )
Points pl[];
Flaechen fl[];
Flaechen_Punkte_Liste fpl[];
int anfang;
{
  double hilf;
  int i; 
  double hx,hy,hz;

     /* Berechnung der Flaechenparameter */

 for ( i=anfang; i<ANZAHL_FLAECHEN; i++ )
 {
  hx = pl[fl[i].p1].y * ( pl[fl[i].p2].z - pl[fl[i].p3].z )
      +pl[fl[i].p2].y * ( pl[fl[i].p3].z - pl[fl[i].p1].z )
      +pl[fl[i].p3].y * ( pl[fl[i].p1].z - pl[fl[i].p2].z ); 
 
  hy = pl[fl[i].p1].z * ( pl[fl[i].p2].x - pl[fl[i].p3].x )
      +pl[fl[i].p2].z * ( pl[fl[i].p3].x - pl[fl[i].p1].x )
      +pl[fl[i].p3].z * ( pl[fl[i].p1].x - pl[fl[i].p2].x ); 
 
  hz = pl[fl[i].p1].x * ( pl[fl[i].p2].y - pl[fl[i].p3].y )
      +pl[fl[i].p2].x * ( pl[fl[i].p3].y - pl[fl[i].p1].y )
      +pl[fl[i].p3].x * ( pl[fl[i].p1].y - pl[fl[i].p2].y );

  hilf = sqrt( (hx) * (hx) + (hy) * (hy) + (hz) * (hz) );
  fpl[i].nx = hx / hilf;
  fpl[i].ny = hy / hilf;
  fpl[i].nz = hz / hilf;
 }

}
 
/* ---------------------------------------------------------------- */
void DrawRobo ( pl,fl,Gerade,wy,wx,d,stdpkt )
Points pl[];
Flaechen fl[];
Points Gerade[2];
double wy;
double wx;
double d;
short stdpkt;
{
 int j,i,k;
 Points ph[ANZAHL_PKTE];
 XPoint ppl[ANZAHL_PKTE];
 XPoint ebene[5];
 char Reihenfolge[16];
 int anfang,ende;
 int clipp;
 double lx,ly,lz;
 double hilf,cosinus;
 Status result;
 XColor exact,color;



 Projektion ( pl,ph,fl,fpl,ebene,&clipp,ANZAHL_PKTE,ANZAHL_FLAECHEN,wy,wx,d,NEU );
 Sortiere_Koerper ( fpl,ph,Reihenfolge,wy,wx,d );

   /* Pixmap mit Hintergrundfarbe laden */
 XSetForeground ( mydisplay,graphgc,graphbg );
 clear_pixmap(); 
 
 for ( i=0 ; i<16 ; i++ )
 {
  switch ( Reihenfolge[i] )
  {
   case 'e':
            for ( j=0 ; j<clipp ; j++ )
            {
             ppl[j].x = ebene[j].x;
             ppl[j].y = ebene[j].y;
            }
            ppl[clipp].x = ppl[0].x;
            ppl[clipp].y = ppl[0].y;

            if ( depth != 1 )
            { 
             lx = Licht.x - pl[fl[0].p1].x;
             ly = Licht.y - pl[fl[0].p1].y;
             lz = Licht.z - pl[fl[0].p1].z;
             hilf = sqrt( lx*lx + ly*ly + lz*lz );
             lx = lx / hilf;
             ly = ly / hilf;
             lz = lz / hilf;

             cosinus = lx *fpl[0].nx + ly * fpl[0].ny + lz * fpl[0].nz;
             if (cosinus < 0.0 ) cosinus = 0.0;
             
             XSetForeground ( mydisplay,graphgc,FT[5][(int)(cosinus * 30)] );
             XFillPolygon ( mydisplay,pixmap,graphgc,ppl,clipp+1,Convex,CoordModeOrigin );
            }
            else
            { 
             XSetForeground ( mydisplay,graphgc,graphbg );
             XFillPolygon ( mydisplay,pixmap,graphgc,ppl,clipp+1,Convex,CoordModeOrigin );
             XSetForeground ( mydisplay,graphgc,plane );
             XDrawLines ( mydisplay,pixmap,graphgc,ppl,clipp+1,CoordModeOrigin );
            }
            break;
   case 'i':
   case 'd':
   case 's':
                if (Reihenfolge[i] == 's')
                 {
                  anfang = 1;
                  ende = 12;
                 }
                else {
                      if ( Reihenfolge[i] == 'i') {
                                                   anfang = 70;
                                                   ende = 84;

                                                   if (fpl[70].C > 0.0 ||
                                                       fpl[71].C > 0.0 ||
                                                       fpl[72].C > 0.0   )
                                                       {
                                                        for ( j=70; j<73; j++ ) fpl[j].C = 1.0;
                                                       } 
                                                   if (fpl[81].C > 0.0 ||
                                                       fpl[82].C > 0.0 ||
                                                       fpl[83].C > 0.0   )
                                                       {
                                                        for ( j=81; j<84; j++ ) fpl[j].C = 1.0;
                                                       } 
                                                
                                                  }
                      else {
                            anfang = 12;
                            ende = 23;
                           } 
                     }
                for ( k=anfang ; k<ende ; k++ )
                {
                 if ( fpl[k].C > 0.0 )
                 { 
                  for ( j=0 ; j<4 ; j++ )
                  {
                   ppl[j].x = fpl[k].pp[j].x;
                   ppl[j].y = fpl[k].pp[j].y;
                  }
                 ppl[4].x = ppl[0].x;
                 ppl[4].y = ppl[0].y;

                 if ( depth != 1 )
                 {
                  lx = Licht.x - pl[fl[k].p1].x;
                  ly = Licht.y - pl[fl[k].p1].y;
                  lz = Licht.z - pl[fl[k].p1].z;
                  hilf = sqrt( lx*lx + ly*ly + lz*lz );
                  lx = lx / hilf;
                  ly = ly / hilf;
                  lz = lz / hilf;

                  cosinus = lx * fpl[k].nx + ly * fpl[k].ny + lz * fpl[k].nz;
                  if ( cosinus < 0.0 ) cosinus = 0.0;
                  
                  if (Reihenfolge[i] == 's')
                  {
                   XSetForeground ( mydisplay,graphgc,FT[0][(int)(cosinus * 30)] );     
                  }
                  else
                  {
                   if (Reihenfolge[i]=='i')
                   {
                    XSetForeground ( mydisplay,graphgc,FT[6][(int)(cosinus * 30)] );     
                   }
                   else
                   {
                    XSetForeground ( mydisplay,graphgc,FT[1][(int)(cosinus * 30)] );                        
                   }
                  } 
                 
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                 }
                 else
                 {
                  XSetForeground ( mydisplay,graphgc,graphbg );
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                  XSetForeground ( mydisplay,graphgc,plane );
                  XDrawLines ( mydisplay,pixmap,graphgc,ppl,5,CoordModeOrigin );
                 }
                } 
               }
              break;
   case 'k':
   case 'l':
   case '1':
             if ( Reihenfolge[i] == '1' ) {
                                           anfang = 23;
                                           ende = 28;
                                          }
             else
              {
               if ( Reihenfolge[i] == 'k' ) {
                                             if ( fpl[84].C >= 0.0 ) 
                                              {
                                               fpl[90].C = 1.0;
                                              } 
                                             anfang = 90;
                                             ende = 95;
                                            } 
               else
                {
                 if ( fpl[84].C >= 0.0 )
                  {
                   fpl[95].C = 1.0;
                  } 
                 anfang = 95;
                 ende = 100;
                }
              }
             for ( k=anfang ; k<ende ; k++ )
                {
                 if ( fpl[k].C >= 0.0 )
                 { 
                  for ( j=0 ; j<4 ; j++ )
                  {
                   ppl[j].x = fpl[k].pp[j].x;
                   ppl[j].y = fpl[k].pp[j].y;
                  }
                 ppl[4].x = ppl[0].x;
                 ppl[4].y = ppl[0].y;

                 if ( depth != 1 )
                 {
                  lx = Licht.x - pl[fl[k].p1].x;
                  ly = Licht.y - pl[fl[k].p1].y;
                  lz = Licht.z - pl[fl[k].p1].z;
                  hilf = sqrt( lx*lx + ly*ly + lz*lz );
                  lx = lx / hilf;
                  ly = ly / hilf;
                  lz = lz / hilf;

                  cosinus = lx * fpl[k].nx + ly * fpl[k].ny + lz * fpl[k].nz;
                  if (cosinus < 0.0) cosinus = 0.0;
 
                  if (Reihenfolge[i] == '1')
                  {
                   XSetForeground ( mydisplay,graphgc,FT[1][(int)(cosinus * 30)] );
                  }
                  else
                   {
                    XSetForeground ( mydisplay,graphgc,FT[4][(int)(cosinus * 30)] );                   
                   }
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );

                 }
                 else
                 { 
                  XSetForeground ( mydisplay,graphgc,graphbg );
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                  XSetForeground ( mydisplay,graphgc,plane );
                  XDrawLines ( mydisplay,pixmap,graphgc,ppl,5,CoordModeOrigin );
                 }
                } 
               }

            break;
   case 'j':
   case '2':
   case '3':
             if ( Reihenfolge[i] == '2' ) {
                                           anfang = 43;
                                           ende = 49;
                                          }
             else {
                   if ( Reihenfolge[i] == 'j' ) {
                                                anfang = 84;
                                                ende = 90;
                                                }
                   else
                    {
                     anfang = 64;
                     ende = 70;
                    }
                  }   
             for ( k=anfang ; k<ende ; k++ )
                {
                 if ( fpl[k].C > 0.0 )
                 { 
                  for ( j=0 ; j<4 ; j++ )
                  {
                   ppl[j].x = fpl[k].pp[j].x;
                   ppl[j].y = fpl[k].pp[j].y;
                  }
                 ppl[4].x = ppl[0].x;
                 ppl[4].y = ppl[0].y;

                 if ( depth != 1 )
                 {
                  lx = Licht.x - pl[fl[k].p1].x;
                  ly = Licht.y - pl[fl[k].p1].y;
                  lz = Licht.z - pl[fl[k].p1].z;
                  hilf = sqrt( lx*lx + ly*ly + lz*lz );
                  lx = lx / hilf;
                  ly = ly / hilf;
                  lz = lz / hilf;

                  cosinus = lx * fpl[k].nx + ly * fpl[k].ny + lz * fpl[k].nz;
                  if ( cosinus < 0.0 ) cosinus = 0.0;
                 
                  if (Reihenfolge[i] == 'j')
                  {
                  XSetForeground ( mydisplay,graphgc,FT[4][(int)(cosinus * 30)] );
                  }
                  else
                  {
                   if (Reihenfolge[i]=='2')
                   {
                    XSetForeground ( mydisplay,graphgc,FT[2][(int)(cosinus * 30)] );
                   }
                   else
                   {
                    XSetForeground ( mydisplay,graphgc,FT[3][(int)(cosinus * 30)] );                 
                   }
                  } 
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                 }
                 else
                 {
                 XSetForeground ( mydisplay,graphgc,graphbg );
                 XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                 XSetForeground ( mydisplay,graphgc,plane );
                 XDrawLines ( mydisplay,pixmap,graphgc,ppl,5,CoordModeOrigin );
                }
               } 
              }

            break;

   case 'a': 
   case 'b':
   case 'c':
   case 'f':
   case 'g':
   case 'h':
             switch( Reihenfolge[i])
             {
              case 'a': anfang = 28;
                        ende = 33;
                        break;
              case 'b': anfang = 33;
                        ende = 38;
                        break;
              case 'c': anfang = 38;
                        ende = 43;
                        break;
              case 'f': anfang = 49;
                        ende = 54;
                        break;
              case 'g': anfang = 54;
                        ende = 59;
                        break;
              case 'h': anfang = 59;
                        ende = 64;
                        break;   
             }
            for ( k=anfang ; k<ende ; k++ )
                {
                 if ( fpl[k].C > 0.0 )
                 { 
                  for ( j=0 ; j<4 ; j++ )
                  {
                   ppl[j].x = fpl[k].pp[j].x;
                   ppl[j].y = fpl[k].pp[j].y;
                  }
                 ppl[4].x = ppl[0].x;
                 ppl[4].y = ppl[0].y;

                 if ( depth != 1 )
                 {
                  lx = Licht.x - pl[fl[k].p1].x;
                  ly = Licht.y - pl[fl[k].p1].y;
                  lz = Licht.z - pl[fl[k].p1].z;
                  hilf = sqrt( lx*lx + ly*ly + lz*lz );
                  lx = lx / hilf;
                  ly = ly / hilf;
                  lz = lz / hilf;

                  cosinus = lx * fpl[k].nx + ly * fpl[k].ny + lz * fpl[k].nz;
                  if ( cosinus < 0.0 ) cosinus = 0.0;
                
                  switch ( Reihenfolge[i] )
                  {
                   case 'a':
                   case 'b': XSetForeground ( mydisplay,graphgc,FT[1][(int)(cosinus * 30)] );
                             break;
                   case 'h': XSetForeground ( mydisplay,graphgc,FT[3][(int)(cosinus * 30)] );
                             break;
                   default : XSetForeground ( mydisplay,graphgc,FT[2][(int)(cosinus * 30)] );
                             break;                      
                  }
                 XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                 }
                 else
                 {
                  XSetForeground ( mydisplay,graphgc,graphbg );
                  XFillPolygon ( mydisplay,pixmap,graphgc,ppl,5,Convex,CoordModeOrigin );
                  XSetForeground ( mydisplay,graphgc,plane );
                  XDrawLines ( mydisplay,pixmap,graphgc,ppl,5,CoordModeOrigin );
                 }
                } 
               }

            break;
  }
 }
}
/* ---------------------------------------------------------------- */

void Flaechen_Farb_Tabelle ( FT,fname,Krit,wy,wx,d )
unsigned long FT[6][31];
string fname[];
short Krit;
double wy,wx,d;
{
 int i,j,k,l,merker,ind;
 XColor exact,color,hilf;
 Status result;
 unsigned long pixels[256];
 unsigned long p[256],HT[31];
 unsigned int np;
 static string name[8];
 unsigned long element;
 int zaehler;


np = 0;

if ( Krit == 1 )
{
 for( i=0; i<8; i++ )
 {
  if ( strcmp(name[i],fname[i]) != 0 && i != 6)
  {   /* neue Farbe */
   if ( i != 7 ) ind = i;
   else ind = 6;
   if ( i != 7 ) strcpy(name[i],fname[i]);
   else strcpy(name[7],fname[i]);
   result = XAllocNamedColor ( mydisplay,cmap,fname[i],&exact,&color );

   for ( j=0; j<31 ; j++ )
   {
    HT[j] = FT[ind][j];
    hilf.red = (unsigned short)(color.red * (1.0 - (30.0 - j) / 45.0));
    hilf.blue = (unsigned short)(color.blue * (1.0 - (30.0 - j)/ 45.0));
    hilf.green = (unsigned short)(color.green * (1.0 - (30.0 - j) / 45.0));
 
    result = XAllocColor ( mydisplay,cmap,&hilf );
    if ( i!= 7 ) FT[i][j] = hilf.pixel;
    else FT[6][j] = hilf.pixel;  
   } 

   DrawRobo ( pl,fl,Gerade,wy,wx,d,ALT );
   show_pixmap(); 

   for( j=0; j<31; j++)
   {
    zaehler = 0; 
    for ( k=j+1; k<31; k++)
     {
      if ( HT[j] == HT[k] ) {
                             zaehler = 1;
                             break;
                            }
     }
    if ( zaehler == 0 )
    { 
     zaehler = 0;
     for( k=0; k<7; k++ )
     {
      for( l=0; l<31; l++ )
      {
       if ( FT[k][l] == HT[j] ) { zaehler = 1;
                                 break;
                               }
      }
     }
     if ( zaehler == 0 && HT[j] != background) 
      XFreeColors ( mydisplay,DefaultColormap(mydisplay,myscreen),&HT[j],1,0 );
    }
   }
  }
 }
}
else
{
 for ( i=0; i<8; i++ )
 {
  if ( i < 6 ) strcpy(name[i],fname[i]);
  if ( i== 7 ) strcpy(name[7],fname[i]);
 } 
 for ( i=0; i<8; i++ )
  {
   if ( i!= 6 )
    {
     result = XAllocNamedColor ( mydisplay,cmap,fname[i],&exact,&color );

     for ( j=0; j<31 ; j++ )
     {
      hilf.red = (unsigned short)(color.red * (1.0 - (30.0 - j) / 45.0));
      hilf.blue = (unsigned short)(color.blue * (1.0 - (30.0 - j)/ 45.0));
      hilf.green = (unsigned short)(color.green * (1.0 - (30.0 - j) / 45.0));
 
      result = XAllocColor ( mydisplay,cmap,&hilf );
      if ( i != 7 ) FT[i][j] = hilf.pixel;
      else FT[6][j] = hilf.pixel; 
     }
    }  
  }
 }
}
/* ------------------------------------------------------------------ */

int Kollision ( pl,rpl )   /* Kollision = 0 ... keine Kollision */
Points pl[];               /*             1 ... Kollision       */
int rpl[14];
{
 int i;

 /* -------------------------------- 
    Test ob Kollision mit dem Sockel
    und der Ebene.
    -------------------------------- */
  for ( i=0 ; i<14 ; i++ )
   {
    if (( fabs(pl[rpl[i]].x) < 4.5 &&
          fabs(pl[rpl[i]].y) < 3.0 &&
          fabs(pl[rpl[i]].z) < 4.5 ) ||
          pl[rpl[i]].y < -0.05   ) { return(1); }
   }

 /* ---------------------------------
    Test ob Kollision mit Link1.
    --------------------------------- */
  for ( i=2 ; i<14 ; i++ )
   {
    if ( fabs(pl[rpl[i]].x) <= 1.3 &&
         fabs(pl[rpl[i]].z) <= 1.3 &&
         pl[rpl[i]].y <= linkl[0] + 0.5 ) return(1);
   }
 return(0);
}
/* ---------------------------------------------------------------- */
void Projektion_D( pl,kl,kpl,Anzahl_pkte,Anzahl_kten,wy,wx,d,stdpkt )
Points pl[];               /* 3D - Punkteliste */
Kanten kl[];
Kanten_Punkte_Liste kpl[];
int Anzahl_pkte;
int Anzahl_kten;
double wy;                            /* Projektionsparameter */
double wx;
double d;
int stdpkt;                           /* stdpkt = 0 ... alter Standpunkt */
                                      /* stdpkt = 1 ... neuer Standpunkt */
{
 int i,anfang,merker;
 double m,x,y,z;
 static double c_wy,s_wy,s_wxs_wy,c_wx,c_wxs_wy,
               s_wx,c_wxc_wy,s_wxc_wy;
 Points ph[ANZAHL_PKTE];

merker = 0;

if ( stdpkt == NEU )
 {
  c_wy = cos(wy);
  c_wx = cos(wx);
  s_wy = sin(wy);
  s_wx = sin(wx);
  s_wxs_wy = s_wx * s_wy;
  s_wxc_wy = s_wx * c_wy;
  c_wxs_wy = c_wx * s_wy;
  c_wxc_wy = c_wx * c_wy;
  anfang = 0;
 }
else { anfang = 44; }

/* ---------------------------------------------------
     Rotation der Punkte, so dass Betrachter auf der
     Z-Achse steht.
   --------------------------------------------------- */

 for ( i=anfang;i<Anzahl_pkte;i++)
  {
   ph[i].x = c_wy * pl[i].x + s_wy * pl[i].z;
   ph[i].y = s_wxs_wy * pl[i].x + c_wx * pl[i].y - s_wxc_wy * pl[i].z;
   ph[i].z = s_wx * pl[i].y - c_wxs_wy * pl[i].x + c_wxc_wy * pl[i].z;

   if ( ph[i].z >= (d- 2 ) ) merker = 1;
  }
 

/* ---------------------------------------------------
   Initialisierung der Kanten_Punkte_Liste
   --------------------------------------------------- */
   if ( stdpkt == NEU ) anfang=0;
   else anfang = 56;   

   for ( i=anfang ; i<Anzahl_kten ; i++ )
    {
     kpl[i].p1.x = ph[ kl[i].p1 ].x;
     kpl[i].p1.y = ph[ kl[i].p1 ].y;
     kpl[i].p1.z = ph[ kl[i].p1 ].z;

     kpl[i].p2.x = ph[ kl[i].p2 ].x;
     kpl[i].p2.y = ph[ kl[i].p2 ].y;
     kpl[i].p2.z = ph[ kl[i].p2 ].z; 
    }
/* ----------------------------------------------------
    3 D - Clippingalgorithmus.
   ---------------------------------------------------- */

 if ( merker == 1 )
  {  
   for ( i=anfang ; i<Anzahl_kten ; i++ )
    {
     if ( kpl[i].p1.z >= (d-2) && kpl[i].p2.z >= (d-2) )
      {
        kpl[i].sichtbar = 1;
      }
     else
     {
      if (!( (kpl[i].p1.z < (d-2)) && (kpl[i].p2.z < (d-2)) ))
       {  /* es muss geclippt werden. */
        
        m = ( (d-2) - kpl[i].p1.z ) / ( kpl[i].p2.z - kpl[i].p1.z );

        x = kpl[i].p1.x + m * ( kpl[i].p2.x - kpl[i].p1.x );
        y = kpl[i].p1.y + m * ( kpl[i].p2.y - kpl[i].p1.y );
        z = kpl[i].p1.z + m * ( kpl[i].p2.z - kpl[i].p1.z );
        
        if ( kpl[i].p1.z > kpl[i].p2.z ) 
         {
          kpl[i].p1.x = x;
          kpl[i].p1.y = y;
          kpl[i].p1.z = z;
          
         }  
        else
        {
          kpl[i].p2.x = x;
          kpl[i].p2.y = y;
          kpl[i].p2.z = z;
         
        }
       } 
     }
    }
  } 

/* --------------------------------------------------------
   Ermittlung des Schnittpunktes mit der Projektions-
   ebene.
   -------------------------------------------------------- */

 for ( i=anfang ; i<Anzahl_kten ; i++ )
  {
   m = ((-30.0) / (kpl[i].p1.z -d )) * 5.0;
   kpl[i].p1.x = 250.0 + m * kpl[i].p1.x;
   kpl[i].p1.y = 200.0 - m * kpl[i].p1.y;

   m = ((-30.0) / (kpl[i].p2.z - d)) * 5.0;
   kpl[i].p2.x = 250.0 + m * kpl[i].p2.x;
   kpl[i].p2.y = 200.0 - m * kpl[i].p2.y;
  }

}
/* ---------------------------------------------------------------- */


void KoordinatenSystem ( kpl,wy,wx )
Points kpl[4];
double wy;
double wx;
{
 int i;
 double x,y,z;
 Kanten_Punkte_Liste koorkpl[3];

 Projektion_D ( kpl,koork,koorkpl,4,3,wy,wx,30.0,NEU );
 XSetForeground ( mydisplay,graphgc,BlackPixel(mydisplay,myscreen) );
 for ( i=0 ; i<3 ; i++ )
 {
  XDrawLine ( mydisplay,pixmap,graphgc,(short)(koorkpl[i].p1.x-200),(short)(koorkpl[i].p1.y-135),
              (short)(koorkpl[i].p2.x-200),(short)(koorkpl[i].p2.y-135));
 }
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[0].p2.x-200),(short)(koorkpl[0].p2.y-135),"X",1);
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[1].p2.x-200),(short)(koorkpl[1].p2.y-135),"Y",1);
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[2].p2.x-200),(short)(koorkpl[2].p2.y-135),"Z",1);
}
/* ---------------------------------------------------------------- */

void Rotation_Y ( pl,winkel,anfang,anzahl )
Points pl[ANZAHL_PKTE];
double winkel;
int anfang;
int anzahl;
{
 int i;
 double x,z;
 double cosinus,sinus;

 cosinus = cos(winkel);
 sinus = sin(winkel);

 for ( i=anfang ; i< anfang+anzahl ; i++ )
  {
   x = cosinus * pl[i].x + sinus * pl[i].z;
   z = cosinus * pl[i].z - sinus * pl[i].x;

   pl[i].x = x;
   pl[i].z = z;   
  }
}
/* ---------------------------------------------------------------- */

void Rotation_K ( pl,winkel,Achse,anfang,anzahl )
Points pl[ANZAHL_PKTE];
double winkel;
Kanten Achse;
int anfang;
int anzahl;
{
 int i;
 double cosinus,sinus,v0;
 double r00,r01,r02,r03,
        r10,r11,r12,r13,
        r20,r21,r22,r23;
 double kx,ky,kz,px,py,pz;
 double kxx,kxy,kxz,kyy,kyz,kzz;

 cosinus = cos(winkel);
 sinus = sin(winkel);
 v0 = 1 - cosinus;

 px = pl[Achse.p1].x;
 py = pl[Achse.p1].y;
 pz = pl[Achse.p1].z;

 kx = pl[Achse.p2].x - px;
 ky = pl[Achse.p2].y - py;
 kz = pl[Achse.p2].z - pz;

 kxx = kx * kx * v0;
 kxy = kx * ky * v0;
 kxz = kx * kz * v0;
 kyz = ky * kz * v0;
 kyy = ky * ky * v0;
 kzz = kz * kz * v0;
 
 r00 = kxx + cosinus;
 r10 = kxy + kz * sinus;
 r20 = kxz - ky *sinus;

 r01 = kxy - kz * sinus;
 r11 = kyy + cosinus;
 r21 = kyz + kx * sinus;

 r02 = kxy + ky * sinus;
 r12 = kyz - kx * sinus;
 r22 = kzz + cosinus;
 
 r03 = r00 * (-px) - r01 * py - r02 * pz + px;
 r13 = r10 * (-px) - r11 * py - r12 * pz + py;
 r23 = r20 * (-px) - r21 * py - r22 * pz + pz;

 for ( i=anfang ; i<anfang+anzahl ; i++ )
  {
   kx = r00 * pl[i].x + r01 * pl[i].y + r02 * pl[i].z + r03;
   ky = r10 * pl[i].x + r11 * pl[i].y + r12 * pl[i].z + r13;
   kz = r20 * pl[i].x + r21 * pl[i].y + r22 * pl[i].z + r23;

   pl[i].x = kx;
   pl[i].y = ky;
   pl[i].z = kz;
  }
}


/* ----------------------------------------------------------------- */

void PosRobo ( pl,drehwinkel,Winkel )
Points pl[];
double drehwinkel[6];
Winkel_Daten Winkel[6];
{
 int j;

   if ( drehwinkel[0] != 0.0 ) Rotation_Y ( pl,drehwinkel[0],44,110 );
   if ( drehwinkel[1] != 0.0 ) Rotation_K ( pl,drehwinkel[1],kl[86],66,88 );
   if ( drehwinkel[2] != 0.0 ) Rotation_K ( pl,drehwinkel[2],kl[128],96,58 );
   if ( drehwinkel[3] != 0.0 ) Rotation_K ( pl,drehwinkel[3],kl[153],114,40 );
   if ( drehwinkel[4] != 0.0 ) Rotation_K ( pl,drehwinkel[4],kl[154],116,38 );
   if ( drehwinkel[5] != 0.0 ) Rotation_K ( pl,drehwinkel[5],kl[180],134,20 );
 
    for ( j=0 ; j<6 ; j++ )
    {
      Winkel[j].akt = Winkel[j].akt + drehwinkel[j];
      
    }
}



/* ----------------------------------------------------------------- */

void  file_handle ( aktion,eingabe,estring,BListe,indx,Kriterium,stdpkt,wy,wx,d )

int * aktion;
double eingabe[9];
string estring[6];
Points BListe[360];
int *indx;
int Kriterium;
double stdpkt[3];
double *wy,*wx,*d;
{
  /* indx >= 0 nur frobo bearbeiten,
     indx = -1 Befehlsliste neu auffuellen,
     

     Kriterium = 0   beide Dateien bearbeiten,
     Kriterium = 1   nur Betrachterliste auffuellen, falls moeglich */

 char c[10];
 int i,offset,Schritte;
 float f;
 double cx,sx,cy,sy,cz,sz,m,x,y,z,mdiff;
 static frobo_end = 0,
        fviewer_end = 0;
 double eingab[9];
  
 if ( Kriterium == 0 && f_Z_R == 0)
  {
    /* Datei frobo bearbeiten */

   offset = fscanf( frobo,"%s",c );
   if ( feof(frobo) ) f_Z_R = -1;
   if ( offset == 0 || offset == EOF ) {
                                        f_Z_R = -1;
                                        *aktion = -1;                                       
                                       }
   else
   {
    switch ( c[0] )
    {
     case 'G':
     case 'g': offset = fscanf( frobo," %lf %lf %lf %lf %lf %lf",
                   &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
               if ( offset != 6 )
                 {
                  f_Z_R = -1;
                  *aktion = -1;                  
                 }   
                 else
                 {
                  for ( i=0; i<6; i++ )
                  {
                   if (eingabe[i] < 1.0) eingabe[i] = 1.0;
                   if (eingabe[i] > 11.0) eingabe[1] = 11.0;
                  }
                  for ( i=0; i<6; i++ ) power[i] = (int)(eingabe[i]);
                  *aktion = -1;
                 }

              break;
     case 'N':
     case 'n': *aktion = -1;
              break;
     case 'S':
     case 's': if ( f_Z_B == 0 ) f_Z_B = 1;
               *aktion = -1; 
              break;
     case 'P':
     case 'p': if ( f_Z_B == 1) f_Z_B = 0;
               *aktion = -1;
              break;
     case 'M':
     case 'm': offset = fscanf( frobo,"%s",c );
               if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                        
                                  }
               else
                {
                 if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                 else f_absolut = 0;
              
                 offset = fscanf( frobo," %lf %lf %lf %lf %lf %lf",
                            &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
                 if ( offset != 6 )
                 {
                  f_Z_R = -1;
                  *aktion = -1;                  
                 }   
                 else
                 {
                  for ( i=0; i<6; i++ ) eingabe[i] = eingabe[i] * ( PI / 180.0 );
                  *aktion = MANUELL;
                 }
                }
               break;
      case 'A':
      case 'a': offset = fscanf( frobo ,"%s",c);
                if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                        
                                   }
               else
               { 
                if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                else f_absolut = 0;

                offset = fscanf( frobo ,"%s",c);
                if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                                    
                                   }
                else
                {
                 if ( c[0] == 'G' || c[0] == 'g' ) f_auto_gerade = 0;
                 else f_auto_gerade = 1;
 
                 offset = fscanf( frobo," %lf %lf %lf",
                            &eingabe[0],&eingabe[1],&eingabe[2] );
                 if ( offset != 3 ){
                                    f_Z_R = -1;
                                    *aktion = -1;                                     
                                   }                
                 else *aktion = AUTO;
               }
              }
             break;
     case 'L':
     case 'l': offset = fscanf( frobo , "%lf %lf %lf", &eingabe[0],&eingabe[1],&eingabe[2]);
               if ( offset != 3 ) {
                                   f_Z_R = -1;
                                   *aktion = -1;                                     
                                  }
               else *aktion = ARMLAENGE;
              break; 
     case 'W':
     case 'w': offset = fscanf( frobo , "%lf %lf %lf %lf %lf %lf",
                                &eingabe[0],&eingabe[1],&eingabe[2],
                                &eingabe[3],&eingabe[4],&eingabe[5] );
               if ( offset != 6 ) {
                                   f_Z_R= -1;
                                   *aktion = -1;
                                  }
               else *aktion = WINKEL;
              break;
     case 'F':
     case 'f': offset = fscanf( frobo , "%s %s %s %s %s %s",
                                estring[0],estring[1],estring[2],
                                estring[3],estring[4],estring[5] );
               if ( offset != 6 ) {
                                   f_Z_R = -1;
                                   *aktion = -1;  
                                  }
               else *aktion = FARBE;
              break;
    default :
             f_Z_R = -1;
             *aktion = -1;               
             break;
               
    }
   }
  }


 if ( akt > *indx && f_Z_B == 0)
 {
  offset = fscanf( fviewer , "%s",c);
  if ( feof(fviewer) ) f_Z_B = -1;
  if ( offset == 0 || offset == EOF ) {
                                       f_Z_B = -1;
                                       if (Kriterium == 1) *aktion = -1; 
                                      }
  else
  {
   switch( c[0] )
   {
    case 'S':
    case 's': if ( f_Z_R == 0 ) f_Z_R = 1;
              if ( Kriterium == 1 ) *aktion = -1;
             break;
    case 'P':
    case 'p': if ( f_Z_R == 1 ) f_Z_R = 0;
              if ( Kriterium == 1 ) *aktion = -1;
             break;
    case 'B':
    case 'b':
             offset = fscanf( fviewer , "%s",c);
             if ( offset == 0 || offset == EOF ) {
                                                  f_Z_B = -1;
                                                  if (Kriterium == 1) *aktion = -1;
                                                 }
             else
              {
               switch( c[0] )
                {
                 case 'A':
                 case 'a':
                 case 'R':
                 case 'r': if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                           else f_absolut = 0;

                  
                           offset = fscanf( fviewer,"%lf%lf%lf",&eingab[0],&eingab[1],&eingab[2] );
                           if ( offset != 3 ) {
                                               f_Z_B = -1;
                                               if ( Kriterium == 1 ) *aktion = -1; 
                                              }  

                           if ( f_absolut == 0 )
                           {
                            eingab[0] = eingab[0] + stdpkt[0];
                            eingab[1] = eingab[1] + stdpkt[1];
                            eingab[2] = eingab[2] + stdpkt[2];
                           } 
                          Winkelberechnung( eingab[0],eingab[1],eingab[2],&BListe[0].y,
                                            &BListe[0].x,&BListe[0].z );

                           *wy = BListe[0].y;
                           *wx = BListe[0].x;
                           *d = BListe[0].z;

                          x = eingab[0];
                          y = eingab[1];
                          z = eingab[2];


                          akt = 0;
                          *indx = 0; 
                          break; 
                 case 'K':
                 case 'k':
                          offset = fscanf( fviewer ,"%lf%lf%lf%lf%lf%lf%lf%lf%lf",
                                           &eingab[0],&eingab[1],&eingab[2],
                                           &eingab[3],&eingab[4],&eingab[5],
                                           &eingab[6],&eingab[7],&eingab[8] );
                          if ( offset != 9 ) {
                                              f_Z_B = -1;
                                              if (Kriterium == 1) *aktion = -1; 
                                             }
                          else
                          {
                          Schritte = (int)(eingab[8] / eingab[7] );
                          Schritte = abs(Schritte);
                          if ( (Schritte+1) > 360 ) Schritte = 359;
                          eingab[1] = eingab[1] * (PI/180.0);
                          eingab[2] = eingab[2] * (PI/180.0);
                          eingab[3] = eingab[3] * (PI/180.0);
                          eingab[7] = eingab[7] * (PI/180.0);
                          eingab[8] = eingab[8] * (PI/180.0);

                          cx = cos( eingab[1] );
                          sx = sin( eingab[1] );
                          cy = cos( eingab[2] );
                          sy = sin( eingab[2] );
                          cz = cos( eingab[3] );
                          sz = sin( eingab[3] );
                          m = 0.0;

                          for( i=0; i<Schritte+1; i++ )
                          {
                           if ( i == Schritte ) m = eingab[8];
                            /* Berechnung des Punktes in der XY-Ebene */
                           eingab[2] = sin(m) * eingab[0];
                           eingab[1] = cos(m) * eingab[0];

                            /* Rotation */
                            x = eingab[1] * cy * cz + eingab[2] * ( sx*sy*cz - cx*sz ) + eingab[4];
                            y = eingab[1] * cy * sz + eingab[2] * ( sx*sy*sz + cx*cz ) + eingab[5];
                            z = eingab[1] * ( - sy ) + eingab[2] * sx * cy + eingab[6];

                           /* Projektion. */
                            Winkelberechnung ( x,y,z,&BListe[i].y,&BListe[i].x,&BListe[i].z );
                            m = m + eingab[7]; 

                             *wy = BListe[i].y;
                             *wx = BListe[i].x;
                             *d = BListe[i].z;


                          }
                          BListe[Schritte+1] = BListe[Schritte];
                          *indx =(int)( Schritte+1 );
                          akt = 0; 
                          }
                          break;
                 case 'G':
                 case 'g':
                          offset = fscanf( fviewer,"%lf%lf%lf%lf%lf%lf%lf",
                                           &eingab[0],&eingab[1],&eingab[2],
                                           &eingab[3],&eingab[4],&eingab[5],
                                           &eingab[6],&eingab[7]              );
                          if ( offset != 7 ) {
                                              f_Z_B = -1;
                                              if (Kriterium == 1) *aktion = -1;
                                             }
                          else
                          {
                           Schritte = (int)(eingab[6]);
                           if ( Schritte > 359.0 ) Schritte = 359;
                           mdiff = 1.0 / Schritte;
                           m = 0.0;

                           for( i=0; i<((int)(Schritte)+1); i++ )
                            {
                             x = eingab[0] + m * ( eingab[3] - eingab[0] );
                             y = eingab[1] + m * ( eingab[4] - eingab[1] );
                             z = eingab[2] + m * ( eingab[5] - eingab[2] );

                             Winkelberechnung ( x,y,z,&BListe[i].y,&BListe[i].x,&BListe[i].z);

                             *wy = BListe[i].y;
                             *wx = BListe[i].x;
                             *d = BListe[i].z;


                             m = m + mdiff; 
                            }
                          }
                          /*BListe[Schritte+1] = BListe[Schritte];*/
                          *indx =(int)( Schritte );
                          akt = 0;  
                          break;
                } 

               if (*indx != -1)
               {
                stdpkt[0] = x;
                stdpkt[1] = y;
                stdpkt[2] = z;
               } 

              }
              break;

   }
  }
 }

 if ( Kriterium == 0 && f_Z_R != 0 )
 {
  for ( i=akt; i< *indx; i++ )
  {
   DrawRobo ( pl,fl,Gerade,BListe[i].y,BListe[i].x,BListe[i].z,NEU );
   show_pixmap();
   akt = *indx;
  }
  if ( feof(fviewer) ) f_Z_B = -1;
  *indx = -1;
  *aktion = -1;
 }

}





/* ----------------------------------------------------------------- */

void MoveRobo ( pl,Gerade,drehwinkel,winkel,Schritte,Fehlercode,wy,wx,d,show,indx,stdpkt )
Points pl[];
Points Gerade[2];
double drehwinkel[6];
Winkel_Daten winkel[6];
int Schritte;
int *Fehlercode;
double *wy,*wx,*d;
int show;
int *indx;
double stdpkt[3];
{
 int i,j;
 double offset[6];
 int merker;
 double eingabe[9];
 string estring[2];

 merker = 0;
 if ( Schritte == 0 ) Schritte = 1;
 for ( i=0 ; i<6 ; i++ )
 {
  offset[i] = drehwinkel[i] / Schritte;
 }

 *Fehlercode = 0;
 for ( i=0 ; i<Schritte ; i++ )
  {
   if ( *Fehlercode == 0 )
   {
   if ( offset[0] != 0.0 ) {
                            Rotation_Y ( pl,offset[0],44,110 );
                            merker = 23;
                           } 
   if ( offset[1] != 0.0 ) { 
                            Rotation_K ( pl,offset[1],kl[86],66,88 );
                            if ( merker == 0 ) merker = 43;
                           }
   if ( offset[2] != 0.0 ) {
                            Rotation_K ( pl,offset[2],kl[128],96,58 );
                            if ( merker == 0 ) merker = 59; 
                           }
   if ( offset[3] != 0.0 ) {
                            Rotation_K ( pl,offset[3],kl[153],114,40 );
                            if ( merker == 0 ) merker = 70;
                           }
   if ( offset[4] != 0.0 ) {
                            Rotation_K ( pl,offset[4],kl[154],116,38 );
                            if ( merker == 0 ) merker = 70;
                           }
   if ( offset[5] != 0.0 ) {
                            Rotation_K ( pl,offset[5],kl[180],134,20 );
                            if ( merker == 0 ) merker =84;
                           }
  
   if ( merker != 0 ) Nvektor (pl,fl,fpl,merker );

   for ( j=0 ; j<6 ; j++ )
     {
       winkel[j].akt = winkel[j].akt + offset[j];
      
     }
  
   if ( Kollision(pl,rpl) == 1 ) { for ( j=0 ; j<6 ; j++ ) offset[j] = -offset[j];
                                   PosRobo(pl,offset,winkel);
                                   *Fehlercode = 1;  
                                 }



  if ( show == 1 ) 
   {
    if ( f_file == 2 && f_Z_B == 0 && f_Z_R == 0)
    {
     if ( !((akt) < *indx))
     {
      file_handle (&j,eingabe,estring,BListe,indx,1,stdpkt,wy,wx,d);
     }
     if ( f_Z_B == 0 && f_Z_R == 0)
     {
      *wy = BListe[akt].y;
      *wx = BListe[akt].x;
      *d = BListe[akt].z;
      akt++;
     }
    }    


    DrawRobo (pl,fl,Gerade,*wy,*wx,*d,ALT);
    show_pixmap();
   }
  
  }
 }

}
/* ----------------------------------------------------------------- */

void copy_PKTLISTE ( PL,pl )
Points PL[ANZAHL_PKTE];
Points pl[ANZAHL_PKTE];
{
 int i;

 for ( i=0 ; i<ANZAHL_PKTE ; i++ )
 {
  pl[i].x = PL[i].x;
  pl[i].y = PL[i].y;
  pl[i].z = PL[i].z;
 }
}
/* ----------------------------------------------------------------- */

void pipe_handle ( aktion,eingabe ,estring,Schritte )
int *aktion;
double eingabe[9];
string estring[6];
int *Schritte;
{
 char c[20];
 int i;
 float f;

 scanf("%s",c);

 switch (c[0])
 {
  case 'M' :
  case 'm' : scanf("%s",c);
             if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
             else f_absolut = 0;

             for ( i=0 ; i<6 ; i++ ){
                                     scanf("%f",&f);
                                     eingabe[i] = (PI / 180.0 ) * f;
                                    }
             *aktion = MANUELL;
             break;

  case 'B':
  case 'b':scanf("%s",c);
           if ( c[0] == 'G' || c[0] == 'g' )
            {   /* Betrachnter soll sich auf einer Geraden bewegen. */
             for ( i=0 ; i<6 ; i++)
             {
              scanf("%f",&f);
              eingabe[i] = f;
             }         
             scanf("%i",&(*Schritte));
             *aktion = BETRACHTER_GERADE;
            }
           else  
           { 
           if ( c[0] == 'K' || c[0] == 'k' )
           { /* Betrachter soll sich auf einem Kreis bewegen. */
            for ( i=0 ; i<9 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = f;
            }
            *aktion = BETRACHTER_KREIS;
           } 
           else
           {  
           if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
           else f_absolut = 0;

           for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = BETRACHTER;
           } 
           } 
           break;

  case 'A':
  case 'a':scanf("%s",c);
           if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
           else f_absolut = 0;

           scanf("%S",c);
           if ( c[0] == 'G' || c[0] == 'g' ) f_auto_gerade = 0;
           else f_auto_gerade = 1;
 
           for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = AUTO;
           break;
  case 'L':
  case 'l': for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = ARMLAENGE;
           break;
  case 'W':
  case 'w':for ( i=0 ; i<6 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = WINKEL;
           break;
  case 'F':
  case 'f':for ( i=0 ; i<6 ; i++ )
           {
            scanf("%s",estring[i]);
           } 
           *aktion = FARBE;
           break;
  case 'G':
  case 'g': scanf(" %lf %lf %lf %lf %lf %lf",
                   &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
            for ( i=0; i<6; i++ )
                  {
                   if (eingabe[i] < 1.0) eingabe[i] = 1.0;
                   if (eingabe[i] > 11.0) eingabe[1] = 11.0;
                  }
                  for ( i=0; i<6; i++ ) power[i] = (int)(eingabe[i]);
                  *aktion = -1;
           break;

  case 'Q':
  case 'q':   
  default: power[0] = 3;
           power[1] = 3;
           power[2] = 4;
           power[3] = 5;
           power[4] = 5;
           power[5] = 5;
               
           wgewicht[0] = 0;
           wgewicht[1] = 30;
           wgewicht[2] = 20;
           wgewicht[3] = 10;
           wgewicht[4] = 10;
           wgewicht[5] = 10;   

          XMoveWindow ( mydisplay,textwin,500,200 );
          f_file = 0;
          *aktion = -1;
          break;
 }
}
/* ----------------------------------------------------------------- */

void berechne_Winkel ( eingabe,wB,wE,SchritteB,SchritteE )
double eingabe[];
double wB[];
double wE[];
int *SchritteB;
int *SchritteE;
{
 double w_max,wdiffB,wdiffE;
 double a,b,v;
 int i_max,i;
 int X;
                 for ( i=0; i<6; i++ )
                  {
                   wE[i] = 0.0;
                   wB[i] = 0.0;
                  }                  

               /* Bestimmung des maximalen Winkels. */
                 i_max = 0;
                 w_max = fabs(eingabe[0]);
                 for ( i=1; i<6; i++ )
                 {
                  if ( w_max < fabs(eingabe[i]) ) {
                                                   i_max = i;
                                                   w_max = fabs( eingabe[i]);
                                                  } 
                 } 
  
                 if ( w_max != 0.0 )
                 {
                  /* Bestimmung von wdiffB. */
                  wdiffB = (( power[i_max] * ( power[i_max] + 1 )) / 2.0 )*( PI / 180.0 ); 

                  /* Fallunterscheidung. */
                  if ( (wdiffB * 2.0) >= fabs(eingabe[i_max]) )
                  {  /* Es gibt keine Endgeschwindigkeitsphase. */
                   wE[i_max] = 0.0;
                   *SchritteE = 0;

                   X = (int)( fabs(eingabe[i_max]) / ( PI/180.0));
                   *SchritteB = (int)( (-1.0 + sqrt( 1.0 + 4.0 * X)) / 2.0);
                   if ( *SchritteB == 0 ) *SchritteB = 1;

                   wB[i_max] = eingabe[i_max] / ((*SchritteB) * ((*SchritteB) + 1.0 ) );
                   for ( i=0; i<6; i++ )
                   {
                    if ( i != i_max )
                    {
                     wE[i] = 0.0;
                     wB[i] = eingabe[i] / ((*SchritteB) * ( (*SchritteB) + 1.0 )); 
                    }
                   }  
                  }
                 else
                  {  /* Es gibt eine Endgeschwindigkeitsphase. */
                   *SchritteB = power[i_max];
                   wdiffE = fabs(eingabe[i_max]) - ( wdiffB * 2.0 );

                   v = wdiffB / wdiffE;
                   for ( i=0; i<6; i++ )
                   {
                    if ( i != i_max )
                    {
                     a = eingabe[i] / ( 2.0 + ( 2.0 / v ));
                     b = eingabe[i] - 2.0 * a;

                     wB[i] = a / ((power[i_max] * (power[i_max] + 1.0)) / 2.0);
                     wE[i] = b;
                    }
                    else
                    {
                     if ( eingabe[i_max] >= 0.0 ) {
                                                   wB[i_max] = PI/180.0;
                                                   wE[i_max] = wdiffE;
                                                  }
                     else {
                           wB[i_max] = -PI/180.0;
                           wE[i_max] = -wdiffE;
                          } 

                     *SchritteE = (int)( wdiffE / (power[i_max] * PI/180.0));
                     
                    }
                   } 
                  }
                 } 
}
/* ----------------------------------------------------------------- */

void berechne_StdPkt( stdpkt,wy,wx )
double stdpkt[];
double wy;
double wx;
{
 double x,y,z;

 x = cos(wy) * stdpkt[0] + sin(wy)*sin(wx) * stdpkt[1] + sin(wy)*cos(wx) * stdpkt[2];
 y = cos(wx) * stdpkt[1] - sin(wx) * stdpkt[2];
 z = -sin(wy) * stdpkt[0] + cos(wy)*sin(wx) * stdpkt[1] + cos(wy)*cos(wx) * stdpkt[2];

 stdpkt[0] = x;
 stdpkt[1] = y;
 stdpkt[2] = z;

}

/* ----------------------------------------------------------------- */

main ( argc,argv )
int argc;
char *argv[];
{
 Points philf[ANZAHL_PKTE],PLH[ANZAHL_PKTE];
 int done = 0,
     i,j,Fehlercode,merker,aktion , Schritte,Schrittzahl,anfang;
 double x,y,z,h,dh;
 double T[3][4];
 double wx ;
 double wy ;
 double d ;
 XPoint ppl[ANZAHL_PKTE];
 double eingabe[9];
 double stdpkt[3],stdpkt_neu[3];
 double pos[3];
 double m,mdiff,Distanz;
 Points p1,p2;
 double w_neu[6],w_alt[6],hilf,w[6],wdiff,hw[6],dw[6],hw1[6];
 XColor exact;
 string estring[7];
 double cx,cy,cz,sx,sy,sz,s_wx;
 Points plh[ANZAHL_PKTE];
 int faktor[6];

 unsigned long pixels[256];

 double wdiffB,wdiffE,w_max,wB[6],wE[6];
 int n;

 int indx = -1;

 Winkel_Daten wi[6];






 if ( argc > 1 ) 
  {
   for ( i=0; i<argc; i++ )
   {
    j = strcmp( argv[i],"-c");
    if ( j== 0 )                 {
                                  strcpy( fname[6],argv[i+1] );

                                 } 






    j = strcmp( argv[i],"-f");
    if ( j == 0 )                 { f_file = 2;
                                    j = strcspn( argv[i+1] , ".robot" );
                                    if ( j == strlen( argv[i+1] ))  
                                      { 
                                        printf("\n Error opening files!!!!!!!!");
                                        exit(1);
                                      }
 
                                    j = strcspn( argv[i+2] , ".view" );
                                    if ( j == strlen( argv[i+2] ))
                                     {
                                      printf("\n Error opening files!!!!!!!!");
                                      exit(1);
                                     }
                      
                                    frobo = fopen( argv[i+1] , "r" );
                                    if ( frobo == NULL )
                                     {
                                      printf("\nError opening file %s",argv[i+1]);
                                      f_file = 0;
                                     }
                                    fviewer = fopen ( argv[i+2] , "r" );
                                    if ( fviewer == NULL )
                                     {
                                      if ( f_file != 0 ) fclose( frobo );
                                      printf("\nError opening file %s",argv[i+2]);
                                      f_file = 0;
                                     } 
                                    
                                  }
    j = strcmp( argv[i],"-p");
    if ( j == 0 )                 { f_file = 1;
                                   
                                  }
   }
  }
 else f_file = 0;


 copy_PKTLISTE ( PL,pl ); 
 init_x();
 init_textwindow ( argc,argv );
 XMapRaised ( mydisplay,textwin );
 init_Ausgabefenster (argc,argv );
 XMapRaised ( mydisplay,Ausgabefenster );
 init_Graphdwin();
 init_graphwindow ();
 XMapRaised ( mydisplay,graphwin );
 init_Bregelwin();
 init_errorwin();
 init_Pixmap();
 init_Regler ();
 XMapRaised ( mydisplay,regelwin );
 init_buttonwindows ( );
 init_deckwindow ( );
 XMapSubwindows ( mydisplay,textwin );
 init_formularwindows ( );
 init_hwin();
 init_helpwin( argc,argv );

 load_set_fonts (); 


 Winkelberechnung ( 0.0,10.0,26.0,&wy,&wx,&d); 
 stdpkt[0] = 0.0;
 stdpkt[1] = 10.0;
 stdpkt[2] = 26.0;
 Nvektor ( pl,fl,fpl,0 );
 Flaechen_Farb_Tabelle ( FT,fname,0,wy,wx,d );
 Flaechen_Farb_Tabelle ( FT,fname,1,wy,wx,d );



 DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU );
 KoordinatenSystem ( koorpl,wy,wx ); 
 
 berechne_Pos ( Winkel,pos );

 XSynchronize(mydisplay,0); 


/* ------------------ EVENT - SCHLEIFE --------------------------- */


 while ( done == 0 )
 {  

  switch ( f_file )
  {
   case 0 :  event_handle ( &aktion , eingabe , estring ,Winkel,stdpkt,pos);
           break; 
   case 1 :  pipe_handle ( &aktion,eingabe,estring,&Schritte );
           break;
   case 2 :  file_handle ( &aktion,eingabe,estring,BListe,&indx,0,stdpkt,&wy,&wx,&d );

             if ( f_Z_B == -1 && f_Z_R == -1 )
              {
               f_file = 0;
               XMoveWindow ( mydisplay,textwin,500,200 );
               aktion = -1;
               fclose ( frobo );
               fclose ( fviewer ); 
               power[0] = 3;
               power[1] = 3;
               power[2] = 4;
               power[3] = 5;
               power[4] = 5;
               power[5] = 5;
               
               wgewicht[0] = 0;
               wgewicht[1] = 30;
               wgewicht[2] = 20;
               wgewicht[3] = 10;
               wgewicht[4] = 10;
               wgewicht[5] = 10; 
               Winkelberechnung ( stdpkt[0],stdpkt[1],stdpkt[2],&wy,&wx,&d );
               DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU );
               KoordinatenSystem( koorpl,wy,wx );
               show_pixmap();  
              }
           break;
  }
  
  switch ( aktion )
  {
   case MANUELL:
                if ( f_absolut == 1 )
                 {
                  for ( i=0 ; i<6 ; i++ ) eingabe[i] = eingabe[i] - Winkel[i].akt;
                 } 
                for ( i=0 ; i<6 ; i++ )
                 {
                  if (((Winkel[i].akt + eingabe[i])<=Winkel[i].max + 0.000001)&&
                     ((Winkel[i].akt + eingabe[i])>=Winkel[i].min - 0.000001) )
                     {
                      merker = 1;   
                      w_neu[i] = Winkel[i].akt + eingabe[i];                
                     }
                  else { merker = 0;
                         if ( f_file == 0 )
                         show_errorwin ( "     Winkelwerte liegen nicht im",
                                         "     zulaessigen Bereich!" );
                         XBell (mydisplay,30);
                         break;
                       }
                 }  
                 
                if ( merker==1) 
                {  
                 berechne_Winkel ( eingabe,wB,wE,&n,&Schritte );                  
                  for ( i=1; i<n+1; i++ )
                  {
                   for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;

                   MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                   if ( Fehlercode == 1 ) break;
                  }    
    
                  if ( Fehlercode != 1)
                  {
                   MoveRobo ( pl,Gerade,wE,Winkel,Schritte,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                  
                   if ( Fehlercode != 1 )
                   { 
                    for ( i=n; i>0; i-- )
                    {
                     for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;
  
                     MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                     if ( Fehlercode == 1 ) break;
                    }
                   }  
                  }
                 }                      

                 if ( Fehlercode != 1 && merker == 1)
                 {
                  copy_PKTLISTE(PL,plh);
                  for ( i=0 ; i<6 ; i++ ) { 
                                            Winkel[i].akt = 0.0;
                                          }
                  MoveRobo ( plh,Gerade,w_neu,
                             Winkel,1,&Fehlercode,&wy,&wx,&d,0,&indx,stdpkt);  
                  copy_PKTLISTE(plh,pl);
                 } 
                 else { if ( Fehlercode == 1 && f_file == 0)
                         { show_errorwin (" ","            Kollision!");
                           XBell(mydisplay,30);
                         } 
                      }
                 aktualisiere_hwin( Winkel,stdpkt );
                 berechne_Pos ( Winkel,pos );
                 DrawRobo ( pl,fl,Gerade,wy,wx,d,ALT);
                 if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                 show_pixmap();
                break;
   case AUTO:
             if ( f_absolut == 0 )
              {
               berechne_Pos ( Winkel,pos );
               for ( i=0 ; i<3 ; i++ ) eingabe[i] = eingabe[i] + pos[i];
              } 
             if ( eingabe[0] != 0.0 || eingabe[1] != 0.0 || eingabe[2] != 0.0 )
             {
              Gerade[0].x = eingabe[0];
              Gerade[0].y = eingabe[1];
              Gerade[0].z = eingabe[2];


              T06 ( Winkel,linkl,T );

              Gerade[1].x = linkl[3] * T[0][2] + T[0][3];
              Gerade[1].y = linkl[3] * T[2][2] + T[2][3] + linkl[0];
              Gerade[1].z = -(linkl[3] * T[1][2] + T[1][3]);
              p1.x = T[0][3];
              p1.y = T[1][3];
              p1.z = T[2][3];
              T[0][3] = eingabe[0];
              T[1][3] = -eingabe[2];
              T[2][3] = eingabe[1] - linkl[0];
               
              T[0][3] = T[0][3] - T[0][2] * linkl[3];
              T[1][3] = T[1][3] - T[1][2] * linkl[3];
              T[2][3] = T[2][3] - T[2][2] * linkl[3];

              if ( f_auto_gerade == 1 ) 
               {
                inverse_Kinematik ( T,eingabe,Winkel,linkl,&merker,f_auto_gerade );

              for ( i=0 ; i<6 ; i++ )
               {
                eingabe[i] = eingabe[i] - Winkel[i].akt ;
               }               
              if ( merker == 0 )
               {
                Gerade[1].x = Gerade[0].x;
                Gerade[1].y = Gerade[0].y;
                Gerade[1].z = Gerade[0].z;
                if ( Bregel_flag[0] != 0 ||
                     Bregel_flag[1] != 0 ||
                     Bregel_flag[2] != 0 ) Gerade[0].y = -1.0;
            
               /* Ausfuehren der Bewegung mit Beschleunigung. */
               berechne_Winkel ( eingabe,wB,wE,&n,&Schritte );                  
                  for ( i=1; i<n+1; i++ )
                  {
                   for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;

                   MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                   if ( Fehlercode == 1 ) break;
                  }    
    
                  if ( Fehlercode != 1)
                  {
                   MoveRobo ( pl,Gerade,wE,Winkel,Schritte,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                  
                   if ( Fehlercode != 1 )
                   { 
                    for ( i=n; i>0; i-- )
                    {
                     for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;
  
                     MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                     if ( Fehlercode == 1 ) break;
                    }
                   }  
                  }




                
                if (Fehlercode == 1) { show_errorwin ("","     Kollision!");
                                      
                                    }

               }
              else {  if ( f_file == 0 ) show_errorwin ( "","   Zielpunkt nicht erreichbar!");
                      
                   }

               }
              else
              { 

              p2.x = T[0][3];
              p2.y = T[1][3];
              p2.z = T[2][3];
              Distanz = sqrt( sqr(p2.x - p1.x) + sqr(p2.y - p1.y) + sqr(p2.z - p1.z) );
             
              Schritte =(int)(Distanz / 0.5);
              if ( Schritte == 0 ) Schritte = 1;
              mdiff = 1.0 / Schritte;
              m = mdiff;

              while ( m <= 1.0 )
              {
               T[0][3] = p1.x + m * (p2.x - p1.x);
               T[1][3] = p1.y + m * (p2.y - p1.y);
               T[2][3] = p1.z + m * (p2.z - p1.z);
               inverse_Kinematik ( T,eingabe,Winkel,linkl,&merker,f_auto_gerade );
               
               if ( merker == 0 )
                {
                 for ( i=0 ; i<6 ; i++ )
                  {
                   eingabe[i] = eingabe[i] - Winkel[i].akt;
                  if ( fabs(eingabe[i]) > 0.087266462 && m < 1.0) merker=1;
                  if ( fabs(eingabe[i]) > PI ) { merker = 2;
                                                 break;
                                               } 
                  }
                 if ( merker == 1 ) {
                                     mdiff = mdiff / 2.0;
                                     m = m - mdiff;
                                    }
                else 
                { if ( merker == 0 )
                  {
                   Schrittzahl = abs((int)(eingabe[0] / (power[0]*(PI/180))));
                   for ( i=1 ; i<6 ; i++ )
                    {
                     merker = abs((int)(eingabe[i] / (power[i]*(PI/180))));
                     if (merker>Schrittzahl) Schrittzahl = merker;
                    } 
                   if ( Bregel_flag[0] != 0 ||
                        Bregel_flag[1] != 0 ||
                        Bregel_flag[2] != 0 ) Gerade[0].y = -1.0;
                   MoveRobo ( pl,Gerade,eingabe,
                              Winkel,Schrittzahl,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                   if ( Fehlercode == 1 ) { if ( f_file == 0 )
                                            show_errorwin("","            Kollision!");
                                           
                                            m = 2.0;
                                          }
                   mdiff = 1.0 / Schritte;
                   if ( m<1.0 && (m+mdiff) > 1.0 ) m = 1.0;
                   else m = m + mdiff;

                  }
                  else {
                         if ( f_file == 0 )show_errorwin ("","   Zielpunkt ist nicht erreichbar!");
                         XBell ( mydisplay , 30 );
                         m = 2.0;
                       }    
                 } 
                }
               else { if ( f_file == 0 )
                      show_errorwin ("","   Zielpunkt ist nicht erreichbar!");
                      
                      m = 2.0;
                    } 
              }
              }
              berechne_Pos ( Winkel,pos );
              aktualisiere_hwin ( Winkel,stdpkt,pos );
              Gerade[0].y = -2.0;
             }  
             else { if ( f_file == 0 )
                    show_errorwin ("","   Zielpunkt ist nicht erreichbar!");
                   
                  } 
             if ( Bregel_flag[0] != 0 ||
                  Bregel_flag[1] != 0 ||
                  Bregel_flag[2] != 0 ) Gerade[0].y = -1.0; 
             DrawRobo ( pl,fl,Gerade,wy,wx,d,ALT);
              if ( Bregel_flag[0] == 0 &&
                   Bregel_flag[1] == 0 &&
                   Bregel_flag[2] == 0 )
              {
              for ( i=0 ; i<3 ; i++ ) 
                           { Bregler[i] = (int)((225.0 / 51.0) * pos[i] + 220.5);
                             XClearWindow ( mydisplay,Bregelwin[i] );
                             XFillArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],1,14,14,0,23040 );
                           }
              }
             if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
             show_pixmap();

             break;
   case BETRACHTER:
                   if ( f_absolut == 0 ) 
                    {
                       for ( i=0 ; i<3 ; i++ )
                        {
                         eingabe[i] = eingabe[i] + stdpkt[i];
                        } 
                    }
                   if ( Bregel_flag[0] == 0 &&
                        Bregel_flag[1] == 0 &&
                        Bregel_flag[2] == 0   )  
                        { for ( i=0 ; i<3 ; i++ ) {
                                                   Bregler[i] = (int)((225.0/51.0) * eingabe[i]+220.5);
                                                   XClearWindow ( mydisplay,Bregelwin[i] );
                                                   XFillArc ( mydisplay,Bregelwin[i],fgc[0],
                                                             Bregler[i],1,14,14,0,23040 );
                                                  }
                        }      

                   if ( sqrt( eingabe[0]*eingabe[0] + eingabe[2]*eingabe[2] ) > 
                          ( linkl[1] + linkl[2] + linkl[3] + 2.0) ||
                        fabs(eingabe[1]) > ( linkl[0] + linkl[1] + linkl[2] + linkl[3] + 2.0 )  )
                   { 
                   Winkelberechnung ( eingabe[0],eingabe[1],eingabe[2],
                                      &wy,&wx,&d );
                   DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU ); 
                   if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                   show_pixmap();
                   for ( i=0 ; i<3 ; i++ ) stdpkt[i] = eingabe[i];
                   aktualisiere_hwin(Winkel,stdpkt );
                   } 
                   else {
                          if ( f_file == 0 ) show_errorwin("","Betrachterstandpunkt unzulaessig");
                        }
                   break;
   case BETRACHTER_GERADE:
                  mdiff = 1.0 / Schritte;
                  m = 0.0;
                  for ( i=0 ; i<Schritte+1 ; i++ )
                   {
                    x = eingabe[0] + m * ( eingabe[3] - eingabe[0] );
                    y = eingabe[1] + m * ( eingabe[4] - eingabe[1] );
                    z = eingabe[2] + m * ( eingabe[5] - eingabe[2] );
                   
                    Winkelberechnung ( x,y,z,&wy,&wx,&d );
                    DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU );
                    show_pixmap();
                    stdpkt[0] = x;
                    stdpkt[1] = y;
                    stdpkt[2] = z;
                    m = m + mdiff;  
                   } 
                  break;
   case BETRACHTER_KREIS:
                  Schritte = (int)( eingabe[8] / eingabe[7] );
                  eingabe[1] = eingabe[1] * ( PI / 180.0 );
                  eingabe[2] = eingabe[2] * ( PI / 180.0 );
                  eingabe[3] = eingabe[3] * ( PI / 180.0 );
                  eingabe[7] = eingabe[7] * ( PI / 180.0 );
                  eingabe[8] = eingabe[8] * ( PI / 180.0 );
                  cx = cos ( eingabe[1] );
                  sx = sin ( eingabe[1] );
                  cy = cos ( eingabe[2] );
                  sy = sin ( eingabe[2] );
                  cz = cos ( eingabe[3] );
                  sz = sin ( eingabe[3] );
                  m = 0.0;
                  for ( i=0 ; i<Schritte+1 ; i++ )
                  {
                   if ( i == Schritte ) m = eingabe[8];
                   /* Berechnung des Punktes in der XY-Ebene. */
                   eingabe[2] = sin(m) * eingabe[0];
                   eingabe[1] = cos(m) * eingabe[0];

                   /* Rotation. */
                   x = eingabe[1] * cy * cz + eingabe[2] * ( sx*sy*cz - cx*sz ) + eingabe[4];
                   y = eingabe[1] * cy * sz + eingabe[2] * ( sx*sy*sz + cx*cz ) + eingabe[5];
                   z = eingabe[1] * ( - sy ) + eingabe[2] * sx * cy + eingabe[6];

                   /* Projektion. */
                   Winkelberechnung ( x,y,z,&wy,&wx,&d );
                   DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU );
                   show_pixmap();
                   stdpkt[0] = x;
                   stdpkt[1] = y;
                   stdpkt[2] = z;
                   m = m + eingabe[7]; 
                  }
                  break;
   case ARMLAENGE: 
                 
                  if ( eingabe[0] < 4.5 ||
                       eingabe[1] < 2.5 ||
                       eingabe[2] < 2.5 ||
                       eingabe[0] > 15.0 ||
                       eingabe[1] > 15.0 ||
                       eingabe[2] > 15.0   )
                  {
                   if ( f_file == 0 )
                    {
                      show_errorwin ( "","  Armlaenge ist nicht zulaessig!");
                      XBell ( mydisplay,40 );
                    }

                  }
                  else
                  {   /* Armlaenge ist zulaessig. */

                   if ( f_file == 0 )
                  {    /* Testen, ob Betrachterstandpunkt angepasst werden muss. */
                   stdpkt_neu[0] = 0.0;
                   stdpkt_neu[1] = 0.0;
                   stdpkt_neu[2] = d;
                   x = -wx;
                   y = -wy;
                   berechne_StdPkt(stdpkt_neu,y,x);
                  
                   
                   x = stdpkt[1];
                   y = eingabe[0] + eingabe[1] + eingabe[2] + linkl[3] + 2.0;
                   if ( x < y )
                   {
                    x = 0.0;
                    y = eingabe[0] + eingabe[1] + eingabe[2] + linkl[3] + 2.0;
                    z = 0.0;
                    
                    x = sqrt( stdpkt_neu[0]*stdpkt_neu[0] + stdpkt_neu[2]*stdpkt_neu[2] );
                    y = eingabe[1] + eingabe[2] + linkl[3] + 2.0;

                    s_wx = sin(wx);
                    z = s_wx * y ;

                    if ( z >= ( d-2.0) || x < y) 
                     {
                      show_errorwin("","Betrachterstandpunkt vorher anpassen.");
                      break;      
                     }
                    }


                   }  /* endif f_file == 0 */
                  
                    /* Durchfuehren der Armveraenderung. */
                    for ( i=0 ; i<6 ; i++ )  {
                                             w_alt[i] = Winkel[i].akt;
                                             Winkel[i].akt = 0.0;
                                            }
                  
                   for ( i=0 ; i<3 ; i++ ) {
                                             h = linkl[i];
                                             linkl[i] = eingabe[i]; 
                                             eingabe[i] = h - eingabe[i];
                                           } 
                   for ( i=48 ; i<78 ; i++ ) PL[i].y = PL[i].y - eingabe[0];
                   for ( i=78 ; i<108 ; i++ ) { PL[i].y = PL[i].y - eingabe[0];
                                                PL[i].x = PL[i].x - eingabe[1];
                                              }
                   for ( i=108 ; i<ANZAHL_PKTE ; i++ ) {
                                                       PL[i].y = PL[i].y - eingabe[0] + 
                                                                 eingabe[2];
                                                       PL[i].x = PL[i].x - eingabe[1];
                                                      }
                   copy_PKTLISTE ( PL,pl );    
                   w_neu[0] = 0.0;
                   w_neu[1] = (-PI/2);
                   w_neu[2] = w_neu[1];
                   w_neu[3] = 0.0;
                   w_neu[4] = 0.0;
                   w_neu[5] = 0.0; 
                   PosRobo ( pl,w_neu,Winkel );

                   w_alt[1] = w_alt[1] + (PI/2);
                   w_alt[2] = w_alt[2] + (PI/2);
                   MoveRobo ( pl,Gerade,w_alt,Winkel,45,&Fehlercode,&wy,&wx,&d,0,&indx,stdpkt );
   

                   DrawRobo ( pl,fl,Gerade,wy,wx,d,NEU ); 
                   if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                   show_pixmap();
                   aktualisiere_hwin ( Winkel,stdpkt ); 


                  }
           
                  break;
   case WINKEL:
               if ( eingabe[0] >= 0.0 &&
                    eingabe[1] >= 0.0 &&
                    eingabe[2] >= 0.0 &&
                    eingabe[3] >= 0.0 &&
                    eingabe[4] >= 0.0 &&
                    eingabe[5] >= 0.0)
                {
                 for ( i=0 ; i<6 ; i++ ) { wgewicht[i] = (int)(eingabe[i]);
                                          }
                 aktualisiere_hwin (Winkel,stdpkt );
                }
               else { if ( f_file == 0 )
                     show_errorwin("","Winkelgewichte muessen positiv sein!");
                     XBell ( mydisplay,30 );
                    }
               break; 
   case FARBE :
               for ( i=0 ; i<7 ; i++ )
                {
                                  
                 merker = XAllocNamedColor ( mydisplay,cmap,estring[i],&exact,&color );
                 if ( merker != 0 ) {
                                     if ( i!= 0 && i != 6) {
                                                            strcpy(fname[i-1],estring[i]);
                                                            farbe[i-1] = color.pixel;
                                                           }
                                     else 
                                      {
                                       if ( i == 0 )
                                          {
                                           strcpy ( fname[5],estring[0] );
                                           plane = color.pixel;
                                          }
                                       else {
                                             strcpy( fname[7],estring[6] );
                                             farbe[6] = color.pixel;
                                            }
                                     } 
                                    }
                 else { if ( f_file == 0 )
                       show_errorwin("","     unbekannter Farbname! "); 
                       XBell(mydisplay,30);
                      }
                }
               Flaechen_Farb_Tabelle ( FT,fname,1,wy,wx,d );
               DrawRobo ( pl,fl,Gerade,wy,wx,d,ALT );
               if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
               show_pixmap(); 
               aktualisiere_hwin(Winkel,stdpkt);
               break; 
   case BEENDEN:
          done = 1;
          break;
   case -1 :
            break;
  }   
 }
 
 XCloseDisplay ( mydisplay ); 
 if ( f_file == 2 ) {
                     fclose(frobo);
                     fclose(fviewer);
                    }
 exit ( 0 );
}
