/* *********************************************************************** */
/* File: rs_Kin.h                                                          */
/* Author: Rainer Pollak                                                   */
/* *********************************************************************** */ 


void T06 (winkel,linkl,T)
Winkel_Daten winkel[6];
double linkl[4];
double T[3][4];
{
 double c[6],c12;
 double s[6],s12;
 double h1,h2;
 int i;

 for ( i=0 ; i<6 ; i++ )
  {
   c[i] = cos( winkel[i].akt );
   s[i] = sin( winkel[i].akt );
  }
 c12 = c[1] * c[2] - s[1] * s[2];
 s12 = c[1] * s[2] + s[1] * c[2];

 h1 = c[3] * c[4] * c[5] - s[3] * s[5];
 h2 = s[4] * c[5];
 T[2][0] = (-s12) * h1 - c12 * h2;
 
 h1 = c12 * h1 - s12 * h2;
 h2 = s[3] * c[4] * c[5] + c[3] * s[5];
 T[0][0] = c[0] * h1 + s[0] * h2;
 T[1][0] = s[0] * h1 - c[0] * h2;


 h1 = (-c[3]) * c[4] * s[5] - s[3] * c[5];
 h2 = s[4] * s[5];
 T[2][1] = (-s12) * h1 + c12 * h2;

 h1 = c12 * h1 + s12 * h2;
 h2 = c[3] * c[5] - s[3] * c[4] * s[5];
 T[0][1] = c[0] * h1 + s[0] * h2;
 T[1][1] = s[0] * h1 - c[0] * h2;


 h1 = c[3] * s[4];
 T[2][2] = s12 * h1 - c12 * c[4]; 
 
 h1 = c12 * h1 + s12 * c[4];
 h2 = s[3] * s[4];
 T[0][2] = (-c[0]) * h1 - s[0] * h2;
 T[1][2] = (-s[0]) * h1 + c[0] * h2;


 h1 = linkl[1] * c[1] - linkl[2] * s12;
 T[0][3] = c[0] * h1;
 T[1][3] = s[0] * h1;
 T[2][3] = (-linkl[1]) * s[1] - linkl[2] * c12;
}

/* ----------------------------------------------------------------- */

void berechne_Pos ( Winkel,pos )
Winkel_Daten Winkel[6];
double pos[3];
{
 double A[3][4],position[3];
 int i,h;

             T06 ( Winkel,linkl,A );
              position[0] = A[0][3] + A[0][2] * linkl[3];
              position[1] = A[2][2] * linkl[3] + A[2][3] + linkl[0];
              position[2] = -A[1][2] * linkl[3] - A[1][3];    
            for ( i=0 ; i<3 ; i++ ) {
                                      h = (int)(position[i] * 1000 + 0.5);
                                      position[i] = h / 1000.0;  
                                      pos[i] = position[i];
                                     }

}

/* --------------------------------------------------------------------- */

void invers_W1 ( T,w_neu,w_alt,merker )
double T[3][4];
double w_neu[2];
Winkel_Daten w_alt[6];
int *merker;
{
 double hilf1,hilf2,hilf3;
 int i;

 
 if ( T[0][3] != 0.0 || T[1][3] != 0.0 )
  {
   /* atan2 ist fuer diese Werte berechenbar,d.h.
      es koennen zwei Winkelwerte bestimmmt werden */

   hilf1 = atan2( T[1][3] , T[0][3] );
   hilf2 = sqrt( T[0][3]*T[0][3] + T[1][3]*T[1][3]);
   hilf3 = atan2( 0.0 , hilf2 );
   w_neu[0] = hilf1 - hilf3;

   hilf3 = atan2( 0.0 , (-hilf2) );
   w_neu[1] = hilf1 - hilf3;

   if ( w_neu[0] == 0.0 &&
        Winkel[0].akt <= 0.0 &&
        w_neu[1] >= 0.0         ) w_neu[1] = -PI;
   if ( w_neu[1] == 0.0 &&
        Winkel[0].akt < 0.0 &&
        w_neu[0] > 0.0         ) w_neu[0] = -PI; 

   for ( i=0 ; i<2 ; i++ )
    {
     if ( w_neu[i] < (-PI )) w_neu[i] = w_neu[i] + 2 * PI;
     else {
           if ( w_neu[i] > PI ) w_neu[i] = w_neu[i] - 2 * PI;
          }   

   
    }
   *merker = 0;
  } 
 else {
       /* Punkt liegt auf der Y-Achse, in diesem Fall
          ist der atan2 nicht berechenbar.            */

       w_neu[0] = w_alt[0].akt ;
       if ( w_alt[0].akt + 1.570796327 <=  (Winkel[0].max )  &&
            w_alt[0].akt + 1.570796327 >= (Winkel[0].min ))
        {
          w_neu[1] = w_alt[0].akt  + PI / 2.0;
        }
       else { w_neu[1] = w_alt[0].akt - PI / 2.0; }
       *merker = 2;
      }
}

/* --------------------------------------------------------------------- */

void invers_W3 ( T,w_neu,linkl,merker )
double T[3][4];
double w_neu[2];
double linkl[3];
int *merker;
{
 double hilf,K,hilf2;
 int i;

 K = T[0][3] * T[0][3] + T[1][3] * T[1][3] + T[2][3] * T[2][3];
 K = K - linkl[1] * linkl[1] - linkl[2] * linkl[2];
 K = K / ( 2 * linkl[1] );
 if ( fabs(K) <= 0.000001 ) K = 0.0;

 hilf = linkl[2] * linkl[2] - K * K;

 if ( hilf > 0 )
  {
   hilf = sqrt ( hilf );
   hilf2 = atan2( 0.0 , linkl[2] );
   w_neu[0] = hilf2 - atan2( K , hilf );
   w_neu[1] = hilf2 - atan2( K , (-hilf) );

   for ( i=0; i<2; i++ )
   {
    if ( w_neu[i] > Winkel[2].max ) w_neu[i] = w_neu[i] - 2 * PI;
   }

   *merker = 0;
  }
 else { *merker = 1;  /* Berechnung nicht moeglich */ } 
}

/* --------------------------------------------------------------------- */

void invers_W2 ( T,w_neu,linkl,w1,w3,s,c,merker )
double T[3][4];
double w_neu[2];
double linkl[3];
double w1,w3;
double s[6];
double c[6];
int *merker;
{
 double hilf1,hilf2;

 hilf1 = T[2][3] * T[2][3];
 hilf2 = c[1] * T[0][3] + s[1] * T[1][3];
 hilf1 = hilf1 + hilf2 * hilf2;

 if ( hilf1 > 0.0 )
  {
   hilf1 = (-linkl[1] * c[3]) * T[2][3] +
           ( c[1] * T[0][3] + s[1] * T[1][3] ) *
           ( linkl[1] * s[3] - linkl[2] );
   if ( hilf1 == -0.0 ) hilf1 = 0.0;
   hilf2 = (linkl[1] * s[3] - linkl[2]) * T[2][3] -
           (-linkl[1] * c[3])*(c[1] * T[0][3] + s[1] * T[1][3]);
   if ( fabs(hilf1) <= 0.000001) hilf1 = 0.0;
   if ( fabs(hilf2) <= 0.000001) hilf2 = 0.0;

   if ( hilf1 != 0.0 || hilf2 != 0.0 )
    {
     w_neu[0] = atan2( hilf1,hilf2 ) - w3;
     if ( w_neu[0] > Winkel[1].max ) w_neu[0] = w_neu[0] - 2*PI;
     if ( fabs(w_neu[0] - PI) <= 0.000001 ) w_neu[0] = -PI;
     *merker = 0;
    }
   else *merker = 1;
  }
 else *merker = 1;
}
/* --------------------------------------------------------------------- */

void invers_W4 ( T,w_neu,w_alt,w1,w2,w3,s,c,merker )
double T[3][4];
double w_neu[2];
Winkel_Daten w_alt[6];
double w1,w2,w3;
double s[6];
double c[6];
int *merker;
{
 double hilf1,hilf2,hilf3,hilf4;
 double c23,s23;


 c23 = c[2] * c[3] - s[2] * s[3];
 s23 = c[2] * s[3] + s[2] * c[3];

 hilf1 = (-T[0][2]) * s[1] + T[1][2] * c[1];
 hilf3 = (-T[0][2]) * c[1] * c23 ;
 hilf4 =( - T[1][2]) * s[1] * c23 ;
 hilf2 = hilf3 + hilf4 + T[2][2] * s23;
 if ( fabs(hilf1) <= 0.000001 ) hilf1 = 0.0;
 if ( fabs(hilf2) <= 0.000001 ) hilf2 = 0.0;

 if ( fabs(hilf1) <= 1.000001 && fabs(hilf2) <= 1.000001 &&
      ( fabs(hilf1) >= 0.01 || fabs(hilf2) >= 0.01))
  {
   w_neu[0] = atan2( hilf1,hilf2 );
   if ( fabs(fabs(w_neu[0]) - PI) <= 0.000001 )
    {
     if ( w_alt[3].akt < 0.0 && w_neu[0] >= 0.0 ) w_neu[0] = w_neu[0] * (-1);
     if ( w_alt[3].akt > 0.0 && w_neu[0] < 0.0 ) w_neu[0] = w_neu[0] * ( -1);
    } 
   *merker = 0;
  }
 else {
       if ( fabs(hilf1) <= 0.01 && fabs(hilf2) <= 0.01 )
         { w_neu[0] = w_alt[3].akt;
           *merker = 5;
         }
       else *merker = 1;
      } 
}
/* --------------------------------------------------------------------- */

void invers_W5 ( T,w_neu,w1,w2,w3,w4,s,c,merker )
double T[3][4];
double w_neu[2];
double w1,w2,w3,w4;
double s[6],c[6];
int *merker;
{
 double hilf1;
 double hilf2;
 double c23,s23;

 c23 = c[2] * c[3] - s[2] * s[3];
 s23 = c[2] * s[3] + s[2] * c[3];

 hilf1 = -(T[0][2] * ( c[1] * c23 * c[4] + s[1] * s[4] ) + T[1][2] * 
          ( s[1] * c23 * c[4] - c[1] * s[4] ) - T[2][2] * ( s23 * c[4]));
 hilf2 = T[0][2] * ( (-c[1]) * s23 ) + T[1][2] * ( (-s[1]) * s23 ) + 
         T[2][2] * (-c23);
 if ( fabs(hilf1) <= 0.000001 ) hilf1 = 0.0;
 if ( fabs(hilf2) <= 0.000001 ) hilf2 = 0.0;

  if ( fabs(hilf1) <= 1.000001 && fabs(hilf2) <= 1.000001 &&
      ( hilf1 != 0.0 || hilf2 != 0.0))
  {
   w_neu[0] = atan2( hilf1,hilf2 );
   *merker = 0;
  }
 else { *merker = 1;}

}
/* --------------------------------------------------------------------- */

void invers_W6 ( T,Winkel,w_neu,w1,w2,w3,w4,w5,s,c,merker )
double T[3][4];
Winkel_Daten Winkel[6];
double w_neu[2];
double w1,w2,w3,w4,w5;
double s[6],c[6];
int *merker;
{
 double hilf1;
 double hilf2,hilf3,hilf4;
 double c23,s23;

 c23 = c[2] * c[3] - s[2] * s[3];
 s23 = c[2] * s[3] + s[2] * c[3];

 hilf1 = (-T[0][0])*( c[1]*c23*s[4] - s[1]*c[4]); 
 hilf3 = T[1][0]*( s[1]*c23*s[4] + c[1]*c[4]);
 hilf4 = T[2][0]*( s23*s[4]);
 hilf1 = hilf1 - hilf3 + hilf4;

 hilf2 = T[0][0]*((c[1]*c23*c[4] + s[1]*s[4])*c[5] - c[1]*s23*s[5]) +
         T[1][0]*((s[1]*c23*c[4]-c[1]*s[4])*c[5] - s[1]*s23*s[5]) -
         T[2][0]*(s23*c[4]*c[5] + c23*s[5]);
 if ( fabs(hilf1) <= 0.000001) hilf1 = 0.0;
 if ( fabs(hilf2) <= 0.000001) hilf2 = 0.0;
 
 
  if ( fabs(hilf1) <= 1.000001 && fabs(hilf2) <= 1.000001 &&
      ( hilf1 != 0.0 || hilf2 != 0.0))
  {
   w_neu[0] = atan2( hilf1,hilf2 );

/* **************************************************** */
    if ( fabs(fabs(w_neu[0]) - PI ) < 0.000001 )
      {
       if ( Winkel[5].akt < 0.0 && w_neu[0] >= 0.0 ) w_neu[0] = -w_neu[0];
       if ( Winkel[5].akt > 0.0 && w_neu[0] < 0.0 ) w_neu[0] = -w_neu[0];
      }
/* **************************************************** */
        
    if ( w_neu[0] < (-PI )) w_neu[0] = w_neu[0] + 2 * PI;
    else {
          if ( w_neu[0] > PI ) w_neu[0] = w_neu[0] - 2 * PI;
         }   

   *merker = 0;
  }
 else { *merker = 1;}

}
/* --------------------------------------------------------------------- */

void inverse_Kinematik ( T,w_neu,w_alt,linkl,erg,f_a_g )
double T[3][4];     /* Frame 6 relativ zu Frame 0 */
double w_neu[6];
Winkel_Daten w_alt[6];    /* aktuelle Winkel */
double linkl[3];    /* aktuelle Link-Laengen */
int *erg;
           /* erg = 0 ... gueltige Winkelkombination
                                   gefunden.                 */ 
int f_a_g;
{
 double A[3][4];
 double w_max,whilf;
 int nummer;
 Winkel_Daten w[6];
 double s[6],c[6];
 double winkel[2],zw,hilf;
 int i,j,k,
     merker;          /* merker = 0 ... Loesung ist ok.
                         merker = 1 ... keine Loesung.
                         merker = 2 ... Loesung muss geprueft werden.
                         merker = 5 ... Winkel 5 auf 0 setzen.        */
     
 double w_tab[8][7];  /* w_tab[i][0] = 0 ... Winkelkombination ist ok. 
                         w_tab[i][0] = 1 ... Winkelkombination nicht ok.
                         w_tab[i][0] = 2 ... Kombination muss getestet werden.*/

 *erg = 1;

 invers_W1 ( T,winkel,w_alt,&merker );
 for ( i=0 ; i<2 ; i++ ) { w_tab[i][0] = merker;
                           w_tab[i][1] = winkel[0];
                         }
 for ( i=2 ; i<4 ; i++ ) { w_tab[i][0] = merker;
                           w_tab[i][1] = winkel[1];
                         }

 invers_W3 ( T,winkel,linkl,&merker );
 if ( merker == 0 )
  {   /* Es existiert eine Loesung fuer Winkel 3 */
   for ( i=0 ; i<2 ; i++ ) { w_tab[i*2][3] = winkel[0];
                             w_tab[i*2+1][3] = winkel[1];
                           }

   for ( i=0 ; i<4 ; i++ )
    {
     s[1] = sin ( w_tab[i][1] );
     c[1] = cos ( w_tab[i][1] );
     s[3] = sin ( w_tab[i][3] );
     c[3] = cos ( w_tab[i][3] );

     invers_W2 ( T,winkel,linkl,w_tab[i][1],w_tab[i][3],s,c,&merker );
     if ( merker == 1 ) { w_tab[i][0] = 1.0 ; }
     else
      {  /* Loesung fuer Winkel 2 existiert, d.h. Winkel 4
            kann nun berechnet werden.                     */  
       w_tab[i][2] = winkel[0];
       s[2] = sin ( winkel[0] );
       c[2] = cos ( winkel[0] );

       invers_W4 ( T,winkel,w_alt,w_tab[i][1],w_tab[i][2],w_tab[i][3],
                   s,c,&merker );
       if ( merker == 1 ) { w_tab[i][0] = 1.0; }
       else
        {  /* Loesung fuer Winkel 4 existiert,d.h. Winkel 5
              kann nun berechnet werden.                    */
         s[4] = sin ( winkel[0] );
         c[4] = cos ( winkel[0] ); 
         w_tab[i][4] = winkel[0];
         if ( merker == 5 )
          {
           w_tab[i][0] = 2.0;
           w_tab[i][5] = 0.0;
           s[5] = 0.0;
           c[5] = 1.0; 
          }  /* if .. merker == 5 */
         else
          { /* Berechnung von Winkel 5 */
           invers_W5 ( T,winkel,w_tab[i][1],w_tab[i][2],w_tab[i][3],
                       w_tab[i][4],s,c,&merker );
           if ( merker == 1 ) { w_tab[i][0] = 1.0; }
           else { w_tab[i][5] = winkel[0];
                  s[5] = sin ( w_tab[i][5] );
                  c[5] = cos ( w_tab[i][5] );
                }
          }  /* else .. merker == 5 */
         if ( w_tab[i][0] != 1.0 )
          {  /* Berechnung von Winkel 6 */
           invers_W6 ( T,Winkel,winkel,w_tab[i][1],w_tab[i][2],w_tab[i][3],
                       w_tab[i][4],w_tab[i][5],s,c,&merker );
           if ( merker == 1 ) { w_tab[i][0] = 1.0 ; }
           else
            {
             w_tab[i][6] = winkel[0];
             
              /* Kopieren der Winkelwerte */
              w_tab[i+4][0] = w_tab[i][0];
              w_tab[i+4][1] = w_tab[i][1];
              w_tab[i+4][2] = w_tab[i][2];
              w_tab[i+4][3] = w_tab[i][3];

              if ( fabs(w_tab[i][4]) == 0.0 ) 
              {
               if ( w_alt[3].akt >= 0.0 ) w_tab[i+4][4] = w_tab[i][4] + PI;
               else w_tab[i+4][4] = w_tab[i][4] - PI;
              } 
              else 
              { if (w_tab[i][4] > 0.0) w_tab[i+4][4] = w_tab[i][4] - PI;
                else w_tab[i+4][4] = w_tab[i][4] + PI;
              } 
              w_tab[i+4][5] = -w_tab[i][5];
              
              if ( fabs(w_tab[i][6]) == 0.0 ) 
              {
              if ( w_alt[5].akt >= 0.0 ) w_tab[i+4][6] = w_tab[i][6] + PI;
              else w_tab[i+4][6] = w_tab[i][6] - PI;
              } 
              else 
              { if (w_tab[i][6] > 0.0) w_tab[i+4][6] = w_tab[i][6] - PI;
                else w_tab[i+4][6] = w_tab[i][6] + PI;
              } 

            } /* else .. merker W6 */  
          } /* if ... w_tab[i][0] == 0 */ 

        }  /* else .. merker Winkel 4 */
      }   /* else .. merker Winkel 2 */
    } /* endfor  */
  
/* Bestimmung der besten Winkelloesung */

*erg = 1;
zw = 10000;
for ( i=0 ; i<8 ; i++ )
 {
  if ( w_tab[i][0] != 1.0)
   {
    merker = 0;
    for ( j=0 ; j<6 ; j++ )
     {
      w[j].akt = w_tab[i][j+1];
      if ( w_tab[i][j+1] < Winkel[j].min ||
           w_tab[i][j+1] > Winkel[j].max ) 
                                          {
                                           w_tab[i][0] = 1.0;
                                           merker = 1;
                                           break;
                                          }
     } /* endfor */
    if ( merker == 0 )
     {
      T06 ( w,linkl,A );
      for ( j=0 ; j<3 ; j++ )
       {
        if ( fabs(T[j][0] - A[j][0]) > 0.01 ||
             fabs(T[j][1] - A[j][1]) > 0.01 ||
             fabs(T[j][2] - A[j][2]) > 0.01 ||
             fabs(T[j][3] - A[j][3]) > 0.1     ) { 
                                                  w_tab[i][0] = 1.0;  
                                                  merker = 1;
                                                  break;
                                                 } 
       }
      if ( merker == 0 )
        {
          /* Diese Winkelkombination ist zulaessig und korrekt. */
          /* Berechnung der Zielfunktion.                       */

          hilf = 0;
          for ( j=0 ; j<6 ; j++ )
           {
            hilf = hilf + 
                  wgewicht[j] * fabs( w_tab[i][j+1] - w_alt[j].akt );
           } 
          if ( zw > hilf ) {
                            zw = hilf;
                            for ( j=0 ; j<6 ; j++ )
                             {
                              w_neu[j] = w_tab[i][j+1];
                             }
                           }  
          *erg = 0;
        }
     }
   } /* end if */
  }  /* end for */


    /* Fuer den Fall, dass f_auto_gerade == 0 ,
       wird jetzt noch getestet, ob es einen bessere
       LOesung gibt.                                 */

   if ( f_a_g == 0 )
   {
    w_max = fabs( w_alt[0].akt  - w_neu[0] );
    for ( i=1; i<6; i++ )
    {
     if ( w_max < ( fabs( w_alt[i].akt - w_neu[i] ) )) w_max = fabs( w_alt[i].akt - w_neu[i] );
    }

    for ( i=0; i<8; i++ )
    {
      if ( w_tab[i][0] != 1 )
      {
       whilf = fabs( w_alt[0].akt - w_tab[i][1] );
       for ( j=2; j <7; j++ )
       {
        if ( whilf < ( fabs( w_alt[i-1].akt - w_tab[i][j] ))) whilf = fabs( w_alt[i-1].akt - w_tab[i][j] );
       }      
       if ( w_max > whilf )
       {
        w_max = whilf;
        for ( j=0; j<6; j++ ) w_neu[j] = w_tab[i][j+1];
       }
      }
   
    }
    
   }



 } 
}
