/*********************************************************************/
/*  File:  Oberflaeche                                               */
/*                                                                   */
/*  Author: Rainer Pollak                                            */
/*********************************************************************/

#define clear_pixmap()   XFillRectangle(mydisplay,pixmap,graphgc,\
                                        0,0,graphhint.width,\
                                        graphhint.height)

#define show_pixmap()    XCopyArea(mydisplay,pixmap,graphwin,graphgc,\
                                   0,0,graphhint.width,\
                                   graphhint.height,0,0)
typedef struct {
                char t[100];
                int x,y,f;               
               } text;
typedef short flag;

/***************** Variablendefinition der Oberflaeche **************/

string finput[7];
 
string fname[8]  = { "red"  ,      /* Link 0            */
                     "yellow" ,      /* Link 1            */
                     "green" ,      /* Link 2            */
                     "mediumblue" ,      /* Link 3            */
                     "violet",      /* Hand              */
                     "skyblue",       /* Ebene             */ 
                     "white" ,    /* Grafikhintergrund */
                     "violet" };    /* Gelenk 4 */

text btext[14]  = {{ "manuell",    15,15,1 },    /* Beschriftung der */
                  { "auto",       22,15,1 },    /* Buttons          */
                  { "Betrachter", 1,15,1 },
                  { "Armlaenge",  5,15,1 },
                  { "Winkel",     17,15,1 },
                  { "Beenden",    15,15,1 },
                  { "abbrechen",  3,15,1 },
                  { "ausfuehren", 0,15,1 },
                  { "JA",    5,15,0},
                  { "NEIN",  1,15,0},
                  { "rel.",  1,15,0},
                  { "abs.",  1,15,0},
                  { "Farbe" , 20,15,0},
                  { "Hilfe",  22,15,1}};

text rtext[3] = {{ "Geschwindigkeit" , 100,120,0 },
                { "L"         , 190,105,0 },
                { "S"         ,280,105,0 }};

text Bregelt[5] = {{"X-Wert",5,38,0},
                   {"Y-Wert",5,53,0},
                   {"Z-Wert",5,68,0},
                   {"-50",45,20,0},
                   {"50",483,20,0}}; 
               
text ftext[31]  = {{ "MANUELLE  Steuerung", 33,30,2 },	
                   { "Winkel 1",           7,53,0 },
                   { "Winkel 2",           147,53,0 },
                   { "Winkel 3",           7,103,0 },
                   { "Winkel 4",           147,103,0 },
                   { "Winkel 5",           7,153,0 },
                   { "Winkel 6",           147,153,0 },
                   { "AUTOMATISCHE STEUERUNG", 0,30,2 },
                   { " X-Wert",               7,53,0 },
                   { " Y-Wert",               147,53,0 },
                   { " Z-Wert",               7,103,0 },
                   { "Gerade",              205,125,0 },
                   { "Distanz",             153,53,0 },
                   { "Betrachterstandpunkt", 40,30,2 },
                   { "X-Wert",             15,51,0 },
                   { "Y-Wert",             155,51,0 },
                   { "Z-Wert",             15,101,0 },
                   { "Bestimmung der ARMLAENGE", 3,30,2 },
                   { "Arm 1",                    20,51,0 },
                   { "Arm 2",                    160,51,0 },
                   { "Arm 3",                    20,101,0 },
                   { "Winkelgewichte", 55,30,2 },
                   { "Eingabe",                  50,190,0},
                   { "Farbnamen",80,30,2},
                   { "Ebene", 20,51,0},
                   { "Sockel" , 157,51,0},
                   { "Link 1" , 15,101,0},
                   { "Link 2" , 155,101,0},
                   { "Link 3" , 15,151,0},
                   { "Hand" ,   167,151,0},
                   { "Gelenk 4", 10,201, 0}};

text htext [8] = {{ "",60,230,0},
                  { "",0,0,0},
                  { "|Winkel 1| <= 180 ; -210 <= Winkel 2 <=  30",25,215,0},
                  { "|Winkel 4| <= 180 ; -210 <= Winkel 3 <=  30",25,230,0},
                  { "|Winkel 5| <=  90 ;       |Winkel 6| <= 180" ,25,245,0},
                  { "Arm 1 >= 4.5",                                50,215,0},
                  { "Arm 2 >= 2.5",                                50,230,0},
                  { "Arm 3 >= 2.5",                                50,245,0}}; 

text Htext[36] = {{ "MANUELLE   Steuerung", 50, 50, 2},
                  { "Steuerung des Roboters durch Eingabe", 15,75 , 1},
                  { "von sechs Winkelwerten. Mit Hilfe des", 15,90 , 1},
                  { "Buttons <Eingabe> kann zwischen dem", 15, 105, 1},
                  { "absoluten und relativen Eingabemodus", 15,120, 1},
                  { "gewechselt werden.",15 ,135 ,1 },
                  { "AUTOMATISCHE  Steuerung", 50, 50,2 },
                  { "Steuerung des Roboters durch Vorgabe",15 , 75,1 },
                  { "eines Zielpunktes. Mit Hilfe des",15 ,90 ,1 },
                  { "Buttons <Gerade> kann festgelegt werden",15, 105, 1 },
                  { "ob sich der Greifer dabei auf einer", 15, 120,1 },
                  { "Geraden bewegen soll.",15 ,135 ,1 },
                  { "Betrachterstandpunkt", 50,50 ,2 },
                  { "Mit Hilfe dieses Formulars kann", 15, 75,1 },
                  { "der Betrachterstandpunkt veraendert", 15,90 ,1 },
                  { "werden. Dabei muessen im Programm", 15,105 ,1 },
                  { "RoboSim gewisse Restriktionen be-", 15,120 ,1 },
                  { "achtet werden." , 15,135 , 1},
                  { "Bestimmung  der  ARMLAENGEN", 15,50,2},
                  { "Mit Hilfe dieses Formulars kann",15,75, 1},
                  { "die Laenge der Arme 1, 2 und 3 ver-",15,90,1},
                  { "aendert werden. Dabei muessen be-",15,105,1},
                  { "stimmte Restriktionen beachtet werden.",15,120,1},
                  { "",15,135,1},
                  { "Winkelgewichte",60,50,2},
                  { "Mit Hilfe dieses Formulars kann",15,75,1},
                  { "die Gewichtung der Gelenke fuer die",15,90,1},
                  { "AUTOMATISCHE Steuerung veraendert",15,105,1},
                  { "veraendert werden. Die Gewichte muessen",15,120,1},
                  { "positive,ganze Zahlen sein.",15,135,1},
                  { "Farbnamen",60,50,2},
                  { "Mit Hilfe dieses Formulars kann",15,75,1},
                  { "die Farbe der Roboterelemente ver-",15,90,1},
                  { "aendert werden. Eine Auswahl moeglicher",15,105,1},
                  { "Farbnamen befindet sich in der Datei",15,120,1},
                  { "RS_FARBEN. ",15,135,1}};
       
flag  f_allg = 0,
      f_manu = 0,
      f_auto_winkel = 0,
      f_auto_gerade = 0,
      f_Betr = 0,
      f_Arm = 0,
      f_absolut = 1,
      f_Winkel = 0,
      regel_flag = 0,
      Bregel_flag[3] = {0,0,0},
      f_file = 0,
      f_Farbe = 0;

 

/******************* FUNKTIONEN ************************************/
 

init_x()
{
 int i;
 int result;
 XColor exact; 

 mydisplay = XOpenDisplay ( "" );
 myscreen =  DefaultScreen ( mydisplay );
 
 cmap =  XDefaultColormap ( mydisplay,myscreen );
 foreground = BlackPixel ( mydisplay,myscreen );
 background = WhitePixel ( mydisplay,myscreen );
 
 depth =  DefaultDepth ( mydisplay,myscreen );
 if ( depth == 1 ) {
                     for ( i=0; i< 8; i++ ) farbe[i] = foreground; 
                     plane = foreground;
                     graphbg = background; 
                   }
 else { 
        result = XAllocNamedColor ( mydisplay,cmap,fname[6],&exact,&color);
        if ( result != 0 ) {
                            graphbg = color.pixel;
                            }
        else printf("%s\n","Fehler bei der Farbermittlung!");

        for ( i=0 ; i<5 ; i++ )
        {
         result = XAllocNamedColor ( mydisplay,cmap,fname[i],&exact,&color);
         if ( result != 0 ) {
                             farbe[i] = color.pixel;
                             }
         else printf("%s\n","Fehler bei der Farbermittlung!");
        }

        result = XAllocNamedColor ( mydisplay,cmap,fname[5],&exact,&color );
        if ( result != 0 ) {
                           plane = color.pixel;
                           }
        else printf("%s\n","Fehler bei der Farbermittlung!");  
 
        result = XAllocNamedColor ( mydisplay,cmap,fname[7],&exact,&color );
        if ( result != 0 ) {
                            farbe[6] = color.pixel;
                           }
        else printf("%s\n","Fehler bei der Farbermittlung!");   

        result = XAllocNamedColor ( mydisplay,cmap,"lightgray",&exact,&color );
        if ( result != 0 ) {
                           background = color.pixel;
                           }
        else printf("%s\n","Fehler bei der Farbermittlung!");   

       }

}    

/* -------------------------------------------------------------- */
init_Ausgabefenster ( argc,argv )
int argc;
char *argv[];
{
                 /*******************************/
                /* Ausgabefenster initialisieren */
                /*******************************/
 graphhint.x = 5;
 graphhint.y = 5;
 graphhint.width = 500;
 graphhint.height = 500;
 graphhint.flags = PPosition | PSize;

 Ausgabefenster = XCreateSimpleWindow ( mydisplay,DefaultRootWindow ( mydisplay ),
                                  graphhint.x,graphhint.y,graphhint.width,
                                  graphhint.height,5,foreground,background );

 XSetStandardProperties ( mydisplay,Ausgabefenster,"RoboSim-Ausgabe","RoboSimA",
                          None,argv,argc,&graphhint );

 graphgc = XCreateGC ( mydisplay,Ausgabefenster,0,0 );
 XSetBackground ( mydisplay,graphgc,graphbg );
 XSetForeground ( mydisplay,graphgc,foreground );

 XSelectInput ( mydisplay,Ausgabefenster,ExposureMask |
                                         KeyPressMask |
                                         ButtonPressMask |
                                         EnterWindowMask |
                                         LeaveWindowMask );

}
/* -------------------------------------------------------------- */

init_graphwindow ( )
{
                /*******************************/
                /* Grafikwindow initialisieren */
                /*******************************/
 graphwin = XCreateSimpleWindow ( mydisplay,Ausgabefenster,
                                  0,0,graphhint.width,graphhint.height,
                                  0,foreground,background );

 XSelectInput ( mydisplay,graphwin,ExposureMask |
                                   KeyPressMask |
                                   ButtonPressMask |
                                   EnterWindowMask |
                                   LeaveWindowMask );

}

/* -------------------------------------------------------------- */

void init_errorwin()
{
 errorwin = XCreateSimpleWindow ( mydisplay,Ausgabefenster,
                                  100,300,250,125,1,
                                  BlackPixel(mydisplay,myscreen),
                                  background );

 XSelectInput ( mydisplay,errorwin,ExposureMask |
                                   ButtonPressMask ); 
}
/* -------------------------------------------------------------- */

void init_Graphdwin ()
{
 Graphdwin = XCreateSimpleWindow ( mydisplay,Ausgabefenster,
                                   0,420,graphhint.width,graphhint.height,
                                   1,BlackPixel(mydisplay,myscreen),background );
 
}
/* -------------------------------------------------------------- */

void init_Bregelwin()
{
 int i,y;

 y = 450;
 for ( i=0 ; i<3 ; i++ )
  {
   Bregelwin[i] = XCreateSimpleWindow ( mydisplay,Ausgabefenster,45,y,
                                        455,15,1,BlackPixel(mydisplay,myscreen),
                                        background );
   XSelectInput ( mydisplay,Bregelwin[i],ExposureMask |
                                         ButtonPressMask |
                                         ButtonReleaseMask |
                                         PointerMotionMask |
                                         OwnerGrabButtonMask );
   y = y + 16;  
  } 
}
/* -------------------------------------------------------------- */

void init_Pixmap ()
{
  int status,
       x,
        y;
  unsigned int width,height,border,tiefe;
  Window root;

  pixmap = XCreatePixmap ( mydisplay,graphwin,
                           graphhint.width,graphhint.height,depth );

 status = XGetGeometry ( mydisplay,pixmap,&root,
                         &x,&y,&width,&height,&border,&tiefe );
 if ( status == 0 ) {
                     printf("%s\n","Fehler bei Pixmap Erstellung!");
                     exit(1);
                    } 

}

/* -------------------------------------------------------------- */
void init_textwindow ( argc,argv )
int argc;
char *argv[];
{
                /*****************************/
                /* Textwindow initialisieren */
                /*****************************/
if ( f_file == 0 ) {
                    texthint.x = 510;
                    texthint.y = 200;
                   }
else {
      texthint.x = 5;
      texthint.y = 5;
     }
 texthint.width = 305;
 texthint.height = 400;
 texthint.flags = PPosition | PSize ;

 textwin = XCreateSimpleWindow ( mydisplay,DefaultRootWindow ( mydisplay ),
                                 texthint.x,texthint.y,texthint.width,
                                 texthint.height,5,foreground,background );

 XSetStandardProperties ( mydisplay,textwin,"RoboSim-Eingabe","RoboSimE",
                          None,argv,argc,&texthint );

 mywmhints.input = False;
 mywmhints.flags = InputHint;
 XSetWMHints ( mydisplay,textwin,&mywmhints);

 textgc =  XCreateGC ( mydisplay,textwin,0,0 );
 XSetBackground ( mydisplay,textgc,background );
 XSetForeground ( mydisplay,textgc,foreground );

 XSelectInput ( mydisplay,textwin,ExposureMask |
                                  KeyPressMask |
                                  ButtonPressMask |
                                  EnterWindowMask |
                                  LeaveWindowMask );

}

/* -------------------------------------------------------------- */

void init_helpwin( argc,argv )
int argc;
char *argv[];
{
 helphint.x = 10;
 helphint.y = 300;
 helphint.width = 350;
 helphint.height = 250;
 helphint.flags = PPosition | PSize;

 helpwin = XCreateSimpleWindow ( mydisplay,DefaultRootWindow ( mydisplay),
                                10,300,500,500,5,BlackPixel(mydisplay,myscreen),
                                WhitePixel( mydisplay,myscreen));

 XSetStandardProperties ( mydisplay,helpwin,"RoboSim-Hilfe","RoboSimH",
                          None,argv,argc,&helphint );
 helpgc = XCreateGC ( mydisplay,helpwin,0,0 );
 XSetForeground ( mydisplay,helpgc,BlackPixel(mydisplay,myscreen) );
 XSetBackground ( mydisplay,helpgc,WhitePixel(mydisplay,myscreen) );

 XSelectInput ( mydisplay,helpwin,ExposureMask |
                                  ButtonPressMask );
}
/* -------------------------------------------------------------- */
void init_Regler ()
{
 regelwin = XCreateSimpleWindow ( mydisplay,textwin,190,110,95,15,
                                  1,foreground,background );

 XSelectInput ( mydisplay,regelwin, ButtonPressMask | ButtonReleaseMask |
                OwnerGrabButtonMask | PointerMotionMask | ExposureMask ); 
}
/* -------------------------------------------------------------- */
init_buttonwindows ( )
{
 int x,y,i,dx,dy;
                  /**************************/
                  /* Buttons initialisieren */
                  /**************************/
 x = 15; y = 15;
 for ( i = 0 ; i < 11 ; i++ )
 {
  dx = 80;
  dy = 20;
  if ( i == 3 )  { x = 15;
                   y = 60; }
  if ( i == 6 )  { x = 100;
                   y = 315; 
                   dx = 40;
                 }
  if ( i == 7 )  { x = 200;
                   y = 315; } 
  if ( i == 8 )  { x = 255;
                   y = 250;
                   dx = 40;
                 }
  if ( i == 9 ) { x = 15;
                  y = 105;
                }
  if ( i == 10 ) { x = 120;
                   y = 365;
                   dx = 80;
                   dy = 20;
                 }
  if ( (i==9 && depth>1) || i!=9 )
  { 
  bwin[i] = XCreateSimpleWindow ( mydisplay,textwin,x,y,dx,dy,
                                  1,foreground,background );
  bgc[i] = XCreateGC ( mydisplay,bwin[i],0,0 );
  XSetBackground ( mydisplay,bgc[i],background );
  XSetForeground ( mydisplay,bgc[i],foreground ); 
  
  XSelectInput ( mydisplay,bwin[i],ExposureMask |
                                   ButtonPressMask |
                                   EnterWindowMask |
                                   LeaveWindowMask );
 } 
 x = x + 95; 
 }
 
}

/* ------------------------------------------------------------- */
init_formularwindows ( )
{
 int x,y,i;
                 /****************************/ 
                 /* Formulare initialisieren */
                 /****************************/
 x = 60; y = 180;
 for ( i = 0; i < 7; i++ )
 {
  if ( i== 2 || i==4 || i == 6) { x = 60;
                                  y = y + 50; }

  fwin[i] = XCreateSimpleWindow ( mydisplay,textwin,x,y,80,15,
                                  1,BlackPixel(mydisplay,myscreen),background ); 

  fgc[i] = XCreateGC ( mydisplay,fwin[i],0,0 );
  XSetBackground ( mydisplay,fgc[i],background );
  XSetForeground ( mydisplay,fgc[i],BlackPixel(mydisplay,myscreen) );

  XSelectInput ( mydisplay,fwin[i],ExposureMask |
                                   EnterWindowMask |
                                   LeaveWindowMask |
                                   KeyPressMask );
  x = x + 140;
 } 
}

/* -------------------------------------------------------------- */
init_hwin ()
{
 int x,y,i;
             /*******************************/
             /* Hilfsfenster initialisieren */
             /*******************************/
 x = 60; y = 200; 
 for ( i=0 ; i<7 ; i++ )
 {
  if ( i==2 || i==4 || i == 6 ) { x = 60;
                                  y = y + 50; }

  hwin[i] = XCreateSimpleWindow ( mydisplay,textwin,x,y,100,15,
                                  0,BlackPixel(mydisplay,myscreen),background );

  hgc[i] = XCreateGC ( mydisplay,hwin[i],0,0 );
  XSetBackground ( mydisplay,hgc[i],background );
  XSetForeground ( mydisplay,hgc[i],BlackPixel(mydisplay,myscreen) );

  XSelectInput ( mydisplay,hwin[i],ExposureMask );

  x = x + 140;

 }
}
/* -------------------------------------------------------------- */

init_deckwindow ( )
{
 dwin = XCreateSimpleWindow ( mydisplay,textwin,0,140,
                              texthint.width,texthint.height-140,
                              1,BlackPixel(mydisplay,myscreen),background );

 dgc = XCreateGC ( mydisplay,dwin,0,0 );
 XSetBackground ( mydisplay,dgc,background );
 XSetForeground ( mydisplay,dgc,foreground );

 titelgc = XCreateGC ( mydisplay,dwin,0,0 );
 XSetForeground ( mydisplay,titelgc,BlackPixel(mydisplay,myscreen) );
 XSetBackground ( mydisplay,titelgc,background );

 XSelectInput ( mydisplay,dwin,ExposureMask );  
}                              
/* -------------------------------------------------------------- */
load_set_fonts ()
{
 int i;

 font[0] = XLoadFont ( mydisplay,"8x13" );    /* Eingabefont */
 font[1] = XLoadFont ( mydisplay,"8x13bold" ); /* Buttonfont */
 font[2] = XLoadFont ( mydisplay,
   "-adobe-new century schoolbook-bold-r-normal--18-*-*-*-*-*-*-*" );

 for (i=0;i<9;i++) 
 { XSetFont ( mydisplay,bgc[i],font[btext[i].f] ); }

 XSetFont ( mydisplay,titelgc,font[ftext[0].f] );

 curs = XCreateFontCursor ( mydisplay, XC_hand2 );
 XDefineCursor( mydisplay,textwin,curs );  

}
/*--------------------------------------------------------------- */

void menu_windows ( Menu )
int Menu;
{
 int i;

 XMapRaised ( mydisplay,dwin );
 XClearWindow ( mydisplay,dwin );

 XMapRaised ( mydisplay,bwin[7] );
 XMapRaised ( mydisplay,bwin[10] );

 switch ( Menu )
 {             
  case FARBE: for ( i=0 ; i<7 ; i++ )
                 {
                  XMapRaised ( mydisplay,fwin[i] );
                  XMapRaised ( mydisplay,hwin[i] );
                 }  
             break;
  case MANUELL: XMapRaised ( mydisplay,bwin[6] );
  case WINKEL : for ( i=0 ; i<6 ; i++ )
                 {
                  XMapRaised ( mydisplay,fwin[i] );
                  XMapRaised ( mydisplay,hwin[i] );
                 }  
                break; 
  case AUTO:
  case BETRACHTER: XMapRaised ( mydisplay,bwin[6] );
  default : for ( i=0 ; i<3 ; i++ )
             {
               XMapRaised ( mydisplay,fwin[i] );
               XMapRaised ( mydisplay,hwin[i] );
             }
            if ( f_auto_winkel == 1 ) XMapRaised ( mydisplay,bwin[8] );
           break;
 }
}
/* --------------------------------------------------------------- */

void menu_Schrift ( Menu )
int Menu;
{
 int i;

 XSetForeground ( mydisplay,dgc,BlackPixel(mydisplay,myscreen) );
 switch ( Menu )
 {
  case MANUELL: XDrawImageString ( mydisplay,dwin,titelgc,ftext[0].x,
                                   ftext[0].y,ftext[0].t,strlen(ftext[0].t));
                for ( i=1 ; i<7 ; i++ )
                 {
                  XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                     ftext[i].y,ftext[i].t,strlen(ftext[i].t));
                 }
                XDrawImageString ( mydisplay,dwin,dgc,ftext[22].x, ftext[22].y,
                                  ftext[22].t,strlen(ftext[22].t) );
                break;

  case FARBE: XDrawImageString ( mydisplay,dwin,titelgc,ftext[23].x,
                                 ftext[23].y,ftext[23].t,strlen(ftext[23].t) );
              for ( i=24 ; i<31 ; i++ )
               {
                 XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                    ftext[i].y,ftext[i].t,strlen(ftext[i].t));
               }
              break;

  case WINKEL: XDrawImageString ( mydisplay,dwin,titelgc,ftext[21].x,
                                  ftext[21].y,ftext[21].t,strlen(ftext[21].t));
               for ( i=1 ; i<7 ; i++ )
                {
                 XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                    ftext[i].y,ftext[i].t,strlen(ftext[i].t));
                }
               break; 

  case BETRACHTER: XDrawImageString ( mydisplay,dwin,titelgc,ftext[13].x,
                                  ftext[13].y,ftext[13].t,strlen(ftext[13].t));
                   for ( i=14 ; i<17 ; i++ )
                    {
                     XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                    ftext[i].y,ftext[i].t,strlen(ftext[i].t));
                    }
                   XDrawImageString ( mydisplay,dwin,dgc,ftext[22].x, ftext[22].y,
                                  ftext[22].t,strlen(ftext[22].t) );
                  break;

  case ARMLAENGE:
            XDrawImageString ( mydisplay,dwin,titelgc,ftext[17].x,
                                  ftext[17].y,ftext[17].t,strlen(ftext[17].t));
            for ( i=18 ; i<21 ; i++ )
             {
              XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                 ftext[i].y,ftext[i].t,strlen(ftext[i].t));
             }
            break;

  case AUTO: XDrawImageString ( mydisplay,dwin,titelgc,ftext[7].x,
                                  ftext[7].y,ftext[7].t,strlen(ftext[7].t));
             for ( i=8 ; i<12 ; i++ )
              {
               XDrawImageString ( mydisplay,dwin,dgc,ftext[i].x,
                                  ftext[i].y,ftext[i].t,strlen(ftext[i].t));
              }
             XDrawImageString ( mydisplay,dwin,dgc,ftext[22].x, ftext[22].y,
                                  ftext[22].t,strlen(ftext[22].t) );
             break;


 }
}
/* --------------------------------------------------------------- */

void string_lesen ( t,inputstring,anzahl,max )
char t[10];            /* aktuelles Zeichen */
char inputstring[50];
int anzahl;
int max;
{
  int i,
      punkt = 0;


  for ( i=0 ; i<strlen(inputstring) ; i++ )
   {
    if ( inputstring[i] == '.' ) punkt = 1;
   }
  if ( key == XK_Delete ||
       key == XK_BackSpace )
     {
      inputstring[ strlen(inputstring)-1] = 0;
     } 
 else 
     {
       if ( anzahl == 1)
        {
         if (  isdigit ( t[0] ) ||
             ( t[0] == '.' && punkt ==  0 ) ||
             ( ( t[0] =='+' || t[0] == '-' ) && strlen(inputstring) == 0 ))
          {
           if ( strlen(inputstring) < max ) {
                                             strcat ( inputstring,t );
                                            }
          } 
        }
           
     }
}
/* -------------------------------------------------------------- */

void string_farbe_lesen ( t,inputstring,anzahl,max )
char t[10];
char inputstring[50];
int anzahl;
int max;
{
 
 if ( key == XK_Delete ||
      key == XK_BackSpace )
  {
   inputstring[strlen(inputstring)-1] = 0;
  }
 else
  {
   if ( anzahl == 1 && key!=XK_Return) 
                                      {
                                       strcat(inputstring,t);
                                      }
  }
}
/* -------------------------------------------------------------- */

string_loeschen ( s )
char s[20];
{
 int i;

 for ( i=0;i<19;i++ ) s[i] = 0;
}

/* -------------------------------------------------------------- */

void setze_flags_null()
{
 f_manu = 0;
 f_auto_winkel = 0;
 f_Winkel = 0;
 f_Betr = 0;
 f_Arm = 0;
 f_Farbe = 0;
}
/* -------------------------------------------------------------- */
aktualisiere_hwin ( winkel,stdpkt )
Winkel_Daten winkel[6];
double stdpkt[3];
{
 int i,hilf;
 char buffer[20];
 double wert;
 double pos[3];

 if (f_manu == 1 ) {
                     for ( i=0 ; i<6 ; i++ )
                     {
                      hilf = (int)(winkel[i].akt * (18000/PI) );
                      wert = (float)(hilf) / 100;
                      gcvt (wert,5,buffer);
                      XClearWindow ( mydisplay,hwin[i] );
                      XDrawImageString ( mydisplay,hwin[i],hgc[i],5,10,
                                         buffer,strlen(buffer)); 

                     }
                   }
 if (f_Farbe == 1) {
                     XClearWindow ( mydisplay,hwin[0] ); 
                     XDrawImageString ( mydisplay,hwin[0],hgc[0],5,10,
                                        fname[5],strlen(fname[5]) );
                     for ( i=0 ; i<5 ; i++ )
                      {
                       XClearWindow ( mydisplay,hwin[i+1] );
                       XDrawImageString ( mydisplay,hwin[i+1],hgc[i+1],
                                          5,10,fname[i],strlen(fname[i]) );
                      }
                     XClearWindow ( mydisplay,hwin[6] );
                     XDrawImageString ( mydisplay,hwin[6],hgc[0],
                                        5,10,fname[7],strlen(fname[7]) ); 
                    }
 if (f_Winkel == 1) { for ( i=0 ; i<6 ; i++ )
                      {
                       wert = (double)(wgewicht[i]);
                       gcvt ( wert,5,buffer );
                       XClearWindow ( mydisplay,hwin[i] );
                       XDrawImageString ( mydisplay,hwin[i],hgc[i],5,10,
                                         buffer,strlen(buffer)); 
                      }
                    }
 if (f_Betr == 1 ) {
                    for ( i=0 ; i<3 ; i++ )
                     {
                      gcvt(stdpkt[i],5,buffer);
                      XClearWindow ( mydisplay,hwin[i] );
                      XDrawImageString ( mydisplay,hwin[i],hgc[i],5,10,
                                         buffer,strlen(buffer)); 

                     }  
                   }
 if (f_auto_winkel == 1)
                    {
                     berechne_Pos ( winkel,pos );
                     for ( i=0 ; i<3 ; i++ )
                     {
                      XClearWindow ( mydisplay,hwin[i] );
                      gcvt(pos[i],5,buffer);
                      XDrawImageString ( mydisplay,hwin[i],hgc[i],5,10,
                                         buffer,strlen(buffer)); 

                     }
                    }
 if ( f_Arm == 1 ) {
                    for ( i=0 ; i<3 ; i++ )
                     {
                      XClearWindow ( mydisplay,hwin[i] ); 
                      gcvt( linkl[i],5,buffer );
                      XDrawImageString ( mydisplay,hwin[i],hgc[i],5,10,
                                         buffer,strlen(buffer) ); 
                     }
                   }
}
/* -------------------------------------------------------------- */

void show_errorwin ( Meldung1,Meldung2)
char Meldung1[];
char Meldung2[];
{
 XMapRaised ( mydisplay,errorwin );
 XClearWindow ( mydisplay,errorwin );
 XDrawImageString ( mydisplay,errorwin,bgc[0],45,30,"Fehlermeldung:",
                    strlen("Fehlermeldung:") );

 XDrawImageString ( mydisplay,errorwin,fgc[0],10,50,Meldung1,strlen(Meldung1) );
 XDrawImageString ( mydisplay,errorwin,fgc[0],10,65,Meldung2,strlen(Meldung2) );
 XDrawImageString ( mydisplay,errorwin,fgc[0],100,100,"<QUIT>",6);
}
/* -------------------------------------------------------------- */

void event_handle ( aktion , eingabe,estring,winkel,stdpkt,pos )
int *aktion;
double eingabe[];
string estring[];
Winkel_Daten winkel[6];
double stdpkt[3];
double pos[3];
 {
  int i,j,k, anfang,ende, 
      anzahl = 0;
  char input[10],buffer[20];
  Time time;

  *aktion = -1;
  XNextEvent ( mydisplay,&myevent );
  switch ( myevent.type )
  {
   case Expose:
               if ( myevent.xexpose.count == 0 )
               {
                 if ( myevent.xexpose.window == helpwin )
                 {
                       
                   if ( f_manu == 1 ) {
                                       anfang = 0;
                                       ende = 6;
                                      }
                   if ( f_auto_winkel == 1 ) {
                                              anfang = 6;
                                              ende = 12;
                                             }
                   if ( f_Betr == 1 ) {
                                       anfang = 12;
                                       ende = 18;
                                      }
                   if ( f_Arm == 1 ) {
                                      anfang = 18;
                                      ende = 24;
                                     }
                   if ( f_Winkel == 1 ) {
                                         anfang = 24;
                                         ende = 30;
                                        }
                   if ( f_Farbe == 1 ) {
                                         anfang = 30;
                                         ende = 36;
                                       }
                   XSetFont( mydisplay,helpgc,font[Htext[anfang].f] );   
                   XDrawImageString( mydisplay,helpwin,helpgc,Htext[anfang].x,
                                     Htext[anfang].y,Htext[anfang].t,strlen(Htext[anfang].t));

                   XSetFont( mydisplay,helpgc,font[1] );
                   
                   for ( k=anfang+1; k<ende; k++ )
                    XDrawImageString( mydisplay,helpwin,helpgc,Htext[k].x,
                                      Htext[k].y,Htext[k].t,strlen(Htext[k].t));

                   XDrawImageString ( mydisplay,helpwin,helpgc,160,230,"<QUIT>",6);
                 }
                 for ( i=0 ; i<3 ; i++ )
                  {
                   if ( myevent.xexpose.window == Bregelwin[i] )
                    {
                     XFillArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],1,14,14,0,23040 );
                     break;
                    }
                  }
                if ( myevent.xexpose.window == Graphdwin ) 
                  {
                   for ( i=0 ; i<3 ; i++ )XMapRaised ( mydisplay,Bregelwin[i] ); 
                   for ( i=0 ; i<5 ; i++ )
                   XDrawImageString ( mydisplay,Graphdwin,fgc[0],
                                        Bregelt[i].x,Bregelt[i].y,
                                        Bregelt[i].t,strlen(Bregelt[i].t));
                  }                  
                if ( myevent.xexpose.window == regelwin )
                 {
                  for ( i=0 ; i<3 ; i++ )
                  {
                   XDrawImageString ( mydisplay,textwin,fgc[0],rtext[i].x,
                                      rtext[i].y,rtext[i].t,strlen(rtext[i].t));
                  }
                 XFillArc ( mydisplay,regelwin,fgc[0],x_regler,1,14,14,0,23040 );
                 }  
                if ( myevent.xexpose.window == textwin )
                 {
                     /*  Textwindow neu herstellen */                 
                 }  
                if ( myevent.xexpose.window == graphwin )
                 {
                   show_pixmap();
                 }
                i = 0;
                while ( i < 8 )
                {
                 if ( myevent.xexpose.window == bwin[i] && i != 6 )
                  {
                   XDrawImageString ( mydisplay,bwin[i],bgc[i],
                                      btext[i].x,btext[i].y,btext[i].t,
                                      strlen ( btext[i].t ) );
                   break;
                  }    
                 i++;
                }   /* End While */
               if ( myevent.xexpose.window == bwin[6] )
                {
                 if ( f_absolut == 0 ) XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                                          btext[10].x,btext[10].y,btext[10].t,
                                                          strlen(btext[10].t) );
                 else XDrawImageString  ( mydisplay,bwin[6],bgc[8],
                                          btext[11].x,btext[11].y,btext[11].t,
                                          strlen(btext[11].t) );

                }   
               if ( myevent.xexpose.window == bwin[8] )
                {
                  if ( f_auto_gerade == 0 )  XDrawImageString ( mydisplay,bwin[8],bgc[8],
                                                                btext[8].x,btext[8].y,btext[8].t,
                                                                strlen ( btext[8].t ) );
                  else  XDrawImageString ( mydisplay,bwin[8],bgc[8],
                                           btext[9].x,btext[9].y,btext[9].t,
                                           strlen ( btext[9].t ) );


                }
                if ( myevent.xexpose.window == bwin[9] )
                {
                 XDrawImageString ( mydisplay,bwin[9],bgc[0],btext[12].x,btext[12].y,
                                    btext[12].t,strlen( btext[12].t ) );
                }  
               if ( myevent.xexpose.window == bwin[10] )
                {
                 XDrawImageString ( mydisplay,bwin[10],bgc[0],btext[13].x,btext[13].y,
                                    btext[13].t,strlen( btext[13].t ) );
                }  
  
               if ( myevent.xexpose.window == dwin )
                {  
                 if ( f_allg == 1 )
                  {
                   if ( f_manu == 1 ) menu_Schrift ( MANUELL );
                   if ( f_auto_winkel == 1 ) menu_Schrift ( AUTO );
                   if ( f_Betr == 1 ) menu_Schrift ( BETRACHTER );
                   if ( f_Arm == 1 ) menu_Schrift ( ARMLAENGE );      
                   if ( f_Winkel == 1 ) menu_Schrift ( WINKEL );
                  }     
                } 
               for ( i=0 ; i<7 ; i++ )
                {
                 if ( myevent.xexpose.window == fwin[i] )
                  {
                   if ( finput[i] != 0 )
                     {
                      XDrawImageString ( mydisplay,fwin[i],fgc[0],5,10,
                                         finput[i],strlen( finput[i] ));
                      break; 
                     }  
                  }
                } 
               }
               
               break;
   case MappingNotify:
                      XRefreshKeyboardMapping ( &myevent );
                      break;
   case MotionNotify :
                      if ( Bregel_flag[0] + Bregel_flag[1] + Bregel_flag[2] == 1)
                      {
                      for ( i=0 ; i<3 ; i++ )
                       { 
                        if ( myevent.xmotion.window == Bregelwin[i] && Bregel_flag[i] == 1)
                         {
                          Bregler[i] = myevent.xmotion.x;
                          if ( !(Bregler[i] > 1) ) Bregler[i] = 1;
                          if ( !(Bregler[i] < 441) ) Bregler[i] = 441;
                          
                          if ( f_Betr == 1 )
                          {
                           for ( j=0 ; j<3 ; j++ )
                           {
                            if ( j == i ) 
                              eingabe[j] = (51.0/225.0)*(Bregler[j] - 220.5);
                            else eingabe[j] = stdpkt[j];
                           }
                          *aktion = BETRACHTER;
                          }
                          if ( f_auto_winkel == 1 )
                          {
                           for ( j=0 ; j<3 ; j++ )
                           {
                            if ( j == i ) eingabe[j] = (51.0/225.0)*(Bregler[j] - 220.5);
                            else eingabe[j] = pos[j];
                           }
                           *aktion = AUTO;
                          }
                          XClearWindow ( mydisplay,Bregelwin[i] );
                          XDrawArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],
                                     1,14,14,0,23040 );
                          break;
                         } 
                       }
                       }
                      if ( myevent.xmotion.window == regelwin &&
                           regel_flag == 1 )
                       {
                        x_regler = myevent.xmotion.x;
                        if ( !(x_regler>1)) x_regler = 1;
                        if ( !(x_regler<82)) x_regler = 82;
                        XClearWindow ( mydisplay,regelwin );
                        XDrawArc ( mydisplay,regelwin,fgc[0],x_regler,1,14,14,0,23040 );
                       }
                      break;
   case ButtonRelease :
                       if (  Bregel_flag[0] + Bregel_flag[1] + Bregel_flag[2] == 1)
                       {
                       for ( i=0 ; i<3 ; i++ )
                       { 
                        if ( myevent.xmotion.window == Bregelwin[i] && Bregel_flag[i] == 1 )
                         {
                          Bregel_flag[i] = 0;
                          Bregler[i] = myevent.xmotion.x;
                          if ( !(Bregler[i] > 1) ) Bregler[i] = 1;
                          if ( !(Bregler[i] < 441) ) Bregler[i] = 441;
                          if ( f_auto_winkel == 1 )
                          {
                           for ( j=0 ; j<3 ; j++ )
                           {
                            if ( j == i ) eingabe[j] = (51.0/225.0)*(Bregler[j] - 220.5);
                            else eingabe[j] = pos[j];
                           }
                           *aktion = AUTO;
                          }
                          if ( f_Betr == 1 )
                          {
                          for ( j=0 ; j<3 ; j++ )
                           {
                            if ( j == i ) 
                              eingabe[j] = (51.0/225.0)*(Bregler[j] - 220.5);
                            else eingabe[j] = stdpkt[j];
                           }
                          *aktion = BETRACHTER;
                          }  
                          XClearWindow ( mydisplay,Bregelwin[i] );
                          XFillArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],
                                     1,14,14,0,23040 );
                          break;
                         } 
                        }
                       } 
                       if ( myevent.xbutton.window == regelwin &&
                            regel_flag == 1)
                        {
                         x_regler = myevent.xbutton.x;
                         if ( !(x_regler>1) ) x_regler = 1;
                         if ( !(x_regler<82) ) x_regler = 82; 
                         XClearWindow ( mydisplay,regelwin );
                         XFillArc ( mydisplay,regelwin,fgc[0],x_regler,1,14,14,0,23040 ); 
                         regel_flag = 0;
                         power[0] = 1 + (x_regler/10);
                         power[1] = power[0];
                         power[2] = 2 + (x_regler/10);
                         power[3] = 3 + (x_regler/10);
                         power[4] = power[3];
                         power[5] = power[3];
                        }
                       break;
   case ButtonPress:
                     XSetInputFocus ( mydisplay,textwin,
                                       RevertToPointerRoot,
                                       myevent.xbutton.time );
                    if ( myevent.xbutton.window == helpwin ) XUnmapWindow ( mydisplay,helpwin );
                    if ( myevent.xbutton.window == errorwin ) 
                     {
                      XMapRaised ( mydisplay,graphwin );
                      if ( f_Betr == 1 || f_auto_winkel == 1 ) 
                                         { XMapRaised(mydisplay,Graphdwin);   
                                           for ( i=0 ; i<5 ; i++ )
                                             {
                                              if ( i<3 )XMapRaised ( mydisplay,Bregelwin[i] );
                                              XDrawImageString ( mydisplay,Graphdwin,fgc[0],
                                                                 Bregelt[i].x,Bregelt[i].y,
                                                                 Bregelt[i].t,strlen(Bregelt[i].t));
                                             }                   
                                         }
                      break;
                     }
                    if ( myevent.xbutton.window == regelwin ) 
                     {
                      regel_flag = 1;
                      XClearWindow ( mydisplay,regelwin );
                      XDrawArc ( mydisplay,regelwin,fgc[0],x_regler,1,14,14,0,23040 );
                      break;
                     } 
                    if ( Bregel_flag[0] == 0 && Bregel_flag[1] == 0
                         && Bregel_flag[2] == 0 )
                    { 
                    for ( i=0 ; i<3 ; i++ )
                     {
                      if ( myevent.xbutton.window == Bregelwin[i] ) 
                     {
                      Bregel_flag[i] = 1;
                      f_absolut = 1;
                      XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                         btext[11].x,btext[11].y,btext[11].t,
                                         strlen(btext[11].t) );   
                      Bregler[i] = myevent.xbutton.x;
                      XClearWindow ( mydisplay,Bregelwin[i] );
                      XDrawArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],1,14,14,0,23040 );
                      break;
                     } 

                    } 
                    } 
                    if ( myevent.xbutton.window == bwin[0] )
		      {  /* manuelle Steuerung */
                                           XUnmapWindow( mydisplay,helpwin );
                                           XMapRaised ( mydisplay,graphwin );
                                           if ( f_allg == 1 ) setze_flags_null ();
                                           f_allg = 1;
                                           f_manu = 1;
                                           for ( i = 0 ; i < 6 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                           menu_windows ( MANUELL );
                                           menu_Schrift ( MANUELL ); 
                                          aktualisiere_hwin(winkel,stdpkt );
                                           break;
                                          
                      }
                    if ( myevent.xbutton.window == bwin[1] )
                      {  /* automatische Steuerung */
                                           XUnmapWindow( mydisplay,helpwin );
                                            XMapRaised ( mydisplay,graphwin );
                                           if ( f_allg == 1 ) setze_flags_null();
                                            f_allg = 1;
                                            f_auto_winkel = 1;
                                            for ( i = 0 ; i < 6 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                            menu_windows ( AUTO );
                                            menu_Schrift ( AUTO ); 
                                            aktualisiere_hwin(winkel,stdpkt );
                                            XMapRaised ( mydisplay,Graphdwin );
                                            for ( j=0 ; j<3 ; j++ ) 
                                            Bregler[j] = (int)((225.0 / 51.0) * pos[j] + 220.5);
                                            for ( i=0 ; i<5 ; i++ )
                                             {
                                              if ( i<3 )XMapRaised ( mydisplay,Bregelwin[i] );
                                              XDrawImageString ( mydisplay,Graphdwin,fgc[0],
                                                                 Bregelt[i].x,Bregelt[i].y,
                                                                 Bregelt[i].t,strlen(Bregelt[i].t));
                                             }
                                            break;
                                           
                      }
                    if ( myevent.xbutton.window == bwin[2] )
                      {  /* Betrachterstandpunkt */
                                           XUnmapWindow( mydisplay,helpwin );
                                            if ( f_allg == 1 ) setze_flags_null();
                                            f_allg = 1;
                                            f_Betr = 1;
                                            for ( i = 0 ; i < 6 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                            menu_windows ( BETRACHTER );
                                            menu_Schrift ( BETRACHTER ); 
                                           aktualisiere_hwin(winkel,stdpkt );
                                            XMapRaised ( mydisplay,Graphdwin );
                                           for ( j=0 ; j<3 ; j++ ) 
                                           Bregler[j] = (int)((225.0 / 51.0) * stdpkt[j] + 220.5);
                                            for ( i=0 ; i<5 ; i++ )
                                             {
                                              if ( i<3 )XMapRaised ( mydisplay,Bregelwin[i] );
                                              XDrawImageString ( mydisplay,Graphdwin,fgc[0],
                                                                 Bregelt[i].x,Bregelt[i].y,
                                                                 Bregelt[i].t,strlen(Bregelt[i].t));
                                             }
                                           
                                            break;  
                                           
                      } 
                    if ( myevent.xbutton.window == bwin[3] )
		      {  /* Armlaenge */
                                           XUnmapWindow( mydisplay,helpwin );
                                             XMapRaised ( mydisplay,graphwin );
                                             if ( f_allg == 1 ) setze_flags_null();
                                             f_allg = 1;
                                             f_Arm =1; 
                                             for ( i = 0 ; i < 6 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                             menu_windows ( ARMLAENGE );
                                             menu_Schrift ( ARMLAENGE ); 
                                           aktualisiere_hwin(winkel,stdpkt );
                                             break;
                      }
                    if ( myevent.xbutton.window == bwin[4] )
                      {  /* Winkelgewichte */
                                           XUnmapWindow( mydisplay,helpwin );
                                             XMapRaised ( mydisplay,graphwin );
                                             if ( f_allg == 1 ) setze_flags_null();
                                             f_allg = 1;
                                             f_Winkel = 1;
                                             for ( i = 0 ; i < 6 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                             menu_windows ( WINKEL );
                                             menu_Schrift ( WINKEL ); 
                                             aktualisiere_hwin(winkel,stdpkt );
                                             break; 
                      }
                    if ( myevent.xbutton.window == bwin[5] )
		      {  /* Beenden */
                       *aktion = 5; 
                       break;
		      }
                    if ( myevent.xbutton.window == bwin[6] )
                      { /* absolut - relativ */
                        if ( f_absolut == 1 ) { f_absolut = 0;
                                                XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                                          btext[10].x,btext[10].y,btext[10].t,
                                                          strlen(btext[10].t) );
                                              }
                        else { f_absolut = 1;
                               XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                                  btext[11].x,btext[11].y,btext[11].t,
                                                 strlen(btext[11].t) );
                             }
           
                        break;
                      }

                     if ( myevent.xbutton.window == bwin[9] )
                      {  /* Farben */
                                             XUnmapWindow ( mydisplay,helpwin );
                                             XMapRaised ( mydisplay,graphwin );
                                             if ( f_allg == 1 ) setze_flags_null();
                                             f_allg = 1;
                                             f_Farbe = 1;
                                             for ( i = 0 ; i < 7 ; i++ ) 
                                               string_loeschen ( finput[i] );
                                             menu_windows ( FARBE );
                                             menu_Schrift ( FARBE ); 
                                             aktualisiere_hwin(winkel,stdpkt);
                                             break; 
                      }

                    if ( myevent.xbutton.window == bwin[10] )
                     {
                      XMapRaised ( mydisplay,helpwin );
                      XClearWindow ( mydisplay,helpwin );
                     } 
 
                    if ( myevent.xbutton.window == bwin[7] )
		      {  /* ausfuehren
                            Die finput - Werte den 
                            entsprechenden Variablen
                            zuweisen, und finput loeschen ,
                            und entsprechende Aktion ausloesen   */

                        if ( f_manu == 1 )
                          {
                           *aktion = MANUELL;
                           for ( i=0 ; i<6 ; i++ )
                           {
                            if ( finput[i][0] != 0 ) {
                                                      eingabe[i]=(double)(atof(finput[i]));
                                                      eingabe[i]= eingabe[i] * PI/180;
                                                      string_loeschen(finput[i]);
                                                      XClearWindow ( mydisplay,fwin[i] ); 
                                                     }
                            else { if (f_absolut == 1) eingabe[i] = Winkel[i].akt; 
                                   else eingabe[i] = 0.0;}
                           } 
                          }
                       if ( f_Farbe == 1 )
                        {
                         *aktion = FARBE; 
                         for ( i=0 ; i<7 ; i++ )
                         {
                          if ( strlen(finput[i]) > 0 ) {
                                                 strcpy(estring[i],finput[i]);
                                                 string_loeschen(finput[i]);
                                                 XClearWindow ( mydisplay,fwin[i] );  
                                                }
                          else { if ( i== 0 ) strcpy ( estring[0],fname[5]);
                                 else
                                 {
                                  if ( i== 6 ) strcpy ( estring[6],fname[7] );
                                  else strcpy ( estring[i],fname[i-1] );
                                 }
                               }
                         } 
                        }
                       if ( f_auto_winkel == 1 )
                         {
                          berechne_Pos ( Winkel,pos );
                          *aktion = AUTO;
                          for ( i=0 ; i<3 ; i++ )
                          {
                           if ( finput[i][0] != 0 ) {     
                                                 eingabe[i]=(double)(atof(finput[i]));
                                                 string_loeschen(finput[i]);
                                                 XClearWindow ( mydisplay,fwin[i] ); 
                                                    }
                           else { if ( f_absolut == 1 ) eingabe[i] = pos[i];
                                  else eingabe[i] = 0.0; }
                          } 
                         }
                        if ( f_Betr == 1)
                         {
                          for ( i=0 ; i<3 ; i++ )
                           {
                            if ( strlen(finput[i]) != 0 ) 
                                 {
                                  eingabe[i] = (double)(atof(finput[i])); 
                                  string_loeschen(finput[i]);
                                  XClearWindow ( mydisplay,fwin[i] ); 
                                 }
                            else { if ( f_absolut == 1) eingabe[i] = stdpkt[i];
                                   else eingabe[i] = 0.0;}
                          }
                         *aktion = BETRACHTER; 
                        }

                       if ( f_Arm == 1 )
                        {
                         for ( i=0 ; i<3 ; i++ )
                          {
                           if ( strlen(finput[i]) != 0 )
                            {
                             eingabe[i] = (double)(atof(finput[i])); 
                             string_loeschen(finput[i]);
                             XClearWindow ( mydisplay,fwin[i] ); 
                            }
                           else { eingabe[i] = linkl[i];}
                          } 
                         *aktion = ARMLAENGE;
                        } 
                       if ( f_Winkel == 1 )
                        {
                           *aktion = WINKEL;
                           for ( i=0 ; i<6 ; i++ )
                           {
                            if ( finput[i][0] != 0 ) {
                                                      eingabe[i]=(double)(atof(finput[i]));
                                                      string_loeschen(finput[i]);
                                                      XClearWindow ( mydisplay,fwin[i] ); 
                                                     }
                            else { eingabe[i] = wgewicht[i]; }
                           } 
                          }

                       break; 
                       
                       }
                    if ( myevent.xbutton.window == bwin[8] )
		      { 
                       XClearWindow ( mydisplay,bwin[8] );
                       if ( f_auto_gerade == 0 ) {
                                                   f_auto_gerade = 1;
                                                   XDrawImageString ( mydisplay,bwin[8],bgc[8],
                                                                      btext[9].x,btext[9].y,btext[9].t,
                                                                      strlen ( btext[9].t ) );
                                                 }
                        else { f_auto_gerade = 0;
                                XDrawImageString ( mydisplay,bwin[8],bgc[8],
                                                   btext[8].x,btext[8].y,btext[8].t,
                                                   strlen ( btext[8].t ) );
                            }
                       break; 
		      }
                    
   case EnterNotify:
                    i = 0;
                    while ( i< 10 )
                    {
                     if ( myevent.xexpose.window == bwin[i])
                     {
                      XSetWindowBorderWidth ( mydisplay,bwin[i],2 );
                      break;
                     }   
                     i++;
                    }
                    for ( i=0 ; i<7 ; i++ )
                     {
                      if ( myevent.xexpose.window == fwin[i])
                       {
                        XSetWindowBorderWidth ( mydisplay,fwin[i],2 );

                          
                        strcat ( finput[i],"|" );
                        XDrawString ( mydisplay,fwin[i],fgc[0],5,10,
                                           finput[i],strlen( finput[i] ) );
                        finput[i][strlen(finput[i])-1] = 0;
 
                        break;
                       }   

                     }
                    break;
   case LeaveNotify:
                    i = 0;
                    while ( i < 10 )
                    {
                     if ( myevent.xexpose.window == bwin[i] )
                     {
                      XSetWindowBorderWidth ( mydisplay,bwin[i],1 );
                     } 
                     i++;
                    }  
                    for ( i=0 ; i<7 ; i++ )
                     {
                      if ( myevent.xexpose.window == fwin[i])
                       {
                        XSetWindowBorderWidth ( mydisplay,fwin[i],1 );
                        break;
                       }   
                      }
 
                    break;
   case KeyPress:
                 string_loeschen ( input ); 
                 anzahl = XLookupString ( &myevent,input,10,&key,0 );
                

                 /* Steuerung ueber Tasten */
                
                 if ( f_Betr == 1 ) 
                 {
                  if ( key == XK_Left )
                  {
                                             eingabe[0] = stdpkt[0] - 0.5;
                                             eingabe[1] = stdpkt[1];
                                             eingabe[2] = stdpkt[2];
                                             *aktion = -2;
                  }
                  if ( key == XK_Right )
                  {
                                             eingabe[0] = stdpkt[0] + 0.5;
                                             eingabe[1] = stdpkt[1];
                                             eingabe[2] = stdpkt[2];
                                             *aktion = -2;
                  }
                  if ( key == XK_Up )
                   {
                                             eingabe[0] = stdpkt[0];
                                             eingabe[1] = stdpkt[1];
                                             eingabe[2] = stdpkt[2] - 0.5;
                                             *aktion = -2; 
                  }
                  if ( key == XK_Down )
                  {
                                       eingabe[0] = stdpkt[0];
                                       eingabe[1] = stdpkt[1];
                                       eingabe[2] = stdpkt[2] + 0.5;
                                       *aktion = -2; 
                  }
                  if ( key == XK_R9 )
                  {
                                       eingabe[0] = stdpkt[0];
                                       eingabe[1] = stdpkt[1] + 0.5;
                                       eingabe[2] = stdpkt[2];
                                       *aktion = -2; 
                  }
                  if ( key == XK_R15 )
                  {
                                       eingabe[0] = stdpkt[0];
                                       eingabe[1] = stdpkt[1] - 0.5;
                                       eingabe[2] = stdpkt[2];
                                       *aktion = -2; 
                  }
  
                  if ( *aktion != -1 ) 
                   {
                    XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                       btext[11].x,btext[11].y,btext[11].t,
                                       strlen(btext[11].t) );
                    f_absolut = 1;
                    *aktion = BETRACHTER;
                   }
                 }
                 if ( f_auto_winkel == 1 ) 
                 {
                  berechne_Pos( Winkel,pos ); 
                  if ( key == XK_Left )
                  {
                                             eingabe[0] = pos[0] - 0.5;
                                             eingabe[1] = pos[1];
                                             eingabe[2] = pos[2];
                                             *aktion = -2;
                  }
                  if ( key == XK_Right )
                  {
                                             eingabe[0] = pos[0] + 0.5;
                                             eingabe[1] = pos[1];
                                             eingabe[2] = pos[2];
                                             *aktion = -2;
                  }
                  if ( key == XK_Up )
                   {
                                             eingabe[0] = pos[0];
                                             eingabe[1] = pos[1];
                                             eingabe[2] = pos[2] - 0.5;
                                             *aktion = -2; 
                  }
                  if ( key == XK_Down )
                  {
                                       eingabe[0] = pos[0];
                                       eingabe[1] = pos[1];
                                       eingabe[2] = pos[2] + 0.5;
                                       *aktion = -2; 
                  }
                  if ( key == XK_R9 )
                  {
                                       eingabe[0] = pos[0];
                                       eingabe[1] = pos[1] + 0.5;
                                       eingabe[2] = pos[2];
                                       *aktion = -2; 
                  }
                  if ( key == XK_R15 )
                  {
                                       eingabe[0] = pos[0];
                                       eingabe[1] = pos[1] - 0.5;
                                       eingabe[2] = pos[2];
                                       *aktion = -2; 
                  }
  
                  if ( *aktion != -1 ) 
                   {
                    XDrawImageString ( mydisplay,bwin[6],bgc[8],
                                       btext[11].x,btext[11].y,btext[11].t,
                                       strlen(btext[11].t) );
                    f_absolut = 1;
                    *aktion = AUTO;
                    f_auto_gerade = 1;
                    XDrawImageString ( mydisplay,bwin[8],bgc[8],
                                       btext[9].x,btext[9].y,btext[9].t,
                                       strlen ( btext[9].t ) );
 
                   }
                 }

                 i = 0;
                 while ( i < 7 )
        	    {
                     if ( myevent.xkey.window == fwin[i] && f_Farbe == 0 && i<6)
                     {
                      string_lesen ( input,finput[i],anzahl,10 ); 
                      XClearWindow ( mydisplay,fwin[i] );
                       
                      strcat ( finput[i],"|" );

                      XDrawString ( mydisplay,fwin[i],fgc[i],5,10,
                                         finput[i],strlen( finput[i] ) );

                      finput[i][strlen(finput[i])-1] = 0;
                      break;
		     } /* End if */
                     if ( myevent.xkey.window == fwin[i] && f_Farbe == 1)
                      {
                       string_farbe_lesen(input,finput[i],anzahl,20);
                       XClearWindow ( mydisplay,fwin[i] );
 
                       strcat ( finput[i] , "|" );

                       XDrawString ( mydisplay,fwin[i],fgc[0],5,10,
                                         finput[i],strlen( finput[i] ) );

                       finput[i][strlen(finput[i])-1] = 0;
                      break;

                      } 
                     i++;
                    } /* End while */ 
                break;
  }
}
  
