/*********************************************************************/
/*  File:  Robotersimulation                                         */
/*                                                                   */
/*  Author: Rainer Pollak                                            */
/*********************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h> 
#include <search.h>

#include "rs_Daten.h"
#include "rs_Kin.h"
#include "rs_X.h"

/* ************************ Funktionen **************************** */ 

void Winkelberechnung ( x,y,z,wy,wx,d )
double x;     /* neues Projektionszentrum   */
double y;
double z;
double *wy;   /* Rotationswinkel um Y-Achse */
double *wx;   /* Rotationswinkel um X-Achse */
double *d;    /* Position auf der Z-Achse   */
{
 double betrag;
 double hx,hy,hz;

 betrag = sqrt ( x*x + z*z );

 /* Berechnung des Winkelbetrages wy */
 if ( betrag == 0 ) {
                     *wy = 0.0;
                    }
 else               {
                     *wy = acos( z / betrag );
                    }

 /* Berechnung des Vorzeichens von wy */
 if (  x > 0 ) *wy = -*wy;

 /* Rotation um die Y-Achse */
 hx = cos(*wy)*x + sin(*wy)*z;
 hy = y;
 hz = cos(*wy)*z - sin(*wy)*x;

 betrag = sqrt ( hx*hx + hy*hy + hz*hz );

 /* Berechnung des Winkelbetrages wx */
 *wx = acos( (hz)/betrag );

 /* Berechnung des Vorzeichens von wx */
 if ( hy < 0 ) *wx = -*wx;

 /* Rotation um X-Achse */
 x = hx;
 y = cos(*wx)*hy - sin(*wx)*hz;
 z = sin(*wx)*hy + cos(*wx)*hz;

 /* Test ob neues Projektionszentrum nahe genug
    an der Z-Achse liegt                        */
 if ((fabs(x)<0.01)&&(fabs(y)<0.01)) {
                                       *d = z;
                                      }
 else                                 {
                                       exit(1);
                                      }      
}

/* ---------------------------------------------------------------- */

void Projektion ( pl,kl,kpl,Anzahl_pkte,Anzahl_kten,wy,wx,d,stdpkt )
Points pl[];               /* 3D - Punkteliste */
Kanten kl[];
Kanten_Punkte_Liste kpl[];
int Anzahl_pkte;
int Anzahl_kten;
double wy;                            /* Projektionsparameter */
double wx;
double d;
int stdpkt;                           /* stdpkt = 0 ... alter Standpunkt */
                                      /* stdpkt = 1 ... neuer Standpunkt */
{
 int i,anfang,merker;
 double m,x,y,z;
 static double c_wy,s_wy,s_wxs_wy,c_wx,c_wxs_wy,
               s_wx,c_wxc_wy,s_wxc_wy;
 Points ph[ANZAHL_PKTE];

merker = 0;

if ( stdpkt == NEU )
 {
  c_wy = cos(wy);
  c_wx = cos(wx);
  s_wy = sin(wy);
  s_wx = sin(wx);
  s_wxs_wy = s_wx * s_wy;
  s_wxc_wy = s_wx * c_wy;
  c_wxs_wy = c_wx * s_wy;
  c_wxc_wy = c_wx * c_wy;
  anfang = 0;
 }
else { anfang = 44; }

/* ---------------------------------------------------
     Rotation der Punkte, so dass Betrachter auf der
     Z-Achse steht.
   --------------------------------------------------- */

 for ( i=anfang;i<Anzahl_pkte;i++)
  {
   ph[i].x = c_wy * pl[i].x + s_wy * pl[i].z;
   ph[i].y = s_wxs_wy * pl[i].x + c_wx * pl[i].y - s_wxc_wy * pl[i].z;
   ph[i].z = s_wx * pl[i].y - c_wxs_wy * pl[i].x + c_wxc_wy * pl[i].z;

   if ( ph[i].z >= (d- 2 ) ) merker = 1;
  }
 

/* ---------------------------------------------------
   Initialisierung der Kanten_Punkte_Liste
   --------------------------------------------------- */
   if ( stdpkt == NEU ) anfang=0;
   else anfang = 56;   

   for ( i=anfang ; i<Anzahl_kten ; i++ )
    {
     kpl[i].p1.x = ph[ kl[i].p1 ].x;
     kpl[i].p1.y = ph[ kl[i].p1 ].y;
     kpl[i].p1.z = ph[ kl[i].p1 ].z;

     kpl[i].p2.x = ph[ kl[i].p2 ].x;
     kpl[i].p2.y = ph[ kl[i].p2 ].y;
     kpl[i].p2.z = ph[ kl[i].p2 ].z; 
    }

/* ----------------------------------------------------
    3 D - Clippingalgorithmus.
   ---------------------------------------------------- */

 if ( merker == 1 )
  {  
   for ( i=anfang ; i<Anzahl_kten ; i++ )
    {
     if ( kpl[i].p1.z >= (d-2) && kpl[i].p2.z >= (d-2) )
      {
        kpl[i].sichtbar = 1;
      }
     else
     {
      if (!( (kpl[i].p1.z < (d-2)) && (kpl[i].p2.z < (d-2)) ))
       {  /* es muss geclippt werden. */
        
        m = ( (d-2) - kpl[i].p1.z ) / ( kpl[i].p2.z - kpl[i].p1.z );

        x = kpl[i].p1.x + m * ( kpl[i].p2.x - kpl[i].p1.x );
        y = kpl[i].p1.y + m * ( kpl[i].p2.y - kpl[i].p1.y );
        z = kpl[i].p1.z + m * ( kpl[i].p2.z - kpl[i].p1.z );
        
        if ( kpl[i].p1.z > kpl[i].p2.z ) 
         {
          kpl[i].p1.x = x;
          kpl[i].p1.y = y;
          kpl[i].p1.z = z;
          
         }  
        else
        {
          kpl[i].p2.x = x;
          kpl[i].p2.y = y;
          kpl[i].p2.z = z;
         
        }
       } 
     }
    }
  } 

/* --------------------------------------------------------
   Ermittlung des Schnittpunktes mit der Projektions-
   ebene.
   -------------------------------------------------------- */

 for ( i=anfang ; i<Anzahl_kten ; i++ )
  {
   m = ((-30.0) / (kpl[i].p1.z -d )) * 5.0;
   kpl[i].p1.x = 250.0 + m * kpl[i].p1.x;
   kpl[i].p1.y = 200.0 - m * kpl[i].p1.y;

   m = ((-30.0) / (kpl[i].p2.z - d)) * 5.0;
   kpl[i].p2.x = 250.0 + m * kpl[i].p2.x;
   kpl[i].p2.y = 200.0 - m * kpl[i].p2.y;
  }

}
/* ---------------------------------------------------------------- */

int Kollision ( pl,rpl )   /* Kollision = 0 ... keine Kollision */
Points pl[];               /*             1 ... Kollision       */
int rpl[14];
{
 int i;

 /* -------------------------------- 
    Test ob Kollision mit dem Sockel
    und der Ebene.
    -------------------------------- */
  for ( i=0 ; i<14 ; i++ )
   {
    if (( fabs(pl[rpl[i]].x) < 4.5 &&
          fabs(pl[rpl[i]].y) < 3.0 &&
          fabs(pl[rpl[i]].z) < 4.5 ) ||
          pl[rpl[i]].y < 0.0   ) { return(1); }
   }

 /* ---------------------------------
    Test ob Kollision mit Link1.
    --------------------------------- */
  for ( i=2 ; i<14 ; i++ )
   {
    if ( fabs(pl[rpl[i]].x) <= 1.3 &&
         fabs(pl[rpl[i]].z) <= 1.3 &&
         pl[rpl[i]].y <= linkl[0] + 0.5 ) return(1);
   }
 return(0);
}
/* ---------------------------------------------------------------- */

void KoordinatenSystem ( kpl,wy,wx )
Points kpl[4];
double wy;
double wx;
{
 int i;
 double x,y,z;
 Kanten_Punkte_Liste koorkpl[3];

 Projektion ( kpl,koork,koorkpl,4,3,wy,wx,30.0,NEU );
 XSetForeground ( mydisplay,graphgc,BlackPixel(mydisplay,myscreen) );
 for ( i=0 ; i<3 ; i++ )
 {
  XDrawLine ( mydisplay,pixmap,graphgc,(short)(koorkpl[i].p1.x-200),(short)(koorkpl[i].p1.y-135),
              (short)(koorkpl[i].p2.x-200),(short)(koorkpl[i].p2.y-135));
 }
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[0].p2.x-200),(short)(koorkpl[0].p2.y-135),"X",1);
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[1].p2.x-200),(short)(koorkpl[1].p2.y-135),"Y",1);
 XDrawImageString ( mydisplay,pixmap,graphgc,(short)(koorkpl[2].p2.x-200),(short)(koorkpl[2].p2.y-135),"Z",1);
}
/* ---------------------------------------------------------------- */

void DrawRobo ( pl,kl,Gerade,wy,wx,d,stdpkt )
Points pl[];
Kanten kl[];
Points Gerade[2];
double wy;
double wx;
double d;
int stdpkt;
{
 static XSegment seg[57];
 static Kanten_Punkte_Liste kpl[ANZAHL_KANTEN];
 static Kanten_Punkte_Liste gkpl[1];
 int i,Anzahl,h;


 for ( i=0 ; i<ANZAHL_KANTEN ; i++ ) kpl[i].sichtbar = 0;

 gkpl[0].sichtbar = 0;
 
 if ( Bregel_flag[0] == 0 &&
      Bregel_flag[1] == 0 &&
      Bregel_flag[2] == 0   ) Projektion ( Gerade,Gkl,gkpl,2,1,wy,wx,d,NEU ); 
 else Gerade[0].y = -1.0;
 Projektion ( pl,kl,kpl,ANZAHL_PKTE,ANZAHL_KANTEN,wy,wx,d,NEU );
 
 /* Pixmap mit Hintergrundfarbe laden */

 XSetForeground ( mydisplay,graphgc,graphbg );
 clear_pixmap();
 
 /* Ebene zeichnen */

 Anzahl = 8;
 h = 0;
 for ( i=0; i<8 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-h].x1 = (short)(kpl[i].p1.x);
    seg[i-h].y1 = (short)(kpl[i].p1.y);
    seg[i-h].x2 = (short)(kpl[i].p2.x);
    seg[i-h].y2 = (short)(kpl[i].p2.y);
   }
   else { Anzahl = Anzahl - 1;
          h = h + 1;
        }
  }
 XSetForeground ( mydisplay,graphgc,plane );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );  

 if ( Gerade[0].x == Gerade[1].x &&
      Gerade[0].y == Gerade[1].y &&
      Gerade[0].z == Gerade[1].z &&
      Gerade[0].y > 0.0          ) {
                                    XFillArc ( mydisplay,pixmap,graphgc,(short)(gkpl[0].p1.x-5),
                                               (short)(gkpl[0].p1.y-5),10,10,0,23040 );
                                   } 
 else {
       if ( Gerade[0].y > 0.0 )
        XDrawLine ( mydisplay,pixmap,graphgc,
                   (short)(gkpl[0].p1.x),(short)(gkpl[0].p1.y),
                   (short)(gkpl[0].p2.x),(short)(gkpl[0].p2.y) );
      }

 /* Sockel zeichnen */

 Anzahl = 24;
 h = 0;
 for ( i=8 ; i<32 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-8-h].x1 = (short)(kpl[i].p1.x);
    seg[i-8-h].y1 = (short)(kpl[i].p1.y);
    seg[i-8-h].x2 = (short)(kpl[i].p2.x);
    seg[i-8-h].y2 = (short)(kpl[i].p2.y);
   } 
  else { Anzahl = Anzahl - 1;
         h = h + 1;
       }
  } 
 XSetForeground ( mydisplay,graphgc,farbe[0] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );

 /* Drehscheibe und Link_1 zeichnen */

  Anzahl = 55;
  h = 0;
  for ( i=32 ; i<87 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-32-h].x1 = (short)(kpl[i].p1.x);
    seg[i-32-h].y1 = (short)(kpl[i].p1.y);
    seg[i-32-h].x2 = (short)(kpl[i].p2.x);
    seg[i-32-h].y2 = (short)(kpl[i].p2.y);
   }
   else { Anzahl = Anzahl - 1;
          h = h + 1;
        }
  } 
 XSetForeground ( mydisplay,graphgc,farbe[1] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );

/* Link 2 zeichnen */

   Anzahl = 41;
   h = 0;
   for ( i=87 ; i<128 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-87-h].x1 = (short)(kpl[i].p1.x);
    seg[i-87-h].y1 = (short)(kpl[i].p1.y);
    seg[i-87-h].x2 = (short)(kpl[i].p2.x);
    seg[i-87-h].y2 = (short)(kpl[i].p2.y);
   }
   else { Anzahl = Anzahl - 1;
          h = h + 1;
        } 
  } 
 XSetForeground ( mydisplay,graphgc,farbe[2] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );

/* Link 3 zeichnen */

   Anzahl = 25;
   h = 0;
   for ( i=128 ; i<153 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-128-h].x1 = (short)(kpl[i].p1.x);
    seg[i-128-h].y1 = (short)(kpl[i].p1.y);
    seg[i-128-h].x2 = (short)(kpl[i].p2.x);
    seg[i-128-h].y2 = (short)(kpl[i].p2.y);
   }
   else { Anzahl = Anzahl - 1;
          h = h + 1;
        }
  } 
 XSetForeground ( mydisplay,graphgc,farbe[3] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );


/* Achse 4, Achse 5 , Gelenk 5 zeichnen */


  Anzahl = 28;
  h = 0;
   for ( i=153 ; i<181 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-153-h].x1 = (short)(kpl[i].p1.x);
    seg[i-153-h].y1 = (short)(kpl[i].p1.y);
    seg[i-153-h].x2 = (short)(kpl[i].p2.x);
    seg[i-153-h].y2 = (short)(kpl[i].p2.y);
   }
  else { Anzahl = Anzahl - 1;
         h = h + 1;
       }  
  } 
 XSetForeground ( mydisplay,graphgc,farbe[6] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );

  Anzahl = 30;
  h = 0;
   for ( i=181 ; i<211 ; i++ )
  {if ( kpl[i].sichtbar == 0 )
   {
    seg[i-181-h].x1 = (short)(kpl[i].p1.x);
    seg[i-181-h].y1 = (short)(kpl[i].p1.y);
    seg[i-181-h].x2 = (short)(kpl[i].p2.x);
    seg[i-181-h].y2 = (short)(kpl[i].p2.y);
   }
  else { Anzahl = Anzahl - 1;
         h = h + 1;
       }  
  } 
 XSetForeground ( mydisplay,graphgc,farbe[4] );
 XDrawSegments ( mydisplay,pixmap,graphgc,seg,Anzahl );

}
/* ---------------------------------------------------------------- */

void Rotation_Y ( pl,winkel,anfang,anzahl )
Points pl[ANZAHL_PKTE];
double winkel;
int anfang;
int anzahl;
{
 int i;
 double x,z;
 double cosinus,sinus;

 cosinus = cos(winkel);
 sinus = sin(winkel);

 for ( i=anfang ; i< anfang+anzahl ; i++ )
  {
   x = cosinus * pl[i].x + sinus * pl[i].z;
   z = cosinus * pl[i].z - sinus * pl[i].x;

   pl[i].x = x;
   pl[i].z = z;   
  }
}
/* ---------------------------------------------------------------- */

void Rotation_K ( pl,winkel,Achse,anfang,anzahl )
Points pl[ANZAHL_PKTE];
double winkel;
Kanten Achse;
int anfang;
int anzahl;
{
 int i;
 double cosinus,sinus,v0;
 double r00,r01,r02,r03,
        r10,r11,r12,r13,
        r20,r21,r22,r23;
 double kx,ky,kz,px,py,pz;
 double kxx,kxy,kxz,kyy,kyz,kzz;

 cosinus = cos(winkel);
 sinus = sin(winkel);
 v0 = 1 - cosinus;

 px = pl[Achse.p1].x;
 py = pl[Achse.p1].y;
 pz = pl[Achse.p1].z;

 kx = pl[Achse.p2].x - px;
 ky = pl[Achse.p2].y - py;
 kz = pl[Achse.p2].z - pz;

 kxx = kx * kx * v0;
 kxy = kx * ky * v0;
 kxz = kx * kz * v0;
 kyz = ky * kz * v0;
 kyy = ky * ky * v0;
 kzz = kz * kz * v0;
 
 r00 = kxx + cosinus;
 r10 = kxy + kz * sinus;
 r20 = kxz - ky *sinus;

 r01 = kxy - kz * sinus;
 r11 = kyy + cosinus;
 r21 = kyz + kx * sinus;

 r02 = kxy + ky * sinus;
 r12 = kyz - kx * sinus;
 r22 = kzz + cosinus;
 
 r03 = r00 * (-px) - r01 * py - r02 * pz + px;
 r13 = r10 * (-px) - r11 * py - r12 * pz + py;
 r23 = r20 * (-px) - r21 * py - r22 * pz + pz;

 for ( i=anfang ; i<anfang+anzahl ; i++ )
  {
   kx = r00 * pl[i].x + r01 * pl[i].y + r02 * pl[i].z + r03;
   ky = r10 * pl[i].x + r11 * pl[i].y + r12 * pl[i].z + r13;
   kz = r20 * pl[i].x + r21 * pl[i].y + r22 * pl[i].z + r23;

   pl[i].x = kx;
   pl[i].y = ky;
   pl[i].z = kz;
  }
}


/* ----------------------------------------------------------------- */

void PosRobo ( pl,drehwinkel,Winkel )
Points pl[];
double drehwinkel[6];
Winkel_Daten Winkel[6];
{
 int j;

   if ( drehwinkel[0] != 0.0 ) Rotation_Y ( pl,drehwinkel[0],44,110 );
   if ( drehwinkel[1] != 0.0 ) Rotation_K ( pl,drehwinkel[1],kl[86],66,88 );
   if ( drehwinkel[2] != 0.0 ) Rotation_K ( pl,drehwinkel[2],kl[128],96,58 );
   if ( drehwinkel[3] != 0.0 ) Rotation_K ( pl,drehwinkel[3],kl[153],114,40 );
   if ( drehwinkel[4] != 0.0 ) Rotation_K ( pl,drehwinkel[4],kl[154],116,38 );
   if ( drehwinkel[5] != 0.0 ) Rotation_K ( pl,drehwinkel[5],kl[180],134,20 );
 
    for ( j=0 ; j<6 ; j++ )
    {
      Winkel[j].akt = Winkel[j].akt + drehwinkel[j];
      
    }
}

/* ----------------------------------------------------------------- */

void  file_handle ( aktion,eingabe,estring,BListe,indx,Kriterium,stdpkt,wy,wx,d )

int * aktion;
double eingabe[9];
string estring[6];
Points BListe[360];
int *indx;
int Kriterium;
double stdpkt[3];
double *wy,*wx,*d;
{
  /* indx >= 0 nur frobo bearbeiten,
     indx = -1 Befehlsliste neu auffuellen,
     

     Kriterium = 0   beide Dateien bearbeiten,
     Kriterium = 1   nur Betrachterliste auffuellen, falls moeglich */

 char c[10];
 int i,offset,Schritte;
 float f;
 double cx,sx,cy,sy,cz,sz,m,x,y,z,mdiff;
 static frobo_end = 0,
        fviewer_end = 0;
 double eingab[9];
  
 if ( Kriterium == 0 && f_Z_R == 0)
  {
    /* Datei frobo bearbeiten */

   offset = fscanf( frobo,"%s",c );
   if ( feof(frobo) ) f_Z_R = -1;
   if ( offset == 0 || offset == EOF ) {
                                        f_Z_R = -1;
                                        *aktion = -1;                                       
                                       }
   else
   {
    switch ( c[0] )
    {
     case 'G':
     case 'g': offset = fscanf( frobo," %lf %lf %lf %lf %lf %lf",
                   &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
               if ( offset != 6 )
                 {
                  f_Z_R = -1;
                  *aktion = -1;                  
                 }   
                 else
                 {
                  for ( i=0; i<6; i++ )
                  {
                   if (eingabe[i] < 1.0) eingabe[i] = 1.0;
                   if (eingabe[i] > 11.0) eingabe[1] = 11.0;
                  }
                  for ( i=0; i<6; i++ ) power[i] = (int)(eingabe[i]);
                  *aktion = -1;
                 }

              break;
     case 'N':
     case 'n': *aktion = -1;
              break;
 case 'S':
     case 's': if ( f_Z_B == 0 ) f_Z_B = 1;
               *aktion = -1; 
              break;
     case 'P':
     case 'p': if ( f_Z_B == 1) f_Z_B = 0;
               *aktion = -1;
              break;
     case 'M':
     case 'm': offset = fscanf( frobo,"%s",c );
               if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                        
                                  }
               else
                {
                 if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                 else f_absolut = 0;
              
                 offset = fscanf( frobo," %lf %lf %lf %lf %lf %lf",
                            &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
                 if ( offset != 6 )
                 {
                  f_Z_R = -1;
                  *aktion = -1;                  
                 }   
                 else
                 {
                  for ( i=0; i<6; i++ ) eingabe[i] = eingabe[i] * ( PI / 180.0 );
                  *aktion = MANUELL;
                 }
                }
               break;
      case 'A':
      case 'a': offset = fscanf( frobo ,"%s",c);
                if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                        
                                   }
               else
               { 
                if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                else f_absolut = 0;

                offset = fscanf( frobo ,"%s",c);
                if ( offset != 1 ) {
                                    f_Z_R = -1;
                                    *aktion = -1;                                    
                                   }
                else
                {
                 if ( c[0] == 'G' || c[0] == 'g' ) f_auto_gerade = 0;
                 else f_auto_gerade = 1;
 
                 offset = fscanf( frobo," %lf %lf %lf",
                            &eingabe[0],&eingabe[1],&eingabe[2] );
                 if ( offset != 3 ){
                                    f_Z_R = -1;
                                    *aktion = -1;                                     
                                   }                
                 else *aktion = AUTO;
               }
              }
             break;
 case 'L':
     case 'l': offset = fscanf( frobo , "%lf %lf %lf", &eingabe[0],&eingabe[1],&eingabe[2]);
               if ( offset != 3 ) {
                                   f_Z_R = -1;
                                   *aktion = -1;                                     
                                  }
               else *aktion = ARMLAENGE;
              break; 
     case 'W':
     case 'w': offset = fscanf( frobo , "%lf %lf %lf %lf %lf %lf",
                                &eingabe[0],&eingabe[1],&eingabe[2],
                                &eingabe[3],&eingabe[4],&eingabe[5] );
               if ( offset != 6 ) {
                                   f_Z_R= -1;
                                   *aktion = -1;
                                  }
               else *aktion = WINKEL;
              break;
     case 'F':
     case 'f': offset = fscanf( frobo , "%s %s %s %s %s %s",
                                estring[0],estring[1],estring[2],
                                estring[3],estring[4],estring[5] );
               if ( offset != 6 ) {
                                   f_Z_R = -1;
                                   *aktion = -1;  
                                  }
               else *aktion = FARBE;
              break;
    default :
             f_Z_R = -1;
             *aktion = -1;               
             break;
               
    }
   }
  }


 if ( akt > *indx && f_Z_B == 0)
 {
  offset = fscanf( fviewer , "%s",c);
  if ( feof(fviewer) ) f_Z_B = -1;
  if ( offset == 0 || offset == EOF ) {
                                       f_Z_B = -1;
                                       if (Kriterium == 1) *aktion = -1; 
                                      }
  else
  {
   switch( c[0] )
   {
    case 'S':
    case 's': if ( f_Z_R == 0 ) f_Z_R = 1;
              if ( Kriterium == 1 ) *aktion = -1;
             break;
    case 'P':
    case 'p': if ( f_Z_R == 1 ) f_Z_R = 0;
              if ( Kriterium == 1 ) *aktion = -1;
             break;
    case 'B':
    case 'b':
             offset = fscanf( fviewer , "%s",c);
             if ( offset == 0 || offset == EOF ) {
                                                  f_Z_B = -1;
                                                  if (Kriterium == 1) *aktion = -1;
                                                 }
             else
 {
               switch( c[0] )
                {
                 case 'A':
                 case 'a':
                 case 'R':
                 case 'r': if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
                           else f_absolut = 0;

                  
                           offset = fscanf( fviewer,"%lf%lf%lf",&eingab[0],&eingab[1],&eingab[2] );
                           if ( offset != 3 ) {
                                               f_Z_B = -1;
                                               if ( Kriterium == 1 ) *aktion = -1; 
                                              }  

                           if ( f_absolut == 0 )
                           {
                            eingab[0] = eingab[0] + stdpkt[0];
                            eingab[1] = eingab[1] + stdpkt[1];
                            eingab[2] = eingab[2] + stdpkt[2];
                           } 
                          Winkelberechnung( eingab[0],eingab[1],eingab[2],&BListe[0].y,
                                            &BListe[0].x,&BListe[0].z );

                           *wy = BListe[0].y;
                           *wx = BListe[0].x;
                           *d = BListe[0].z;

                          x = eingab[0];
                          y = eingab[1];
                          z = eingab[2];


                          akt = 0;
                          *indx = 0; 
                          break; 
                 case 'K':
                 case 'k':
                          offset = fscanf( fviewer ,"%lf%lf%lf%lf%lf%lf%lf%lf%lf",
                                           &eingab[0],&eingab[1],&eingab[2],
                                           &eingab[3],&eingab[4],&eingab[5],
                                           &eingab[6],&eingab[7],&eingab[8] );
                          if ( offset != 9 ) {
                                              f_Z_B = -1;
                                              if (Kriterium == 1) *aktion = -1; 
                                             }
                          else
                          {
                          Schritte = (int)(eingab[8] / eingab[7] );
                          Schritte = abs(Schritte);
                          if ( (Schritte+1) > 360 ) Schritte = 359;
                          eingab[1] = eingab[1] * (PI/180.0);
                          eingab[2] = eingab[2] * (PI/180.0);
                          eingab[3] = eingab[3] * (PI/180.0);
                          eingab[7] = eingab[7] * (PI/180.0);
                          eingab[8] = eingab[8] * (PI/180.0);

                          cx = cos( eingab[1] );
                          sx = sin( eingab[1] );
                          cy = cos( eingab[2] );
                          sy = sin( eingab[2] );
                          cz = cos( eingab[3] );
                          sz = sin( eingab[3] );
                          m = 0.0;

                          for( i=0; i<Schritte+1; i++ )
                          {
                           if ( i == Schritte ) m = eingab[8];
                            /* Berechnung des Punktes in der XY-Ebene */
                           eingab[2] = sin(m) * eingab[0];
                           eingab[1] = cos(m) * eingab[0];

                            /* Rotation */
                            x = eingab[1] * cy * cz + eingab[2] * ( sx*sy*cz - cx*sz ) + eingab[4];
                            y = eingab[1] * cy * sz + eingab[2] * ( sx*sy*sz + cx*cz ) + eingab[5];
                            z = eingab[1] * ( - sy ) + eingab[2] * sx * cy + eingab[6];

                           /* Projektion. */
                            Winkelberechnung ( x,y,z,&BListe[i].y,&BListe[i].x,&BListe[i].z );
                            m = m + eingab[7]; 

                             *wy = BListe[i].y;
                             *wx = BListe[i].x;
                             *d = BListe[i].z;


                          }
                          BListe[Schritte+1] = BListe[Schritte];
                          *indx =(int)( Schritte+1 );
                          akt = 0; 
                          }
                          break;
                 case 'G':
                 case 'g':
                          offset = fscanf( fviewer,"%lf%lf%lf%lf%lf%lf%lf",
                                           &eingab[0],&eingab[1],&eingab[2],
                                           &eingab[3],&eingab[4],&eingab[5],
                                           &eingab[6],&eingab[7]              );
                          if ( offset != 7 ) {
                                              f_Z_B = -1;
                                              if (Kriterium == 1) *aktion = -1;
                                             }
                          else
                          {
                           Schritte = (int)(eingab[6]);
                           if ( Schritte > 359.0 ) Schritte = 359;
                           mdiff = 1.0 / Schritte;
                           m = 0.0;

                           for( i=0; i<((int)(Schritte)+1); i++ )
                            {
                             x = eingab[0] + m * ( eingab[3] - eingab[0] );
                             y = eingab[1] + m * ( eingab[4] - eingab[1] );
                             z = eingab[2] + m * ( eingab[5] - eingab[2] );

                             Winkelberechnung ( x,y,z,&BListe[i].y,&BListe[i].x,&BListe[i].z);

                             *wy = BListe[i].y;
                             *wx = BListe[i].x;
                             *d = BListe[i].z;


                             m = m + mdiff; 
                            }
                          }
                        
                          *indx =(int)( Schritte );
                          akt = 0;  
                          break;
                } 
               if (*indx != -1)
               {
                stdpkt[0] = x;
                stdpkt[1] = y;
                stdpkt[2] = z;
               } 

              }
              break;

   }
  }
 }

 if ( Kriterium == 0 && f_Z_R != 0 )
 {
  for ( i=akt; i< *indx; i++ )
  {
   DrawRobo ( pl,kl,Gerade,BListe[i].y,BListe[i].x,BListe[i].z,NEU );
   show_pixmap();
   akt = *indx;
  }
  if ( feof(fviewer) ) f_Z_B = -1;
  *indx = -1;
  *aktion = -1;
 }

}





/* ----------------------------------------------------------------- */
void MoveRobo ( pl,Gerade,drehwinkel,winkel,Schritte,Fehlercode,wy,wx,d,show,indx,stdpkt )
Points pl[];
Points Gerade[2];
double drehwinkel[6];
Winkel_Daten winkel[6];
int Schritte;
int *Fehlercode;
double *wy,*wx,*d;
int show;
int *indx;
double stdpkt[3];
{
 int i,j;
 double offset[6];
 int merker;
 double eingabe[9];
 string estring[2];

 if ( Schritte == 0 ) Schritte = 1;
 for ( i=0 ; i<6 ; i++ )
 {
  offset[i] = drehwinkel[i] / Schritte;
 }

 *Fehlercode = 0;
 for ( i=0 ; i<Schritte ; i++ )
  {
   if ( *Fehlercode == 0 )
   {
   if ( offset[0] != 0.0 ) Rotation_Y ( pl,offset[0],44,110 );
   if ( offset[1] != 0.0 ) Rotation_K ( pl,offset[1],kl[86],66,88 );
   if ( offset[2] != 0.0 ) Rotation_K ( pl,offset[2],kl[128],96,58 );
   if ( offset[3] != 0.0 ) Rotation_K ( pl,offset[3],kl[153],114,40 );
   if ( offset[4] != 0.0 ) Rotation_K ( pl,offset[4],kl[154],116,38 );
   if ( offset[5] != 0.0 ) Rotation_K ( pl,offset[5],kl[180],134,20 );
  
   for ( j=0 ; j<6 ; j++ )
     {
       winkel[j].akt = winkel[j].akt + offset[j];
      
     }
  
   if ( Kollision(pl,rpl) == 1 ) { for ( j=0 ; j<6 ; j++ ) offset[j] = -offset[j];
                                   PosRobo(pl,offset,winkel);
                                   XBell ( mydisplay,30 );
                                   *Fehlercode = 1;  
                                 } 
   if ( show == 1 ) 
   {
    if ( f_file == 2 && f_Z_B == 0 && f_Z_R == 0)
    {
     if ( (akt) > *indx)
     {
      file_handle (&j,eingabe,estring,BListe,indx,1,stdpkt,wy,wx,d);
     }
     if ( f_Z_B == 0 && f_Z_R == 0)
     {
      *wy = BListe[akt].y;
      *wx = BListe[akt].x;
      *d = BListe[akt].z;
      akt++;
     }
    }    


    DrawRobo (pl,kl,Gerade,*wy,*wx,*d,ALT);
    show_pixmap();
   }

  } 
 }

}
/* ----------------------------------------------------------------- */

void copy_PKTLISTE ( PL,pl )
Points PL[ANZAHL_PKTE];
Points pl[ANZAHL_PKTE];
{
 int i;

 for ( i=0 ; i<ANZAHL_PKTE ; i++ )
 {
  pl[i].x = PL[i].x;
  pl[i].y = PL[i].y;
  pl[i].z = PL[i].z;
 }
}
/* ----------------------------------------------------------------- */

void pipe_handle ( aktion,eingabe ,estring,Schritte )
int *aktion;
double eingabe[9];
string estring[6];
int *Schritte;
{
 char c[20];
 int i;
 float f;

 scanf("%s",c);

 switch (c[0])
 {
  case 'M' :
  case 'm' : scanf("%s",c);
             if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
             else f_absolut = 0;

             for ( i=0 ; i<6 ; i++ ){
                                     scanf("%f",&f);
                                     eingabe[i] = (PI / 180.0 ) * f;
                                    }
             *aktion = MANUELL;
             break;

  case 'B':
  case 'b':scanf("%s",c);
           if ( c[0] == 'G' || c[0] == 'g' )
            {   /* Betrachnter soll sich auf einer Geraden bewegen. */
             for ( i=0 ; i<6 ; i++)
             {
              scanf("%f",&f);
              eingabe[i] = f;
             }         
             scanf("%i",&(*Schritte));
             *aktion = BETRACHTER_GERADE;
            }
           else  
           { 
           if ( c[0] == 'K' || c[0] == 'k' )
           { /* Betrachter soll sich auf einem Kreis bewegen. */
            for ( i=0 ; i<9 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = f;
            }
            *aktion = BETRACHTER_KREIS;
           } 
           else
           {  
           if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
           else f_absolut = 0;

           for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = BETRACHTER;
           } 
           } 
           break;

  case 'A':
  case 'a':scanf("%s",c);
           if ( c[0] == 'A' || c[0] == 'a' ) f_absolut = 1;
           else f_absolut = 0;

           scanf("%S",c);
           if ( c[0] == 'G' || c[0] == 'g' ) f_auto_gerade = 0;
           else f_auto_gerade = 1;
 
           for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = AUTO;
           break;
  case 'L':
  case 'l': for ( i=0 ; i<3 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = ARMLAENGE;
           break;
  case 'W':
  case 'w':for ( i=0 ; i<6 ; i++ )
            {
             scanf("%f",&f);
             eingabe[i] = (double)( f );
            }
           *aktion = WINKEL;
           break;
  case 'F':
  case 'f':for ( i=0 ; i<6 ; i++ )
           {
            scanf("%s",estring[i]);
           } 
           *aktion = FARBE;
           break;
  case 'G':
  case 'g': scanf(" %lf %lf %lf %lf %lf %lf",
                   &eingabe[0],&eingabe[1],&eingabe[2],&eingabe[3],&eingabe[4],&eingabe[5] );
            for ( i=0; i<6; i++ )
                  {
                   if (eingabe[i] < 1.0) eingabe[i] = 1.0;
                   if (eingabe[i] > 11.0) eingabe[1] = 11.0;
                  }
                  for ( i=0; i<6; i++ ) power[i] = (int)(eingabe[i]);
                  *aktion = -1;
           break;

  case 'Q':
  case 'q':   
  default: 
          XMoveWindow ( mydisplay,textwin,500,200 );
          f_file = 0;
          *aktion = -1;
          break;
 }
}
/* ----------------------------------------------------------------- */

void berechne_Winkel ( eingabe,wB,wE,SchritteB,SchritteE )
double eingabe[];
double wB[];
double wE[];
int *SchritteB;
int *SchritteE;
{
 double w_max,wdiffB,wdiffE;
 double a,b,v;
 int i_max,i;
 int X;
                 for ( i=0; i<6; i++ )
                  {
                   wE[i] = 0.0;
                   wB[i] = 0.0;
                  }                  

               /* Bestimmung des maximalen Winkels. */
                 i_max = 0;
                 w_max = fabs(eingabe[0]);
                 for ( i=1; i<6; i++ )
                 {
                  if ( w_max < fabs(eingabe[i]) ) {
                                                   i_max = i;
                                                   w_max = fabs( eingabe[i]);
                                                  } 
                 } 
  
                 if ( w_max != 0.0 )
                 {
                  /* Bestimmung von wdiffB. */
                  wdiffB = (( power[i_max] * ( power[i_max] + 1 )) / 2.0 )*( PI / 180.0 ); 

                  /* Fallunterscheidung. */
                  if ( (wdiffB * 2.0) >= fabs(eingabe[i_max]) )
                  {  /* Es gibt keine Endgeschwindigkeitsphase. */
                   wE[i_max] = 0.0;
                   *SchritteE = 0;

                   X = (int)( fabs(eingabe[i_max]) / ( PI/180.0));
                   *SchritteB = (int)( (-1.0 + sqrt( 1.0 + 4.0 * X)) / 2.0);

                   wB[i_max] = eingabe[i_max] / ((*SchritteB) * ((*SchritteB) + 1.0 ) );
                   for ( i=0; i<6; i++ )
                   {
                    if ( i != i_max )
                    {
                     wE[i] = 0.0;
                     wB[i] = eingabe[i] / ((*SchritteB) * ( (*SchritteB) + 1.0 )); 
                    }
                   }  
                  }
                 else
                  {  /* Es gibt eine Endgeschwindigkeitsphase. */
                   *SchritteB = power[i_max];
                   wdiffE = fabs(eingabe[i_max]) - ( wdiffB * 2.0 );

                   v = wdiffB / wdiffE;
                   for ( i=0; i<6; i++ )
                   {
                    if ( i != i_max )
                    {
                     a = eingabe[i] / ( 2.0 + ( 2.0 / v ));
                     b = eingabe[i] - 2.0 * a;

                     wB[i] = a / ((power[i_max] * (power[i_max] + 1.0)) / 2.0);
                     wE[i] = b;
                    }
                    else
                    {
                     if ( eingabe[i_max] >= 0.0 ) {
                                                   wB[i_max] = PI/180.0;
                                                   wE[i_max] = wdiffE;
                                                  }
                     else {
                           wB[i_max] = -PI/180.0;
                           wE[i_max] = -wdiffE;
                          } 

                     *SchritteE = (int)( wdiffE / (power[i_max] * PI/180.0));
                     
                    }
                   } 
                  }
                 } 
}
/* ----------------------------------------------------------------- */


main ( argc,argv )
int argc;
char *argv[];
{
 int done = 0,
     i,Fehlercode,merker,
     aktion , Schritte,Schrittzahl;
 double x,y,z,h;
 double T[3][4];
 double wx ;
 double wy ;
 double d ;
 XPoint ppl[ANZAHL_PKTE];
 double eingabe[9];
 double stdpkt[3];
 double pos[3];
 double m,mdiff,Distanz;
 Points p1,p2;
 double w_neu[6],w_alt[6],hw[6],hilf;
 XColor exact;
 string estring[7];
 double cx,cy,cz,sx,sy,sz;
 Points plh[ANZAHL_PKTE];
 double wB[6],wE[6];
 int n,j;


 int indx = -1;

 Winkel_Daten wi[6];



 if ( argc > 1 ) 
  {
   for ( i=0; i<argc; i++ )
   {
     j = strcmp( argv[i],"-c");
    if ( j== 0 )                 {
                                  strcpy( fname[6],argv[i+1] );

                                 } 



    j = strcmp( argv[i],"-f");
    if ( j == 0 )                 { f_file = 2;
                                    j = strcspn( argv[i+1] , ".robot" );
                                    if ( j == strlen( argv[i+1] ))  
                                      { 
                                        printf("\n Error opening files!!!!!!!!");
                                        exit(1);
                                      }
 
                                    j = strcspn( argv[i+2] , ".view" );
                                    if ( j == strlen( argv[i+2] ))
                                     {
                                      printf("\n Error opening files!!!!!!!!");
                                      exit(1);
                                     }
                      
                                    frobo = fopen( argv[i+1] , "r" );
                                    if ( frobo == NULL )
                                     {
                                      printf("\nError opening file %s",argv[i+1]);
                                      f_file = 0;
                                     }
                                    fviewer = fopen ( argv[i+2] , "r" );
                                    if ( fviewer == NULL )
                                     {
                                      if ( f_file != 0 ) fclose( frobo );
                                      printf("\nError opening file %s",argv[i+2]);
                                      f_file = 0;
                                     } 
                                    
                                    
                                  }
    j = strcmp( argv[i],"-p");
    if ( j == 0 )                 { f_file = 1;
                                   
                                  }
   }
  }
 else f_file = 0;




 copy_PKTLISTE ( PL,pl ); 
 init_x();

 XSynchronize( mydisplay,1);


 init_textwindow ( argc,argv );
 XMapRaised ( mydisplay,textwin );
 init_Ausgabefenster (argc,argv );
 XMapRaised ( mydisplay,Ausgabefenster );
 init_Graphdwin();
 init_graphwindow ();
 XMapRaised ( mydisplay,graphwin );
 init_Bregelwin();
 init_errorwin();
 init_Pixmap();
 init_Regler ();
 XMapRaised ( mydisplay,regelwin );
 init_buttonwindows ( );
 init_deckwindow ( );
 XMapSubwindows ( mydisplay,textwin );
 init_formularwindows ( );
 init_hwin();
 init_helpwin( argc,argv );

 load_set_fonts (); 


 XSynchronize( mydisplay,0);


 Winkelberechnung ( 0.0,1.0,26.0,&wy,&wx,&d); 
 stdpkt[0] = 0.0;
 stdpkt[1] = 1.0;
 stdpkt[2] = 26.0;
 DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU );
 KoordinatenSystem ( koorpl,wy,wx ); 



 berechne_Pos ( Winkel,pos );


/* ------------------ EVENT - SCHLEIFE --------------------------- */

 while ( done == 0 )
 {  
   switch ( f_file )
    {
     case 0 :  event_handle ( &aktion , eingabe , estring ,Winkel,stdpkt,pos);
             break; 
     case 1 :  pipe_handle ( &aktion,eingabe,estring,&Schritte );
             break;
     case 2 :  file_handle ( &aktion,eingabe,estring,BListe,&indx,0,stdpkt,&wy,&wx,&d );
  
               if ( f_Z_B == -1 && f_Z_R == -1 )
                {
                 f_file = 0;
                 XMoveWindow ( mydisplay,textwin,500,200 );
                 aktion = -1;
                 fclose ( frobo );
                 fclose ( fviewer ); 
                 power[0] = 3;
                 power[1] = 3;
                 power[2] = 4;
                 power[3] = 5;
                 power[4] = 5;
                 power[5] = 5;
               
                 wgewicht[0] = 0;
                 wgewicht[1] = 30;
                 wgewicht[2] = 20;
                 wgewicht[3] = 10;
                 wgewicht[4] = 10;
                 wgewicht[5] = 10; 
                 Winkelberechnung ( stdpkt[0],stdpkt[1],stdpkt[2],&wy,&wx,&d );
                 DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU );
                 KoordinatenSystem( koorpl,wy,wx );
                 show_pixmap();  
                }
             break;
  }

  switch ( aktion )
  {
   case MANUELL:
                if ( f_absolut == 1 )
                 {
                  for ( i=0 ; i<6 ; i++ ) eingabe[i] = eingabe[i] - Winkel[i].akt;
                 } 
                for ( i=0 ; i<6 ; i++ )
                 {
                  if (((Winkel[i].akt + eingabe[i])<=Winkel[i].max + 0.000001)&&
                     ((Winkel[i].akt + eingabe[i])>=Winkel[i].min - 0.000001) )
                     {
                      w_neu[i] = Winkel[i].akt + eingabe[i];  
                      merker = 1;                   
                     }
                  else { merker = 0;
                         if ( f_file == 0 )
                         show_errorwin ( "     Winkelwerte liegen nicht im",
                                         "     zulaessigen Bereich!" );
                         XBell (mydisplay,30);
                         break;
                       }
                 }  

                if ( merker==1) 
                {  
                 berechne_Winkel ( eingabe,wB,wE,&n,&Schritte );                  
                  for ( i=1; i<n+1; i++ )
                  {
                   for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;

                   MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                   if ( Fehlercode == 1 ) break;
                  }    
    
                  if ( Fehlercode != 1)
                  {
                   MoveRobo ( pl,Gerade,wE,Winkel,Schritte,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                  
                   if ( Fehlercode != 1 )
                   { 
                    for ( i=n; i>0; i-- )
                    {
                     for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;
  
                     MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                     if ( Fehlercode == 1 ) break;
                    }
                   }  
                  }
                 }                      

                 if ( Fehlercode != 1 && merker == 1)
                 {
                  copy_PKTLISTE(PL,plh);
                  for ( i=0 ; i<6 ; i++ ) { 
                                            Winkel[i].akt = 0.0;
                                          }
                  MoveRobo ( plh,Gerade,w_neu,
                             Winkel,1,&Fehlercode,&wy,&wx,&d,0,&indx,stdpkt);  
                  copy_PKTLISTE(plh,pl);
                 } 
                 else { if ( Fehlercode == 1 && f_file == 0)
                         { show_errorwin (" ","            Kollision!");
                           XBell(mydisplay,30);
                         } 
                      }
                 aktualisiere_hwin( Winkel,stdpkt );
                 berechne_Pos ( Winkel,pos );
                 DrawRobo ( pl,kl,Gerade,wy,wx,d,ALT);
                 if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                 show_pixmap();

                break;
   case AUTO:
             if ( f_absolut == 0 )
              {
               berechne_Pos ( Winkel,pos );
               for ( i=0 ; i<3 ; i++ ) eingabe[i] = eingabe[i] + pos[i];
              } 
             if ( eingabe[0] != 0.0 || eingabe[1] != 0.0 || eingabe[2] != 0.0 )
             {
              Gerade[0].x = eingabe[0];
              Gerade[0].y = eingabe[1];
              Gerade[0].z = eingabe[2];


              T06 ( Winkel,linkl,T );

              Gerade[1].x = linkl[3] * T[0][2] + T[0][3];
              Gerade[1].y = linkl[3] * T[2][2] + T[2][3] + linkl[0];
              Gerade[1].z = -(linkl[3] * T[1][2] + T[1][3]);
              p1.x = T[0][3];
              p1.y = T[1][3];
              p1.z = T[2][3];
              T[0][3] = eingabe[0];
              T[1][3] = -eingabe[2];
              T[2][3] = eingabe[1] - linkl[0];
               
              T[0][3] = T[0][3] - T[0][2] * linkl[3];
              T[1][3] = T[1][3] - T[1][2] * linkl[3];
              T[2][3] = T[2][3] - T[2][2] * linkl[3];

              if ( f_auto_gerade == 1 ) 
               {
                inverse_Kinematik ( T,eingabe,Winkel,linkl,&merker,f_auto_gerade );

              for ( i=0 ; i<6 ; i++ )
               {
                eingabe[i] = eingabe[i] - Winkel[i].akt ;
               }               
              if ( merker == 0 )
               {
                Gerade[1].x = Gerade[0].x;
                Gerade[1].y = Gerade[0].y;
                Gerade[1].z = Gerade[0].z;
                if ( Bregel_flag[0] != 0 ||
                     Bregel_flag[1] != 0 ||
                     Bregel_flag[2] != 0 ) Gerade[0].y = -1.0;
                
               /* Ausfuehren der Bewegung mit Beschleunigung. */
               berechne_Winkel ( eingabe,wB,wE,&n,&Schritte );                  
                  for ( i=1; i<n+1; i++ )
                  {
                   for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;

                   MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                   if ( Fehlercode == 1 ) break;
                  }    
    
                  if ( Fehlercode != 1)
                  {
                   MoveRobo ( pl,Gerade,wE,Winkel,Schritte,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                  
                   if ( Fehlercode != 1 )
                   { 
                    for ( i=n; i>0; i-- )
                    {
                     for ( j=0; j<6; j++ ) hw[j] = wB[j] * i;
  
                     MoveRobo ( pl,Gerade,hw,Winkel,1,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt );
                     if ( Fehlercode == 1 ) break;
                    }
                   }  
                  }


 



                if (Fehlercode == 1) { show_errorwin ("","     Kollision!");
                                     
                                    }

               }
              else {  if ( f_file == 0 ) show_errorwin ( "","   Zielpunkt nicht erreichbar!");
                    XBell ( mydisplay,30 );
                   }

               }
              else
              { 

              p2.x = T[0][3];
              p2.y = T[1][3];
              p2.z = T[2][3];
              Distanz = sqrt( sqr(p2.x - p1.x) + sqr(p2.y - p1.y) + sqr(p2.z - p1.z) );
             
              Schritte =(int)(Distanz / 0.5);
              if ( Schritte == 0 ) Schritte = 1;
              mdiff = 1.0 / Schritte;
              m = mdiff;

              while ( m <= 1.0 )
              {
               T[0][3] = p1.x + m * (p2.x - p1.x);
               T[1][3] = p1.y + m * (p2.y - p1.y);
               T[2][3] = p1.z + m * (p2.z - p1.z);
               inverse_Kinematik ( T,eingabe,Winkel,linkl,&merker,f_auto_gerade );
               
               if ( merker == 0 )
                {
                 for ( i=0 ; i<6 ; i++ )
                  {
                   eingabe[i] = eingabe[i] - Winkel[i].akt;
                  if ( fabs(eingabe[i]) > 0.087266462 && m < 1.0) merker=1;
                  if ( fabs(eingabe[i]) > PI ) { merker = 2;
                                                 break;
                                               } 
                  }
                 if ( merker == 1 ) {
                                     mdiff = mdiff / 2.0;
                                     m = m - mdiff;
                                    }
                else 
                { if ( merker == 0 )
                  {
                   Schrittzahl = abs((int)(eingabe[0] / (power[0]*(PI/180))));
                   for ( i=1 ; i<6 ; i++ )
                    {
                     merker = abs((int)(eingabe[i] / (power[i]*(PI/180))));
                     if (merker>Schrittzahl) Schrittzahl = merker;
                    } 
                   if ( Bregel_flag[0] != 0 ||
                        Bregel_flag[1] != 0 ||
                        Bregel_flag[2] != 0 ) Gerade[0].y = -1.0;
                   MoveRobo ( pl,Gerade,eingabe,
                              Winkel,Schrittzahl,&Fehlercode,&wy,&wx,&d,1,&indx,stdpkt);
                   if ( Fehlercode == 1 ) { if ( f_file == 0 )
                                            show_errorwin("","            Kollision!");
                                           
                                            m = 2.0;
                                          }
                   mdiff = 1.0 / Schritte;
                   if ( m<1.0 && (m+mdiff) > 1.0 ) m = 1.0;
                   else m = m + mdiff;

                  }
                  else {
                         m = 2.0;
                       }    
                 } 
                }
               else { if ( f_file == 0 )
                      show_errorwin ("","   Zielpunkt ist nicht erreichbar!");
                     
                      m = 2.0;
                    } 
              }
              }
              berechne_Pos ( Winkel,pos );
              aktualisiere_hwin ( Winkel,stdpkt,pos );
              Gerade[0].y = -2.0;
             }  
             else { if ( f_file == 0 )
                    show_errorwin ("","   Zielpunkt ist nicht erreichbar!");
                   
                  } 
             if ( Bregel_flag[0] != 0 ||
                  Bregel_flag[1] != 0 ||
                  Bregel_flag[2] != 0 ) Gerade[0].y = -1.0; 
             DrawRobo ( pl,kl,Gerade,wy,wx,d,ALT);
              if ( Bregel_flag[0] == 0 &&
                   Bregel_flag[1] == 0 &&
                   Bregel_flag[2] == 0 )
              {
              for ( i=0 ; i<3 ; i++ ) 
                           { Bregler[i] = (int)((225.0 / 51.0) * pos[i] + 220.5);
                             XClearWindow ( mydisplay,Bregelwin[i] );
                             XFillArc ( mydisplay,Bregelwin[i],fgc[0],Bregler[i],1,14,14,0,23040 );
                           }
              }
             if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
             show_pixmap();
             break;
   case BETRACHTER:
                   if ( f_absolut == 0 ) 
                    {
                       for ( i=0 ; i<3 ; i++ )
                        {
                         eingabe[i] = eingabe[i] + stdpkt[i];
                        } 
                    }
                   if ( Bregel_flag[0] == 0 &&
                        Bregel_flag[1] == 0 &&
                        Bregel_flag[2] == 0   )  
                        { for ( i=0 ; i<3 ; i++ ) {
                                                   Bregler[i] = (int)((225.0/51.0) * eingabe[i]+220.5);
                                                   XClearWindow ( mydisplay,Bregelwin[i] );
                                                   XFillArc ( mydisplay,Bregelwin[i],fgc[0],
                                                             Bregler[i],1,14,14,0,23040 );
                                                  }
                        }      
                   if ( eingabe[0] == 0.0 &&
                        eingabe[1] == 0.0 &&
                        eingabe[2] == 0.0    ) eingabe[2] = 0.01;
                   Winkelberechnung ( eingabe[0],eingabe[1],eingabe[2],
                                      &wy,&wx,&d );
                   DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU ); 
                   if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                   show_pixmap();
                   for ( i=0 ; i<3 ; i++ ) stdpkt[i] = eingabe[i];
                   aktualisiere_hwin(Winkel,stdpkt );
                   break;
   case BETRACHTER_GERADE:
                  mdiff = 1.0 / Schritte;
                  m = 0.0;
                  for ( i=0 ; i<Schritte+1 ; i++ )
                   {
                    x = eingabe[0] + m * ( eingabe[3] - eingabe[0] );
                    y = eingabe[1] + m * ( eingabe[4] - eingabe[1] );
                    z = eingabe[2] + m * ( eingabe[5] - eingabe[2] );
                   
                    Winkelberechnung ( x,y,z,&wy,&wx,&d );
                    DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU );
                    show_pixmap();
                    stdpkt[0] = x;
                    stdpkt[1] = y;
                    stdpkt[2] = z;
                    m = m + mdiff;  
                   } 
                    Winkelberechnung ( x,y,z,&wy,&wx,&d );
                    DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU );
                    show_pixmap();

                  break;
   case BETRACHTER_KREIS:
                  Schritte = (int)( eingabe[8] / eingabe[7] );
                  eingabe[1] = eingabe[1] * ( PI / 180.0 );
                  eingabe[2] = eingabe[2] * ( PI / 180.0 );
                  eingabe[3] = eingabe[3] * ( PI / 180.0 );
                  eingabe[7] = eingabe[7] * ( PI / 180.0 );
                  eingabe[8] = eingabe[8] * ( PI / 180.0 );
                  cx = cos ( eingabe[1] );
                  sx = sin ( eingabe[1] );
                  cy = cos ( eingabe[2] );
                  sy = sin ( eingabe[2] );
                  cz = cos ( eingabe[3] );
                  sz = sin ( eingabe[3] );
                  m = 0.0;
                  for ( i=0 ; i<Schritte+1 ; i++ )
                  {
                   if ( i == Schritte ) m = eingabe[8];
                   /* Berechnung des Punktes in der XY-Ebene. */
                   eingabe[2] = sin(m) * eingabe[0];
                   eingabe[1] = cos(m) * eingabe[0];

                   /* Rotation. */
                   x = eingabe[1] * cy * cz + eingabe[2] * ( sx*sy*cz - cx*sz ) + eingabe[4];
                   y = eingabe[1] * cy * sz + eingabe[2] * ( sx*sy*sz + cx*cz ) + eingabe[5];
                   z = eingabe[1] * ( - sy ) + eingabe[2] * sx * cy + eingabe[6];

                   /* Projektion. */
                   Winkelberechnung ( x,y,z,&wy,&wx,&d );
                   DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU );
                   show_pixmap();
                   stdpkt[0] = x;
                   stdpkt[1] = y;
                   stdpkt[2] = z;
                   m = m + eingabe[7]; 
                  }
                  break;
   case ARMLAENGE: 
                  if ( eingabe[0] >= 4.5 &&
                       eingabe[1] >= 2.5 &&
                       eingabe[2] >= 2.5 )
                  {
                   for ( i=0 ; i<6 ; i++ )  {
                                             w_alt[i] = Winkel[i].akt;
                                             Winkel[i].akt = 0.0;
                                            }
                  
                   for ( i=0 ; i<3 ; i++ ) {
                                             h = linkl[i];
                                             linkl[i] = eingabe[i]; 
                                             eingabe[i] = h - eingabe[i];
                                           } 
                   for ( i=48 ; i<78 ; i++ ) PL[i].y = PL[i].y - eingabe[0];
                   for ( i=78 ; i<108 ; i++ ) { PL[i].y = PL[i].y - eingabe[0];
                                                PL[i].x = PL[i].x - eingabe[1];
                                              }
                   for ( i=108 ; i<ANZAHL_PKTE ; i++ ) {
                                                       PL[i].y = PL[i].y - eingabe[0] + 
                                                                 eingabe[2];
                                                       PL[i].x = PL[i].x - eingabe[1];
                                                      }
             
                   copy_PKTLISTE ( PL,pl );    
                   w_neu[0] = 0.0;
                   w_neu[1] = (-PI/2);
                   w_neu[2] = w_neu[1];
                   w_neu[3] = 0.0;
                   w_neu[4] = 0.0;
                   w_neu[5] = 0.0; 
                   PosRobo ( pl,w_neu,Winkel );

                   w_alt[1] = w_alt[1] + (PI/2);
                   w_alt[2] = w_alt[2] + (PI/2);
                   MoveRobo ( pl,Gerade,w_alt,Winkel,45,&Fehlercode,&wy,&wx,&d,0,&indx,stdpkt );
   
                   DrawRobo ( pl,kl,Gerade,wy,wx,d,NEU ); 
                   if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
                   show_pixmap();
                  }
                  else { if ( f_file == 0 )
                        show_errorwin ( "","  Armlaenge ist nicht zulaessig!");
                        XBell ( mydisplay,40 );
                       }
                  aktualisiere_hwin ( Winkel,stdpkt ); 
                  break;
   case WINKEL:
               if ( eingabe[0] >= 0.0 &&
                    eingabe[1] >= 0.0 &&
                    eingabe[2] >= 0.0 &&
                    eingabe[3] >= 0.0 &&
                    eingabe[4] >= 0.0 &&
                    eingabe[5] >= 0.0)
                {
                 for ( i=0 ; i<6 ; i++ ) { wgewicht[i] = (int)(eingabe[i]);
                                          }
                 aktualisiere_hwin (Winkel,stdpkt );
                }
               else { if ( f_file == 0 )
                     show_errorwin("","Winkelgewichte muessen positiv sein!");
                     XBell ( mydisplay,30 );
                    }
               break; 
   case FARBE :
               for ( i=0 ; i<7 ; i++ )
                {
                 merker = XAllocNamedColor ( mydisplay,cmap,estring[i],&exact,&color );
                 if ( merker != 0 ) {
                                     if ( i!= 0 && i != 6) {
                                                            strcpy(fname[i-1],estring[i]);
                                                            farbe[i-1] = color.pixel;
                                                           }
                                     else 
                                     {
                                       if ( i == 0 )
                                        {
                                           strcpy ( fname[5],estring[0] );
                                           plane = color.pixel;
                                        }
                                       else {
                                             strcpy( fname[7],estring[6] );
                                             farbe[6] = color.pixel;
                                            }
                                      } 
                                    }
                 else { if ( f_file == 0 )
                       show_errorwin("","     unbekannter Farbname! "); 
                       XBell(mydisplay,30);
                      }
                }
              
               DrawRobo ( pl,kl,Gerade,wy,wx,d,ALT );
               if ( f_file == 0 ) KoordinatenSystem ( koorpl,wy,wx ); 
               show_pixmap(); 
               aktualisiere_hwin(Winkel,stdpkt);
               break; 
   case BEENDEN:
          done = 1;
          break;
   case -1 :
            break;
  }   
 }
 
 XCloseDisplay ( mydisplay ); 
 exit ( 0 );
}  
