/************************************************************************/
/* File: ~/sopra/RoboPackII/Cinematic.java                                */
/* This file consists of the methods the robot needs to calculate his	*/
/* new values								*/
/************************************************************************/

package RoboPackII;


final class CinematicCalculations
{
	/* This class provides the 'main class' with the needed        */
	/* calculation methods.					       */

	public static void TO6(AngleDates[] angles, double[] linkl, 
			       double[][] T)
	{
	   /* The 'angles'- and 'linkl'-arrays have to consist of 6    */
	   /* elements, the 'T'-array is a 3x4-array.		       */

	   double c12, s12;
 	   double[] s = new double[6];
	   double[] c = new double[6];
 	   double h1,h2;
 	   int i;

 	   for ( i=0 ; i<6 ; i++ )
  	     {
               c[i] = Math.cos( angles[i].act );
               s[i] = Math.sin( angles[i].act );
             }
 	   c12 = c[1] * c[2] - s[1] * s[2];
 	   s12 = c[1] * s[2] + s[1] * c[2];

           h1 = c[3] * c[4] * c[5] - s[3] * s[5];
 	   h2 = s[4] * c[5];
 	   T[2][0] = (-s12) * h1 - c12 * h2;
 
           h1 = c12 * h1 - s12 * h2;
	   h2 = s[3] * c[4] * c[5] + c[3] * s[5];
	   T[0][0] = c[0] * h1 + s[0] * h2;
	   T[1][0] = s[0] * h1 - c[0] * h2;

 	   h1 = (-c[3]) * c[4] * s[5] - s[3] * c[5];
 	   h2 = s[4] * s[5];
 	   T[2][1] = (-s12) * h1 + c12 * h2;

 	   h1 = c12 * h1 + s12 * h2;
	   h2 = c[3] * c[5] - s[3] * c[4] * s[5];
 	   T[0][1] = c[0] * h1 + s[0] * h2;
 	   T[1][1] = s[0] * h1 - c[0] * h2;


 	   h1 = c[3] * s[4];
 	   T[2][2] = s12 * h1 - c12 * c[4]; 
 
	   h1 = c12 * h1 + s12 * c[4];
 	   h2 = s[3] * s[4];
           T[0][2] = (-c[0]) * h1 - s[0] * h2;
	   T[1][2] = (-s[0]) * h1 + c[0] * h2;


 	   h1 = linkl[1] * c[1] - linkl[2] * s12;
 	   T[0][3] = c[0] * h1;
 	   T[1][3] = s[0] * h1;
 	   T[2][3] = (-linkl[1]) * s[1] - linkl[2] * c12;
	}

	public static void calculatePos(AngleDates[] angles, double[] pos,
					RoboProto rob)
	{
	   /* 'Angles has to be a 6-elements- and 'pos' a 3-elements-    */
	   /* array.						         */

           double[][] A = new double[3][4];
	   double[] position = new double[3];
	   int i,h;

           TO6(angles,rob.linkLengths,A);
              position[0] = A[0][3] + A[0][2] * rob.linkLengths[3];
              position[1] = A[2][2] * rob.linkLengths[3] + A[2][3] 
				+ rob.linkLengths[0];
              position[2] = -A[1][2] * rob.linkLengths[3] - A[1][3];    
            for ( i=0 ; i<3 ; i++ ) 
              {
                 h = (int)(position[i] * 1000 + 0.5);
                 position[i] = h / 1000.0;  
                 pos[i] = position[i];
              }
	}

	public static int inverseAngle1(double[][] T, double[] angNew, 
		AngleDates[] angOld, int reminder, RoboProto rob)
	{
	   /* 'T' has to be a 3x4-array, 'angNew' consists of 2 elements  */
	   /* and 'angOld' of 6. 				 	  */
	   /* Returns the new value of reminder.			  */
	
	   double help1, help2, help3;
 	   int i;
	     
 	   if ( T[0][3] != 0.0 || T[1][3] != 0.0 )
  	     {
  	       /* atan2 is calculatable for these values,so */
      	       /* two angle values can be determined.       */

   	       help1 = Math.atan2( T[1][3] , T[0][3] );
	       help2 = Math.sqrt( T[0][3]*T[0][3] + T[1][3]*T[1][3]);
 	       help3 = Math.atan2( 0.0 , help2 );
   	       angNew[0] = help1 - help3;

  	       help3 = Math.atan2( 0.0 , -help2 );
  	       angNew[1] = help1 - help3;

   	       if ( angNew[0] == 0.0 && rob.angles[0].act <= 0.0 &&
     		    angNew[1] >= 0.0 ) 
		 angNew[1] = -Math.PI;
   	       if ( angNew[1] == 0.0 && rob.angles[0].act < 0.0 &&
       		    angNew[0] > 0.0 ) 
		 angNew[0] = -Math.PI; 

 	       for ( i=0 ; i < 2 ; i++ )
    		 {
     		   if ( angNew[i] < (-Math.PI ))
		     angNew[i] = angNew[i] + 2 * Math.PI;
                   else {
         		  if ( angNew[i] > Math.PI ) 
			    angNew[i] = angNew[i] - 2 * Math.PI;
         		}   

   
   		 }
	       return 0;
	     }
	   else 
	     {
	       /* Point is on the Y-line. In this case */
               /* atan2 is not calculatable.           */

       	      angNew[0] = angOld[0].act;
       	      if ( angOld[0].act + 1.570796327  <=  (rob.angles[0].max)  &&
            	   angOld[0].act + 1.570796327  >= (rob.angles[0].min ) )
                 angNew[1] = angOld[0].act  + Math.PI / 2.0;
              else angNew[1] = angOld[0].act - Math.PI / 2.0; 
      	      return 2;
    	     }
	}

	public static int inverseAngle3(double[][] T, double[] angNew, 
			double[] linkl, int reminder, RoboProto rob)
	{
	   /* 'T' has to be a 3x4-array, 'angNew' consists of 2 elements  */
	   /* and 'linkl' of 3. 				 	  */
	   /* Returns the new value of reminder.			  */
	
	   double help, K, help2;
 	   int i;

	   K = T[0][3] * T[0][3] + T[1][3] * T[1][3] + T[2][3] * T[2][3];
	   K = K - linkl[1] * linkl[1] - linkl[2] * linkl[2];
 	   K = K / ( 2 * linkl[1] );
 	   if ( Math.abs(K) <= 0.000001 ) 
	     K = 0.0;

 	   help = linkl[2] * linkl[2] - K * K;

 	   if ( help > 0 )
  	     {
 	       help = Math.sqrt( help );
  	       help2 = Math.atan2( 0.0 , linkl[2] );
   	       angNew[0] = help2 - Math.atan2( K , help );
   	       angNew[1] = help2 - Math.atan2( K , (-help) );

   	       for (i=0; i < 2; i++)
   		 {
  		   if ( angNew[i] > rob.angles[2].max ) 
		     angNew[i] = angNew[i] - 2 * Math.PI;
   		 }

   	       return 0;
 	     }
	   else 
	     return 1;  // Calculation not possible.
	}

	public static int inverseAngle2(double[][] T, double[] angNew, 
			double[] linkl, double angle1, double angle3, 
		        double[] s, double[] c, int reminder, RoboProto rob)
	{
	   /* 'T' has to be a 3x4-array, 'angNew' consists of 2 elements  */
	   /* and 'linkl' of 3. 's' and 'c' consist of 6 elements.	  */
	   /* Returns the new value of reminder.			  */

	   double help1,help2;

 	   help1 = T[2][3] * T[2][3];
 	   help2 = c[1] * T[0][3] + s[1] * T[1][3];
 	   help1 = help1 + help2 * help2;

 	   if ( help1 > 0.0 )
 	     {
  	       help1 = (-linkl[1] * c[3]) * T[2][3] +
                       ( c[1] * T[0][3] + s[1] * T[1][3] ) *
                       ( linkl[1] * s[3] - linkl[2] );
   	       if ( help1 == -0.0 )
		 help1 = 0.0;
 	       help2 = (linkl[1] * s[3] - linkl[2]) * T[2][3] -
            	       (-linkl[1] * c[3])*(c[1] * T[0][3] + s[1] * T[1][3]);
  	       if ( Math.abs(help1) <= 0.000001) 
		 help1 = 0.0;
  	       if ( Math.abs(help2) <= 0.000001) 
		 help2 = 0.0;

	       if ( help1 != 0.0 || help2 != 0.0 )
 	         {
   		   angNew[0] = Math.atan2( help1,help2 ) - angle3;
   	           if ( angNew[0] > rob.angles[1].max )
		     angNew[0] = angNew[0] - 2*Math.PI;
   		   if ( Math.abs(angNew[0] - Math.PI) <= 0.000001 ) 
	             angNew[0] = -Math.PI;
     		   return 0;
  	         }
  	       else return 1;
 	     }
 	   else return 1;
	}

	public static int inverseAngle4(double[][] T, double[] angNew, 
	    AngleDates[] angOld, double angle1, double angle2, double angle3,
	    double[] s, double[] c, int reminder, RoboProto rob) 
	{
	   /* 'T' has to be a 3x4-array, 'angNew' consists of 2 elements  */
	   /* and 'angOld' of 6. 's' and 'c' consist of 6 elements.	  */
	   /* Returns the new value of 'reminder'.			  */

	   double help1, help2, help3, help4;
	   double c23, s23;

           c23 = c[2] * c[3] - s[2] * s[3];
 	   s23 = c[2] * s[3] + s[2] * c[3];

	   help1 = (-T[0][2]) * s[1] + T[1][2] * c[1];
           help3 = (-T[0][2]) * c[1] * c23 ;
 	   help4 = (-T[1][2]) * s[1] * c23 ;
	   help2 = help3 + help4 + T[2][2] * s23;
 	   if ( Math.abs(help1) <= 0.000001 )
	     help1 = 0.0;
 	   if ( Math.abs(help2) <= 0.000001 )
	     help2 = 0.0;

 	   if ( Math.abs(help1) <= 1.000001 && Math.abs(help2) <= 1.000001 &&
     	      ( Math.abs(help1) >= 0.01 || Math.abs(help2) >= 0.01))
  	     {
  	       angNew[0] = Math.atan2( help1,help2 );
   	       if ( Math.abs(Math.abs(angNew[0]) - Math.PI) <= 0.000001 )
   	         {
   	           if ( angOld[3].act < 0.0 && angNew[0] >= 0.0 ) 
		     angNew[0] = angNew[0] * (-1);
    		   if ( angOld[3].act > 0.0 && angNew[0] < 0.0 )
		     angNew[0] = angNew[0] * ( -1);
   		 } 
  	       return 0;
  	     }
	   else 
	     {
      	       if ( Math.abs(help1) <= 0.01 && Math.abs(help2) <= 0.01 )
       	         { 
		   angNew[0] = angOld[3].act;
           	   return 5;
        	 }
      	       else return 1;
     	     } 
	}

	public static int inverseAngle5(double[][] T, double[] angNew,
			double a1, double a2, double a3, double a4, double[] s,
			double[] c, int reminder, RoboProto rob)
	{
	   /* 'T' has to be a 3x4-array, 'angNew' consists of 6 elements.  */
	   /* 's' and 'c' consist of 6 elements.	                   */
	   /* Returns the new value of 'reminder'.	       		   */

	   double help1;
 	   double help2;
 	   double c23, s23;

 	   c23 = c[2] * c[3] - s[2] * s[3];
 	   s23 = c[2] * s[3] + s[2] * c[3];

 	   help1 = -(T[0][2] * ( c[1] * c23 * c[4] + s[1] * s[4] ) 
		  + T[1][2] * 
                ( s[1] * c23 * c[4] - c[1] * s[4] ) - T[2][2] * ( s23 * c[4]));
 	   help2 = T[0][2] * ( (-c[1]) * s23 ) + T[1][2] * ( (-s[1]) * s23 ) 
	           + T[2][2] * (-c23);
	   if ( Math.abs(help1) <= 0.000001 )
	     help1 = 0.0;
 	   if ( Math.abs(help2) <= 0.000001 )
	     help2 = 0.0;

 	   if ( Math.abs(help1) <= 1.000001 && Math.abs(help2) <= 1.000001 &&
    	        ( help1 != 0.0 || help2 != 0.0))
 	     {
  	       angNew[0] = Math.atan2( help1,help2 );
   	       return 0;
  	     }
 	   else return 1;
	}

	public static int inverseAngle6(double[][] T, AngleDates[] angles,
	 	       double[] angNew, double a1, double a2, double a3,
		       double a4, double a5, double[] s, double[] c, 
		       int reminder, RoboProto rob) 
	{
	   /* 'T' has to be a 3x4-array, 'angles' consists of 6 elements  */
	   /* and 'angNew' of 6. 's' and 'c' consist of 6 elements.	  */
	   /* Returns the new value of 'reminder'.			  */

	   double help1;
 	   double help2, help3, help4;
 	   double c23, s23;

 	   c23 = c[2] * c[3] - s[2] * s[3];
 	   s23 = c[2] * s[3] + s[2] * c[3];

	   help1 = (-T[0][0])*( c[1]*c23*s[4] - s[1]*c[4]); 
	   help3 = T[1][0]*( s[1]*c23*s[4] + c[1]*c[4]);
 	   help4 = T[2][0]*( s23*s[4]);
 	   help1 = help1 - help3 + help4;

 	   help2 = T[0][0]*((c[1]*c23*c[4] + s[1]*s[4])*c[5] - c[1]*s23*s[5]) +
                   T[1][0]*((s[1]*c23*c[4]-c[1]*s[4])*c[5] - s[1]*s23*s[5]) -
                   T[2][0]*(s23*c[4]*c[5] + c23*s[5]);
           if ( Math.abs(help1) <= 0.000001)
	     help1 = 0.0;
 	   if ( Math.abs(help2) <= 0.000001)
	     help2 = 0.0;
 
 
 	   if ( Math.abs(help1) <= 1.000001 && Math.abs(help2) <= 1.000001 &&
  	        ( help1 != 0.0 || help2 != 0.0))
  	     {
   	       angNew[0] = Math.atan2( help1,help2 );

	       /* **************************************************** */
   	       if ( Math.abs(Math.abs(angNew[0]) - Math.PI ) < 0.000001 )
      		 {
      	 	   if ( angles[5].act < 0.0 && angNew[0] >= 0.0 ) 
		     angNew[0] = -angNew[0];
    		   if ( angles[5].act > 0.0 && angNew[0] < 0.0 )
		     angNew[0] = -angNew[0];
     		  }
	       /* **************************************************** */
        
   	       if ( angNew[0] < (-Math.PI ))
	         angNew[0] = angNew[0] + 2 * Math.PI;
    	       else 
		 {
	           if ( angNew[0] > Math.PI )
		     angNew[0] = angNew[0] - 2 * Math.PI;
         	 }   

  	       return 0;
 	     }
 	   else return 1;
	}

	public static int inverseCinematic(double[][] T, double[] angNew,
			AngleDates[] angOld, double[] linkl, int result,
			int f_a_g, RoboProto rob)
	{
	   /* 'T' has to be a 3x4-array and is frame 6 relatively to     */
	   /* frame 0. 'angNew' consists of 6 elements as 'angOld' does. */
	   /* 'linkl' has got 3 elements.				 */
	   /* 'angOld' are the actual angles and 'linkl' the actual link */
	   /* lengths. If result is 0 then a valid combination of angles */
	   /* has been found.						 */
	   /* Returns the new value of 'result'.             		 */

	   double[][] A = new double[3][4];
 	   double angMax,angHelp;
 	   int number;
 	   AngleDates[] w = { new AngleDates(0.0, 0.0, 0.0),
			      new AngleDates(0.0, 0.0, 0.0),  
			      new AngleDates(0.0, 0.0, 0.0),
			      new AngleDates(0.0, 0.0, 0.0),  
			      new AngleDates(0.0, 0.0, 0.0),
			      new AngleDates(0.0, 0.0, 0.0) }; 
 	   double[] s = new double[6], c = new double[6];
 	   double zw,help;
	   double[] angle = new double[2];
 	   int i,j,k, reminder;      
		      /* reminder = 0 ... result is OK.
                         reminder = 1 ... no result.
                         reminder = 2 ... the result has to be checked.
                         reminder = 5 ... set angle 5  to 0.        */
     
 	   double[][] w_tab = new double[8][7]; 
		      // w_tab[i][0] = 0 ... Angle combination is OK. 
                      // w_tab[i][0] = 1 ... Angle combination is not OK.
                      // w_tab[i][0] = 2 ... Combination has to be checked.

 	   result = 1;
	   reminder = 300; // stupid, only for the syntax needed default value

 	   reminder = inverseAngle1 ( T,angle,angOld,reminder, rob );
 	   for ( i=0 ; i < 2 ; i++ )
	     {
	       w_tab[i][0] = reminder;
               w_tab[i][1] = angle[0];
             }
 	   for ( i=2 ; i < 4 ; i++ )
	     {
	       w_tab[i][0] = reminder;
               w_tab[i][1] = angle[1];
             }
             
 	   reminder = inverseAngle3 ( T,angle,linkl,reminder, rob );
 	   if ( reminder == 0 )
 	     {   
	       /* It exists a solution for angle 3 */
   	       for ( i=0 ; i < 2 ; i++ ) 
	         {
		   w_tab[i*2][3] = angle[0];
                   w_tab[i*2+1][3] = angle[1];
                 }

  	       for ( i=0 ; i < 4 ; i++ )
 	         {
	           s[1] = Math.sin ( w_tab[i][1] );
 	           c[1] = Math.cos ( w_tab[i][1] );
   	  	   s[3] = Math.sin ( w_tab[i][3] );
   		   c[3] = Math.cos ( w_tab[i][3] );

    		   reminder = inverseAngle2 (T,angle,linkl,w_tab[i][1],
					 w_tab[i][3], s,c,reminder, rob );
   		   if ( reminder == 1 ) 
	             w_tab[i][0] = 1.0 ; 
     		   else
      		     {  
		       /* A solution for angle 2 exists, that means angle 4
         	          can now be calculated.                           */  
      		       w_tab[i][2] = angle[0];
     		       s[2] = Math.sin ( angle[0] );
     		       c[2] = Math.cos ( angle[0] );

     		       reminder = inverseAngle4 ( T,angle,angOld,w_tab[i][1],
				   w_tab[i][2], w_tab[i][3], s,c,reminder,rob);
    		       if ( reminder == 1 ) 
			 w_tab[i][0] = 1.0;
       		       else
  		         { 
			    /* A solution for angle 4 exists, that means 
			       angle 5 can now be calculated.		 */
        		    s[4] = Math.sin ( angle[0] );
     			    c[4] = Math.cos ( angle[0] ); 
     			    w_tab[i][4] = angle[0];
      			    if ( reminder == 5 )
          		      {
           			w_tab[i][0] = 2.0;
         		        w_tab[i][5] = 0.0;
       			        s[5] = 0.0;
       			        c[5] = 1.0; 
        		      }  /* if .. reminder == 5 */
       			    else
       			      { 
			        /* Calculation of angle 5 */
       			        reminder = inverseAngle5(T,angle,w_tab[i][1],
					    w_tab[i][2],w_tab[i][3], 
					    w_tab[i][4],s,c,reminder, rob );
           			if ( reminder == 1 ) 
				  w_tab[i][0] = 1.0; 
           			else 
				  { 
				    w_tab[i][5] = angle[0];
                		    s[5] = Math.sin ( w_tab[i][5] );
                		    c[5] = Math.cos ( w_tab[i][5] );
              			  }
         		      }  /* else .. reminder == 5 */
       			    if ( w_tab[i][0] != 1.0 )
         		      {  
				/* Calculation of angle 6 */
          		        reminder = inverseAngle6(T,rob.angles,angle,
				    w_tab[i][1], w_tab[i][2],w_tab[i][3],
                                    w_tab[i][4],w_tab[i][5],s,c,reminder, rob);
    	                        if ( reminder == 1 )
			          w_tab[i][0] = 1.0 ; 
         		        else
      			          {
      			            w_tab[i][6] = angle[0];
             
         		            /* Copying of the angle values: */
         		            w_tab[i+4][0] = w_tab[i][0];
       		                    w_tab[i+4][1] = w_tab[i][1];
        		            w_tab[i+4][2] = w_tab[i][2];
          		            w_tab[i+4][3] = w_tab[i][3];

              			    if ( Math.abs(w_tab[i][4]) == 0.0 ) 
              			      {
              			        if ( angOld[3].act >= 0.0 ) 
					  w_tab[i+4][4] = w_tab[i][4] +Math.PI;
               				else w_tab[i+4][4] = w_tab[i][4] 
							     - Math.PI;
             			      } 
              			    else 
             		              { 
			 	 	if (w_tab[i][4] > 0.0) 
					  w_tab[i+4][4] = w_tab[i][4] -Math.PI;
                			else w_tab[i+4][4] = w_tab[i][4] 
							     + Math.PI;
             			      } 
            			    w_tab[i+4][5] = -w_tab[i][5];
              
              			    if ( Math.abs(w_tab[i][6]) == 0.0 ) 
             			      {
             			        if ( angOld[5].act >= 0.0 ) 
					  w_tab[i+4][6] = w_tab[i][6] +Math.PI;
              				else w_tab[i+4][6] = w_tab[i][6] 
							     - Math.PI;
             			      } 
             			    else 
           			      { 
				        if (w_tab[i][6] > 0.0) 
					  w_tab[i+4][6] = w_tab[i][6] -Math.PI;
              			        else w_tab[i+4][6] = w_tab[i][6] 
							     + Math.PI;
            			      } 

            		          } /* else .. reminder W6 */  
         		      } /* if ... w_tab[i][0] == 0 */ 

      		          }  /* else .. reminder Angle 4 */
      		      }    /* else .. reminder Angle 2 */
	          } /* endfor  */
  
		/* Determination of the best angle solution */
                      
	        result = 1;
	        zw = 10000;
		for ( i=0 ; i < 8 ; i++ )
 		  {
  		    if ( w_tab[i][0] != 1.0)
   		      {
   		        reminder = 0;
   		        for ( j=0 ; j < 6 ; j++ )
    			  {
   			    w[j].act = w_tab[i][j+1];
    			    if ( w_tab[i][j+1] < rob.angles[j].min ||
    		                 w_tab[i][j+1] > rob.angles[j].max ) 
                              {
                                w_tab[i][0] = 1.0;
                                reminder = 1;
                                break;
                              }
   		 	  } /* endfor */
   		        if ( reminder == 0 )
     			  {
     			    TO6 ( w,linkl,A );
     			    for ( j=0 ; j < 3 ; j++ )
     			      {
      			        if ( Math.abs(T[j][0] - A[j][0]) > 0.01 ||
       			             Math.abs(T[j][1] - A[j][1]) > 0.01 ||
         		             Math.abs(T[j][2] - A[j][2]) > 0.01 ||
          		             Math.abs(T[j][3] - A[j][3]) > 0.1     )
				  { 
                                    w_tab[i][0] = 1.0;  
                                    reminder = 1;
                                    break;
                                  } 
     			      }
      		 	    if ( reminder == 0 )
       			      {
              		        // This combination of angles is allowed
				// and correct. 
          			// Calculation of the target function.
       			        help = 0;
         		        for ( j=0 ; j < 6 ; j++ )
         			  help = help + rob.angleWeights[j] * 
				     Math.abs( w_tab[i][j+1] - angOld[j].act );
         			if ( zw > help ) 
				  {
                          	    zw = help;
                          	    for ( j=0 ; j < 6 ; j++ )
                             	      angNew[j] = w_tab[i][j+1];
                            	  }  
         		        result = 0;
      			      }
     			  }
                      } /* end if */
                  }  /* end for */


                /* If it is the case that f_auto_gerade is 0 ,
      	 	   it will be tested, if there exists a better solution. */

 	        if ( f_a_g == 0 )
  		  {
   		    angMax = Math.abs( angOld[0].act  - angNew[0] );
   		    for ( i=1; i < 6; i++ )
    		      {
   			if (angMax < (Math.abs( angOld[i].act - angNew[i] ) )) 
			  angMax = Math.abs( angOld[i].act - angNew[i] );
  		      }

   		    for ( i=0; i < 8; i++ )
   		      {
    		        if ( w_tab[i][0] != 1 )
       		          {
       			    angHelp = Math.abs( angOld[0].act - w_tab[i][1] );
    		            for ( j=2; j < 7; j++ )
     			      { if ((i > 0) && (i < 7))// meine Einschraenkung
     			        if (angHelp < 
				  (Math.abs(angOld[i-1].act - w_tab[i][j]))) 
			          angHelp = Math.abs(
					       angOld[i-1].act - w_tab[i][j] );
    		              }      
     		            if ( angMax > angHelp )
     			      {
      			        angMax = angHelp;
      			        for ( j=0; j < 6; j++ ) 
			          angNew[j] = w_tab[i][j+1];
   		              }
    		          }
   
 		      }
    
                  }  



 
             } /* if reminder == 0) ... */ 
	   return result;
	} /* end of method: 'inverseCinematic' */
	
}
 