/**********************************************************************/
/* File: ~/sopra/RoboPackII/SmallClasses.java                           */
/* This file consists of some useful tiny classes which               */
/* could have been created as structures in "C" as well.              */
/**********************************************************************/

package RoboPackII;

import java.awt.Point;

class Points
{
        /* This class holds the three coordinates' values of a        */
        /* three-dimensional point. 				      */

	public double x, y, z;

	Points()
	{
	   this.x = this.y = this.z = 0.0;
	}

	Points(double x, double y, double z)
	{
	   this.x = x;
	   this.y = y;
	   this.z = z;
	}
}

class Edges
{
        public short p1, p2;

	Edges()
	{
	   this.p1 = this.p2 = 0;
	}

	Edges(short p1, short p2)
	{
	   this.p1 = p1;
	   this.p2 = p2;
	}

	Edges(int p1, int p2)
	{
	   this.p1 = (short) p1;
	   this.p2 = (short) p2;
	}
}

class AngleDates
{
        /* This class is home of the dates corresponding to every     */
        /* angle.                                                     */

 	double max, min, act;

	AngleDates(double max, double min, double act)
	{
	   this.max = max;
	   this.min = min;
	   this.act = act;
	}
       
}

class EdgesPointsList
{
	public Points p1, p2;
	public short visible;

	EdgesPointsList(Points p1, Points p2, short visible)
	{
	   this.p1 = p1;
	   this.p2 = p2;
	   this.visible = visible;
	}
}

class Areas
{
	public short p1, p2, p3, p4;

	Areas()
	{
	   this.p1 = this.p2 = this.p3 = this.p4 = 0;
	}

	Areas(short p1, short p2, short p3, short p4)
	{
	   this.p1 = p1;
	   this.p2 = p2;
 	   this.p3 = p3;
	   this.p4 = p4;
	}

	Areas(int p1, int p2, int p3, int p4)
	{
	   this.p1 = (short) p1;
	   this.p2 = (short) p2;
 	   this.p3 = (short) p3;
	   this.p4 = (short) p4;
	}

}

class AreasPointsList
{
	public Point[] pp = new Point[4]; // ist das 2D-Punkt????
	public Points[] p = new Points[4]; // 3D-list of points
	public double zmin; // smallest value of the surface 
	public double nx, ny, nz;
	public double C;    // Coefficient of the area equatation 

}

class Sort
{
	public double z;
	public char part;

	Sort(double z, char part)
	{
	   this.z = z;
	   this.part = part;
	}
}

class RefInt
	/* This class is helpful, if you want an 'int' argument */
	/* to be a 'call-by-reference' one.				*/
{
	public int in;

	RefInt(int in)
	{
	   this.in = in;
	}
}

class RefDouble
	/* This class is helpful, if you want a 'double' argument */
	/* to be a 'call-by-reference' one.		   		  */
{  
	public double in;

	RefDouble(double in)
	{
	   this.in = in;
	}
}
