/************************************************************************/
/* File: ~/sopra/RoboPack/Windows.java                                  */
/* This file consists of  classes which are able to build up the needed */
/* windows.                                                             */
/************************************************************************/

package RoboPackII;

import java.awt.*;
import java.io.*;
import java.applet.Applet;

class MenuFrame extends Frame
{       
	/* This class provides for its subclasses the normal behaviour */
	/* of a Frame plus a Menubar with the items "Quit" and "Help". */
	/* If "Quit" is selected, the window hides itself and enables  */
	/* the panel of "main" window. It also defines an "execute"-   */
	/* button available for its subclasses.			       */

	private MenuBar menuBar = new MenuBar();
	private Menu menu = new Menu("Menu");
	protected MenuItem quit = new MenuItem("Quit");
	protected MenuItem help = new MenuItem("Help");
	protected RoboProto chefRobot;
	// Constants' declaration:
	protected final Button execButton = new Button("execute");
	

	MenuFrame(String name, RoboProto callingRobot)
	{ 
	   super(name);
	   menu.add(help);
	   menu.add(quit);
	   menuBar.add(menu);
	   this.setMenuBar(menuBar);
	   chefRobot = callingRobot;
	}

	public boolean action(Event e, Object o)
	{  
	   if (e.target == quit)
	      {
		this.hide(); 
		chefRobot.menuEnable();
		return true;
	      }
	    // sonst:
	   return super.action(e, o);
	}
}

class ReadfileWindow extends MenuFrame
{
	/* The only purpose of this class is to get the name of */
	/* the file the user wants to read in and then to read	*/
	/* the specific file.					*/

	private Panel readPanel = new Panel();
	private String fileName = null;
	private String fileText = null; // gets the text of the file
	private TextField fileT = new TextField("    ");
	private Button readIn = new Button("Read the file!");

	ReadfileWindow(Point where, RoboProto myrobot)
	{
	   super("Open File", myrobot);
	   // To avoid that the new window hides the old one:
	   if (where.x > 300)
	     move(100, 200);
	   else move(700 + where.x, 200);
	   resize(300, 200);
	   // Definition of the panel:
	   readPanel.setLayout(new GridLayout(2, 2, 10, 1));
	   readPanel.add(new Label("Path of the file:"));		
	   readPanel.add(fileT);   
	   readPanel.add(new Label(""));
	   readPanel.add(readIn);
	   add("Center", readPanel);
	   pack();
	   hide();
	}
	
	public boolean action(Event e, Object o)
	{
	   if (e.target == readIn)
	     {
	        fileName = new String(fileT.getText());
		File f = new File(fileName);
		int size = (int) f.length();
		FileInputStream fileIn;
		byte[] data = new byte[size];
		int i = 0;
		try
		{
		   fileIn = new FileInputStream(f);
		   // The file is read in and saved in "data"
		   while (i < size)
		     i += fileIn.read(data, i, size - i);
		   fileText = new String(data, 0);   
		}
		catch (IOException error)
		  { fileText = "File not found.";}
		this.hide();
		chefRobot.repaint();
	        chefRobot.menuEnable();
		return true;
	     }
	   // default:
	   return super.action(e, o);
	} 		
}	        

class HelpWindow extends Frame
{
	/* This class is a "Dialog" which shows a helping text, if */
	/* the user doesn't know, what to do. The text is loaded   */
	/* of the file given to the constructor of this class as   */
	/* argument.						   */

	private Panel belowP = new Panel();
	private Button okButton = new Button("O.K.");
	public TextArea helpText = new TextArea("Error.", 12, 50);
	
	HelpWindow(String filePath)
	{ 
	    super("RoboSim-Help");
	    helpText.setEditable(false);

	   // To avoid that the new window hides the old one:
	   move(700, 200);
	   resize(300, 200);
	  	   
	    // Loading of the with filePath specified file:
	    File f = new File(filePath);  
	    int size = (int)f.length();
	    java.io.FileInputStream fileIn;
	    byte[] data = new byte[size];
	    String str = null;
	    int i = 0;
	    try 
	    { 
	       fileIn = new java.io.FileInputStream(f);
               while (i < size)
		 i += fileIn.read(data, i, size - i);
	       str = new String(data, 0);
	    }
	    catch (IOException e) { str = "File not found.";}
	    helpText.setText(str);
	    belowP.setLayout(new FlowLayout());
	    belowP.add(okButton);
	    add("Center", helpText);
	    add("South", belowP);
	    pack();
	}

	public boolean action(Event e, Object o)
	{
	   if (e.target == okButton)
	     {
		this.hide();
		return true;
	     }
	   // sonst:
	   return super.action(e, o);
	}
}

















































































