/*********************************************************************/
/* File: ~/sopra/RoboPackII/Initialize.java                            */
/* The purpose of this file is to initialize all needed values, par- */
/* ticularly the robot specifying instances.			     */
/*********************************************************************/

package RoboPackII;


final class RobotInit
{
	/* This class defines all robot specific variables with use- */
	/* ful values.						     */

	public static void now(RoboProto rob)
	{
	   // First: new objects are builded
	   Points light = new Points(-800.0, 1500.0, 1000.0);
	   double[] linkLengths = { 13.5, 10.0, 10.0, 2.5 };
	   int[] angleWeights = { 0, 30, 20, 10, 10, 10 }; 
	   int[] power = { 3, 3, 3, 3, 3, 3 };
	   AngleDates[] angles = { new AngleDates(Math.PI,     -Math.PI, 0.0),
			        new AngleDates(0.523598775,-3.665191429, 0.0),
				new AngleDates(0.523598775,-3.665191429, 0.0),
				new AngleDates(Math.PI,        -Math.PI, 0.0),
		  		new AngleDates(Math.PI/2,    -Math.PI/2, 0.0),
  				new AngleDates(Math.PI/2,    -Math.PI/2, 0.0)};
	   Points[] line = { new Points(0.0, 2.0, 0.0),
	                     new Points(0.0, 0.0, 0.0) } ;
	   Edges gkl = new Edges((short)0, (short)1);
	   int[] rpl = { 64, 65, 94, 5, 114, 115, 138, 139, 140, 141, 146,
	 	         147, 152, 153 };
	   Points[] coorpl = { new Points(0, 0, 0), new Points(10, 0, 0), 
			       new Points(0, 10, 0),new Points(0, 0, 10) };
	   Edges[] coorc = { new Edges((short)0, (short)1), 
			     new Edges((short)0, (short)2), 
			     new Edges((short)0, (short)3) };
	
	   // Second: the robot gets new references to these objects
	   rob.light = light;
	   rob.linkLengths = linkLengths;
	   rob.angleWeights = angleWeights;
	   rob.power = power;
	   rob.angles = angles;
	   rob.line = line;
	   rob.gkl = gkl;
	   rob.rpl = rpl;
	   rob.coorpl = coorpl;
	   rob.coorc = coorc;

	   // Instanciation without values:
	   int i;
	   for (i = 0; i < rob.numberOfAreas; i++)
	     rob.apl[i] = new AreasPointsList();
	   for (i = 0; i < rob.numberOfPoints; i++)
	     rob.pl[i] = new Points();

	   for (i = 0; i < 361; i++)
	     rob.BListe[i] = new Points();

	   for (i = 0; i < 4; i++)
	     {
	       for (int j = 0; j < 6; j++)
	         rob.savedAngles[i][j] = 0;
	       rob.savedAngles[i][6] = 0.0; // a totally open hand
	     }

	  
	   // Instanciation with many values:
           Points[] helpPL =  { new Points(-25.0 ,   0.0 ,-25.0), // Area 0 
                                   new Points( -8.3 ,   0.0 ,-25.0),
                                   new Points(  8.3 ,   0.0 ,-25.0),
                                   new Points( 25.0 ,   0.0 ,-25.0),
                                   new Points(-25.0 ,   0.0 , -8.3),
                                   new Points( 25.0 ,   0.0 , -8.3),
                                   new Points(-25.0 ,   0.0 ,  8.3),
                                   new Points( 25.0 ,   0.0 ,  8.3),
                                   new Points(-25.0 ,   0.0 , 25.0),
                                   new Points( -8.3 ,   0.0 , 25.0),
                                   new Points(  8.3 ,   0.0 , 25.0), /* 10 */
                                   new Points( 25.0 ,   0.0 , 25.0),
                                   new Points(  0.0 ,   0.0 , -5.0), // Base 
                                   new Points( 3.53 ,   0.0 ,-3.53),
                                   new Points(  5.0 ,   0.0 ,  0.0),
                                   new Points( 3.53 ,   0.0 , 3.53),
                                   new Points(  0.0 ,   0.0 ,  5.0),
                                   new Points(-3.53 ,   0.0 , 3.53),
                                   new Points( -5.0 ,   0.0 ,  0.0),
                                   new Points(-3.53 ,   0.0 ,-3.53),
                                   new Points(  0.0 ,   3.0 , -5.0),  /* 20 */
                                   new Points( 3.53 ,   3.0 ,-3.53),
                                   new Points(  5.0 ,   3.0 ,  0.0),
                                   new Points( 3.53 ,   3.0 , 3.53),
                                   new Points(  0.0 ,   3.0 ,  5.0),
                                   new Points(-3.53 ,   3.0 , 3.53),
                                   new Points( -5.0 ,   3.0 ,  0.0),
                                   new Points(-3.53 ,   3.0 ,-3.53),
                                   new Points(  0.0 ,   3.0 , -1.5), //Turnarea
                                   new Points( 1.06 ,   3.0 ,-1.06),
                                   new Points(  1.5 ,   3.0 ,  0.0),  /* 30 */
                                   new Points( 1.06 ,   3.0 , 1.06),
                                   new Points(  0.0 ,   3.0 ,  1.5),
                                   new Points(-1.06 ,   3.0 , 1.06),
                                   new Points( -1.5 ,   3.0 ,  0.0),
                                   new Points(-1.06 ,   3.0 ,-1.06),
                                   new Points(  0.0 ,   3.5 , -1.5), 
                                   new Points( 1.06 ,   3.5 ,-1.06),
                                   new Points(  1.5 ,   3.5 ,  0.0),
                                   new Points( 1.06 ,   3.5 , 1.06),
                                   new Points(  0.0 ,   3.5 ,  1.5),  /* 40 */
                                   new Points(-1.06 ,   3.5 , 1.06),
                                   new Points( -1.5 ,   3.5 ,  0.0),
                                   new Points(-1.06 ,   3.5 ,-1.06),
                                   new Points( -1.0 ,   3.5 ,  1.0), // Link 1 
                                   new Points( -1.0 ,   3.5 , -1.0),
                                   new Points(  1.0 ,   3.5 , -1.0),
                                   new Points(  1.0 ,   3.5 ,  1.0),
                                   new Points( -1.0 ,  12.5 ,  1.0),
                                   new Points( -1.0 ,  12.5 , -1.0),
                                   new Points(  1.0 ,  12.5 , -1.0),  /* 50 */
                                   new Points(  1.0 ,  12.5 ,  1.0),
                                   new Points(  1.0 ,  12.5 ,  0.5),
                                   new Points( -1.0 ,  12.5 ,  0.5),
                                   new Points( -0.5 ,  14.0 ,  1.0),
                                   new Points(  0.5 ,  14.0 ,  1.0),
                                   new Points(  0.5 ,  14.0 ,  0.5),
                                   new Points( -0.5 ,  14.0 ,  0.5),
                                   new Points(  1.0 ,  12.5 , -0.5),
                                   new Points( -1.0 ,  12.5 , -0.5),
                                   new Points( -0.5 ,  14.0 , -0.5),  /* 60 */
                                   new Points(  0.5 ,  14.0 , -0.5),
                                   new Points(  0.5 ,  14.0 , -1.0),
                                   new Points( -0.5 ,  14.0 , -1.0),
                                   new Points(  0.0 ,  13.5 ,  0.5), // Axis 2
                                   new Points(  0.0 ,  13.5 , -0.5),
                                   new Points( -0.3 ,  13.0 ,  0.5), // Link 2 
                                   new Points(  1.5 ,  13.0 ,  0.5),
                                   new Points(  1.5 ,  13.0 , -0.5),
                                   new Points( -0.3 ,  13.0 , -0.5),
                                   new Points( -0.3 ,  14.0 ,  0.5),  /* 70 */
                                   new Points(  1.5 ,  14.0 ,  0.5),
                                   new Points(  1.5 ,  14.0 , -0.5),
                                   new Points( -0.3 ,  14.0 , -0.5),
                                   new Points(  1.5 ,  12.5 ,  1.0),
                                   new Points(  1.5 ,  14.5 ,  1.0),
                                   new Points(  1.5 ,  14.5 , -1.0),
                                   new Points(  1.5 ,  12.5 , -1.0),
                                   new Points(  9.0 ,  12.5 ,  1.0),
                                   new Points(  9.0 ,  14.5 ,  1.0),
                                   new Points(  9.0 ,  14.5 , -1.0),  /* 80 */
                                   new Points(  9.0 ,  12.5 , -1.0),
                                   new Points(  9.0 ,  12.5 ,  0.5),
                                   new Points(  9.0 ,  14.5 ,  0.5),
                                   new Points( 10.5 ,  14.0 ,  1.0),
                                   new Points( 10.5 ,  14.0 ,  0.5),
                                   new Points( 10.5 ,  13.0 ,  0.5),
                                   new Points( 10.5 ,  13.0 ,  1.0),
                                   new Points(  9.0 ,  12.5 , -0.5),
                                   new Points(  9.0 ,  14.5 , -0.5),
                                   new Points( 10.5 ,  14.0 , -1.0),  /* 90 */
                                   new Points( 10.5 ,  13.0 , -1.0),
                                   new Points( 10.5 ,  13.0 , -0.5),
                                   new Points( 10.5 ,  14.0 , -0.5),
                                   new Points( 10.0 ,  13.5 ,  0.5), // Axis 3
                                   new Points( 10.0 ,  13.5 , -0.5),
                                   new Points(  9.5 ,  13.8 ,  0.5), // Link 3
                                   new Points(  9.5 ,  13.8 , -0.5),
                                   new Points( 10.5 ,  13.8 , -0.5),
                                   new Points( 10.5 ,  13.8 ,  0.5),
                                   new Points( 10.5 ,  11.9 , -0.5),  /* 100 */
                                   new Points( 10.5 ,  11.9 ,  0.5),
                                   new Points(  9.5 ,  11.9 ,  0.5),
                                   new Points(  9.5 ,  11.9 , -0.5),
                                   new Points(  9.0 ,  12.0 ,  1.0),
                                   new Points(  9.0 ,  12.0 , -1.0),
                                   new Points( 11.0 ,  12.0 , -1.0),
                                   new Points( 11.0 ,  12.0 ,  1.0),
                                   new Points( 11.0 ,   4.5 , -1.0),
                                   new Points( 11.0 ,   4.5 ,  1.0),
                                   new Points(  9.0 ,   4.5 ,  1.0),  /* 110 */
                                   new Points(  9.0 ,   4.5 , -1.0),
                                   new Points( 10.0 ,   5.0 ,  0.0), // Axis 4
                                   new Points( 10.0 ,   4.0 ,  0.0),
                                   new Points( 10.0 ,   3.5 ,  0.5), // Axis 5
                                   new Points( 10.0 ,   3.5 , -0.5),
                                   new Points( 10.0 ,   4.5 ,  1.0), //link 5
                 		   new Points( 10.7 ,   4.2 ,  1.0),
				   new Points( 11.0 ,   3.5 ,  1.0),
                                   new Points( 10.7 ,   2.8 ,  1.0),
                                   new Points( 10.0 ,   2.5 ,  1.0),  /* 120 */
                                   new Points(  9.3 ,   2.8 ,  1.0),
                                   new Points(  9.0 ,   3.5 ,  1.0),
                                   new Points(  9.3 ,   4.2 ,  1.0),
                                   new Points( 10.0 ,   4.5 , -1.0),
                                   new Points( 10.7 ,   4.2 , -1.0),
                                   new Points( 11.0 ,   3.5 , -1.0),
                                   new Points( 10.7 ,   2.8 , -1.0),
                                   new Points( 10.0 ,   2.5 , -1.0),
                                   new Points(  9.3 ,   2.8 , -1.0),
                                   new Points(  9.0 ,   3.5 , -1.0),  /* 130 */
                                   new Points(  9.3 ,   4.2 , -1.0),
                                   new Points( 10.0 ,   3.0 ,  0.0), //Axis 6 
                                   new Points( 10.0 ,   2.0 ,  0.0),
                                   new Points(  9.0 ,   2.5 ,  1.0), // Hand */
                                   new Points(  9.0 ,   2.5 , -1.0),
                                   new Points( 11.0 ,   2.5 , -1.0),
                                   new Points( 11.0 ,   2.5 ,  1.0),
                                   new Points( 11.0 ,   2.0 ,  1.0),
                                   new Points(  9.0 ,   2.0 ,  1.0),
                                   new Points(  9.0 ,   2.0 , -1.0),  /* 140 */
                                   new Points( 11.0 ,   2.0 , -1.0),
                                   new Points(  9.0 ,   2.0 ,  1.0),
                                   new Points(  9.0 ,   2.0 , -1.0),
                                   new Points(  9.5 ,   2.0 , -1.0),
                                   new Points(  9.5 ,   2.0 ,  1.0),
                                   new Points(  9.5 ,   0.5 ,  1.0),
                                   new Points(  9.5 ,   0.5 , -1.0),
                                   new Points( 11.0 ,   2.0 , -1.0),
                                   new Points( 11.0 ,   2.0 ,  1.0),
                                   new Points( 10.5 ,   2.0 ,  1.0),  /* 150 */
                                   new Points( 10.5 ,   2.0 , -1.0),
                                   new Points( 10.5 ,   0.5 , -1.0),
                                   new Points( 10.5 ,   0.5 ,  1.0)}; // 153  


           rob.PL = helpPL;		

	   Edges[] helpel = { new Edges(0, 3),
 		 new Edges( 0, 8),
                 new Edges( 8,11),
                 new Edges(11, 3),
                 new Edges( 1, 9),
                 new Edges( 2,10),
                 new Edges( 4, 5),
                 new Edges( 6, 7),
                 new Edges(12,13),   /* Base */
                 new Edges(13,14),
                 new Edges(14,15),    /*10*/
                 new Edges(15,16),
                 new Edges(16,17),
                 new Edges(17,18),
                 new Edges(18,19),
                 new Edges(19,12),
                 new Edges(20,21),
                 new Edges(21,22),
                 new Edges(22,23),
                 new Edges(23,24),
                 new Edges(24,25),   /*20*/
                 new Edges(25,26),
                 new Edges(26,27),
                 new Edges(27,20),
                 new Edges(12,20),
                 new Edges(13,21),
                 new Edges(14,22),
                 new Edges(15,23),
                 new Edges(16,24),
                 new Edges(17,25),
                 new Edges(18,26),  /*30*/
                 new Edges(19,27),
                 new Edges(28,29),    /* turn area */
                 new Edges(29,30),
                 new Edges(30,31),
                 new Edges(31,32),
                 new Edges(32,33),
                 new Edges(33,34),
                 new Edges(34,35),
                 new Edges(35,28),
                 new Edges(36,37),   /*40*/
                 new Edges(37,38),
                 new Edges(38,39),
                 new Edges(39,40),
                 new Edges(40,41),
                 new Edges(41,42),
                 new Edges(42,43),
                 new Edges(43,36),
                 new Edges(28,36),
                 new Edges(29,37),
                 new Edges(30,38),  /*50*/
                 new Edges(31,39),
                 new Edges(32,40),
                 new Edges(33,41),
                 new Edges(34,42),
                 new Edges(35,43),
                 new Edges(44,45),     /* Link 1 */  /*56*/
                 new Edges(45,46),
                 new Edges(46,47),
                 new Edges(47,44),
                 new Edges(44,48),
                 new Edges(45,49),
                 new Edges(46,50),  
                 new Edges(47,51),
                 new Edges(48,49),
                 new Edges(49,50),
                 new Edges(50,51),
                 new Edges(51,48),
                 new Edges(48,54),
                 new Edges(54,55),
                 new Edges(55,51),
                 new Edges(55,56),
                 new Edges(54,57),
                 new Edges(52,56),
                 new Edges(53,57),
                 new Edges(56,57),
                 new Edges(52,53),
                 new Edges(59,60),
                 new Edges(60,63),
                 new Edges(63,62),
                 new Edges(62,61),
                 new Edges(61,60),
                 new Edges(49,63),
                 new Edges(50,62),
                 new Edges(58,61),
                 new Edges(58,59),
                 new Edges(64,65),  /* Axis 2 */
                 new Edges(66,67),  /* Link 2 */
                 new Edges(66,69),
                 new Edges(66,70),
                 new Edges(70,73),
                 new Edges(70,71),
                 new Edges(71,72),
                 new Edges(71,67),
                 new Edges(67,68),
                 new Edges(68,69),
                 new Edges(68,72),
                 new Edges(72,73),
                 new Edges(74,77),
                 new Edges(74,75),
                 new Edges(75,76),
                 new Edges(76,77),
                 new Edges(77,81),
                 new Edges(81,80),
                 new Edges(80,79),
                 new Edges(79,78),
                 new Edges(78,81),
                 new Edges(74,78),
                 new Edges(75,79),
                 new Edges(76,80),
                 new Edges(79,84),
                 new Edges(84,85),
                 new Edges(85,86),
                 new Edges(86,87),
                 new Edges(87,84),
                 new Edges(83,85),
                 new Edges(83,82),
                 new Edges(82,86),
                 new Edges(78,87),
                 new Edges(88,89),
                 new Edges(88,92),
                 new Edges(92,91),
                 new Edges(92,93),
                 new Edges(93,89),
                 new Edges(93,90),
                 new Edges(90,80),
                 new Edges(90,91),
                 new Edges(81,91),
                 new Edges(94,95),  /* Axis 3 */
                 new Edges(96,97),  /* Link 3 */
                 new Edges(97,98),
                 new Edges(98,99),
                 new Edges(99,96),
                 new Edges(96,102),
                 new Edges(102,101),
                 new Edges(101,100),
                 new Edges(100,103),
                 new Edges(103,102),
                 new Edges(103,97),
                 new Edges(100,98),
                 new Edges(101,99),
                 new Edges(104,105),
                 new Edges(105,106),
                 new Edges(106,107),
                 new Edges(107,104),
                 new Edges(104,110),
                 new Edges(110,111),
                 new Edges(111,108),
                 new Edges(108,109),
                 new Edges(109,110),
                 new Edges(111,105),
                 new Edges(106,108),
                 new Edges(109,107),
                 new Edges(112,113),  /*Axis 4 */
                 new Edges(114,115),  /*Axis 5 */
                 new Edges(116,117),  /* link 5 */
                 new Edges(117,118),
                 new Edges(118,119),
                 new Edges(119,120),
                 new Edges(120,121),
                 new Edges(121,122),
                 new Edges(122,123),
                 new Edges(123,116),
                 new Edges(116,124),
                 new Edges(124,125),
                 new Edges(125,126),
                 new Edges(126,127),
                 new Edges(127,128),
                 new Edges(128,129),
                 new Edges(129,130),
                 new Edges(130,131),
                 new Edges(131,124),
                 new Edges(116,124),
                 new Edges(117,125),
                 new Edges(118,126),
                 new Edges(119,127),
                 new Edges(120,128),
                 new Edges(121,129),
                 new Edges(122,130),
                 new Edges(123,131),
                 new Edges(132,133),  /* Axis 6 */
                 new Edges(134,135),  /* Hand */
                 new Edges(135,136),
                 new Edges(136,137),
                 new Edges(137,134),
                 new Edges(134,139),
                 new Edges(139,140),
                 new Edges(140,141),
                 new Edges(141,138),
                 new Edges(138,139),
                 new Edges(140,135),
                 new Edges(141,136),
                 new Edges(138,137),
                 new Edges(142,143),
                 new Edges(143,144),
                 new Edges(144,145),
                 new Edges(145,142),
                 new Edges(142,146),
                 new Edges(146,145),
                 new Edges(146,147),
                 new Edges(147,144),
                 new Edges(147,143),
                 new Edges(150,151),
                 new Edges(151,148),
                 new Edges(148,149),
                 new Edges(149,150),
                 new Edges(150,153),
                 new Edges(153,149),
                 new Edges(153,152),
                 new Edges(152,148),
                 new Edges(152,151) }; 
	   
	   rob.el = helpel;

	   Areas[] helpal = { new Areas(0, 8, 11, 3),
 			      new Areas( 12 , 20 , 21 , 13 ), /* base */
                              new Areas( 13 , 21 , 22 , 14 ),
                              new Areas( 14 , 22 , 23 , 15 ),
                              new Areas( 15 , 23 , 24 , 16 ),
                              new Areas( 16 , 24 , 25 , 17 ),
                              new Areas( 17 , 25 , 26 , 18 ),
                              new Areas( 18 , 26 , 27 , 19 ),
                              new Areas( 19 , 27 , 20 , 12 ),
                              new Areas( 20 , 27 , 26 , 25 ),
                              new Areas( 25 , 24 , 21 , 20 ),   /* 10 */
                              new Areas( 21 , 24 , 23 , 22 ),
                              new Areas( 28 , 36 , 37 , 29 ), /* turn area */
                              new Areas( 29 , 37 , 38 , 30 ),
                              new Areas( 30 , 38 , 39 , 31 ),
                              new Areas( 31 , 39 , 40 , 32 ),
                              new Areas( 32 , 40 , 41 , 33 ),
                              new Areas( 33 , 41 , 42 , 34 ),
                              new Areas( 34 , 42 , 43 , 35 ),
                              new Areas( 35 , 43 , 36 , 28 ),
                              new Areas( 36 , 43 , 42 , 41 ),    /* 20 */
                              new Areas( 36 , 41 , 40 , 37 ),
                              new Areas( 37 , 40 , 39 , 38 ),
                              new Areas( 44 , 47 , 51 , 48 ), /* Link 1 */
                              new Areas( 47 , 46 , 50 , 51 ),
                              new Areas( 45 , 49 , 50 , 46 ),
                              new Areas( 44 , 48 , 49 , 45 ),
                              new Areas( 48 , 51 , 50 , 49 ),
                              new Areas( 48 , 51 , 55 , 54 ),// Holder 1 Link 1
                              new Areas( 51 , 52 , 56 , 55 ),
                              new Areas( 52 , 53 , 57 , 56 ),   /* 30 */
                              new Areas( 53 , 48 , 54 , 57 ),
                              new Areas( 54 , 55 , 56 , 57 ),
                              new Areas( 59 , 58 , 61 , 60 ), //Holder 2 Link1
                              new Areas( 58 , 50 , 62 , 61 ),
                              new Areas( 49 , 63 , 62 , 50 ),
                              new Areas( 49 , 59 , 60 , 63 ),
                              new Areas( 60 , 61 , 62 , 63 ),
                              new Areas( 66 , 67 , 71 , 70 ), //Holder 1 Link 2
                              new Areas( 70 , 71 , 72 , 73 ),
                              new Areas( 68 , 69 , 73 , 72 ), /* 40 */
                              new Areas( 66 , 69 , 68 , 67 ),
                              new Areas( 69 , 66 , 70 , 73 ),
                              new Areas( 74 , 78 , 79 , 75 ), /* Link 2 */
                              new Areas( 75 , 79 , 80 , 76 ),
                              new Areas( 77 , 76 , 80 , 81 ),
                              new Areas( 74 , 77 , 81 , 78 ),
                              new Areas( 77 , 74 , 75 , 76 ),
                              new Areas( 78 , 81 , 80 , 79 ),
                              new Areas( 78 , 87 , 84 , 79 ), //Holder 2 Link 2
                              new Areas( 78 , 82 , 86 , 87 ), /* 50 */
                              new Areas( 82 , 83 , 85 , 86 ),
                              new Areas( 83 , 79 , 84 , 85 ),
                              new Areas( 84 , 87 , 86 , 85 ),
                              new Areas( 89 , 88 , 92 , 93 ), //Holder 3 Link 2
                              new Areas( 88 , 81 , 91 , 92 ),
                              new Areas( 81 , 80 , 90 , 91 ),
                              new Areas( 80 , 89 , 93 , 90 ),
                              new Areas( 93 , 92 , 91 , 90 ),
                              new Areas(102 ,101 , 99 , 96 ), //Holder 1 Link 3
                              new Areas(101 ,100 , 98 , 99 ), /* 60 */
                              new Areas(103 , 97 , 98 ,100 ),
                              new Areas(103 ,102 , 96 , 97 ),
                              new Areas( 96 , 99 , 98 , 97 ),
                              new Areas(110 ,109 ,107 ,104 ), /* Link 3 */
                              new Areas(109 ,108 ,106 ,107 ),
                              new Areas(111 ,105 ,106 ,108 ),
                              new Areas(111 ,110 ,104 ,105 ),
                              new Areas(104 ,107 ,106 ,105 ),
                              new Areas(110 ,111 ,108 ,109 ),
                              new Areas(116 ,123 ,122 ,121 ), //link */ /* 70
                              new Areas(116 ,121 ,120 ,117 ),
                              new Areas(117 ,120 ,119 ,118 ),
                              new Areas(116 ,117 ,125 ,124 ),
                              new Areas(117 ,118 ,126 ,125 ),
                              new Areas(118 ,119 ,127 ,126 ),
                              new Areas(119 ,120 ,128 ,127 ),
                              new Areas(120 ,121 ,129 ,128 ),
                              new Areas(121 ,122 ,130 ,129 ),
                              new Areas(122 ,123 ,131 ,130 ),
                              new Areas(123 ,116 ,124 ,131 ), /* 80 */
                              new Areas(124 ,129 ,130 ,131 ),
                              new Areas(124 ,125 ,128 ,129 ),
                              new Areas(125 ,126 ,127 ,128 ),
                              new Areas(139 ,138 ,137 ,134 ),//Hand base area
                              new Areas(138 ,141 ,136 ,137 ),
                              new Areas(140 ,135 ,136 ,141 ),
                              new Areas(140 ,139 ,134 ,135 ),
                              new Areas(134 ,137 ,136 ,135 ),
                              new Areas(139 ,140 ,141 ,138 ),
                              new Areas(146 ,145 ,142 ,146 ),//Handtaker 1 90
                              new Areas(146 ,147 ,144 ,145 ),
                              new Areas(142 ,145 ,144 ,143 ),
                              new Areas(143 ,144 ,147 ,147 ),
                              new Areas(147 ,146 ,142 ,143 ),
                              new Areas(153 ,149 ,150 ,153 ),/*Handtaker 2 */
                              new Areas(153 ,152 ,148 ,149 ),
                              new Areas(151 ,148 ,152 ,152 ),
                              new Areas(152 ,153 ,150 ,151 ),
                              new Areas(150 ,149 ,148 ,151 ) }; 

	   rob.al = helpal;

	}
}

	
