/****************************************************************************/
/* File: ~/sopra/RoboPackII/Win.java                                        */
/* This file contains the 'Win'class. The 'Win'class is used to show the    */
/* about text or the help text in a window, if the program has been started */
/* from the Applet Viewer.                                                  */
/****************************************************************************/

package RoboPackII;

import java.io.*;
import java.awt.*;

public class Win extends java.awt.Frame 
{
        public static int HELP = 1, ABOUT = 2; 
        private String f_str;
        protected Button ok = new Button("O.K.");
        protected RoboProto father;
        private Label l;

        public Win(RoboProto rob, int type) 
        {
                super ("RoboSim Support");
                father = rob;
		if(type == HELP)
		  {
                    l = new Label("Help for RoboSim");
                    l.setFont(new Font("TimesRoman", Font.BOLD, 20));
                    f_str = "Texts/help.doc";
		  }
		else
		  {
                    l = new Label("About RoboSim");
                    l.setFont(new Font("TimesRoman", Font.BOLD, 20)); 
                    f_str = "Texts/about.doc";
                  }

	        File f = new File(f_str);
                int size = (int)f.length();
                FileInputStream filein;
                byte[] data = new byte[size];
                TextArea helptext = null;
                String  str = null;     
                int i = 0;
                try 
		  { 
		    filein = new FileInputStream(f);            
                    while (i<size)
                      {
                        i +=filein.read(data, i, size - i);
                      } // end while
                    str = new String(data  ,0);
                  }
                catch(IOException e)
		  {
		    str = "File not found."; 
		  }
                helptext = new TextArea(str, 24, 80);
                helptext.setEditable(false);
                add("North", l);
                add("Center", helptext);
                add("South", ok);
	  	this.pack();
		this.show();
        }

        public boolean action(Event e, Object o)
        {
                if ("O.K.".equals(o))
		  {
                    (this).hide();
		    this.dispose();
                    return(true);
		  }
                else 
		  {
		    return super.action(e, o);
		  }
        }
}
