/************************************************************************/
/* File: ~/sopra/RoboPackII/ErrorWindow.java                            */
/* This file consists of the "ErrorWIndow" class which shows an error   */
/* text in a seperate window.                                           */
/************************************************************************/

package RoboPackII;

import java.awt.*;
import java.io.*;
import java.applet.Applet;

class ErrorWindow extends Frame
{       
	/* This class needs as argument an error text and shows it in */
	/* a seperate window.					      */
	
	private Button quitButton = new Button("Quit");
	private Label textLabel = null;
	private RoboProto myRobot;

	ErrorWindow(String errorText, RoboProto rob)
	{ 
	   super("Error:");
	   myRobot = rob;
	   hide();
	   move(100, 200);
	   resize(400, 200);
	   
	   setLayout(new BorderLayout());
	   textLabel = new Label(errorText);
	   add("Center", textLabel);
	   Panel quitPanel = new Panel();
	   quitPanel.setLayout(new FlowLayout());// is necessary for the quit
	   quitPanel.add(quitButton);	// button to appear in "normal" size
	   add("South", quitPanel);
	   pack();
	   show();
	   myRobot.menuDisable();
	}

	public boolean action(Event e, Object o)
	{  
	   if (e.target == quitButton)
	      {
		this.hide(); 
		myRobot.menuEnable();
		myRobot.crashIsActive = false;
		this.dispose();
	 	return true;
	      }
	    // sonst:
	   return super.action(e, o);
	}
}
