/************************************************************************/
/* File: ~/sopra/RoboPackII/RoboProto.java                              */
/* This file consists of the main class which includes the user 	*/
/* interface and holds the specific values of the robot.		*/
/* The most important methods are also part of this file.		*/
/************************************************************************/

package RoboPackII;

import java.awt.*;
import java.io.RandomAccessFile;
import java.io.IOException;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;

public class RoboProto extends Applet
{    
        // Constants:
	private final double[][] realRobRestr =   // realRobotRestrictions
	  { {  -0.88, 0.9  },     //angle1
	    {  -2.38, -0.82},     //angle2
	    { -0.686, 0.406},	  //angle3      
	    {      0, 0    },     // useful dummy
	    { -0.698, 0.698} };	  //angle4      

	// Declaration of the graphics constants:
	public final static int numberOfPoints = 154;
	public final static int numberOfEdges = 211;
	public final static int numberOfAreas = 100;
		
	//Declaration of the variables specifying the robot:
	public AreasPointsList[] apl = new AreasPointsList[numberOfAreas];
	public Points light = null;
	public long[][] colorTable = new long[7][31];
	public double[] linkLengths = new double[4];
	public int[] angleWeights = new int[6]; 
	public int[] power = new int[6];
	public AngleDates[] angles = new AngleDates[6];
	public Points[] line = new Points[2];
	public Edges gkl = null;
	public int[] rpl = new int[14];
	public Points[] coorpl = new Points[4];
	public Edges coorc[] = new Edges[3];
	public Points[] pl = new Points[numberOfPoints];
	public Points[] PL = new Points[numberOfPoints];//vertices of the robot
	public Edges[] el = new Edges[numberOfEdges];   //edges of the robot
	public Areas[] al = new Areas[numberOfAreas];
	private boolean robotIsReal = false; // signifies whether the existing
					     // robot is simulated

	public double[] target = { 0, 0, 0 };// for the auto control

	// Some strange, but nevertheless needed variables:
	private int errorcode, reminder, steps, stepNumber;
	private double angleX, angleY, d, x, y, z, s_wx, h;
	private double[] input = new double[9];
	private double[] location = new double[3];
	private double[] pos = new double[3];
	private double[] angleNew = new double[6], angleOld = new double[6];
	private double[] hw = new double[6];
	private double[] wB = new double[6];
	private double[] wE = new double[6];
	private int n;
	private int indx = -1;
        public boolean crashIsActive = false;
	private double[] locationNew = new double[3];
	public Points[] BListe = new Points[361];
	public short f_Z_B = 0;
    	public short  f_Z_R = 0;
	public int akt = 0;
	public int errvariable = 0;
	public short fFile = 0;
	private double[][] T = new double[3][4];
	private Points p1 = new Points(), p2 = new Points();
	private int fAutoLine = 0;
	private double m, mdiff, distance;
	private boolean[] anglesLeftExtreme = { false, false, false, false,
					        false, false };
		// signifies whether the minimum of an angle had been reached

	// Variables for the saving and loading of positions:
	public double[][] savedAngles = new double[4][7];
	private Button[] storeButtons = { new Button("Def.Init "),
					  new Button("Def.Pos.1"),
					  new Button("Def.Pos.2"), 
					  new Button("Def.Pos.3") };
	private Button[] loadButtons = { new Button("Go Init"),
					 new Button("Go Pos.1"),
					 new Button("Go Pos.2"),
					 new Button("Go Pos.3") }; 
	
	// Declaration of the user interface variables:
	
	private Font headerFont = new Font("TimesRoman", Font.BOLD, 14);

	public Canvas roboCanvas = new Canvas();
	public final int canvasSize = 500; // as in the original program
	public ThreeD animation = new ThreeD(roboCanvas, this);
	  // the animation has to be started after the roboCanvas gets resized
	
	public int xControl = 25; //controls the speed
	private Scrollbar speedScroll = new Scrollbar(Scrollbar.HORIZONTAL, 
					 		xControl, 10, 1, 82); 
	   // 'speedScroll' represents 1 to 82
	public boolean megaSpeed = true;// if 'megaSpeed' is true, the double
					 // buffering is omitted
        public  float zoomValue = 1.5f; // should be between 0.1 and 3.5
	private final int zoomScrollScale = 100;
	private Scrollbar zoomScroll = new Scrollbar(Scrollbar.HORIZONTAL, 
			       (int)(zoomScrollScale * zoomValue), 10, 0, 350);
	  // 'zoomScrollScale' times the representing value 
         
 	private Panel belowP = new Panel();
	private Panel leftP = new Panel();
	private Panel rightP = new Panel();
	private Panel upP = new Panel();

	private Button exampleButton = new Button("Example");

	private Scrollbar[] manualScrolls = new Scrollbar[6]; 
	private Label[] manualLabels = new Label[6];
	private final int manualScrollScale = 30;
		// ... * 30, so that the control is more sensitive

	private Scrollbar[] linkScrolls = new Scrollbar[3];
	private Label[] linkLabels = new Label[3];
	private Label linkHeader = new Label("Linklengths:");
	private Button linkExec = new Button("e x e c u t e");
	private final double[] linkMax = { 15.0, 15.0, 15.0 };
	private final double[] linkMin = { 4.5, 2.5, 2.5 };
	private final int linkScrollScale = 30; 
	
	private Scrollbar[] autoScrolls = new Scrollbar[3];
	private Label[] autoLabels = new Label[3];
	private final int autoScrollScale = 20;
	private final int autoScrollRange = 50;
        private Label autoHeader = new Label("Inverse Kinematics:");
	private final String onLine = new String("Move on a straight line");
	private final String notOnLine = new String("Move on arbitrary way");
	private Choice lineButton = new Choice();
	private Button autoExecButton = new Button("e x e c u t e");

	private static ErrorWindow errWin = null;//the object instanciated in 
					  // 'writeError'
	private static Win helpWin = null; // the help / about text are shown
	private static Win aboutWin = null;// in these windows
	
	private Choice hand = new Choice();
	private Label handLabel = new Label("Hand");
	private Scrollbar handScroll = new Scrollbar(Scrollbar.HORIZONTAL, 
			                 0, 10, 0, 50);//represents 0 to 1
	private final int handScrollScale = 100;
	private double handValue = 0.0;// must be between 0.0 and 0.5
				// 0.5 is fully closed and 0.0 open
	private boolean showTheMove = true; // necessary for the "hand move"

	private CheckboxGroup whichRobotGroup = new CheckboxGroup();
	private Checkbox realRobot = new Checkbox("Real Robot", 
					whichRobotGroup, false);
	private Checkbox virtualRobot = new Checkbox("Virtual Robot", 
					whichRobotGroup, true);
	private Button fileButton = new Button("Open File");
	private final String teachStr = new String("Teach");
	private final String enterStr = new String("Enter");
	private Button teachButton = new Button(teachStr);
	private Button stopButton = new Button("Stop");
	private RandomAccessFile saveFile = null;
	private TextField[] weightsText = new TextField[6];
	private Button weightsExec = new Button("e x e c u t e");

	private Button helpButton = new Button("Help");
	private Button aboutButton = new Button("About");
        private String netscape = new String("netscape");
	 		
	public void init()    
	{
	   for (int i = 0; i < 6; i++)
	     manualLabels[i] = new Label("  ");
	   for (int i = 0; i < 3; i++)
	     {
	       linkLabels[i] = new Label("  ");
	       autoLabels[i] = new Label("  ");
	     }  // instanciation of the label-arrays
	   Label manualHeader = new Label("Forward Kinematics:");
	   manualHeader.setFont(headerFont);
	   linkHeader.setFont(headerFont);
	   autoHeader.setFont(headerFont);	

	   RobotInit.now(this); // the robot specific variables get its values
	   setLayout(new BorderLayout());

	   // Definition of the 'roboCanvas':
	   roboCanvas.resize(canvasSize, canvasSize);
	   roboCanvas.setBackground(new Color(200, 200, 200));// a nice gray
 	   add("Center", roboCanvas);

	   // Defintion of the 'upP'anel:
	   
	   upP.setLayout(new FlowLayout()); 
	   upP.add(helpButton);
	   Label title = new Label("RoboSim - A Robot Manipulator Simulator");
	   Font titleFont = new Font("TimesRoman", Font.ITALIC, 30);
	   title.setFont(titleFont);
	   upP.add(title);
	   upP.add(aboutButton);
	   add("North", upP);
	   	   
	   // Definition of the 'leftP'anel:

	   leftP.setLayout(new GridLayout(33, 1, 10, 1));
	   leftP.add(manualHeader);
	   for (int i = 0; i < 6; i++)
	     {
		manualScrolls[i] = new Scrollbar(Scrollbar.HORIZONTAL, 
			   (int)(manualScrollScale  * angles[i].act),
			   10 /* width */, 
			   (int)(manualScrollScale * angles[i].min), 
			   (int)(manualScrollScale * angles[i].max));
		manualScrolls[i].resize(100, 10);
		updateManualLabel(i);
		leftP.add(manualLabels[i]);
		leftP.add(manualScrolls[i]);
	   	leftP.add(new Label(""));
	     }
	   leftP.add(new Label(" ")); // Distance to the next entries
	   leftP.add(new Label(" ")); 
	   Label speedHeader = new Label("Speed:");
	   speedHeader.setFont(headerFont);
	   leftP.add(speedHeader);
	   leftP.add(new Label("slow           -->                fast"));
	   leftP.add(speedScroll); 
	   leftP.add(new Label(" ")); // Distance to the next entries
	   Label zoomHeader = new Label("Zoom:");
	   zoomHeader.setFont(headerFont);
	   leftP.add(zoomHeader);
	   leftP.add(new Label("out            -->                   in"));
	   leftP.add(zoomScroll);
  	   leftP.add(new Label(" "));
	   handLabel.setFont(headerFont);
	   leftP.add(handLabel);
	   leftP.add(new Label("open          -->                closed"));
	   leftP.add(handScroll);

	   add("West", leftP);  

	   // Definition of the 'rightP'anel:

	   rightP.setLayout(new GridLayout(27, 1, 10, 1));
	
	   rightP.add(autoHeader);
  	 
	   for (int i = 0; i < 3; i++)
	     {
		autoScrolls[i] = new Scrollbar(Scrollbar.HORIZONTAL, 
			   autoScrollScale * (int)target[i], 10 /* width */, 
 		           autoScrollScale * (-autoScrollRange), 
			   autoScrollScale * autoScrollRange);
		autoScrolls[i].resize(100, 10);
		updateAutoLabel(i);				
		rightP.add(autoLabels[i]);
		rightP.add(autoScrolls[i]);
		if (i != 2) 
		  rightP.add(new Label(""));
	     }
	   actualizeAutoPanel(); // to initialize the default values
	   lineButton.addItem(notOnLine);
	   lineButton.addItem(onLine);
	   rightP.add(lineButton);
	   rightP.add(autoExecButton);

	   rightP.add(new Label(""));
 	   rightP.add(linkHeader);
 	   for (int i = 0; i < 3; i++)
	     {
		linkScrolls[i] = new Scrollbar(Scrollbar.HORIZONTAL, 
			   (int)(linkScrollScale * linkLengths[i]), 
			   10 /* width */, 
			   (int)(linkScrollScale * linkMin[i]), 
			   (int)(linkScrollScale * linkMax[i]));
		linkScrolls[i].resize(100, 10);
		updateLinkLabel(i);				
		rightP.add(linkLabels[i]);
		rightP.add(linkScrolls[i]);
	        if (i != 2)
		  rightP.add(new Label(""));
	     }
	   rightP.add(linkExec);
	   rightP.add(new Label(" "));
	   rightP.add(fileButton); 
	   rightP.add(new Label(" "));
	   rightP.add(virtualRobot);
	   rightP.add(realRobot);  
	  
	 	  	 
	   add("East", rightP);	

	   // Definition of the 'belowP'anel:

	   belowP.setLayout(new GridLayout(2, 12));
	   Label weightHeader = new Label("Weights of:");
	   weightHeader.setFont(headerFont);
	   belowP.add(weightHeader); 
	   for (int i = 0; i < 6; i++)
	     belowP.add(new Label("Angle " + String.valueOf(i + 1)));
	   belowP.add(exampleButton);
	   for (int i = 1; i < 4; i++) // storeButton[0] should be irreversible
	     belowP.add(storeButtons[i]);	
	   belowP.add(teachButton);
	   belowP.add(weightsExec);
	   for (int i = 0; i < 6; i++)
	     {
	       weightsText[i] = new TextField(String.valueOf(angleWeights[i]));
	       belowP.add(weightsText[i]);
	     }
	   for (int i = 0; i < 4; i++)
	     belowP.add(loadButtons[i]);
	   stopButton.disable();
	   belowP.add(stopButton);
	   add("South", belowP);

	   // First robot calculations and first painting of the robot:

	   AllAboutMoving.copyPointList(PL, pl, this);
	   RefDouble refAngleX = new RefDouble(angleX);// reference paramaters
	   RefDouble refAngleY = new RefDouble(angleY);// are needed
	   RefDouble refD = new RefDouble(d);
	   AllAboutMoving.angleCalculation(0.0, 10.0, 26.0, refAngleY, 
				refAngleX, refD);
	   angleX = refAngleX.in; // the real variables get the new values
	   angleY = refAngleY.in;
	   d = refD.in;
	   location[0] = 0.0; // I don't know, why these initialisations are
	   location[1] = 10.0;// not in the init part of this program
	   location[2] = 26.0;
	   AllAboutMoving.Nvector(pl, al, apl, 0, this); 
	   animation.setScale(zoomValue);
	   animation.start(); // now the animation can be started, a new thread
			      // begins to work
	   CinematicCalculations.calculatePos(angles, pos, this);	 

	   repaint();
	}

	public void start()
	{ 
	   menuEnable();
	   repaint();
	
	   repaint();
	   repaint();// if java doesn't want to paint the robot
	   repaint();
	   repaint();
	} 

	public void stop()
	{
	  if (errWin != null)
	    errWin.dispose(); // tidies up the only window which can be open
	}
	

	public void repaint()
	{
	   animation.repaint();
	}

	public void menuEnable()
	{
	   // If another window, which has the panels disabled,is destroyed, 
	   // the panels should be enabled by using this method
	   if (!leftP.isEnabled()) 
	     leftP.enable();
 	   if (!rightP.isEnabled()) 
	     rightP.enable();
	   if (!belowP.isEnabled()) 
	     belowP.enable();
	   if (!upP.isEnabled()) 
	     upP.enable();
	   repaint();
	}

	public void menuDisable()
	{
	   upP.disable();
	   leftP.disable();
	   rightP.disable();
 	   belowP.disable();
	}

	private double roundTo2(double arg)
	{
	   return Math.floor(arg * 100) / 100;
	}

	private String formatTo5(double number)
	{
	   String result = new String(String.valueOf(number));
	   int length = result.length();
	
	   switch(length)
	     {
		case 4: return result + ")   ";
		case 3: return result + ")    ";
		case 2: return result + ")     ";
		case 1: return result + ")      ";
		default: return result + ")  ";
	     }
	}

	private void updateManualLabel(int no)
	{
	  if ((no >= 0) && (no < 6))
	    {
	      String blank = null; // behind the first number, a blank is
		    // necessary for angle no. 4 and 5 (they're too short)
	      if (no == 4 || no == 5)
	        blank = "  ";
	      else
	   	blank = "";
  	      manualLabels[no].setText(String.valueOf(
		        Math.round(angles[no].min * 180 / Math.PI)) + blank  
			+ "   Angle" + String.valueOf(no + 1) + " (" +
			formatTo5(Math.round(angles[no].act * 180 / Math.PI)) 
			+ "        " + String.valueOf(Math.round(
			angles[no].max * 180 / Math.PI)));
	   }
	} 

	private void updateLinkLabel(int no)
	{
	  if ((no >= 0) && (no < 3))
	    linkLabels[no].setText(String.valueOf(
			roundTo2(linkMin[no])) +
			"   Linklength" + String.valueOf(no + 1) + " (" +
			formatTo5(roundTo2(linkLengths[no])) + "      " +
			String.valueOf(roundTo2(linkMax[no])));
	}

	private void updateOldLinkLabel(int no, double actValue)
	// this method is called, if the linkLenth is changed, but the change
	// is not yet executed
	{
	  if ((no >= 0) && (no < 3))
	    linkLabels[no].setText(String.valueOf(
			roundTo2(linkMin[no])) +
			"   Linklength" + String.valueOf(no + 1) + " (" +
			formatTo5(roundTo2(actValue)) + "      " +
			String.valueOf(roundTo2(linkMax[no])));
	}

	private void updateAutoLabel(int no)
	{
	  if ((no >= 0) && (no < 3))
	    {
	      String[] labelHead = { new String("X-Value"), 
			new String("Y-Value"), new String("Z-Value") };
	      autoLabels[no].setText(String.valueOf(-autoScrollRange) + 
			"       " + labelHead[no] + " (" + 
			formatTo5(roundTo2(target[no]))
			+ "           " + String.valueOf(autoScrollRange));
	    }
	}

	private void updateScrolledAutoLabel(int no)
	// this method is called, if an auto scrollbar has been used, but the
	// robot hasn't yet moved to the new position, because the execute
	// button has to be pushed to make him do that
	{
	  if ((no >= 0) && (no < 3))
	    {
	      String[] labelHead = { new String("X-Value"), 
			new String("Y-Value"), new String("Z-Value") };
	      autoLabels[no].setText(String.valueOf(-autoScrollRange) + 
			"       " + labelHead[no] + " (" + 
			formatTo5(roundTo2(input[no]))
			+ "           " + String.valueOf(autoScrollRange));
	    }
	}

	public void writeError(String text)
	{
	    errWin = new ErrorWindow(text, this);
	}

	private void actualizeAutoPanel()
	{
	  CinematicCalculations.calculatePos(angles, pos, this);
	  for (int kl = 0; kl < 3; kl++)
	    {
	      target[kl] = pos[kl];
	      autoScrolls[kl].setValue(autoScrollScale * (int) target[kl]);
	      updateAutoLabel(kl);
	    }
	}

	public void manualInput(double newAngles[])
	// the read angle dates are interpreted
	{
	   if (robotIsReal)
	     {
	       newAngles[3] = 0.0;
	       newAngles[5] = 0.0;
	     }
	   if (! ((newAngles[0] == angles[0].act) &&
		  (newAngles[1] == angles[1].act) && 
		  (newAngles[2] == angles[2].act) &&
		  (newAngles[3] == angles[3].act) && 
		  (newAngles[4] == angles[4].act) &&
		  (newAngles[5] == angles[5].act)))
	     {
	       manualChange(newAngles);
	       for (int i = 0; i < 6; i++)
	         manualScrolls[i].setValue(manualScrollScale * 
	      					(int) angles[i].act); 
	     }
	}

	public void linkLengthInput(double newLength[])
	{
	   if (robotIsReal)
	     return;
	   linkLengthChange(newLength);
	   for (int j = 0; j < 3; j++)
	     { 
	       linkScrolls[j].setValue(linkScrollScale * (int) linkLengths[j]);
	       updateLinkLabel(j);
	     }	
	}

	private void linkLengthChange(double newLength[])
	{
	   int i;
	   double[] remindNewLengths = { newLength[0], newLength[1],
					 newLength[2] };
	   boolean link1NotChanged = false;

	   if ( newLength[0] < linkMin[0] || newLength[1] < linkMin[1] ||
                newLength[2] < linkMin[2] || newLength[0] > linkMax[0] ||
                newLength[1] > linkMax[1] || newLength[2] > linkMax[2] ||
		((newLength[0] == linkLengths[0]) &&  
		 (newLength[1] == linkLengths[1]) &&
		 (newLength[2] == linkLengths[2]))     )
	     return;  // at least one of the new lengths is wrong

	   if (newLength[0] == linkLengths[0])
	     link1NotChanged = true;
	   if ( fFile == 0 )
             {    // Test, if location of view has to be adjusted 
	       locationNew[0] = 0.0;
               locationNew[1] = 0.0;
               locationNew[2] = d;
               x = -angleX;
               y = -angleY;
               AllAboutMoving.calculateLocation(locationNew,y,x);
                  
                   
               x = location[1];
               y = newLength[0] + newLength[1] + newLength[2] + linkLengths[3] 
		   + 2.0;
               if ( x < y )
                 {
                   x = 0.0;
                   y = newLength[0] + newLength[1] + newLength[2] + 
	               linkLengths[3] + 2.0;
                   z = 0.0;
                    
                   x = Math.sqrt(locationNew[0] * locationNew[0] + 
		    	         locationNew[2] * locationNew[2]);
                   y = newLength[1] + newLength[2] + linkLengths[3] + 2.0;

                   s_wx = Math.sin(angleX);
                   z = s_wx * y ;

                   if ( z >= ( d-2.0) || x < y) 
                     {
		       writeError("This change isn't executable.");
		       for (int kl = 0; kl < 3; kl++)
			 {
			   linkScrolls[kl].setValue((int) linkLengths[kl]
							  * linkScrollScale);
			   updateLinkLabel(kl);
			 }
                       return;      
                     }
                 }


             }  // endif f_file == 0 
                  
            // the arms get changed:
           for ( i=0 ; i<6 ; i++ )  
	     {
               angleOld[i] = angles[i].act;
               angles[i].act = 0.0;
             }
	   for (i = 0; i < 3; i++)
	     {
               h = linkLengths[i];
               linkLengths[i] = newLength[i]; 
               newLength[i] = h - newLength[i];
	     }
	   for ( i=48 ; i<78 ; i++ )
	     PL[i].y = PL[i].y - newLength[0];
           for ( i=78 ; i<108 ; i++ ) 
	     {
	       PL[i].y = PL[i].y - newLength[0];
               PL[i].x = PL[i].x - newLength[1];
             }
           for ( i=108 ; i<numberOfPoints ; i++ ) 
	     {
               PL[i].y = PL[i].y - newLength[0] + newLength[2];
               PL[i].x = PL[i].x - newLength[1];
             }
           AllAboutMoving.copyPointList(PL, pl, this);    
           angleNew[0] = 0.0;
           angleNew[1] = -Math.PI/2;
           angleNew[2] = angleNew[1];
           angleNew[3] = 0.0;
           angleNew[4] = 0.0;
           angleNew[5] = 0.0;
           AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	   angleOld[1] = angleOld[1] + (Math.PI/2);
           angleOld[2] = angleOld[2] + (Math.PI/2);
	   // Creation of variables of primitive data type needed as 
	   // call-by-reference variables:
	   RefInt refError = new RefInt(errorcode);
	   RefDouble refAngleY = new RefDouble(angleY);
	   RefDouble refAngleX = new RefDouble(angleX);
	   RefDouble refD = new RefDouble(d);
	   RefInt refIndx = new RefInt(indx);
           AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, angles, 
			45,refError, refAngleY, refAngleX, refD,0, refIndx,
			location, this);
           errorcode = refError.in;
	   angleY = refAngleY.in;
	   angleX = refAngleX.in;
	   indx = refIndx.in;
	   d = refD.in;

	   if (showTheMove)
	     repaint();
	   for (int k = 0; k < 3; k++)
	     linkLengths[k] = remindNewLengths[k];
	
	   if (!link1NotChanged)
	     {
	       manualChange(0, angles[0].act + 0.1);
	       manualChange(0, angles[0].act - 0.1);
	       // The first change of 'linkLength1' is only
	       // executed, if angle 0 gets changed (I don't know why).
	       // Thus I make this angle change every time, 'linkLength1'
	       // gets changed.
	     }
	   for (int kl = 0; kl < 6; kl++)
	     {
	       updateManualLabel(kl);
	       manualScrolls[kl].setValue((int)angles[kl].act
					   * manualScrollScale);
	     }
	}

      private void errorDo()
        {
	   if (!crashIsActive)
	     writeError("This angle change would cause a crash.");
	   crashIsActive = true;
	   for (int i = 0; i < 6; i++)
	     {
	       updateManualLabel(i);
	       manualScrolls[i].setValue((int) (angles[i].act * 
						manualScrollScale));
	     }  
	}

      private boolean crashTest(double dummies[])
	{ // Tests, if a manual change would cause a crash with the floor

	  double[] position = new double[3];
	  AngleDates[] helper = new AngleDates[6];

	  for (int i = 0; i < 6; i++)
	    helper[i] = new AngleDates(angles[i].max, angles[i].min,
					 dummies[i]);
	  CinematicCalculations.calculatePos(helper, pos, this);
	  if (pos[1] <= 0)
	    {
	      if (!crashIsActive)
	        writeError("This angle change would cause a crash.");
	      crashIsActive = true;
	      return false;
	    }
	  return true;
	}
	
	  
	private void manualChange(double newValues[])
	{
	  reminder = 1;
	  for (int j = 0; j < 6; j++)
	    {
	      input[j] = 0;
              angleNew[j] = angles[j].act;
	    }
	  for (int j = 0; j < 6; j++)
	    {
	      if (newValues[j] >= angles[j].max)// Test,if newValue has got an
		{ 
	          newValues[j] = angles[j].max;   // allowed value
	          anglesLeftExtreme[j] = true;
	        }
	      else
 	        if (newValues[j] <= angles[j].min)
	          {
		    newValues[j] = angles[j].min;
		    anglesLeftExtreme[j] = true;
		  }
	    } 
	  if (!crashTest(newValues))
	    {
	       // Reparation of the robot:
	      for (int i=0 ; i<6 ; i++ )  
	        {
                  angleOld[i] = angles[i].act;
                  angles[i].act = 0.0;
                }
	      AllAboutMoving.copyPointList(PL, pl, this);    
              angleNew[0] = 0.0;
              angleNew[1] = -Math.PI/2;
              angleNew[2] = angleNew[1];
              angleNew[3] = 0.0;
              angleNew[4] = 0.0;
              angleNew[5] = 0.0;
              AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	      angleOld[1] = angleOld[1] + (Math.PI/2);
              angleOld[2] = angleOld[2] + (Math.PI/2);
	      // Creation of variables of primitive data type needed as 
	      // call-by-reference variables:
	      RefInt refError = new RefInt(errorcode);
	      RefDouble refAngleY = new RefDouble(angleY);
	      RefDouble refAngleX = new RefDouble(angleX);
	      RefDouble refD = new RefDouble(d);
	      RefInt refIndx = new RefInt(indx);
              AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, 
			angles,	15,refError, refAngleY, refAngleX, refD, 0, 
		        refIndx, location, this);
              errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      indx = refIndx.in;
	      d = refD.in;
	      for (int i = 0; i < 6; i++)
	        manualScrolls[i].setValue((int)(manualScrollScale * 
						angles[i].act));
	      crashIsActive = false;
	      return; // this change would cause a bad crash
	    }
	  // input is the difference between the old and the new
	  // angle 
	  for (int j = 0; j < 6; j++)
	    {
	      input[j] = newValues[j] - angles[j].act;
	      angleNew[j] = angles[j].act + input[j];
	    }
	  RefInt refN = new RefInt(n);        // copies of the variables
	  RefInt refSteps = new RefInt(steps);// which are objects
	  AllAboutMoving.calculateAngle(input, wB, wE, refN, 
				refSteps, this);
	  n = refN.in;
	  steps = refSteps.in;
	  // reference variables for the following MoveRobo-
	  // methods exactly representing the primitive data-
	  // type variables:
	  RefInt refError = new RefInt(errorcode);
	  RefDouble refAngleY = new RefDouble(angleY);
	  RefDouble refAngleX = new RefDouble(angleX);
	  RefDouble refD = new RefDouble(d);
	  RefInt refIndx = new RefInt(indx);
	  for (int j = 1; j < n + 1; j++)
	    {
	      for (int k = 0; k < 6; k++)
	      hw[k] = wB[k] * j;
	      AllAboutMoving.MoveRobo(showTheMove, pl, line, hw, angles, 1,
				refError, refAngleY, refAngleX, refD, 1, 
				refIndx, location, this);
			  
	      if (refError.in == 1)
		{
		  errorDo();
	          break;
		}  
	      errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      d = refD.in;
	      indx = refIndx.in;
	    }	

	  if ( errorcode != 1)
            {
              AllAboutMoving.MoveRobo (showTheMove, pl, line, wE, angles, 
				 steps,refError, refAngleY, refAngleX, refD, 
				 1, refIndx, location, this);
	      errorcode = refError.in;
                  
              if ( errorcode != 1 )
                { 
                  for (int j = n; j > 0; j-- )
                    {
                      for (int k = 0; k < 6; k++ )
		        hw[k] = wB[k] * j;
  
                      AllAboutMoving.MoveRobo(showTheMove, pl, line, hw, 
					angles, 1, refError, refAngleY, 
					refAngleX, 
					refD, 1, refIndx, location, this);
		      errorcode = refError.in;
                      if ( errorcode == 1 ) 
			{
			  errorDo();
		          break;
			}  
                    }
                }
	      else errorDo();
            }
	  else errorDo();
	  CinematicCalculations.calculatePos(angles, pos, this);
		
	  double oldValueReminder ;
	  for (int j = 0; j < 6; j++)     
	    {    
	      oldValueReminder = angles[j].act;
	      angles[j].act = newValues[j]; // now the variable holds the
				            // new value 
	      if ((oldValueReminder != angles[j].act) || (!showTheMove))
	        updateManualLabel(j);
	    }
	  if (anglesLeftExtreme[0] || anglesLeftExtreme[1] ||
	      anglesLeftExtreme[2] || anglesLeftExtreme[3] ||
	      anglesLeftExtreme[4] || anglesLeftExtreme[5] ||
	      (angles[2].act > 0.4) || 
 	      ((angles[0].act != 0) && (angles[2].act != 0))|| 
	      ((angles[0].act == 0) && (angles[1].act == 0) &&  
	       (angles[2].act == 0) && (angles[3].act == 0) && 
	       (angles[4].act == 0) && (angles[5].act == 0)))
	    { // the robot is crooked and thus is repaired
	      for (int i=0 ; i<6 ; i++ )  
	        {
                  angleOld[i] = angles[i].act;
                  angles[i].act = 0.0;
                }
	      AllAboutMoving.copyPointList(PL, pl, this);    
              angleNew[0] = 0.0;
              angleNew[1] = -Math.PI/2;
              angleNew[2] = angleNew[1];
              angleNew[3] = 0.0;
              angleNew[4] = 0.0;
              angleNew[5] = 0.0;
              AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	      angleOld[1] = angleOld[1] + (Math.PI/2);
              angleOld[2] = angleOld[2] + (Math.PI/2);
	      // Creation of variables of primitive data type needed as 
	      // call-by-reference variables:
	      refError = new RefInt(errorcode);
	      refAngleY = new RefDouble(angleY);
	      refAngleX = new RefDouble(angleX);
	      refD = new RefDouble(d);
	      refIndx = new RefInt(indx);
	      int stepss;
	      if ((angles[0].act == 0) && (angles[1].act == 0) &&  
	       (angles[2].act == 0) && (angles[3].act == 0) && 
	       (angles[4].act == 0) && (angles[5].act == 0))
		stepss = 80;
	      else stepss = 8;
              AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, 
			angles,	stepss, refError, refAngleY, refAngleX, refD, 0, 
		        refIndx, location, this);
              errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      indx = refIndx.in;
	      d = refD.in; 
	      for (int i = 0; i < 6; i++)
	        {
		  updateManualLabel(i);
		  manualScrolls[i].setValue((int)
					(manualScrollScale * angles[i].act));
	 	}
	    } 
	  if (showTheMove)
	    { 
	      repaint();
	      // to unify the values of 'auto' and 'manual control':
	      actualizeAutoPanel();// which are equal if the move isn't shown
	    }
	}

	private void manualChange(int no, double newValue)
	{
	  if (newValue >= angles[no].max)   // Test, if newValue has got an 
	    newValue = angles[no].max;      // allowed value
 	  if (newValue <= angles[no].min)
	    {
	      newValue = angles[no].min;
	      anglesLeftExtreme[no] = true;
	    }
	  if (newValue == angles[no].act)
	    return;

	  
	  reminder = 1;
	  for (int j = 0; j < 6; j++)
	    {
	      input[j] = 0;
              angleNew[j] = angles[j].act;
	    }
	  // input is the difference between the old and the new
	  // angle 
	  input[no] = newValue - angles[no].act;
	  angleNew[no] = angles[no].act + input[no];

	  if (!crashTest(angleNew))
	    {
	      // Reparation of the robot:
	      for (int i=0 ; i<6 ; i++ )  
	        {
                  angleOld[i] = angles[i].act;
                  angles[i].act = 0.0;
                }
	      AllAboutMoving.copyPointList(PL, pl, this);    
	      angleNew[0] = 0.0;
              angleNew[1] = -Math.PI/2;
              angleNew[2] = angleNew[1];
              angleNew[3] = 0.0;
              angleNew[4] = 0.0;
              angleNew[5] = 0.0;
              AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	      angleOld[1] = angleOld[1] + (Math.PI/2);
              angleOld[2] = angleOld[2] + (Math.PI/2);
	      // Creation of variables of primitive data type needed as 
	      // call-by-reference variables:
	      RefInt refError = new RefInt(errorcode);
	      RefDouble refAngleY = new RefDouble(angleY);
	      RefDouble refAngleX = new RefDouble(angleX);
	      RefDouble refD = new RefDouble(d);
	      RefInt refIndx = new RefInt(indx);
              AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, 
			angles,	15,refError, refAngleY, refAngleX, refD, 0, 
		        refIndx, location, this);
              errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      indx = refIndx.in;
	      d = refD.in;
	      manualScrolls[no].setValue((int)(manualScrollScale * 
						angles[no].act));  
	      updateManualLabel(no);
	      return;// this change is forbidden
	    }

	  RefInt refN = new RefInt(n);        // copies of the variables
	  RefInt refSteps = new RefInt(steps);// which are objects
	  AllAboutMoving.calculateAngle(input, wB, wE, refN, 
				refSteps, this);
	  n = refN.in;
	  steps = refSteps.in;
	  // reference variables for the following MoveRobo-
	  // methods exactly representing the primitive data-
	  // type variables:
	  RefInt refError = new RefInt(errorcode);
	  RefDouble refAngleY = new RefDouble(angleY);
	  RefDouble refAngleX = new RefDouble(angleX);
	  RefDouble refD = new RefDouble(d);
	  RefInt refIndx = new RefInt(indx);
	  for (int j = 1; j < n + 1; j++)
	    {
	      for (int k = 0; k < 6; k++)
	      hw[k] = wB[k] * j;
	      AllAboutMoving.MoveRobo(showTheMove, pl, line, hw, angles, 1,
				refError, refAngleY, refAngleX, refD, 1, 
				refIndx, location, this);
			  
	      if (refError.in == 1)
		{
		  errorDo();
	          break;
		}  
	      errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      d = refD.in;
	      indx = refIndx.in;
	    }	

	  if ( errorcode != 1)
            {
              AllAboutMoving.MoveRobo(showTheMove, pl, line, wE, angles, steps,
				 refError, refAngleY, refAngleX, refD, 1, 
				 refIndx, location, this);
	      errorcode = refError.in;
                  
              if ( errorcode != 1 )
                { 
                  for (int j = n; j > 0; j-- )
                    {
                      for (int k = 0; k < 6; k++ )
		        hw[k] = wB[k] * j;
  
                      AllAboutMoving.MoveRobo(showTheMove,pl, line, hw, angles,
					1, refError, refAngleY, refAngleX, 
					refD, 1, refIndx, location, this);
		      errorcode = refError.in;
                      if ( errorcode == 1 ) 
			{
			  errorDo();
		          break;
			}  
                    }
                } 
	      else errorDo();
            }
	  else errorDo();
	  CinematicCalculations.calculatePos(angles, pos, this);
		
	  angles[no].act = newValue; // now the variable holds the
				     // new value 
	  updateManualLabel(no);
	  if (anglesLeftExtreme[no] || (angles[2].act > 0.4))
	    {// the robot is crooked and thus is going to be repaired
	      for (int i=0 ; i<6 ; i++ )  
	        {
                  angleOld[i] = angles[i].act;
                  angles[i].act = 0.0;
                }
	      AllAboutMoving.copyPointList(PL, pl, this);    
              angleNew[0] = 0.0;
              angleNew[1] = -Math.PI/2;
              angleNew[2] = angleNew[1];
              angleNew[3] = 0.0;
              angleNew[4] = 0.0;
              angleNew[5] = 0.0;
              AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	      angleOld[1] = angleOld[1] + (Math.PI/2);
              angleOld[2] = angleOld[2] + (Math.PI/2);
	      // Creation of variables of primitive data type needed as 
	      // call-by-reference variables:
	      refError = new RefInt(errorcode);
	      refAngleY = new RefDouble(angleY);
	      refAngleX = new RefDouble(angleX);
	      refD = new RefDouble(d);
	      refIndx = new RefInt(indx);
              AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, 
			angles,	8,refError, refAngleY, refAngleX, refD, 0, 
		        refIndx, location, this);
              errorcode = refError.in;
	      angleY = refAngleY.in;
	      angleX = refAngleX.in;
	      indx = refIndx.in;
	      d = refD.in;
	      for (int i = 0; i < 6; i++)
	        {
		  updateManualLabel(i);
		  manualScrolls[i].setValue((int)
					(manualScrollScale * angles[i].act));
	 	}
	    } 
	  if (showTheMove)
	    {
	      repaint();
	      // to unify the values of 'auto' and 'manual control':
	      actualizeAutoPanel();// which are equal if the move isn't shown
	    }
	}
  
	public void autoInput(double input[])
	{
	  autoChange(input);
	  actualizeAutoPanel();
	}

	private void autoChange(double input[])
	{
	  int i, j;
	  if ( input[0] != 0.0 || input[1] != 0.0 || input[2] != 0.0 )
            {
              line[0].x = input[0];
              line[0].y = input[1];
              line[0].z = input[2];


              CinematicCalculations.TO6(angles, linkLengths, T);

              line[1].x = linkLengths[3] * T[0][2] + T[0][3];
              line[1].y = linkLengths[3] * T[2][2] + T[2][3] + linkLengths[0];
              line[1].z = -(linkLengths[3] * T[1][2] + T[1][3]);
              p1.x = T[0][3];
              p1.y = T[1][3];
              p1.z = T[2][3];
              T[0][3] = input[0];
              T[1][3] = -input[2];
              T[2][3] = input[1] - linkLengths[0];
               
              T[0][3] = T[0][3] - T[0][2] * linkLengths[3];
              T[1][3] = T[1][3] - T[1][2] * linkLengths[3];
              T[2][3] = T[2][3] - T[2][2] * linkLengths[3];

              if (fAutoLine == 1) 
                {
                  reminder = CinematicCalculations.inverseCinematic(T, input, 
			angles,	linkLengths, reminder, fAutoLine, this );

                  for ( i=0 ; i<6 ; i++ )
                    {
                      input[i] = input[i] - angles[i].act ;
                    }               
                  if ( reminder == 0 )
                    {
                      line[1].x = line[0].x;
                      line[1].y = line[0].y;
                      line[1].z = line[0].z;
                      line[0].y = -1.0;       
            
                      // Execution of the movement with acceleration
		      RefInt refN = new RefInt(n);
		      RefInt refSteps = new RefInt(steps);
                      AllAboutMoving.calculateAngle(input, wB, wE, refN, 
						    refSteps, this);
		      n = refN.in;
		      steps = refSteps.in;
                  
                      for ( i=1; i<n+1; i++ )
                        {
                          for ( j=0; j<6; j++ ) 
		            hw[j] = wB[j] * i;

			  RefInt refError = new RefInt(errorcode);
			  RefDouble refangleY = new RefDouble(angleY);
			  RefDouble refangleX = new RefDouble(angleX);
			  RefDouble refD = new RefDouble(d);	
			  RefInt refindx = new RefInt(indx);
                          AllAboutMoving.MoveRobo(showTheMove, pl,line,hw,
			   angles,1, refError, refangleY, refangleX, refD,1,
			   refindx, location, this);
			  errorcode = refError.in;
			  angleX = refangleX.in;
			  angleY = refangleY.in;
			  d = refD.in;
			  indx = refindx.in;

                          if ( errorcode == 1 )
			    {
			      actualizeAutoPanel();
			      return;
			    }
                        }    
    
                      if ( errorcode != 1)
                        { 
			  RefInt refError = new RefInt(errorcode);
			  RefDouble refangleY = new RefDouble(angleY);
			  RefDouble refangleX = new RefDouble(angleX);
			  RefDouble refD = new RefDouble(d);	
			  RefInt refindx = new RefInt(indx);
                          AllAboutMoving.MoveRobo (showTheMove, pl,line, wE,
				 angles,
				 steps, refError, refangleY, refangleX, refD,
			         1, refindx, location, this);
			  errorcode = refError.in;
			  angleX = refangleX.in;
			  angleY = refangleY.in;
			  d = refD.in;
			  indx = refindx.in;

                  
                          if (errorcode != 1 )
                            { 
                              for ( i=n; i>0; i-- )
                                {
                                  for ( j=0; j<6; j++ ) 
			            hw[j] = wB[j] * i;

  			          refError.in = errorcode;
			          refangleY.in = angleY;
			          refangleX.in = angleX;
			          refD.in = d;	
			          refindx.in = indx;
                     	          AllAboutMoving.MoveRobo(showTheMove, pl,
				    line, hw, angles,1, refError, refangleY,
				    refangleX,refD,1, refindx, 
				    location, this );
				  errorcode = refError.in;
				  angleY = refangleY.in;
				  angleX = refangleX.in;
				  d = refD.in;
				  indx = refindx.in;

                                  if (errorcode == 1 ) 
			            { 
				      actualizeAutoPanel();
				      return;
				    }
                                }
                            }  
                        }

                      if (errorcode == 1) 
		        { 
		          writeError("Crash.");
		        }
                    } 
                  else 
		    {  
		      if ( fFile == 0 )
		        {
			  writeError("Target is unreachable.");
			}
                    }

                }
              else /* if (fAutoline == 1).. */
                { 
                  p2.x = T[0][3];
                  p2.y = T[1][3];
                  p2.z = T[2][3];
                  distance = Math.sqrt( (p2.x - p1.x) * (p2.x - p1.x) + 
				        (p2.y - p1.y) * (p2.y - p1.y) +
					(p2.z - p1.z) * (p2.z - p1.z)  );
             
                  steps =(int)(distance / 0.5);
                  if ( steps == 0 ) 
		    steps = 1;
                  mdiff = 1.0 / steps;
                  m = mdiff;

                  while ( m <= 1.0 )
                    {
                      T[0][3] = p1.x + m * (p2.x - p1.x);
                      T[1][3] = p1.y + m * (p2.y - p1.y);
                      T[2][3] = p1.z + m * (p2.z - p1.z);
                      reminder = CinematicCalculations.inverseCinematic(T,
				input, angles, linkLengths, reminder,
				fAutoLine, this);
                   
                      if ( reminder == 0 )
                        {
                          for ( i=0 ; i<6 ; i++ )
                            {
                              input[i] = input[i] - angles[i].act;
                              if (Math.abs(input[i]) > 0.087266462 && m < 1.0)
			        reminder = 1;
                 	      if ( Math.abs(input[i]) > Math.PI ) 
			        { 
			          reminder = 2;
				  actualizeAutoPanel();
				  return;
                                } 
                            }
                          if ( reminder == 1 ) 
			    {
                              mdiff = mdiff / 2.0;
                              m = m - mdiff;
                            }
                          else 
                            {
			      if ( reminder == 0 )
                                {
                                  stepNumber = Math.abs((int)(input[0] / 
				          	(power[0]*(Math.PI/180))));
                 	          for ( i=1 ; i<6 ; i++ )
                 	            {
                  	              reminder = Math.abs((int)(input[i] / 
				            	(power[i]*(Math.PI/180))));
                     		      if (reminder >stepNumber)
				        stepNumber = reminder;
                  	            } 
                   	          line[0].y = -1.0; 

  			          RefInt refError = new RefInt(errorcode);
			          RefDouble refangleY = new RefDouble(angleY);
			          RefDouble refangleX = new RefDouble(angleX);
			          RefDouble refD = new RefDouble(d);	
			          RefInt refindx = new RefInt(indx);
                     	          AllAboutMoving.MoveRobo(showTheMove, pl, 
				     line, input, 
				     angles,stepNumber, refError,refangleY,
			             refangleX, refD,1,refindx,location, this);
				  errorcode = refError.in;
				  angleY = refangleY.in;
				  angleX = refangleX.in;
				  d = refD.in;
				  indx = refindx.in;
				
                                  if ( errorcode == 1 ) 
			            {
				      if ( fFile == 0 )
					{
					 //writeError("Crash!!");
                                        }
                                      m = 2.0;
                                    }
                                  mdiff = 1.0 / steps;
                                  if ( m < 1.0 && (m + mdiff) > 1.0 ) 
				    m = 1.0;
                  	          else m = m + mdiff;
                                }
                              else 
			        {
                                  if ( fFile == 0 )
				    {
				      writeError("Target is unreachable.");
				    }
                                  // here sounds the bell in the original
                                  m = 2.0;
                                }    
                            } 
		 	}   
                      else 
		        {
		          if ( fFile == 0 )
                             {
			       writeError("Target is unreachable.");	
			     }
                           m = 2.0;
                        } 
                   }
               }
             CinematicCalculations.calculatePos(angles, pos, this);
	     for (int kl = 0; kl < 3; kl++)
	       {
		 target[kl] = pos[kl];
		 autoScrolls[kl].setValue(autoScrollScale * (int) target[kl]);
	       } 
	     for (int kl = 0; kl < 6; kl++)
	       { // to unify the values of 'auto control' and 'manual control'
		 manualScrolls[kl].setValue(manualScrollScale * 
						     (int) angles[kl].act);
		 updateManualLabel(kl);
	       } 	
             line[0].y = -2.0;
           }  
         else 
	   {
	     if ( fFile == 0 )
                {
		  writeError("Target is unreachable.");
	        } 
           } 
         line[0].y = -1.0;  
         repaint();        
        } 
   
	public void weightsInput(int newValues[])
	{
	  for (int i = 0; i < 6; i++)
	    {
	      angleWeights[i] = newValues[i];
	      weightsText[i].setText(String.valueOf(angleWeights[i]));
	    }
	}      

	private void installRealRobot()
	{
	  manualLabels[3].hide();
	  manualScrolls[3].hide();
	  manualChange(3, 0);
	  manualLabels[5].hide();
	  manualScrolls[5].hide();
	  manualChange(5, 0);
	  linkHeader.hide();
	  linkExec.hide();
	  for (int i = 0; i < 3; i++)
	    {
	      linkLabels[i].hide();
	      linkScrolls[i].hide();
	      autoHeader.hide();
	      autoScrolls[i].hide();
	      autoLabels[i].hide();
	      lineButton.hide();
	      autoExecButton.hide();
	    }
	  double[] newLengths = { 4.5, 10.0, 10.0 };
	  linkLengthChange(newLengths); // these are the lengths of 
					// the robot
	  for (int i = 0; i < 3; i++)
	    {
	      linkScrolls[i].setValue((int)(linkScrollScale * 
					linkLengths[i]));
	      updateLinkLabel(i);
	    }
	  int actualSpeed = xControl;//to make the installation faster
	  speedInput(80);
	  manualChange(1, -1.57);// -90 degree
	  manualScrolls[1].setValue((int)(manualScrollScale * 
						angles[1].act));
	  manualChange(2, 0); //start position of the real robot
 	  manualScrolls[2].setValue((int)(manualScrollScale * 
						angles[2].act));
	  manualChange(0, 0); //start position of the real robot
	  manualScrolls[0].setValue((int)(manualScrollScale * 
						angles[0].act));
	  manualChange(4, 0); //start position of the real robot
	  manualScrolls[4].setValue((int)(manualScrollScale * 
						angles[4].act));
	  speedInput(actualSpeed);
	  savedAngles[0][1] = -1.57;//90 degree
	  exampleButton.disable();
	  robotIsReal = true;
	}

	private void tidyUpRealRobot()
	{
	  robotIsReal = false;
	  manualLabels[3].show();
	  manualScrolls[3].show();
	  manualLabels[5].show();
	  manualScrolls[5].show();
	  linkHeader.show();
	  linkExec.show();
	  for (int i = 0; i < 3; i++)
	    {
	      linkLabels[i].show();
	      linkScrolls[i].show();
	      autoHeader.show();
	      autoScrolls[i].show();
	      autoLabels[i].show();
	      lineButton.show();
	      autoExecButton.show();
	    }
 	  savedAngles[0][1] =  0;
	  double[] nullAngles = { 0, -Math.PI/2, 0, 0, 0, 0 };
	  manualChange(nullAngles);
	  double[] newLengths = { 13.5, 10.0, 10.0 };
	  linkLengthChange(newLengths); // these are the lengths of 
					// the robot
	  for (int i = 0; i < 3; i++)
	    {
	      linkScrolls[i].setValue((int)(linkScrollScale * 
					linkLengths[i]));
	      updateLinkLabel(i);
	    }
	  nullAngles[1] = 0;
	  manualChange(nullAngles);
	  for (int i = 0; i < 6; i++)
	    manualScrolls[i].setValue((int)(manualScrollScale * 
						angles[i].act));
	  exampleButton.enable();
	}

	private void saveActualPosition(int where)
	{
	   for (int i = 0; i < 6; i++)
	     savedAngles[where][i] = angles[i].act;
	   savedAngles[where][6] = handValue;
	}

	private void loadPositionNo(int which)
	{
	  for (int i = 0; i < 6; i++)
	    if ( (angles[i].act != savedAngles[which][i]) && robotIsReal
		 && (i == 3 || i == 5) )
	      savedAngles[which][i] = 0;
	  manualChange(savedAngles[which]);
	  handInput(savedAngles[which][6]);
	  for (int kl = 0; kl < 6; kl++)
	     {
	       updateManualLabel(kl);
	       manualScrolls[kl].setValue((int)angles[kl].act
					   * manualScrollScale);
	     } // it doesn't care, if too many labels are new printed
	}

	private void newSpeed()
	{ // calculation of the speeds corresponding to every angle
	  int trSpeed;

	  if (xControl > 60)
	    trSpeed = xControl * 20; // the turbo works
	  else
	    trSpeed = xControl/3;
	  power[0] = power[1] = 1 + (trSpeed/2);
	  power[2] = 2 + (trSpeed/2);
	  power[3] = power[4] = power[5] = 3 + (trSpeed/2);
	}

	public void speedInput(int newSpeed)
	{
	  if (newSpeed < 1)
	    newSpeed = 1;
	  if (newSpeed > 82)
	    newSpeed = 82;
	  xControl = newSpeed;
	  speedScroll.setValue(xControl);
	  newSpeed();
	}

	public void zoomInput(float newValue)
	{
	  if (newValue == zoomValue)
	    return;
	  if (newValue < 0.1)
	    newValue = 0.1f;
	  if (newValue > 3.5)
	    newValue = 3.5f;
	  if (Math.abs(newValue - zoomValue) < 0.2)
	    {
	      zoomValue = newValue;
	      zoomScroll.setValue((int) (zoomScrollScale * zoomValue));
	      animation.setScale(zoomValue);
	      if (showTheMove)
	        repaint();
	    }
	  else
	    { // a smooth movement of the robot's size increase/decrease
	      if (newValue > zoomValue)
		{
		  while (zoomValue < (newValue - 0.1))
		    {
		      zoomValue += 0.1;
		      zoomScroll.setValue((int) (zoomScrollScale * zoomValue));
 		      animation.setScale(zoomValue);
 		      if (showTheMove)
	                repaint();
		    }		
	        }
	      else 
		{
	          while (zoomValue > (newValue + 0.1))
		    {
		      zoomValue -= 0.1;
		      zoomScroll.setValue((int) (zoomScrollScale * zoomValue));
 		      animation.setScale(zoomValue);
 		      if (showTheMove)
	                repaint();
		    }
	        }
	      zoomValue = newValue;
	      zoomScroll.setValue((int) (zoomScrollScale * zoomValue));
	      animation.setScale(zoomValue);
	      if (showTheMove)
	        repaint();
	    }
	}
	   
	public void handInput(double newValue)
	{
	  handChange(newValue);
	  handScroll.setValue((int) (handScrollScale * handValue));
	  if ((angles[0].act != 0.0) && (angles[2].act != 0.0))
	    {
	      double[] remindLengths = { linkLengths[0], 
				 linkLengths[1] + 0.1, linkLengths[2] };
	      linkLengthChange(remindLengths); // stupid, but 
	      remindLengths[1] -= 0.1;	     // otherwise an
	      linkLengthChange(remindLengths); // error occurs
	    } 
	}

	private void handChange(double newValue)
	//to open or close the hand, it's sufficient to change the x-coordinate
	//value only
	{
	  if ((newValue == handValue) || (newValue > 0.5) || (newValue < 0.0))
	    return;
	  
	  showTheMove = false;
	  for (int i=0 ; i<6 ; i++ )  
	     {
               angleOld[i] = angles[i].act;
               angles[i].act = 0.0;
             }
	  double base9 = PL[134].x - handValue;//no.134 is a length 9 point
	  	 base9 += newValue;
	  double base11 = PL[136].x + handValue;//no.136 is a length 11 point
		 base11 -= newValue;
	  double base95 = base9 + 0.5;
	  double base105 = base11 - 0.5;
	  handValue = newValue;// now the actual hand value gets changed
	  for (int i = 134; i < 154; i++) // these points determine the hand
	    {
	      switch(i)
		{
		  case 134: case 135: case 139: case 140: case 142: 
		  case 143: PL[i].x = base9;
	     		    break;
		  case 136: case 137: case 138: case 141: case 148:
		  case 149: PL[i].x = base11;
			    break;
		  case 144: case 145: case 146: case 147:
			    PL[i].x = base95;
			    break;
	          case 150: case 151: case 153: case 152:
			    PL[i].x = base105;
			    break;
		}
	     }
	   AllAboutMoving.copyPointList(PL, pl, this);    
           angleNew[0] = 0.0;
           angleNew[1] = -Math.PI/2;
           angleNew[2] = angleNew[1];
           angleNew[3] = 0.0;
           angleNew[4] = 0.0;
           angleNew[5] = 0.0;
           AllAboutMoving.PosRobo(pl, angleNew, angles, this);// angles get
							// their new values
	   angleOld[1] = angleOld[1] + (Math.PI/2);
           angleOld[2] = angleOld[2] + (Math.PI/2);
	   // Creation of variables of primitive data type needed as 
	   // call-by-reference variables:
	   RefInt refError = new RefInt(errorcode);
	   RefDouble refAngleY = new RefDouble(angleY);
	   RefDouble refAngleX = new RefDouble(angleX);
	   RefDouble refD = new RefDouble(d);
	   RefInt refIndx = new RefInt(indx);
           AllAboutMoving.MoveRobo (showTheMove, pl, line, angleOld, angles, 
			8,refError, refAngleY, refAngleX, refD,0, refIndx,
			location, this);
           errorcode = refError.in;
	   angleY = refAngleY.in;
	   angleX = refAngleX.in;
	   indx = refIndx.in;
	   d = refD.in;
	   showTheMove = true;
	   repaint();
	}
          
          
	private void executeExample()
	{
	  double[] exAngles = new double[6];
	  double[] newLengths = new double[3];

	  newLengths[0] = 13.5;  // default values
	  newLengths[1] = 10;
	  newLengths[2] = 10;
	  linkLengthInput(newLengths);  
	  for (int i = 0; i < 6; i++)	
	    exAngles[i] = 0;  
	  manualInput(exAngles);
	  speedInput(15);
	  exAngles[0] = 90 * Math.PI / 180;
	  exAngles[1] = 0;
	  exAngles[2] = -90 * Math.PI / 180;  
	  exAngles[3] = -90 * Math.PI / 180;
	  exAngles[4] = 0; 
	  exAngles[5] = 0;
	  manualInput(exAngles);
	  zoomInput(2.0f);
	  for (int i = 0; i < 6; i++)	
	    exAngles[i] = - 30 * Math.PI / 180;
	  exAngles[1] = 0;
	  manualInput(exAngles);
	  zoomInput(1.5f);
	  speedInput(80);
	  exAngles[0] = -160 * Math.PI / 180;
	  exAngles[1] = -90 * Math.PI / 180;
	  exAngles[2] = -130 * Math.PI / 180;
	  exAngles[3] = -90 * Math.PI / 180;
	  exAngles[4] = -40 * Math.PI / 180;
	  exAngles[5] = -40 * Math.PI / 180;
	  manualInput(exAngles);
	  speedInput(25);
	  for (int i = 0; i < 6; i++)	
	    exAngles[i] = 0;
	  manualInput(exAngles);
	}


	// the following two events get interpreted by the ThreeD-instance
	public boolean mouseDown(Event e, int x, int y) 
	{
	  if (e.target == roboCanvas)
	    return animation.mouseDown(e, x, y);
	  else return true;
	}
       
        public boolean mouseDrag(Event e, int x, int y) 
	{
	  if (e.target == roboCanvas)
	    return animation.mouseDrag(e, x, y);
	  else return true;
	}
  
	public boolean action(Event e, Object o)
	{
 	   if (e.target == fileButton)
	     {
		try
		  {
		    FileHandle.readFile(this);
		  }	
		catch (IOException err)
		  {
		    writeError(err.getMessage());
		  }
	        finally
		  {
		    repaint();
		    return true;
		  }
	     }
	   if (e.target == teachButton)
	     {
	       if ((teachButton.getLabel()).equals(teachStr))
	  	 {
	           try
		     {  
		       saveFile = FileHandle.openFile(this); 
		       teachButton.setLabel(enterStr);
		       stopButton.enable();
		     }
	           catch (IOException err)
		     {	
		       writeError("Can't open: " + err.getMessage());
		     }
	           finally
		     { 
		       return true;
		     }
		 }
	       else
		 { // can only be called, if this button
                   // is enabled which means 'saveFile' has been 
		   // instanciated
		   FileHandle.writeFile(saveFile, this);
	           return true;
		 }
	     }
	   if (e.target == stopButton)
	     {
		FileHandle.closeFile(saveFile);
		teachButton.setLabel(teachStr);
		stopButton.disable();
		return true;
	     }
	   if (e.target == autoExecButton)
	     {
	       for (int kl = 0; kl < 3; kl++)
		 input[kl] = target[kl]; 
	       autoChange(input); 
	       actualizeAutoPanel();
	       return true;
	     }
	 
	   if (e.target == helpButton)
	     {
	       try
		 {
		   if ((getParameter("where")).equals(netscape))
		     {
	               String helpPath = getParameter("help");
	               URL url = new URL(getCodeBase(), helpPath);
		       getAppletContext().showDocument(url); // the help-html-
		                                   // page is shown
		     }
		   else
		     {
		       helpWin = new Win(this, 1);//'1' means 'help'
		     }  
		 }  
	       catch (MalformedURLException ex) {}
	       return true;
	     }
	   if (e.target == aboutButton)
	     {
	       try
		 {
		   if ((getParameter("where")).equals(netscape))
		     {
	               String aboutPath = getParameter("about");
	               URL url = new URL(getCodeBase(), aboutPath);
		       getAppletContext().showDocument(url); // the about-html-
		                                            // page is shown
		     }	
		   else
		     {
		       aboutWin = new Win(this, 2);//'2' means 'about'
		     }  	
		 }  
	       catch (MalformedURLException ex) {}
	       return true;
	     }
	   for (int loop = 1; loop < 4; loop++)
	     {
	       if (e.target == storeButtons[loop])
		 {
	           saveActualPosition(loop);
	           return true;
		 }
	     }
	   for (int loop = 0; loop < 4; loop++)
	     {
	       if (e.target == loadButtons[loop])
		 {	
		   loadPositionNo(loop);
		   return true;
		 }
	     }
	   if (e.target == exampleButton)
	     {
	       executeExample();
	       return true;
	     }
	   return this.handleEvent(e);
	}  

	public boolean handleEvent(Event e)
	{
	   for (int i = 0; i < 6; i++)
	     if (e.target == manualScrolls[i])
	       switch(e.id)
		 {
		   case Event.SCROLL_LINE_UP:
		   case Event.SCROLL_LINE_DOWN:
	  	   case Event.SCROLL_PAGE_UP:
		   case Event.SCROLL_PAGE_DOWN:
  		   case Event.SCROLL_ABSOLUTE:
		     if (robotIsReal)
		       { 
	 	  	 double newV = ((double) manualScrolls[i].getValue()) 
						 / manualScrollScale;
	  	         if ((newV >= realRobRestr[i][0]) &&
			     (newV <= realRobRestr[i][1]))
			   {
			     manualChange(i,newV);
			   }
			 else
			   manualScrolls[i].setValue((int) 
				   (manualScrollScale * angles[i].act));
		       }
		     else
		       manualChange(i,((double) manualScrolls[i].getValue())
				    / manualScrollScale);
		     return true;
	         }
	   if (e.target == zoomScroll)
	     {
	       switch(e.id)
		 {
		   case Event.SCROLL_LINE_UP:
		   case Event.SCROLL_LINE_DOWN:
	  	   case Event.SCROLL_PAGE_UP:
		   case Event.SCROLL_PAGE_DOWN:
  		   case Event.SCROLL_ABSOLUTE:
		     zoomValue = (float)(((Integer)e.arg).
					 intValue()) / zoomScrollScale;
		     animation.setScale(zoomValue);
		     repaint();
		     break;
		 }
	       return true;
	     } 
	   if (e.target == handScroll)
	     {
	       switch(e.id)
		{
		   case Event.SCROLL_LINE_UP:
		   case Event.SCROLL_LINE_DOWN:
	  	   case Event.SCROLL_PAGE_UP:
		   case Event.SCROLL_PAGE_DOWN:
  		   case Event.SCROLL_ABSOLUTE:
		     double helpHand = ((double) handScroll.getValue())
				           / handScrollScale; 
		     handChange(helpHand);
		     break;
		}
	      return true;
	     }
	   if (e.target == speedScroll)
	     {
		switch(e.id)
	          {
		    case Event.SCROLL_LINE_UP:
		    case Event.SCROLL_LINE_DOWN:
	  	    case Event.SCROLL_PAGE_UP:
		    case Event.SCROLL_PAGE_DOWN:
  		    case Event.SCROLL_ABSOLUTE:
		      xControl = speedScroll.getValue();
	 	      newSpeed();
	              break;
		  }
		return true;
	     }
	   if (e.target == virtualRobot)
	     {
	       if (robotIsReal)
	         tidyUpRealRobot();
	       return true;
	     }
	   if (e.target == realRobot)
	     {
	       if (!robotIsReal)
	         installRealRobot();
	       return true;
	     } 
	  
	   if (e.target == lineButton)
	     {         
	       if ((lineButton.getSelectedItem()).equals(onLine))
	         {	
		   fAutoLine = 0;// I'm copying the original c-program where
	         }               // booleans don't exist(easier for inv..Cine.)
	       else
	         {
		   fAutoLine = 1;
		 }
	       return true;
	     }	 
	   if (e.target == weightsExec)
	     {
	       for (int i = 0; i < 6; i++)
		 {
		   int help;
		   try 
		     {
		       help = Integer.parseInt(weightsText[i].getText()); 
		     }
		   catch (NumberFormatException err) 
		     { 
		       weightsText[i].setText(String.valueOf(angleWeights[i]));
		       continue; // the textfield gets the right value back
		     } 
		   if (help > 0)
	             angleWeights[i] = help;
		   else 
		     weightsText[i].setText(String.valueOf(angleWeights[i]));
	         }  
	       return true;
	     }
	   for (int i = 0; i < 3; i++)
	     if (e.target == linkScrolls[i])
	       switch(e.id)
		 {
		   case Event.SCROLL_LINE_UP:
		   case Event.SCROLL_LINE_DOWN:
	  	   case Event.SCROLL_PAGE_UP:
		   case Event.SCROLL_PAGE_DOWN:
  		   case Event.SCROLL_ABSOLUTE:
		     double actValue = (double)(((Integer)e.arg).intValue())
	 			         / linkScrollScale;
		     updateOldLinkLabel(i, actValue);
						// only the label is changed
		     return true;
	         }
	  if (e.target == linkExec)
	    {
	      double[] actValues = new double[3];
	      for (int kl = 0; kl < 3; kl++)
		actValues[kl] = (double)linkScrolls[kl].getValue()
		 	        / linkScrollScale;
	      linkLengthChange(actValues); 
	      return true;
	    }
	  for (int i = 0; i < 3; i++)
	    if (e.target == autoScrolls[i])
	       switch(e.id)
		 {
		   case Event.SCROLL_LINE_UP:
		   case Event.SCROLL_LINE_DOWN:
		   case Event.SCROLL_PAGE_UP:
		   case Event.SCROLL_PAGE_DOWN:
  		   case Event.SCROLL_ABSOLUTE:
		     for (int kl = 0; kl < 3; kl++)
		       input[kl] = target[kl];
		     input[i] = target[i] = 
		                (double)((Integer)e.arg).intValue() 
		     	 	/ autoScrollScale;
		     updateScrolledAutoLabel(i);
		     return true;
	          }
	   // default:
 	   
	   return super.handleEvent(e);
	}
}
