/************************************************************************/
/* File: ~/sopra/RoboPackII/FileHandle.java                             */
/* This file provides the fileDialog to read and write files. 	 	*/
/************************************************************************/

package RoboPackII;

import java.awt.*;
import java.io.*;
import java.util.Date;

final class FileHandle
{
        private static Frame f1 = new Frame("Parent");
		// 'FileDialog's must be called with a frame as argument
      	       
  	private static FileDialog 
	  FDSave = new FileDialog(f1,"Teach to File...", FileDialog.SAVE); 
	       // FileDialog to save data
	private static FileDialog
	  FDLoad = new FileDialog(f1, "Load from File...", FileDialog.LOAD);
	       // FileDialog to load data
	
	
	private static final String eoF = "e", EoF = "E";
      
        public static void readFile(RoboProto rob) throws IOException
	{
	  String fileString;
	  RandomAccessFile ranFile;
	  double[] nextDouble = new double[6];// takes the double numbers
	  int[] nextInteger = new int[6];     // takes the int numbers
	  String nextChar;                    // takes the command character
	  String help = new String();

	  try
	    { 
	      FDLoad.show();
	      fileString = FDLoad.getDirectory() + FDLoad.getFile();
	      if (fileString.equals(FDLoad.getDirectory()))
	        throw new IOException("No file name");
	      ranFile = new RandomAccessFile(fileString, "r");
			// the specified file is only read in this method
              nextChar = ranFile.readLine();// the only character is read
	      	 
	      while (!((nextChar.equals(eoF)) || (nextChar.equals(EoF))))
	        {
	     	  char helpII = nextChar.charAt(0);
		  switch (helpII)
	   	    {
	 	      case 'f':
		      case 'F': for (int j = 0; j < 6; j++)
				  {		          
				    help  = ranFile.readLine();	
				    Double dHelp = new Double(help);
				    nextDouble[j] = dHelp.doubleValue();
				    nextDouble[j] *= Math.PI / 180;
				    if ((nextDouble[j] > rob.angles[j].max) ||
					(nextDouble[j] < rob.angles[j].min))
				      throw new ClassCastException(
					  "Wrong angle (no."
					   + String.valueOf(j + 1) + "): " +
					   String.valueOf(nextDouble[j]));
				  }
				  // the angle values are read
			        rob.manualInput(nextDouble);
			        break;
		      case 'i':
		      case 'I': for (int j = 0; j < 3; j++)
				  {
				    help  = ranFile.readLine();	
				    Double dHelp = new Double(help);
				    nextDouble[j] = dHelp.doubleValue();
				  }
				rob.autoInput(nextDouble);
				break;
		      case 'l':
		      case 'L': for (int j = 0; j < 3; j++)
				  {
				    help  = ranFile.readLine();	
				    Double dHelp = new Double(help);
				    nextDouble[j] = dHelp.doubleValue();
				  }
				rob.linkLengthInput(nextDouble);
				break;
		      case 'w':
		      case 'W': for (int i = 0; i < 6; i++)
				  {
		   		    int helpI;
		   		    helpI = Integer.parseInt(
				                   ranFile.readLine()); 
		    	            if (helpI < 0)
				      throw new ClassCastException(
					 "Non-Negative number expected (no." +
					 String.valueOf(i + 1) + " : " +
					 String.valueOf(helpI));
		  		    nextInteger[i] = helpI;
				  }
				rob.weightsInput(nextInteger);
			        break;
		      case 's':
		      case 'S': int helpI;
			        helpI = Integer.parseInt(ranFile.readLine());
				rob.speedInput(helpI);
				break;
		      case 'h':
		      case 'H': help  = ranFile.readLine();	
				Double dHelp = new Double(help);
				nextDouble[0] = dHelp.doubleValue() / 2;
				rob.handInput(nextDouble[0]);
			        break;
		      case 'z':
		      case 'Z': help  = ranFile.readLine();	
				Double ddHelp = new Double(help);
				float newValue = (float) ddHelp.doubleValue();
				rob.zoomInput(newValue);
				break;
		      case '#': break; // a commantary is in this line
		      default : throw new ClassCastException(
					"Unknown command :"+ nextChar);
		    }
		   nextChar = ranFile.readLine();
	        }
	      ranFile.close();// the end of the file has been reached
	    }
	  catch (ClassCastException err)
	    {
	      rob.writeError(err.getMessage());
	    }
	  catch (IOException err) 
	    {
	      rob.writeError("Read File Error: " + err.getMessage());
	    }
	  catch (NumberFormatException err)
	    {
	      rob.writeError("Other Format expected: " + err.getMessage());
	    }
	  catch (StringIndexOutOfBoundsException err)
	    {
	      rob.writeError("A command character lacks.");
	    }
	} 
        
	public static RandomAccessFile openFile(RoboProto rob)
						 throws IOException
	{ 
	  RandomAccessFile ranFile;
	  FDSave.show();
	  String fileString = null;
	  fileString = new String(FDSave.getDirectory() + FDSave.getFile());
	  if (fileString.equals(FDSave.getDirectory()))
	    throw new IOException("No file name."); 
	  ranFile = new RandomAccessFile(fileString, "rw");	
	      // now it's necessary to save data  

	  Date now = new Date();
	  // signature of the file:
	  ranFile.writeBytes("# Automatic generated file (" + now.toString()
			      + ")\n");
		
	  // first of all the actual robot linklengths are saved:
	  ranFile.writeBytes("l\n");
	  for (int i = 0; i < 3; i++)
	    {
	      String help = String.valueOf(rob.linkLengths[i]);
	      ranFile.writeBytes(help + "\n");
	    }
	  // then the actual speed and zooming factor are saved:
	  ranFile.writeBytes("s\n");
	  ranFile.writeBytes(String.valueOf(rob.xControl) + "\n");
	  ranFile.writeBytes("z\n");
	  ranFile.writeBytes(String.valueOf(rob.zoomValue) + "\n");
	  return ranFile;
	}
	  
        public static void writeFile(RandomAccessFile ranFile, RoboProto rob)
	{
	  char manualChar = 'f';  //signifies that the numbers followed
			// by this character should be interpreted as angles
	  char handChar = 'h';
	  String help = new String();

	  try
	    {
	      ranFile.writeBytes(manualChar + "\n");//every line must hold one
						    // value
	      for (int i = 0; i < 6; i++)
		{
		  help = String.valueOf(rob.angles[i].act * 180 / Math.PI);
	 	  ranFile.writeBytes(help + "\n");
	        }
	      ranFile.writeBytes(handChar + "\n");
	      help = String.valueOf(2 * rob.handValue);
	      ranFile.writeBytes(help + "\n");
	    }
	  catch (IOException err)	
	    {
	      rob.writeError("Write File Error: " + err.getMessage());
	    }
	}

	public static void closeFile(RandomAccessFile ranFile)
	{	
	  try
	    {
	      ranFile.writeBytes(eoF + "\n");
	      ranFile.close();
	    }
	  catch (IOException err)
	    {
	    }
        }
}






