/*****************************************************************************
 *  Projektname:	AERO
 *  Filename:		Menu.c
 *  Filetyp:		Modul
 *****************************************************************************
 *  Modulname:		
 *  Version:		1.1
 *  letzte Aenderung:	Mittwoch, 21. August 1996, 15:55:39
 *  Autor:  		Andreas (Anpassungen von Hartmut)
 *  Status:		Menu ist fertig. (hoffentlich)
 *
 *  imp. Bezeichner:	Widget ....
 *
 *  exp. Bezeichner:
 *
 *  Beschreibung:
 *  -------------
 *  Bereitstellung eines Menus und der daran anschliessenden Routinen.
 *
 *  Versionsgeschichte:
 *  -------------------
 *  -11.12.92: Bereitstellung der Funktionalit"at
 *   11.12.92: Leichte "Anderungen im Menue-Aufbau
 *   16.12.92: Hinzunehmen des Men"upunktes Bilder pro Sekunde und die
 *             Implementierung der dahinterliegenden Funktion.
 *   21.12.92: Notwendig gewordene "Anderungen in einigen Routinen durch
 *             Ver"anderung des Gravitationstyps. 
 *   27.01.93: Es wurde ein neuer Men"u-Punkt 'Fussboden an/aus' eingef"ugt.
 *             Desweiteren wurde an den Men"u-Eintrag 'Koordinatensystem
 *             an/aus' Funktionalit"at angeh"angt.
 *   02.02.93: Neuer Men"ueintrag 'Koerperkoordinaten an/aus' mitsamt
 *             Funktionalit"at wurde installiert.
 *   05.02.93: Entfernen von Men"ueintrag 'Boden an/aus'.
 *   10.02.93: Quit-Button wurde vom Fenster ins Men"u verlagert.
 *   04.03.93: Ein weiterer Men"ueintrag zur Einstellung der KonfigFBB Daten
 *             kam hinzu. Um diese einstellen zu k"onnen kam auch noch ein
 *             Fenster hinzu.
 *  -08.03.93: Konfig-Parameter werden alle unterst"utzt. 
 *   21.04.93: Ein- Ausschalten der Kraftanzeige ist nun m"oglich.
 *   04.05.93: Entfernen aller Sync-Punkte kam hinzu.
 *   12.10.93: Calculation Parameter werden in ein Grid gesetzt.
 *   07.03.94: Radio-Grp for selecting different Raytracer (Povray 1.0/2.0)
 *   20.08.96: (HK) Radio-Grp rausgeschmissen und durch Athena Toggle-
 *             Widgets ersetzt. Auf diese Weise brauchen wir jetzt kein xpm
 *             mehr. File-Layout ueberarbeitet.
 *****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSink.h>
#include <X11/Xaw/Toggle.h>
#include <Xfwf/RowCol.h>
#include <X11/bitmaps/xlogo11>

#include "Welt.h"
#include "Editor.h"
#include "anzeigeconst.h"
#include "rayausg.h"
#include "HelpAboutAERO"


/*****************************************************************************
 *  Importierte Funktionen aus unterschiedlichen 'Modulen'.
 *****************************************************************************/
   extern  void AnzeigeDarstellung(Widget, Widget, Widget, Widget, 
				   TVektor darstpos, TQuaternion q, 
				   TReal zoom, TZustand *zustand,
                                   int modus);
   extern  void VerlasseAnimation();
   extern  void initBestimmeDateiname(Widget, XtPointer, XtPointer);
   extern  void Aktion_entferneAll(Widget, XtPointer, XtPointer);
   extern  void entferneWelt(TWelt **);
   extern  Dimension AlignButtons(Widget w[], int modus);



/*****************************************************************************
 * lokal globale Variablen
 *****************************************************************************/
static Widget SF_Shell, SF_Fehlerst, SF_KollisErk, SF_GravZufall,
              SF_ISchritt, SF_MinSchritt, SF_MaxSchritt, SF_Kollschritt,
              SF_MaxBerGeschw, SF_MinBeruehr, SF_MinGleitGeschw, 
	      SF_Genauigkeit, SF_MinRollGeschw, SF_GravAnteil,
              SF_MinDehnung, SF_Luftwider, SF_KugelBei, SF_QuaderBei,
              SF_ZylinderBei, SF_StangeDaempf, SF_StangeConst, 
              SF_GelenkDaempf, SF_GelenkConst, SF_FederStoss,
              DW_Dialog, DW_Interakt, RS_Shell, RS_RadioGrp, RS_Apply;
static TKonfigFBB Konfig;


/*****************************************************************************
 *  void Koordinatensystem(Widget w, XtPointer garbage, XtPointer muell)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird durch Selektieren eines Men"ueintrages aufgerufen. In
 *  Abh"angigkeit vom bisherigen Zustand wird der Folgezustand berechnet. Es
 *  handelt sich im Prinzip um das toggeln von einem Bit. Das Toggeln dieses
 *  Bits wird im Meneintrag durch eine Markierung sichtbar gemacht.
 *****************************************************************************/

void Koordinatensystem(Widget w, XtPointer garbage, XtPointer muell)
{
     if(KoordAnAus == 0)
     {
	  XtVaSetValues(w, XtNleftBitmap, mark, NULL);
	  KoordAnAus = WindowCoordON;
     }
     else
     {
	  XtVaSetValues(w, XtNleftBitmap, None, NULL);
	  KoordAnAus = 0;
     }
     AnzeigeDarstellung(EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
			DZoomFaktor, &aktuelleWelt->Welt, 
			KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*****************************************************************************
 *  void KoerperKoord(Widget w, XtPointer garbage, XtPointer muell)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird durch Selektieren eines Men"ueintrages aufgerufen. In
 *  Abh"angigkeit vom bisherigen Zustand wird der Folgezustand berechnet. Es
 *  handelt sich im Prinzip um das toggeln von einem Bit. Das Toggeln dieses
 *  Bits wird im Meneintrag durch eine Markierung sichtbar gemacht.
 *****************************************************************************/

void KoerperKoord(Widget w, XtPointer garbage, XtPointer muell)
{
     if (KoerperKoordAnAus == 0)
     {
	  XtVaSetValues(w, XtNleftBitmap, mark, NULL);
	  KoerperKoordAnAus = ObjectCoordON;
     }
     else
     {
	  XtVaSetValues(w, XtNleftBitmap, None, NULL);
	  KoerperKoordAnAus = 0;
     }
     AnzeigeDarstellung(EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
			DZoomFaktor, &aktuelleWelt->Welt, 
			KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void KraefteAnzeige(Widget w, XtPointer muell, XtPointer garbage)
{
     if (KraefteAnAus == 0)
     {
	  XtVaSetValues(w, XtNleftBitmap, mark, NULL);
	  KraefteAnAus = ForcesON;
     }      
     else
     {
	  XtVaSetValues(w, XtNleftBitmap, None, NULL);
	  KraefteAnAus = 0;
     }
     AnzeigeDarstellung(EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			EM_Darstellung3D, Koordinatenursprung, Ausrichtung, 
			DZoomFaktor, &aktuelleWelt->Welt, 
			KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*****************************************************************************
 *  static void Quit(Widget w, XEvent *event, String *params, 
 *                   Cardinal *num_params)
 *
 *  String *params: Parameterliste, die in der Translationtable stehen.
 *
 *  Beschreibung:
 *  -------------
 *  Die Prozedur Quit bringt ein Fenster an der aktuellen Mausposition zum
 *  Vorschein (es wird nicht die Mausposition, sondern das aufrufende Widget
 *  als Bezugspunkt gew"ahlt). Der Benutzer wird nach einer Best"atigung
 *  seines Wunsches, den Editor zu verlassen, gefragt.
 *****************************************************************************/

static void Quit(Widget w, XtPointer muell, XtPointer garbage)
{
   Position x, y;
   Dimension width, height;

   x = 0; y = 0; width = 0; height = 0;
   XtVaGetValues(w, XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords(w, 0, -(3*height/2), &x, &y);
   if(QD_Shell != NULL)
   {
      XtVaSetValues(QD_Shell, XtNx, x, XtNy, y, NULL);
      XtPopup(QD_Shell, XtGrabExclusive);
   }
   VerlasseAnimation ();
}


/*****************************************************************************
 *  void Gravitation(Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wandelt den Gravitationswert in einen String um, setzt
 *  diesen als Defaultwert in den Dialog ein, positioniert den Dialog noch
 *  in Reichweite der Mouse und bringt ihn dann auf das Desktop.
 *****************************************************************************/

void Gravitation(Widget w, XtPointer GD_Interakt, XtPointer garbage)
{
   Position x, y;
   Dimension width, height;
   char abc[20];

   sprintf(abc, "%.2f", -aktuelleWelt->Welt.GravitationsVektor[1]);  
                      /* double --> String, auf 2 Nachkommastellen gerundet */
   XtVaGetValues(w, XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords(w, 0, -3*height/2, &x, &y);
   XtVaSetValues(GD_Dialog, XtNx, x, XtNy, y, NULL);
   XtVaSetValues((Widget) GD_Interakt, XtNvalue, abc, NULL);

   XtPopup(GD_Dialog, XtGrabExclusive);
}


/*****************************************************************************
 *  void ApplyGrav(Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine schlie"st den Gravitationsdialog und "ubernimmt den Wert,
 *  der eingegeben wurde. (Es wird nicht auf Overflow geprft. Notwendig?)
 *****************************************************************************/

void ApplyGrav(Widget w, XtPointer clientData, XtPointer garbage)
{
     char *abc = malloc (20*sizeof(char));
     
     XtPopdown(GD_Dialog);
     abc = XawDialogGetValueString((Widget) clientData);
     aktuelleWelt->Welt.GravitationsVektor[1] = (TReal) -atof(abc);
     free (abc);
}


void AbortGrav(Widget w, XtPointer clientData, XtPointer callData)
{
   XtPopdown(GD_Dialog);
}


/*****************************************************************************
 *  void Gravitation(Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wandelt den Gravitationswert in einen String um, setzt
 *  diesen als Defaultwert in den Dialog ein, positioniert den Dialog noch
 *  in Reichweite der Mouse und bringt ihn dann auf das Desktop.
 *****************************************************************************/

void initDrehwinkel(Widget w, XtPointer muell, XtPointer garbage)
{
   Position x, y;
   Dimension width, height;

   XtVaGetValues(w, XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords(w, 0, -3*height/2, &x, &y);
   XtVaSetValues(DW_Dialog, XtNx, x, XtNy, y, NULL);
   XtVaSetValues(DW_Interakt, XtNvalue, "5.00", NULL);

   XtPopup(DW_Dialog, XtGrabNone);
}


/*****************************************************************************
 *  void ApplyDreh(Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *****************************************************************************/

void ApplyDreh(Widget w, XtPointer muell, XtPointer garbage)
{
     char *abc = malloc (20*sizeof(char));
     TReal Winkel, q0, qX;
     
     XtPopdown(DW_Dialog);
     abc = XawDialogGetValueString(DW_Interakt);
     Winkel = (TReal) atof(abc)/180*PI;
     
     q0 = cos(Winkel/2);
     qX = sin(Winkel/2);
     CRotXP[0] = q0; CRotXP[1] =  qX;
     CRotXM[0] = q0; CRotXM[1] = -qX; 
     CRotZP[0] = q0; CRotZP[3] =  qX; 
     CRotZM[0] = q0; CRotZM[3] = -qX;
     CRotYP[0] = q0; CRotYP[2] =  qX;
     CRotYM[0] = q0; CRotYM[2] = -qX;
     free (abc);
}


void AbortDreh(Widget w, XtPointer muell, XtPointer garbage)
{
   XtPopdown(DW_Dialog);
}


void AboutAERO(Widget w, XtPointer muell, XtPointer garbage)
{
   XtPopup(AA_Shell, XtGrabNone);
}


void CloseAERO(Widget w, XtPointer muell, XtPointer garbage)
{
   XtPopdown(AA_Shell);
}


/*****************************************************************************
 *  void BilderProSekunde(Widget w, XtPointer BPS_Interaktion, 
 *                        XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  
 *****************************************************************************/

void BilderProSekunde(Widget w, XtPointer BPS_Interaktion, XtPointer garbage)
{
   Position x, y;
   Dimension width, height;
   char abc[20];

   sprintf(abc, "%.2f", 1.0/ZeitIncrement); /* double --> String, auf 2 Nach-
                                               kommastellen gerundet        */
   XtVaGetValues(w, XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords(w, 0, -3*height/2, &x, &y);
   XtVaSetValues(BPS_Dialog, XtNx, x, XtNy, y, NULL);
   XtVaSetValues((Widget) BPS_Interaktion, XtNvalue, abc, NULL);

   XtPopup(BPS_Dialog, XtGrabExclusive);
}


void ApplyBPS(Widget w, XtPointer BPS_Interaktion, XtPointer garbage)
{
     char *abc = malloc (20*sizeof(char));

     XtPopdown(BPS_Dialog);
     abc = XawDialogGetValueString((Widget) BPS_Interaktion);
     ZeitIncrement = (TReal) 1.0/atof(abc);
     free (abc);
}


void AbortBPS(Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown(BPS_Dialog);
}


void installBPS(void)
{
   BPS_Dialog = XtVaCreatePopupShell("pictures per secound", transientShellWidgetClass, topLevel, NULL);
   BPS_Interaktion = XtVaCreateManagedWidget("BPS_Interaktion", dialogWidgetClass, BPS_Dialog, NULL);
   XawDialogAddButton(BPS_Interaktion, "BPS_Apply", ApplyBPS, (XtPointer) BPS_Interaktion);
   XawDialogAddButton(BPS_Interaktion, "BPS_Abort", AbortBPS, NULL);
}


void installAERO(void)
{
   Widget AA_box, AA_Text, AA_End;

   AA_Shell = XtVaCreatePopupShell("About XAero", topLevelShellWidgetClass, topLevel, NULL);
   AA_box = XtVaCreateManagedWidget("AA_box", formWidgetClass, AA_Shell, NULL);
   AA_Text = XtVaCreateManagedWidget("AA_Text", asciiTextWidgetClass, AA_box, XtNstring, HelpAboutAERO, NULL); 
   AA_End = XtVaCreateManagedWidget("AA_End", commandWidgetClass, AA_box, NULL);
   XtAddCallback(AA_End, XtNcallback, CloseAERO, (XtPointer) AA_Shell);
}


void entferneAlleSyncPunkte(Widget w, XtPointer muell, XtPointer garbage)
{
   TWelt *help;

   help = firstSync;
   while(firstSync != NULL)
   {
      firstSync = help->nextSync;
      entferneWelt(&help);
      help = firstSync;
   }
   lastSync = NULL;
   aktuelleWelt->prevSync = NULL;
   aktuelleWelt->nextSync = NULL;
   aktuelleWelt->thisSync = NULL;
}


void initSetzeFolgeschrittParameter(Widget w, XtPointer muell, XtPointer garbage)
{
     char trans[20];

     ErfrageKonfigFBB(&Konfig);
     sprintf(trans,"%.8e", Konfig.I_Schritt);
     XtVaSetValues(SF_ISchritt, XtNstring, trans, NULL);
     XtVaSetValues(SF_Fehlerst, XtNstate, Konfig.I_Fehlersteuerung, NULL);
     sprintf(trans,"%.8e", Konfig.I_Eps);
     XtVaSetValues(SF_Genauigkeit, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.I_MinSchritt);
     XtVaSetValues(SF_MinSchritt, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.I_MaxSchritt);
     XtVaSetValues(SF_MaxSchritt, XtNstring, trans, NULL);
     XtVaSetValues(SF_KollisErk, XtNstate, Konfig.K_Kollisionserkennung, NULL);
     sprintf(trans,"%.8e", Konfig.K_KollSchritt);
     XtVaSetValues(SF_Kollschritt, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.B_MaxBerGeschw);
     XtVaSetValues(SF_MaxBerGeschw, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.B_MinBerTiefe);
     XtVaSetValues(SF_MinBeruehr, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.R_MinGleitGeschw);
     XtVaSetValues(SF_MinGleitGeschw, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.R_MinRollGeschw);
     XtVaSetValues(SF_MinRollGeschw, XtNstring, trans, NULL);
     XtVaSetValues(SF_GravZufall, XtNstate, Konfig.G_Zufall, NULL);
     sprintf(trans,"%.8e", Konfig.G_ZufGravAnteil);
     XtVaSetValues(SF_GravAnteil, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.C_Stange_d);
     XtVaSetValues(SF_StangeDaempf, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.C_Stange_c);
     XtVaSetValues(SF_StangeConst, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.C_Gelenk_d);
     XtVaSetValues(SF_GelenkDaempf, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.C_Gelenk_c);
     XtVaSetValues(SF_GelenkConst, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.F_MinDehnung);
     XtVaSetValues(SF_MinDehnung, XtNstring, trans, NULL);
     XtVaSetValues(SF_Luftwider, XtNstate, Konfig.L_Luftwiderstand, NULL);
     sprintf(trans,"%.8e", Konfig.L_Beiwert_Kugel);
     XtVaSetValues(SF_KugelBei, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.L_Beiwert_Quader);
     XtVaSetValues(SF_QuaderBei, XtNstring, trans, NULL);
     sprintf(trans,"%.8e", Konfig.L_Beiwert_Zylinder);
     XtVaSetValues(SF_ZylinderBei, XtNstring, trans, NULL);
     XtVaSetValues(SF_FederStoss, XtNstate, Konfig.K_FederStoss, NULL);
     
     XtPopup(SF_Shell, XtGrabExclusive);
}


static void getBoolean(Widget w, TBoolean *Wert)
{
     TBoolean i = FALSE;
     XtVaGetValues(w, XtNstate, &i, NULL);
     if(!i)
	  *Wert = FALSE;
     else
	  *Wert = TRUE;
}


static void getReal(Widget w, TReal *Wert)
{
     char *trans = malloc (20*sizeof (char));
   
     XtVaGetValues(w, XtNstring, &trans, NULL);
     if(atof(trans) > 0.0)
	  *Wert = (TReal) atof(trans);
}

   
void setzeFolgeschrittParameterApply(Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown(SF_Shell);

     /************************************************************************
      * Nun werden alle Werte geholt. Sind die edierten Werte kleiner als 0, 
      * werden sie nicht bernommen.
      ************************************************************************/
     getReal(SF_ISchritt, &Konfig.I_Schritt);
     getBoolean(SF_Fehlerst, &Konfig.I_Fehlersteuerung);
     getReal(SF_Genauigkeit, &Konfig.I_Eps);
     getReal(SF_MinSchritt, &Konfig.I_MinSchritt);
     getReal(SF_MaxSchritt, &Konfig.I_MaxSchritt);
     getBoolean(SF_KollisErk, &Konfig.K_Kollisionserkennung);
     getReal(SF_Kollschritt, &Konfig.K_KollSchritt);
     getReal(SF_MaxBerGeschw, &Konfig.B_MaxBerGeschw);
     getReal(SF_MinBeruehr, &Konfig.B_MinBerTiefe);
     getReal(SF_MinGleitGeschw, &Konfig.R_MinGleitGeschw);
     getReal(SF_MinRollGeschw, &Konfig.R_MinRollGeschw);
     getBoolean(SF_GravZufall, &Konfig.G_Zufall);
     getReal(SF_GravAnteil, &Konfig.G_ZufGravAnteil);
     getReal(SF_StangeDaempf, &Konfig.C_Stange_d);
     getReal(SF_StangeConst, &Konfig.C_Stange_c);
     getReal(SF_GelenkDaempf, &Konfig.C_Gelenk_d);
     getReal(SF_GelenkConst, &Konfig.C_Gelenk_c);
     getReal(SF_MinDehnung, &Konfig.F_MinDehnung);
     getBoolean(SF_Luftwider, &Konfig.L_Luftwiderstand);
     getReal(SF_KugelBei, &Konfig.L_Beiwert_Kugel);
     getReal(SF_QuaderBei, &Konfig.L_Beiwert_Quader);
     getReal(SF_ZylinderBei, &Konfig.L_Beiwert_Zylinder);
     getBoolean(SF_FederStoss, &Konfig.K_FederStoss);
     
     KonfigFBB(&Konfig);
}


void setzeFolgeschrittParameterCancel(Widget w, XtPointer muell, 
				      XtPointer garbage)
{
     XtPopdown(SF_Shell);
}


void installSetzeFolgeschrittParameter(void)
{
   Widget SF_box, SF_sub, SF_FehlerstTxt, SF_KollisErkTxt, 
          SF_GravZufallTxt, SF_Apply, SF_Cancel, SF_ISchrittTxt, 
	  SF_MinSchrittTxt, SF_KollschrittTxt, SF_MaxBerGeschwTxt,
	  SF_MinBeruehrTxt, SF_MinGleitGeschwTxt, SF_MinRollGeschwTxt,
	  SF_GravAnteilTxt, SF_MinDehnungTxt, SF_GenauigkeitTxt,
	  SF_MaxSchrittTxt, SF_LuftwiderTxt, SF_KugelBeiTxt,
	  SF_QuaderBeiTxt, SF_ZylinderBeiTxt, SF_StangeDaempfTxt,
	  SF_StangeConstTxt, SF_GelenkDaempfTxt, SF_GelenkConstTxt,
	  SF_FederStossTxt; 

   SF_Shell = 
	XtVaCreatePopupShell("set calculation parameter", 
			     topLevelShellWidgetClass, 
			     topLevel, NULL);
   SF_box =   
	XtVaCreateManagedWidget("SF_box", formWidgetClass, 
				SF_Shell, NULL);
   SF_sub =   
	XtVaCreateManagedWidget("SF_sub", xfwfRowColWidgetClass, SF_box, 
				XtNstoreByRow, TRUE, 
				XtNcolumns, 2, 
				XtNshrinkToFit, TRUE, 
				NULL);
   SF_ISchrittTxt = 
	XtVaCreateManagedWidget("SF_ISchrittTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_ISchritt =    
	XtVaCreateManagedWidget("SF_ISchritt", asciiTextWidgetClass, 
				SF_sub,	NULL);
   SF_FehlerstTxt = 
	XtVaCreateManagedWidget("SF_FehlerstTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_Fehlerst =    
	XtVaCreateManagedWidget("SF_Fehlerst", toggleWidgetClass, 
				SF_sub, NULL);
   SF_GenauigkeitTxt = 
	XtVaCreateManagedWidget("SF_GenauigkeitTxt", labelWidgetClass,
				SF_sub, NULL);
   SF_Genauigkeit = 
	XtVaCreateManagedWidget("SF_Genauigkeit", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MinSchrittTxt =  
	XtVaCreateManagedWidget("SF_MinSchrittTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MinSchritt =  
	XtVaCreateManagedWidget("SF_MinSchritt", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MaxSchrittTxt =  
	XtVaCreateManagedWidget("SF_MaxSchrittTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MaxSchritt =  
	XtVaCreateManagedWidget("SF_MaxSchritt", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_KollisErkTxt =   
	XtVaCreateManagedWidget("SF_KollisErkTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_KollisErk =   
	XtVaCreateManagedWidget("SF_KollisErk", toggleWidgetClass, 
				SF_sub, NULL);
   SF_KollschrittTxt = 
	XtVaCreateManagedWidget("SF_KollschrittTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_Kollschritt = 
	XtVaCreateManagedWidget("SF_Kollschritt", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MaxBerGeschwTxt = 
	XtVaCreateManagedWidget("SF_MaxBerGeschwTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MaxBerGeschw =   
	XtVaCreateManagedWidget("SF_MaxBerGeschw", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MinBeruehrTxt =  
	XtVaCreateManagedWidget("SF_MinBeruehrTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MinBeruehr =  
	XtVaCreateManagedWidget("SF_MinBeruehr", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MinGleitGeschwTxt = 
	XtVaCreateManagedWidget("SF_MinGleitGeschwTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MinGleitGeschw = 
	XtVaCreateManagedWidget("SF_MinGleitGeschw", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MinRollGeschwTxt = 
	XtVaCreateManagedWidget("SF_MinRollGeschwTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MinRollGeschw = 
	XtVaCreateManagedWidget("SF_MinRollGeschw", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_GravZufallTxt = 
	XtVaCreateManagedWidget("SF_GravZufallTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_GravZufall = 
	XtVaCreateManagedWidget("SF_GravZufall", toggleWidgetClass, 
				SF_sub, NULL);
   SF_GravAnteilTxt = 
	XtVaCreateManagedWidget("SF_GravAnteilTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_GravAnteil = 
	XtVaCreateManagedWidget("SF_GravAnteil", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_GelenkDaempfTxt = 
	XtVaCreateManagedWidget("SF_GelenkDaempfTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_GelenkDaempf = 
	XtVaCreateManagedWidget("SF_GelenkDaempf", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_GelenkConstTxt = 
	XtVaCreateManagedWidget("SF_GelenkConstTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_GelenkConst = 
	XtVaCreateManagedWidget("SF_GelenkConst", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_StangeDaempfTxt = 
	XtVaCreateManagedWidget("SF_StangeDaempfTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_StangeDaempf = 
	XtVaCreateManagedWidget("SF_StangeDaempf", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_StangeConstTxt = 
	XtVaCreateManagedWidget("SF_StangeConstTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_StangeConst = 
	XtVaCreateManagedWidget("SF_StangeConst", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_MinDehnungTxt = 
	XtVaCreateManagedWidget("SF_MinDehnungTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_MinDehnung = 
	XtVaCreateManagedWidget("SF_MinDehnung", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_LuftwiderTxt = 
	XtVaCreateManagedWidget("SF_LuftwiderTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_Luftwider = 
	XtVaCreateManagedWidget("SF_Luftwider", toggleWidgetClass, 
				SF_sub, NULL);
   SF_KugelBeiTxt = 
	XtVaCreateManagedWidget("SF_KugelBeiTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_KugelBei = 
	XtVaCreateManagedWidget("SF_KugelBei", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_QuaderBeiTxt = 
	XtVaCreateManagedWidget("SF_QuaderBeiTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_QuaderBei = 
	XtVaCreateManagedWidget("SF_QuaderBei", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_ZylinderBeiTxt = 
	XtVaCreateManagedWidget("SF_ZylinderBeiTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_ZylinderBei = 
	XtVaCreateManagedWidget("SF_ZylinderBei", asciiTextWidgetClass, 
				SF_sub, NULL);
   SF_FederStossTxt = 
	XtVaCreateManagedWidget("SF_FederStossTxt", labelWidgetClass, 
				SF_sub, NULL);
   SF_FederStoss = 
	XtVaCreateManagedWidget("SF_FederStoss", toggleWidgetClass, 
				SF_sub, NULL);

   SF_Apply = 
	XtVaCreateManagedWidget("SF_Apply", commandWidgetClass, 
				SF_box, NULL);
   SF_Cancel = 
	XtVaCreateManagedWidget("SF_Cancel", commandWidgetClass, 
				SF_box, NULL);

   XtAddCallback(SF_Apply, XtNcallback, 
		 setzeFolgeschrittParameterApply, NULL);
   XtAddCallback(SF_Cancel, XtNcallback,  
		 setzeFolgeschrittParameterCancel, NULL);
}


/*****************************************************************************
 *  Funktion  void RaytracerApply(Widget w, ...)
 *
 *  Beschreibung:
 *  -------------
 *  Die Auswahl des Raytracers wird abgeschlossen. Durch leicht Veraenderung
 *  der Translationtable aller Radiobuttons wird erreicht, dass immer genau
 *  ein Toggle gesetzt ist. Dadurch ist hier keine weitere Abfrage mehr auf
 *  korrekt gesetzte Toggles noetig.
 *
 *  Es sollte ueber die Resources genau ein Wert vorbelegt sein, z.B. mit 
 *     XAero*RS_Raytracer2.state:		True
 *
 *  Momentan definierte Werte: (siehe rayausg.h)
 *    PovRay 1.x:   1
 *    PovRay 2.x:   2
 *****************************************************************************/

void RaytracerApply (Widget w, XtPointer muell, XtPointer garbage)
{
     raytracerVersion = (int) XawToggleGetCurrent(RS_RadioGrp);
     XtPopdown (RS_Shell);
}

void initRaytracer (Widget w, XtPointer muell, XtPointer garbage)
{
     Position x, y;
     Dimension width, height;
     
     x = 0; y = 0; width = 0; height = 0;
     XtVaGetValues (w, XtNwidth, &width, XtNheight, &height, NULL);
     if (width == 0)
     {
	  XtRealizeWidget (RS_Shell);
	  XtVaGetValues (w, XtNwidth, &width, XtNheight, &height, NULL);
     }
     XtTranslateCoords (w, 0, -height, &x, &y);
     if (RS_Shell != NULL)  /* You normaly don't have to check it */
     {
	  XtVaSetValues (RS_Shell, XtNx, x, XtNy, y, NULL);
	  XtPopup (RS_Shell, XtGrabExclusive);
     }     
}


void installRaytracer (void)
{
     Widget RS_box1, RS_RadioGrp2, RS_text;
     Dimension width;

     /* Damit immer mindestens ein Button selektiert bleibt, muss die
	Translationtable fuer die Radiobuttons leicht modifiziert werden
	(set() statt wie im Default toggle()). */
     XtTranslations radiotranslations;
     String radiotrans =
        "<EnterWindow>: highlight(Always)\n\
         <LeaveWindow>: unhighlight()\n\
         <Btn1Down>,<Btn1Up>: set() notify()";

     radiotranslations = XtParseTranslationTable(radiotrans);

     RS_Shell = 
	  XtVaCreatePopupShell("select raytracer", 
			       transientShellWidgetClass, 
			       topLevel, NULL);
     RS_box1 = 
	  XtVaCreateManagedWidget ("RS_box1", formWidgetClass, 
				   RS_Shell, NULL);
     RS_text = 
	  XtVaCreateManagedWidget ("RS_text", labelWidgetClass,
				   RS_box1, NULL);
     RS_RadioGrp = 
	  XtVaCreateManagedWidget ("RS_Raytracer1", toggleWidgetClass, 
				   RS_box1,
				   XtNradioData, 1,
				   XtNtranslations, radiotranslations,
				   NULL);
     RS_RadioGrp2 = 
	  XtVaCreateManagedWidget ("RS_Raytracer2", toggleWidgetClass, 
				   RS_box1,
				   XtNradioData, 2,
				   XtNradioGroup, RS_RadioGrp,
				   XtNtranslations, radiotranslations,
				   NULL);
     RS_Apply = 
	  XtVaCreateManagedWidget ("RS_Apply", commandWidgetClass, 
				   RS_box1, NULL);

     /* Breite der Box an breitesten String anpassen */
     {
	  Widget w[] = {RS_text, RS_RadioGrp, RS_RadioGrp2, 
			RS_Apply, (Widget) NULL};
	  
	  width = AlignButtons(w, 1) + 30;
     }

     XtVaSetValues (RS_RadioGrp, XtNwidth, width, NULL);
     XtVaSetValues (RS_RadioGrp2, XtNwidth, width, NULL);

     XtAddCallback (RS_Apply, XtNcallback, RaytracerApply, NULL);

     /* Default-Raytracer-Version ueber Resources holen */
     raytracerVersion = (int) XawToggleGetCurrent(RS_RadioGrp);
     if (raytracerVersion == 0)		  /* Falls nichts gefunden, einen */
	  raytracerVersion = POVRAY2;	  /* festen Default nehmen */

#if 0
     printf("Default-Raytracer: %i\n", raytracerVersion);
#endif
}


/*****************************************************************************
 *  Funktion  void installMenu(void)
 *
 *  Beschreibung:
 *  -------------
 *  Das Menu des Editors wird mit dieser Routine installiert.
 *****************************************************************************/

void installMenu(void)
{
   Widget entry, EM_holeMenu, EM_menu1Button, EM_menu2Button,
	  EM_menu3Button, EM_informationLabel, EM_menu1, EM_menu2, EM_menu3,
	  EM_gravity, EM_AboutAERO, GD_Interakt, EM_ladeZustand,
	  EM_speichereZustand, EM_BilderProSek, EM_KoerperKoordOnOff,
	  EM_quit, EM_FBBParameter, EM_speichereMatTab, EM_entferneAll,
	  EM_KraefteDarst, EM_ladeSequenz, EM_speichereSequenz,
	  EM_entferneAlleSyncPunkte, EM_Drehwinkel, EM_Raytracer; 

   EM_holeMenu = 
	XtVaCreateManagedWidget("EM_holeMenu", formWidgetClass, 
				EM_paneBox, NULL);
   EM_menu1Button = 
	XtVaCreateManagedWidget("EM_menu1Button", menuButtonWidgetClass, 
				EM_holeMenu, NULL);
   EM_menu2Button = 
	XtVaCreateManagedWidget("EM_menu2Button", menuButtonWidgetClass, 
				EM_holeMenu, NULL);
   EM_menu3Button = 
	XtVaCreateManagedWidget("EM_menu3Button", menuButtonWidgetClass, 
				EM_holeMenu, NULL);
   EM_informationLabel = 
	XtVaCreateManagedWidget("EM_informationLabel", labelWidgetClass, 
				EM_holeMenu, NULL);

   EM_menu1 = XtVaCreatePopupShell("EM_menu1", simpleMenuWidgetClass, 
				   topLevel, NULL); 
   EM_menu2 = XtVaCreatePopupShell("EM_menu2", simpleMenuWidgetClass, 
				   topLevel, NULL); 
   EM_menu3 = XtVaCreatePopupShell("EM_menu3", simpleMenuWidgetClass, 
				   topLevel, NULL); 

   /**************************************************************************
    * Eintraege in Menu1 -- AERO 
    **************************************************************************/
   EM_AboutAERO = 
	XtVaCreateManagedWidget("EM_AboutAERO", smeBSBObjectClass,
				EM_menu1, NULL); 
   entry = 
	XtVaCreateManagedWidget("line", smeLineObjectClass,
				EM_menu1, NULL);
   EM_entferneAll = 
	XtVaCreateManagedWidget("EM_entferneAll", smeBSBObjectClass, 
				EM_menu1, NULL);
   EM_entferneAlleSyncPunkte =
	XtVaCreateManagedWidget("EM_entferneAlleSyncPunkte",
				smeBSBObjectClass,
				EM_menu1, NULL);

   EM_quit = 
	XtVaCreateManagedWidget("EM_quit", smeBSBObjectClass, 
				EM_menu1, NULL);

   /*****************************************************************************
    * Eintraege in Menu2 -- I/O Interaktion 
    *****************************************************************************/
   EM_ladeZustand = 
	XtVaCreateManagedWidget("EM_ladeZustand", smeBSBObjectClass, 
				EM_menu2, NULL);
   EM_speichereZustand = 
	XtVaCreateManagedWidget("EM_speichereZustand", smeBSBObjectClass, 
				EM_menu2, NULL);
   EM_ladeMatTab = 
	XtVaCreateManagedWidget("EM_ladeMatTab", smeBSBObjectClass, 
				EM_menu2, NULL);
   EM_speichereMatTab = 
	XtVaCreateManagedWidget("EM_speichereMatTab", smeBSBObjectClass, 
				EM_menu2, NULL);
   EM_ladeSequenz = 
	XtVaCreateManagedWidget("EM_ladeSequenz", smeBSBObjectClass, 
				EM_menu2, NULL);
   EM_speichereSequenz = 
	XtVaCreateManagedWidget("EM_speichereSequenz", smeBSBObjectClass, 
				EM_menu2, NULL); 

   /*****************************************************************************
    * Eintraege in Menu3 -- Arbeitsparameter 
    *****************************************************************************/
   EM_KoordDarstOnOff = 
	XtVaCreateManagedWidget("EM_KoordDarstOnOff", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_KoerperKoordOnOff = 
	XtVaCreateManagedWidget("EM_KoerperKoordOnOff", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_KraefteDarst = 
	XtVaCreateManagedWidget("EM_KraefteDarst", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_gravity = 
	XtVaCreateManagedWidget("EM_gravity", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_BilderProSek = 
	XtVaCreateManagedWidget("EM_BilderProSek", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_Drehwinkel = 
	XtVaCreateManagedWidget("EM_Drehwinkel", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_Raytracer = 
	XtVaCreateManagedWidget("EM_Raytracer", smeBSBObjectClass, 
				EM_menu3, NULL);
   EM_FBBParameter = 
	XtVaCreateManagedWidget("EM_FBBParameter", smeBSBObjectClass, 
				EM_menu3, NULL);

   GD_Dialog = 
	XtVaCreatePopupShell("GD_Dialog", transientShellWidgetClass, 
			     topLevel, NULL);
   GD_Interakt = 
	XtVaCreateManagedWidget("GD_Interakt", dialogWidgetClass, 
				GD_Dialog, NULL);
   XawDialogAddButton(GD_Interakt, "GD_Apply", ApplyGrav, 
		      (XtPointer) GD_Interakt);
   XawDialogAddButton(GD_Interakt, "GD_Abort", AbortGrav, NULL);

   DW_Dialog = XtVaCreatePopupShell("Set rotation angle", 
				    transientShellWidgetClass, 
				    topLevel, NULL);
   DW_Interakt = XtVaCreateManagedWidget("DW_Interakt", dialogWidgetClass, 
					 DW_Dialog, NULL);
   XawDialogAddButton(DW_Interakt, "DW_Apply", ApplyDreh, NULL);
   XawDialogAddButton(DW_Interakt, "DW_Abort", AbortDreh, NULL);   

   mark = XCreateBitmapFromData(XtDisplay(topLevel), 
				RootWindowOfScreen(XtScreen(topLevel)),
				(char *)xlogo11_bits,
				xlogo11_width, xlogo11_height);
   installSetzeFolgeschrittParameter();
   installAERO ();  
   installBPS ();
   installRaytracer ();
   KoerperKoordAnAus = 0;
   KoordAnAus = WindowCoordON;
   XtVaSetValues (EM_KoordDarstOnOff, XtNleftBitmap, mark, NULL); 
   KraefteAnAus = ForcesON; 
   XtVaSetValues (EM_KraefteDarst, XtNleftBitmap, mark, NULL);

   XtAddCallback (EM_AboutAERO, XtNcallback, AboutAERO, (XtPointer) AA_Shell);
   XtAddCallback (EM_entferneAll, XtNcallback, Aktion_entferneAll, NULL);
   XtAddCallback (EM_entferneAlleSyncPunkte, XtNcallback, 
		  entferneAlleSyncPunkte, NULL);
   XtAddCallback (EM_gravity, XtNcallback, Gravitation, 
		  (XtPointer) GD_Interakt);
   XtAddCallback (EM_ladeZustand, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) leseAkt);
   XtAddCallback (EM_speichereZustand, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) schreibeAkt);
   XtAddCallback (EM_ladeMatTab, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) leseMat);
   XtAddCallback (EM_speichereMatTab, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) schreibeMat);
   XtAddCallback (EM_ladeSequenz, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) leseSeq);
   XtAddCallback (EM_speichereSequenz, XtNcallback, initBestimmeDateiname, 
		  (XtPointer) schreibeSeq);
   XtAddCallback (EM_BilderProSek, XtNcallback, BilderProSekunde, 
		  (XtPointer) BPS_Interaktion);
   XtAddCallback (EM_KoordDarstOnOff, XtNcallback, Koordinatensystem, NULL); 
   XtAddCallback (EM_KoerperKoordOnOff, XtNcallback, KoerperKoord, NULL);
   XtAddCallback (EM_KraefteDarst, XtNcallback, KraefteAnzeige, NULL);
   XtAddCallback (EM_Drehwinkel, XtNcallback, initDrehwinkel, NULL);
   XtAddCallback (EM_Raytracer, XtNcallback, initRaytracer, NULL);
   XtAddCallback (EM_FBBParameter, XtNcallback, initSetzeFolgeschrittParameter,
		  NULL);
   XtAddCallback (EM_quit, XtNcallback, Quit, NULL);
}
