/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		darstellung.h
 *  Filetyp:		Header
 ********************************************************************************
 *  Modulname:		Anzeige
 *  Version:		0.1.0
 *  letzte Aenderung:	Montag, 11. September 1995, 13:42:47
 *  Autor:  		Hartmut 
 *  Status:		Enthaelt bisher einige Definitionen fuer die Anzeige
 *                      der Darstellungsfenster.
 *				 
 *  imp. Bezeichner:	div. Typennamen
 * 
 *  exp. Bezeichner:    keine, nur lokales Headerfile fuer mich
 *
 *  Beschreibung:	
 *  -------------	
 *  Lokaler (=privater) Header fuer die Darstellungsroutinen.
 *									       
 *  Versionsgeschichte:							       
 *  -------------------			
 *  0.0.1:  Typen fuer Darstellungslisten, allgemein Darstellungsinformation
 *  0.0.2:  AElement erweitert fuer Koordinatenachsen und Farbe, Projektions-
 *          werte fuer Koordinatenachsen im 3d-Darstellungsfenster.
 *  0.0.3:  AInfo eingefuehrt, dadurch Aenderung bei AElement; ebenso R, G, B 
 *          ersetzt durch eine Farbnummer. ADarstListe erweitert um Display,
 *          Screen und Window.
 *  0.0.4:  NAHE_0 eingefuehrt (fuer Fliesskommazahlenvergleich mit 0)
 *  0.0.5:  Bildschirmachsenausrichtung B_ACHSEN_X und B_ACHSEN_Y
 *  0.0.6:  Alle Dinge, die nichts mit der Darstellung direkt zu tun haben, sind
 *          nach animat.h bzw. visualisierung.h ausgelagert worden.
 *  0.1.0:  File heisst jetzt darstellung.h, voellige Umstrukturierung der
 *          anzeige-Routinen fuer die Darstellung. Die Darstellungslisten
 *          mit 2D-Linien sind weggefallen, dafuer werden jetzt die fuer 
 *          die Darstellung noetigen Daten der Koerper/Verbindungen kopiert.
 ********************************************************************************/

#ifndef DARSTELLUNG_H
#define DARSTELLUNG_H


#include "visualisierung.h"


/* Grundzoom, der beim Darstellungsfenster aufmultipliziert wird.
 * Von diesem Wert haengt es ab, wie gross ein Koerper von z.B. 1m Kantenlaenge
 * in den Darstellungsfenstern zu sehen ist
 */

#define DARST_ZOOM 200



/* Abstand der virt. Kamera vom Darstellungsmittelpunkt.
 * Es werden 4 Ansichten erzeugt (d=DARST_DEFAULTABSTAND):
 *    Bild fuer xy-Ansicht: Kamera auf (0,0,-d)
 *              yz-Ansicht:            (d,0,0)
 *              xz-Ansicht:            (0,d,0)
 *              3d-Ansicht:            schraeg von oben, siehe darstellung.c
 *    mit jeweiliger Blickrichtung nach (0,0,0)
 */

#define DARST_DEFAULTABSTAND 10  



/* Groesse des Kreuzes (in Pixeln), mit dem Naegel bzw. feste Punkte in der Dar-
 * stellung gezeichnet werden. Das Kreuz geht von (x-D, y-D) bis (x+D, y+D)
 */

#define DARST_NAGELGROESSE 5


/* Groesse einer Pfeilspitze (in Pixeln) von Koordinatenachsen in der Darstellung.
   Stellt man sich eine Pfeilspitze nach oben mit der Spitze an (x,y) vor, dann
   hat das Dreieck der Pfeilspitze die Koordinaten:
         (x-DARST_PFEILBREITE, y+DARST_PFEILHOEHE)
	 (x,y)
	 (x+DARST_PFEILBREITE, y+DARST_PFEILHOEHE)   */

#define DARST_PFEILBREITE 3
#define DARST_PFEILHOEHE 6




/* Anzahl der Punkte, mit denen eine Zylindergrundflaeche angenaehert wird.
 * ACHTUNG: eine Aenderung dieses Wertes erfordert auch Aenderungen der ent-
 *          sprechenden Routinen (z.B. ProjektionZylinder()). Also besser nicht
 *          einfach nur so mal aendern!
 */

#define DARST_ZYLPOINTS 12




/*  Kein einzelner Koerper darf mehr als soviele Linien haben, es muss also 
 *  eine absolute Oberschranke sein. Momentan hat der Zylinder die meisten 
 *  Linien (26)
 */

#define DARST_MAXLINES 100

/***********************************************************************
 *  Information ueber Ansichten. In den folgenden Strukturen werden die
 *  Koordinaten immer relativ zur entsprechenden Ansicht in einem Feld
 *  abgelegt. Welcher Index immer zu welcher Ansicht gehoert, wird auch
 *  hier definiert. 
 ***********************************************************************/

#define AnzahlAnsichten 4		  /* 4 Ansichten: XY, YZ, XZ und 3D */
#define Axy 0				  /* Index fuer XY-Ansicht */
#define Ayz 1				  /* Index fuer YZ-Ansicht */
#define Axz 2				  /* Index fuer XZ-Ansicht */
#define A3d 3				  /* Index fuer 3D-Ansicht */


/***********************************************************************
 *  Typen fuer Kraefte vereinbaren. In diesen Typen werden alle fuer
 *  die Darstellung noetigen Werte der Kraefte abgespeichert.
 ***********************************************************************/

#define KraftMproN  0.7  		  /* Skalierungsfaktor fuer Kraefte */

typedef struct AKraft
{
     struct AKraft *next;
     TVektor anfang[AnzahlAnsichten];	  /* Anfangs- und */
     TVektor ende[AnzahlAnsichten];	  /* Endpunkt der Kraft */
} AKraft;


/***********************************************************************
 *  Typen fuer Koerper vereinbaren. In diesen Typen werden alle fuer
 *  die Darstellung noetigen Werte der Koerper abgespeichert.
 ***********************************************************************/

/* Definition aller Eigenschaften, die bei den Koerpern unterschiedlich sind */

typedef TVektor AZylFeld[DARST_ZYLPOINTS];

typedef struct AZylinder
{
     AZylFeld p[AnzahlAnsichten];	  /* unterer Kreis des Zylinders */
     AZylFeld q[AnzahlAnsichten];	  /* oberer Kreis des Zylinders */
} AZylinder;

typedef struct AQuader
{
     TVektor luv[AnzahlAnsichten];	  /* Quadereckpunkte:  */
     TVektor lov[AnzahlAnsichten];
     TVektor rov[AnzahlAnsichten];
     TVektor ruv[AnzahlAnsichten];
     TVektor luh[AnzahlAnsichten];
     TVektor loh[AnzahlAnsichten];
     TVektor roh[AnzahlAnsichten];    
     TVektor ruh[AnzahlAnsichten];
} AQuader;

typedef struct AKugel
{
     TVektor mittelpunkt[AnzahlAnsichten]; /* Mittelpunkt der Kugel */
     TReal   radius;			  /* Radius der Kugel */
} AKugel;

typedef struct ANagel
{
     TVektor punkt[AnzahlAnsichten];	  /* Koordinaten des Punktes */
} ANagel;

typedef struct AEbene
{
     TVektor q[AnzahlAnsichten];	  /* Mittelpunkt des Rechtecks */
     TVektor b1[AnzahlAnsichten];	  /* die beiden normierten Basis- */
     TVektor b2[AnzahlAnsichten];	  /* vektoren der Ebene */
} AEbene;


typedef union AKoeParameter		  /* Union mit allen */
{					  /* unterschiedlichen Parametern */
     AZylinder       zylinder;
     AQuader         quader;
     AKugel          kugel;
     ANagel          nagel;
     AEbene          ebene;
} AKoeParameter;

/* Koerper selbst */

typedef struct AKoerper
{
     struct AKoerper *next;		  /* Zeiger auf naechsten Koerper */
     TGrundFormen    art;		  /* ZYLINDER, QUADER, KUGEL, ... */
     unsigned short  AStatus;		  /* selected, hidden */
     AXColornum      farbnr;		  /* Farbnummer des Koerpers */
     AKraft          *kraft;		  /* Liste von Kraeften am Koerper */
     TVektor         k0[AnzahlAnsichten]; /* Koordinatenachsen: Ursprung, */
     TVektor         kx[AnzahlAnsichten]; /* x-Achsen-Endpunkt, */
     TVektor         ky[AnzahlAnsichten]; /* y-Achsen-Endpunkt und */
     TVektor         kz[AnzahlAnsichten]; /* z-Achsen-Endpunkt */
     AKoeParameter   param;		  /* koerperspezifische Daten */
} AKoerper;



/***********************************************************************
 *  Typen fuer Verbindungen vereinbaren. In diesen Typen werden alle fuer
 *  die Darstellung noetigen Werte der Verbindungen abgespeichert.
 ***********************************************************************/

/* Definition aller Eigenschaften, die bei den Verbindungen unterschiedlich sind */

typedef struct AFeder			  /* Feder braucht zusaetzlich noch */
{					  /* Info ueber Windungsanzahl */
     int windungen;
} AFeder;


typedef union AVerbParameter		  /* Union mit allen unterschiedlichen */
{					  /* Parametern */
     AFeder  feder;
     /* alle anderen Verbindungen haben keine extra Parameter mehr */
} AVerbParameter;


/* Verbindung selbst */

typedef struct AVerbindung
{
     struct AVerbindung *next;		  /* Zeiger auf naechste Verbindung */
     TVerbindungsart art;		  /* GELENK, DAEMPFER, FEDER oder STANGE" */
     unsigned short  AStatus;
     TVektor         anfang[AnzahlAnsichten]; /* Anfangs- und Endpunkt der */
     TVektor         ende[AnzahlAnsichten];   /* Verbindung */
     AVerbParameter  param;		  /* zusaetzliche Parameter der */
					  /* Verbindung (momentan nur Feder) */
} AVerbindung;



/***********************************************************************
 *  Darstellungsliste fuer die 4 Darstellungsfenster des Editors (Koerper,
 *  Verbindungen, Boden, etc.). Enthalten sind Daten fuer alle 4 Ansichten.
 ***********************************************************************/

typedef struct AZustand
{
     AKoerper      *koerper;
     AVerbindung   *verbindungen;
     /* ###hier noch Fussboden und weitere Elemente einfuegen ###*/
} AZustand;






#endif /* #ifndef DARSTELLUNG_H */ 
