/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: stoss.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: stoss.o
 *  letzte Aenderung	: 02.04.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *    Berechnet aus den momentanen Geschwindigkeiten zweier Koerper die
 *    neuen Geschw. nach dem Sto3.
 *  
 *  Versionsgeschichte:
 *  24.01.93	Erstellungsdatum
 *  02.04.93    Wegen ZusGesObj nun Materialien aus TeilKoerper?-> genommen!
 *  11.05.94    Compiler Warnings ausgebaut
 *  
 ********************************************************************************/

#include <stdio.h>


#include "stoss.h"
#include "gleichungsloeser.h"
#include "vektor.h"
#include "ausgabe.h"
#include "fehler.h"


int s_debug_level = 0;


#define ERG_R    0
#define ERG_V1   3
#define ERG_W1   6
#define ERG_V2   9
#define ERG_W2   12


static void StossGl(TReal m[15][16], TVektor k, TVektor i, TVektor j,
TVektor v1, TVektor w1, TVektor p1, TReal m1, TMatrix I1,
TVektor v2, TVektor w2, TVektor p2, TReal m2, TMatrix I2, TReal e)
/****************************************************************************
 * Stossgleichungen fuer zwei freie Koerper
 */
{
    int a, b;
    TVektor hv1, hv2;


    /* m[Zeile][Spalte] */ 

    for (a=0; a<15; a++)
      for (b=0; b<16; b++)
	m[a][b] = 0.0;

    m[0][0] = -1.0;
    m[0][3] = m1;
    m[0][15] = m1 * v1[0];

    m[1][1] = -1.0;
    m[1][4] = m1;
    m[1][15] = m1 * v1[1];

    m[2][2] = -1.0;
    m[2][5] = m1;
    m[2][15] = m1 * v1[2];


    m[3][0] = 1.0;
    m[3][9] = m2;
    m[3][15] = m2 * v2[0];

    m[4][1] = 1.0;
    m[4][10] = m2;
    m[4][15] = m2 * v2[1];

    m[5][2] = 1.0;
    m[5][11] = m2;
    m[5][15] = m2 * v2[2];


    m[6][1] = p1[2];
    m[6][2] = -p1[1];
    m[6][6] = I1[0][0];
    m[6][7] = I1[0][1];
    m[6][8] = I1[0][2];
    m[6][15] = I1[0][0]*w1[0] + I1[0][1]*w1[1] + I1[0][2]*w1[2];

    m[7][0] = -p1[2];
    m[7][2] = p1[0];
    m[7][6] = I1[1][0];
    m[7][7] = I1[1][1];
    m[7][8] = I1[1][2];
    m[7][15] = I1[1][0]*w1[0] + I1[1][1]*w1[1] + I1[1][2]*w1[2];

    m[8][0] = p1[1];
    m[8][1] = -p1[0];
    m[8][6] = I1[2][0];
    m[8][7] = I1[2][1];
    m[8][8] = I1[2][2];
    m[8][15] = I1[2][0]*w1[0] + I1[2][1]*w1[1] + I1[2][2]*w1[2];


    m[9][1] = -p2[2];
    m[9][2] = p2[1];
    m[9][12] = I2[0][0];
    m[9][13] = I2[0][1];
    m[9][14] = I2[0][2];
    m[9][15] = I2[0][0]*w2[0] + I2[0][1]*w2[1] + I2[0][2]*w2[2];

    m[10][0] = p2[2];
    m[10][2] = -p2[0];
    m[10][12] = I2[1][0];
    m[10][13] = I2[1][1];
    m[10][14] = I2[1][2];
    m[10][15] = I2[1][0]*w2[0] + I2[1][1]*w2[1] + I2[1][2]*w2[2];

    m[11][0] = -p2[1];
    m[11][1] = p2[0];
    m[11][12] = I2[2][0];
    m[11][13] = I2[2][1];
    m[11][14] = I2[2][2];
    m[11][15] = I2[2][0]*w2[0] + I2[2][1]*w2[1] + I2[2][2]*w2[2];

    m[12][0] = i[0];
    m[12][1] = i[1];
    m[12][2] = i[2];

    m[13][0] = j[0];
    m[13][1] = j[1];
    m[13][2] = j[2];

    m[14][3] = -k[0];
    m[14][4] = -k[1];
    m[14][5] = -k[2];
    m[14][6] = k[1]*p1[2] - k[2]*p1[1];
    m[14][7] = k[2]*p1[0] - k[0]*p1[2];
    m[14][8] = k[0]*p1[1] - k[1]*p1[0];
    m[14][9] = k[0];
    m[14][10] = k[1];
    m[14][11] = k[2];
    m[14][12] = k[2]*p2[1] - k[1]*p2[2];
    m[14][13] = k[0]*p2[2] - k[2]*p2[0];
    m[14][14] = k[1]*p2[0] - k[0]*p2[1];


    V_MUL(hv1, w1, p1);
    V_MUL(hv2, w2, p2);
    V_DEC(hv1, hv2);
    V_DEC(hv1, v2);
    V_INC(hv1, v1);
    m[14][15] = V_PRODUKT(hv1, k);
    m[14][15] *= e;

#ifndef NODEBUG
    if  (s_debug_level>3) {
	printf("m = \n");
	for (a=0; a<15; a++) {
	    for (b=0; b<16; b++)
	      printf("%+3.3f  ", m[a][b]);
	    printf("\n");
	}
    }
#endif
}




static void StossGl2(TReal m[9][10], TVektor k, TVektor i, TVektor j,
TVektor v1, TVektor w1, TVektor p1, TReal m1, TMatrix I1,
TVektor v2, TVektor w2, TVektor p2, TReal e)
/****************************************************************************
 * Stossgleichungen fuer freien Koerper gegen gefuehrten Koerper
 */
{
    int a, b;
    TVektor hv1, hv2;


    /* m[Zeile][Spalte] */ 

    for (a=0; a<9; a++)
      for (b=0; b<10; b++)
	m[a][b] = 0.0;

    m[0][0] = -1.0;
    m[0][3] = m1;
    m[0][9] = m1 * v1[0];

    m[1][1] = -1.0;
    m[1][4] = m1;
    m[1][9] = m1 * v1[1];

    m[2][2] = -1.0;
    m[2][5] = m1;
    m[2][9] = m1 * v1[2];


    m[3][1] = p1[2];
    m[3][2] = -p1[1];
    m[3][6] = I1[0][0];
    m[3][7] = I1[0][1];
    m[3][8] = I1[0][2];
    m[3][9] = I1[0][0]*w1[0] + I1[0][1]*w1[1] + I1[0][2]*w1[2];

    m[4][0] = -p1[2];
    m[4][2] = p1[0];
    m[4][6] = I1[1][0];
    m[4][7] = I1[1][1];
    m[4][8] = I1[1][2];
    m[4][9] = I1[1][0]*w1[0] + I1[1][1]*w1[1] + I1[1][2]*w1[2];

    m[5][0] = p1[1];
    m[5][1] = -p1[0];
    m[5][6] = I1[2][0];
    m[5][7] = I1[2][1];
    m[5][8] = I1[2][2];
    m[5][9] = I1[2][0]*w1[0] + I1[2][1]*w1[1] + I1[2][2]*w1[2];


    m[6][0] = i[0];
    m[6][1] = i[1];
    m[6][2] = i[2];


    m[7][0] = j[0];
    m[7][1] = j[1];
    m[7][2] = j[2];


    m[8][3] = -k[0];
    m[8][4] = -k[1];
    m[8][5] = -k[2];
    m[8][6] = k[1]*p1[2] - k[2]*p1[1];
    m[8][7] = k[2]*p1[0] - k[0]*p1[2];
    m[8][8] = k[0]*p1[1] - k[1]*p1[0];


    V_MUL(hv1, w1, p1);
    V_MUL(hv2, w2, p2);
    V_DEC(hv1, hv2);
    V_DEC(hv1, v2);
    V_INC(hv1, v1);
    m[8][9] = V_PRODUKT(hv1, k);
    m[8][9] *= e;

    V_MUL(hv1, w2, p2);
    V_INC(hv1, v2);
    m[8][9] -= V_PRODUKT(hv1, k);

#ifndef NODEBUG
    if  (s_debug_level>3) {
	printf("m = \n");
	for (a=0; a<9; a++) {
	    for (b=0; b<10; b++)
	      printf("%+3.3f  ", m[a][b]);
	    printf("\n");
	}
    }
#endif
}




void Stoss(TKollision *ko, TMaterialTabelle *mat)
/****************************************************************************
 * Stossbehandlung zwischen zwei Koerpern
 */
{
     TReal m[15][16];
     TReal m2[9][10];
     TKoerper *k1, *k2;
     TReal x[15];    
     TReal *p1, *p2;
     TMaterial mat1, mat2;
     TMatrix T1, T2, TH;

     FehlerOrt("Stoss()");

#ifndef NODEBUG
     if  (s_debug_level>=1) {
	 printf("Stoss(ko, mat) 1-\n");
     }
#endif

     /* Reihenfolge umdrehen falls Koerper1 ein gefuehrter Koerper ist 
      * => gefuehrte Koerper immer in k2
      */
     if (ko->Koerper1->BewTyp & MASSELOS) {
	 k2 = ko->Koerper1;
	 k1 = ko->Koerper2;
	 mat2 = ko->TeilKoerper1->Material;
	 mat1 = ko->TeilKoerper2->Material;
	 p2 = ko->Ort1;
	 p1 = ko->Ort2;
     } else {
	 k1 = ko->Koerper1;
	 k2 = ko->Koerper2;
	 mat1 = ko->TeilKoerper1->Material;
	 mat2 = ko->TeilKoerper2->Material;
	 p1 = ko->Ort1;
	 p2 = ko->Ort2;
     }

     

     if (k1->BewTyp & MASSELOS) {
	 Fehler("Kollision von zwei gefuehrten/masselosen Koerpern!");
     }


     /* Gefuehrter Koerper in k2 ! */

#ifndef NODEBUG
    if  (s_debug_level>=2) {
	
	printf("Stoss() 2- Masse1=%f, Masse2=%f\n", k1->Masse, k2->Masse);
	printvektor("Stoss() 2- koll.punkt p1 = ", p1);
	printvektor("Stoss() 2- koll.punkt p2 = ", p2);
	printvektor("Stoss() 2- koll.Normale = ", ko->Normale);
	printvektor("Stoss() 2- koll.EbeneVek1 = ", ko->EbenenVek1);
	printvektor("Stoss() 2- koll.EbeneVek2 = ", ko->EbenenVek2);
	printvektor("Stoss() 2- altes v1 =", k1->ty->v);
	printvektor("Stoss() 2- altes w1 =", k1->ty->w);
	printvektor("Stoss() 2- altes v2 =", k2->ty->v);
	printvektor("Stoss() 2- altes w2 =", k2->ty->w);


    }
#endif

     if (k2->BewTyp & MASSELOS) {

	 /* Traegheitstensoren in raumfeste Koord. wandeln 
	  */
	 MM_MUL(TH, k1->Traegheitstensor, k1->RotTrans);
	 MM_MUL(T1, k1->RotTrans1, TH);

	 StossGl2(m2, ko->Normale, ko->EbenenVek1, ko->EbenenVek2, 
		 k1->ty->v, k1->ty->w, p1, k1->Masse, T1 /*k1->Traegheitstensor*/,
		 k2->ty->v, k2->ty->w, p2,
		 Elastizitaet(mat, mat1, mat2));
	 if (LinGleichLoeser(9, (TReal *)m2, x)) {
	     if (s_debug_level>=1) {
		 printf("*** Fehler in Stoss()\n");
		 printf("*** Meldung: Konnte LinGlSys nicht loesen(1freierK)\n");
		 
		 printf("*** Masse1=%f, Masse2=%f\n", k1->Masse, k2->Masse);
		 printvektor("*** koll.punkt p1 = ", p1);
		 printvektor("*** p2 = ", p2);
		 printvektor("*** koll.Normale = ", ko->Normale);
		 printvektor("*** koll.EbeneVek1 = ", ko->EbenenVek1);
		 printvektor("*** koll.EbeneVek2 = ", ko->EbenenVek2);
		 printvektor("*** altes v1 =", k1->ty->v);
		 printvektor("*** altes w1 =", k1->ty->w);
		 printvektor("*** altes v2 =", k2->ty->v);
		 printvektor("*** altes w2 =", k2->ty->w);
		 
		 return;
	     }
	 }
     }
     else {
	 /* Traegheitstensoren in raumfeste Koord. wandeln 
	  */
	 MM_MUL(TH, k1->Traegheitstensor, k1->RotTrans);
	 MM_MUL(T1, k1->RotTrans1, TH);
	 MM_MUL(TH, k2->Traegheitstensor, k2->RotTrans);
	 MM_MUL(T2, k2->RotTrans1, TH);

	 StossGl(m, ko->Normale, ko->EbenenVek1, ko->EbenenVek2, 
		 k1->ty->v, k1->ty->w, p1, k1->Masse, T1 /*k1->Traegheitstensor*/,
		 k2->ty->v, k2->ty->w, p2, k2->Masse, T2 /* k2->Traegheitstensor */,
		 Elastizitaet(mat, mat1, mat2));
	 
	 if (LinGleichLoeser(15, (TReal *) m, x)) {
	     if (s_debug_level>=1) {
		 printf("*** Fehler in Stoss()\n");
		 printf("*** Meldung: Konnte LinGlSys nicht loesen!!!\n");
		 
		 printf("*** Masse1=%f, Masse2=%f\n", k1->Masse, k2->Masse);
		 printvektor("*** koll.punkt p1 = ", p1);
		 printvektor("*** p2 = ", p2);
		 printvektor("*** koll.Normale = ", ko->Normale);
		 printvektor("*** koll.EbeneVek1 = ", ko->EbenenVek1);
		 printvektor("*** koll.EbeneVek2 = ", ko->EbenenVek2);
		 printvektor("*** altes v1 =", k1->ty->v);
		 printvektor("*** altes w1 =", k1->ty->w);
		 printvektor("*** altes v2 =", k2->ty->v);
		 printvektor("*** altes w2 =", k2->ty->w);
	     
		 return;
	     }
	 }
     }

#ifndef NODEBUG
     if  (s_debug_level>=2) {
	 printvektor("Stoss() 2- Stoss R = ", &x[ERG_R]);
	 printvektor("Stoss() 2- neues v1 =", &x[ERG_V1]);
	 printvektor("Stoss() 2- neues w1 =", &x[ERG_W1]);
	 if ((k2->BewTyp & MASSELOS)==0) {
	     printvektor("Stoss() 2- neues v2 =", &x[ERG_V2]);
	     printvektor("Stoss() 2- neues w2 =", &x[ERG_W2]);
	 }
     }
#endif

     V_LET(k1->ty->v, &x[ERG_V1]);
     V_LET(k1->ty->w, &x[ERG_W1]);


     if ((k2->BewTyp & MASSELOS) == 0) {
	 V_LET(k2->ty->v, &x[ERG_V2]);
	 V_LET(k2->ty->w, &x[ERG_W2]);
     }

}




#if 0
/* Simultanstoss - untauglich
 *
 */
static void KoerperEintrag(TReal **ErgVar, int i, TReal *Matrix, int AnzGl,
		   int AnzSpalten, TKoerper *k)
{
    int MIndex;

    /* StossVariable in Koerperstruktur setzen sowie Zeiger wohin Erg 
     * geschrieben werden soll
     */
    k->StossVar = i;
    ErgVar[i  ] = &(k->ty->v[0]);
    ErgVar[i+1] = &(k->ty->v[1]);
    ErgVar[i+2] = &(k->ty->v[2]);
    ErgVar[i+3] = &(k->ty->w[0]);
    ErgVar[i+4] = &(k->ty->w[1]);
    ErgVar[i+5] = &(k->ty->w[2]);



   /* Linken Seiten von m*v' = m*v, I*w' = I*w (also die Unbekannten!) */ 

    MIndex = i + AnzSpalten*i;     /* m*v' */
    
    Matrix[MIndex] = k->Masse;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = k->Masse;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = k->Masse;


    MIndex = i + 3 + AnzSpalten*(i+3);     /* I*w' */

    Matrix[MIndex] = k->Traegheitstensor[0][0];
    Matrix[MIndex+1] = k->Traegheitstensor[0][1];
    Matrix[MIndex+2] = k->Traegheitstensor[0][2];
    MIndex += AnzSpalten;

    Matrix[MIndex] = k->Traegheitstensor[1][0];
    Matrix[MIndex+1] = k->Traegheitstensor[1][1];
    Matrix[MIndex+2] = k->Traegheitstensor[1][2];
    MIndex += AnzSpalten;

    Matrix[MIndex] = k->Traegheitstensor[2][0];
    Matrix[MIndex+1] = k->Traegheitstensor[2][1];
    Matrix[MIndex+2] = k->Traegheitstensor[2][2];



    /* Rechten Seiten von m*v' = m*v, I*w' = I*w */ 

    MIndex = AnzGl + AnzSpalten*i;                      /* m*v */

    Matrix[MIndex] = k->Masse * k->ty->v[0];
    MIndex += AnzSpalten;

    Matrix[MIndex] = k->Masse * k->ty->v[1];
    MIndex += AnzSpalten;

    Matrix[MIndex] = k->Masse * k->ty->v[2];
    MIndex += AnzSpalten;

    Matrix[MIndex] =                                   /* I*w */
      k->Traegheitstensor[0][0] * k->ty->w[0] +
	k->Traegheitstensor[0][1] * k->ty->w[1] +
	  k->Traegheitstensor[0][2] * k->ty->w[2];
    MIndex += AnzSpalten;

    Matrix[MIndex] =
      k->Traegheitstensor[1][0] * k->ty->w[0] +
	k->Traegheitstensor[1][1] * k->ty->w[1] +
	  k->Traegheitstensor[1][2] * k->ty->w[2];
    MIndex += AnzSpalten;

    Matrix[MIndex] =
      k->Traegheitstensor[2][0] * k->ty->w[0] +
	k->Traegheitstensor[2][1] * k->ty->w[1] +
	  k->Traegheitstensor[2][2] * k->ty->w[2];

}






void StossEintrag1(TReal *Matrix, int AnzGl, int AnzSpalten,
		   int RIndex, int K1Index,
		   TVektor v1, TVektor w1, TVektor p1, TReal m1,
		   TVektor v2, TVektor w2, TVektor p2, TReal m2,
		   TVektor k, TVektor i, TVektor j, TReal e) 
{
    int MIndex;
    TVektor hv1, hv2;
    TReal h;


    /* ..-R = mv fuer Koerper1 */
    MIndex = RIndex + K1Index*AnzSpalten;
    
    Matrix[MIndex] = -1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = -1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = -1.0;

    
    /* ..-pxR = I*w fuer Koerper 1 */
    MIndex = RIndex + (K1Index+3)*AnzSpalten;

    Matrix[MIndex+1] = p1[2];
    Matrix[MIndex+2] = -p1[1];
    MIndex += AnzSpalten;

    Matrix[MIndex] = -p1[2];
    Matrix[MIndex+2] = p1[0];
    MIndex += AnzSpalten;

    Matrix[MIndex] = p1[1];
    Matrix[MIndex+1] = -p1[0];



/*  -m1(v1'+w1xp1) + m2(v2'+w2xp2) = -e/(e+1)*R
 */



    MIndex = RIndex*AnzSpalten;

    V_MUL(hv1, w1, p1);
    V_INC(hv1, v1);
    h = m1;
    V_SKALAR(hv1, hv1, h);

    V_MUL(hv2, w2, p2);    
    V_INC(hv2, v2);
    h = m2;
    V_SKALAR(hv2, hv2, h);

    Matrix[MIndex+K1Index] = -m1;
/*    Matrix[MIndex+RIndex] = -1.0; */
    Matrix[MIndex+RIndex] = e/(e+1.0); 
    Matrix[MIndex+K1Index+4] = -m1 * p1[2];
    Matrix[MIndex+K1Index+5] = m1 * p1[1];
    Matrix[MIndex+AnzGl] = - hv2[0]; 

    MIndex += AnzSpalten;

    Matrix[MIndex+1+K1Index] = -m1;
/*    Matrix[MIndex+RIndex+1] = -1.0; */
    Matrix[MIndex+RIndex+1] = e/(e+1.0); 
    Matrix[MIndex+K1Index+3] = m1 * p1[2];
    Matrix[MIndex+K1Index+5] = -m1 * p1[0];
    Matrix[MIndex+AnzGl] =  - hv2[1]; 

    MIndex += AnzSpalten;

    Matrix[MIndex+2+K1Index] = -m1;
/*    Matrix[MIndex+RIndex+2] = -1.0; */
    Matrix[MIndex+RIndex+2] = e/(e+1.0); 
    Matrix[MIndex+K1Index+3] = -m1 * p1[1];
    Matrix[MIndex+K1Index+4] = m1 * p1[0];
    Matrix[MIndex+AnzGl] =  - hv2[2]; 
    
}






void StossEintrag2(TReal *Matrix, int AnzGl, int AnzSpalten,
		   int RIndex, int K1Index, int K2Index,
		   TVektor v1, TVektor w1, TVektor p1, TReal m1,
		   TVektor v2, TVektor w2, TVektor p2, TReal m2,
		   TVektor k, TVektor i, TVektor j, TReal e) 
{
    int MIndex;
    TVektor hv1, hv2;



    /* ..-R = (mv) fuer Koerper1 */
    MIndex = RIndex + K1Index*AnzSpalten;
    
    Matrix[MIndex] = -1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = -1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = -1.0;

    
    /* ..-pxR = I*w fuer Koerper 1 */
    MIndex = RIndex + (3+K1Index)*AnzSpalten;

    Matrix[MIndex+1] = p1[2];
    Matrix[MIndex+2] = -p1[1];
    MIndex += AnzSpalten;

    Matrix[MIndex] = -p1[2];
    Matrix[MIndex+2] = p1[0];
    MIndex += AnzSpalten;

    Matrix[MIndex] = p1[1];
    Matrix[MIndex+1] = -p1[0];



    /* ..+R = (mv) fuer Koerper2 */

    MIndex = RIndex + K2Index*AnzSpalten;
    
    Matrix[MIndex] = 1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = 1.0;
    MIndex += AnzSpalten+1;

    Matrix[MIndex] = 1.0;
    
   
    /* ..+pxR = I*w fuer Koerper 2 */
    MIndex = RIndex + (K2Index+3)*AnzSpalten;

    Matrix[MIndex+1] = p2[2];
    Matrix[MIndex+2] = -p2[1];
    MIndex += AnzSpalten;

    Matrix[MIndex] = -p2[2];
    Matrix[MIndex+2] = p2[0];
    MIndex += AnzSpalten;

    Matrix[MIndex] = p2[1];
    Matrix[MIndex+1] = -p2[0];



/*  -m1(v1'+w1xp1) + m2(v2'+w2xp2) = -e/(e+1)*R
 */



    MIndex = RIndex*AnzSpalten;

    Matrix[MIndex+K1Index] = -m1;
    Matrix[MIndex+K1Index+4] = -m1 * p1[2];
    Matrix[MIndex+K1Index+5] = m1 * p1[1];
    Matrix[MIndex+K2Index] = m2;
    Matrix[MIndex+K2Index+4] = m2 * p2[2];
    Matrix[MIndex+K2Index+5] = -m2 * p2[1];
    Matrix[MIndex+RIndex] = e/(e+1.0); 

    MIndex += AnzSpalten;

    Matrix[MIndex+K1Index+1] = -m1;
    Matrix[MIndex+K1Index+3] = m1 * p1[2];
    Matrix[MIndex+K1Index+5] = -m1 * p1[0];
    Matrix[MIndex+K2Index+1] = m2;
    Matrix[MIndex+K2Index+3] = -m2 * p2[2];
    Matrix[MIndex+K2Index+5] = m2 * p2[0];
    Matrix[MIndex+RIndex+1] = e/(e+1.0); 

    MIndex += AnzSpalten;

    Matrix[MIndex+K1Index+2] = -m1;
    Matrix[MIndex+K1Index+3] = -m1 * p1[1];
    Matrix[MIndex+K1Index+4] = m1 * p1[0];
    Matrix[MIndex+K2Index+2] = m2;
    Matrix[MIndex+K2Index+3] = m2 * p2[1];
    Matrix[MIndex+K2Index+4] = -m2 * p2[0];
    Matrix[MIndex+RIndex+2] = e/(e+1.0); 
}







void SimStoss(TKollision *kol, TMaterialTabelle *mat)
{
    TKollision *ko;
    TKoerper *k1, *k2;    
    TReal *p1, *p2;
    TReal *Matrix;
    TReal *Erg;
    TReal **ErgVar;
    int AnzStoesse, AnzFreieKoerper;
    int AnzGl, AnzElem, AnzSpalten;
    int i, j;
    int RIndex;


    FehlerOrt("SimStoss()");

#ifndef NODEBUG
    if (s_debug_level>=1) printf("SimStoss(kol, mat) 1-\n");
#endif


    /* Ermittle Anzahl der Momentane Stoesse und die Anzahl der darin 
     * verwickelten Koerper (selben Koerper nicht mehrmals zaehlen!)
     */
    for (ko=kol; ko; ko=ko->Naechste) {
	if (ko->Art == KOLLISION) {
	    ko->Koerper1->StossVar = 1;
	    ko->Koerper2->StossVar = 1;
	    ko->Koerper1->SVunbelegt = TRUE;
	    ko->Koerper2->SVunbelegt = TRUE;
	}
    }

    AnzStoesse = 0;
    AnzFreieKoerper = 0;
    for (ko=kol; ko; ko=ko->Naechste) {
	if (ko->Art == KOLLISION) {
	    AnzStoesse++;
	    if ((ko->Koerper1->BewTyp) & FREI) {
		AnzFreieKoerper+= ko->Koerper1->StossVar;
		ko->Koerper1->StossVar = 0;
	    }
	    if ((ko->Koerper2->BewTyp) & FREI) {
		AnzFreieKoerper+= ko->Koerper2->StossVar;
		ko->Koerper2->StossVar = 0;
	    }
	}
    }

#ifndef NODEBUG
    if (s_debug_level>=1)
      printf("SimStoss(t) 1- AnzStoesse=%d, AnzFreieKoerper=%d\n", 
	     AnzStoesse, AnzFreieKoerper);
#endif

    if (AnzStoesse == 0) return;


    /* Speicher bereitstellen fuer Gleichungssystem 
     */

    AnzGl = 3*AnzStoesse + 6*AnzFreieKoerper;
    AnzSpalten = AnzGl+1;
    AnzElem = AnzSpalten*AnzGl;

    Matrix = (TReal *)malloc(AnzElem* sizeof(TReal));
    if (Matrix==NULL) Fehler("Kann Speicher nicht anfordern");

    for (i=0; i<AnzElem; i++)
      Matrix[i] = 0.0;

    ErgVar = (TReal **)malloc(AnzFreieKoerper*6*sizeof(TReal *));
    if (ErgVar==NULL) Fehler("Kann Speicher nicht anfordern");

    Erg = (TReal *)malloc(AnzGl*sizeof(TReal));
    if (Erg==NULL) Fehler("Kann Speicher nicht anfordern");


    /* Jedem involviertem Koerper ein Variablennummer geben
     * -> linke Spalte von v[0]v[1]v[2]w[0]w[1]w[2] (-> StossVar zeigt auf v[0])
     * gleichzeitig wird dem Stossvektor eine Zieladr mittgeteilt indem die
     * Loesung hineigeschrieben werden soll. (Sprich ty->v, ty->w)
     * Koerperspeziefische Gleichungen m*v'=m*v und I*w'=I*w eintragen.
     */
    i = 0;
    for (ko=kol; ko; ko=ko->Naechste) {
	if (ko->Art == KOLLISION) {
	    if (((ko->Koerper1->BewTyp) & FREI) && ko->Koerper1->SVunbelegt) {
		KoerperEintrag(ErgVar, i, Matrix, AnzGl, AnzSpalten, ko->Koerper1);
		i += 6;
		ko->Koerper1->SVunbelegt = FALSE;
	    }

	    if (((ko->Koerper2->BewTyp) & FREI) && ko->Koerper2->SVunbelegt) {
		KoerperEintrag(ErgVar, i, Matrix, AnzGl, AnzSpalten, ko->Koerper2);
		i += 6;
		ko->Koerper2->SVunbelegt = FALSE;
	    }
	}
    }



    RIndex = AnzFreieKoerper*6;
    /*
     * Stossspezifische Gleichungen +/-R, +p1xR1, -p2xR2, R*i=0, R*j=0
     * k*(v2'+w2'xp2-v1'-w1'xp1) = e * k * (v1+w1xp1-v2-w2xp2)
     * in Matrix eintragen.
     */
    for (ko=kol; ko; ko=ko->Naechste) 
      if (ko->Art == KOLLISION) {
	  
	  k1 = ko->Koerper1;
	  
	  if (k1->BewTyp & MASSELOS) {
	      k2 = k1;
	      k1 = ko->Koerper2;
	      p1 = ko->Ort2;
	      p2 = ko->Ort1;
	  } 
	  else {
	      k2 = ko->Koerper2;
	      p1 = ko->Ort1;
	      p2 = ko->Ort2;
	  }
	  
	  
	  if (k1->BewTyp & MASSELOS)
	    Fehler("Stoss zwischen zwei masselosen Koerpern!");
	  
	  if (k2->BewTyp & MASSELOS) {  /* Frei bew. Koerper <-> Masselos */
	      StossEintrag1(Matrix, AnzGl, AnzSpalten, RIndex, k1->StossVar,
			    k1->ty->v, k1->ty->w, p1, k1->Masse,
			    k2->ty->v, k2->ty->w, p2, k2->Masse,
			    ko->Normale, ko->EbenenVek1, ko->EbenenVek2,
			    Elastizitaet(mat, mat1, mat2));
	  }
	  else {
	      StossEintrag2(Matrix, AnzGl, AnzSpalten, RIndex,
			    k1->StossVar, k2->StossVar,
			    k1->ty->v, k1->ty->w, p1, k1->Masse,
			    k2->ty->v, k2->ty->w, p2, k2->Masse,
			    ko->Normale, ko->EbenenVek1, ko->EbenenVek2,
			    Elastizitaet(mat, mat1, mat2));
	      
	  }
	  RIndex += 3;
      }


#ifndef NODEBUG
    if (s_debug_level>=3) {
	printf("SimStoss() 3- Matrix[%d][%d] = \n", AnzGl, AnzSpalten);
	for (i=0; i<AnzGl; i++) {
	    for (j=0; j<AnzSpalten; j++)
	      printf("%+2.2f ", Matrix[i*AnzSpalten+j]);
	    printf("\n");
	}
    }
#endif



    if (LinGleichLoeser(AnzGl, Matrix, Erg)) {
	printf("SimStoss() *** Kann Stoss-Matrix nicht aufloesen\n");
	return;
    }

    /* Ergebnis zurueckkopieren
     */
    for (i=AnzFreieKoerper*6 - 1; i>=0; i--) {
	*ErgVar[i] = Erg[i];
#ifndef NODEBUG
	if (s_debug_level>=2) printf("SimStoss() 2- ErgVar[%d] = %f\n",
				     i, Erg[i]);
#endif
    }


    free(Matrix);
    free(Erg);
    free(ErgVar);
}

#endif
