/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           ZusgesObjekt.c
 *  Filetyp:            Modul
 ********************************************************************************
 *  Modulname:          ZusgesObjekt
 *  Version:            1.0
 *  letzte Aenderung:
 *  Autor:              Andreas
 *  Status:             finished, only bugs will be fixed
 *
 *  imp. Bezeichner:
 *
 *  exp. Bezeichner:
 *
 *  Beschreibung:
 *  -------------
 *
 *  Fehler:
 *  -------
 *
 *  Versionsgeschichte:
 *  -------------------
 *   22.05.93: Erstellen der Objekt-Funktionen.
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Paned.h>

#include <string.h>
#include "Welt.h"
#include "Editor.h"

/********************************************************************************
 *  Importierte Funktionen aus unterschiedlichen 'Modulen'.
 ********************************************************************************/
   extern  void AnzeigeDarstellung(Widget, Widget, Widget, Widget, TVektor darstpos,
                                   TQuaternion q, TReal zoom, TZustand *zustand,
                                   int modus);
   extern  void SelektAllButtons( TBoolean );
   extern  void HighLight( TKoerper * );
   extern  void UnHighLight( TKoerper * );
   extern  void toggleNOStatus( TBoolean );
   extern  void DObjektEinfuegen( void );
   extern  void entferneObjektVerb (TKoerper *);

/********************************************************************************
 *  Importierte Bezeichner (global definiert)
 ********************************************************************************/

static Widget GZO_Shell, GZO_Next, GZO_Apply, GZO_Abort, GZO_Done;
static TKoerper *hangel, *newZObjekt;
static int AnzahlKoerper;




static  void initVektor (TVektor a)
{
     a[0] = 0.0;
     a[1] = 0.0;
     a[2] = 0.0;
}


/*******************************************************************************
 *  void initGZObjekt( Widget w, XtPointer muell, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine z"ahlt zuerst die Anzahl freier K"orper. Ist die Anzahl Null,
 *  k"onnen keine Objekte zusammengesetzt werden und die Routine wird verlassen.
 *  Ist die Zahl gr"o"ser als Null, wird ein Objekt angelegt und mit f"ur ein
 *  zusammengestztes Objekt notwendigen Parameter versehen. Das Objekt wird 
 *  allerdings noch nicht in die K"orperliste eingeh"angt.
 ********************************************************************************/

void initGZObjekt( Widget w, XtPointer muell, XtPointer garbage )
{
   TKoerper *help;
   
   AnzahlKoerper = 0;
   help = aktuelleWelt->Welt.Koerper;
   while( help != NULL )
   {
      if( help->Art != ZUSGESOBJ )
         AnzahlKoerper ++;
      help = help->Naechster;
   }
   if( AnzahlKoerper == 1 )
      XtSetSensitive( GZO_Next, FALSE );
   else if( AnzahlKoerper > 1 )
      XtSetSensitive( GZO_Next, TRUE );
   else return;
   XtSetSensitive( GZO_Apply, TRUE );
   newZObjekt = (TKoerper *) malloc( sizeof(TKoerper) );
   SpeicherFrei( newZObjekt );
   newZObjekt->Art = ZUSGESOBJ;
   newZObjekt->Kraefte = NULL;
   newZObjekt->Form.ZusGesObj.KoerperListe = NULL;
   initVektor( newZObjekt->Geschwindigkeit );
   initVektor( newZObjekt->Drehgeschwindigkeit );
   initVektor( newZObjekt->Beschleunigung );
   initVektor( newZObjekt->Drehbeschleunigung );
   hangel = selektiertesObjekt;
   toggleNOStatus( FALSE );
   SelektAllButtons( FALSE );
   XtPopup( GZO_Shell, XtGrabNone );
}


/*******************************************************************************
 *  void loeseGruppe( Widget w, XtPointer muell, XtPointer garbage )
 *
 *  Beschreibung:
 *  -------------
 *  Diese Routine wird aufgerufen, wenn ein zusammengesetztes Objekt wieder auf- 
 *  gel"ost werden soll. Es ist zu beachten, da"s Verbindung zu anderen Objekten
 *  bestehen k"onnen. Diese werden mit der Routine 'entferneObjektVerb' entfernt.
 *  Jedes Objekt, das zum zusammengesetzten Objekt geh"ort hat, mu"s aus dessen 
 *  Objektliste in die allgemeine Objektliste "ubernommen werden. Jetzt mu nur
 *  noch das selektierte Objekt aus der Liste entfernt werden. Da die guppierten
 *  Objekte alle am Anfang der Liste eingefgt wurden, kann das selektierte
 *  Objekt nicht mit dem 
 ********************************************************************************/

void loeseGruppe (Widget w, XtPointer muell, XtPointer garbage)
{
     TKoerper *help;
   
     if (selektiertesObjekt->Art == ZUSGESOBJ)
     {
	  entferneObjektVerb(selektiertesObjekt);
	  UnHighLight (selektiertesObjekt);
	  help = selektiertesObjekt->Form.ZusGesObj.KoerperListe;
	  while (help != NULL)
	  {
	       selektiertesObjekt->Form.ZusGesObj.KoerperListe = help->Naechster;
	       help->Naechster = aktuelleWelt->Welt.Koerper;
	       aktuelleWelt->Welt.Koerper = help;
	       KoeIniMech (help, aktuelleWelt->Welt.MaterialDaten);
	       help = selektiertesObjekt->Form.ZusGesObj.KoerperListe;
	  }
	  help = aktuelleWelt->Welt.Koerper;
	  while (help != NULL && help->Naechster != selektiertesObjekt)
	       help = help->Naechster;
	  if (help == NULL)
	       fprintf (stderr,"Something went terribly wrong (loeseGruppe)\n");
	  else
	  {
	       help->Naechster = selektiertesObjekt->Naechster;
	       free (selektiertesObjekt);
	  }
	  selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	  HighLight (selektiertesObjekt);
	  SelektAllButtons (TRUE);
	  DObjektEinfuegen ();
     }
     else 
	  fprintf (stderr,"selected object is not a grouped object!\n");
}


void GZObjektAbort( Widget w, XtPointer muell, XtPointer garbage )
{
   TKoerper *help;
   
   UnHighLight( hangel );
   XtPopdown( GZO_Shell );
   help = newZObjekt->Form.ZusGesObj.KoerperListe;
   while( help != NULL )
   {
      newZObjekt->Form.ZusGesObj.KoerperListe = help->Naechster;
      help->Naechster = aktuelleWelt->Welt.Koerper;
      aktuelleWelt->Welt.Koerper = help;
      help = newZObjekt->Form.ZusGesObj.KoerperListe;
   }
   free( newZObjekt );
   HighLight( selektiertesObjekt );
   SelektAllButtons( TRUE );
   DObjektEinfuegen();
}


/*******************************************************************************
 *  void GZObjektDone (Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Wird die Taste 'done' gedr"uckt, hat der Benutzer alle Objekte zu einer 
 *  Gruppe zusammengef"ugt. Das Zusammengesetzte Objekt kann jetzt in die 
 *  K"orperliste "ubernommen werden, wenn die Anzahl der Objekte gr"o"ser als
 *  Null ist. 
 *
 *  Da innerhalb eines zusammengesetzten Objektes keine Kr"afte wirken d"urfen,
 *  m"ussen evtl. vorhandene Kr"afte entfernt werden. 
 ********************************************************************************/

void GZObjektDone (Widget w, XtPointer muell, XtPointer garbage)
{
     /* ist kein K"orper in der K"orperListe, darf das zusammengesetzte Objekt
	nicht in die K"orperListe "ubernommen werden
	*/
     TKoerper *help;
     TKraft *Khelp;
     
     XtPopdown (GZO_Shell);
     
     if (newZObjekt->Form.ZusGesObj.KoerperListe == NULL)
	  free (newZObjekt);
     else
     {
	  KoerperId++;
	  newZObjekt->KoerperId = KoerperId;
	  newZObjekt->Naechster = aktuelleWelt->Welt.Koerper;
	  KoeIniMech (newZObjekt, aktuelleWelt->Welt.MaterialDaten);
	  aktuelleWelt->Welt.Koerper = newZObjekt;
	  selektiertesObjekt = newZObjekt;
	  help = newZObjekt->Form.ZusGesObj.KoerperListe;
	  while (help != NULL)
	  {
	       Khelp = help->Kraefte;
	       entferneObjektVerb(help);
	       while (Khelp != NULL)
	       {
		    help->Kraefte = Khelp->Naechste;
		    free (Khelp);
		    Khelp = help->Kraefte;
	       }
	       help = help->Naechster;
	  }
     }
     UnHighLight (hangel);
     HighLight (selektiertesObjekt);
     SelektAllButtons (TRUE);
     DObjektEinfuegen ();
}


/* In dieser Routine mu"s zweierlei erfolgen:
     1. Das ausgew"ahlte Objekt aus der K"orperListe aush"angen und
     2. es in die Liste der Zusammengesetzten Objekte tun.
   Zudem hat das ausgew"ahlte Objekt jetzt einen 'Oberk"orper'!
*/
     
void GZObjektApply( Widget w, XtPointer muell, XtPointer garbage )
{
   TKoerper *help;
   
   UnHighLight( hangel );
   help = aktuelleWelt->Welt.Koerper;
   if( help == hangel ) /* erster Krper */
   {
      aktuelleWelt->Welt.Koerper = help->Naechster;
      help->Naechster = newZObjekt->Form.ZusGesObj.KoerperListe;
      newZObjekt->Form.ZusGesObj.KoerperListe = help;
   }
   else 
   {
      while( help != NULL && help->Naechster != hangel )
         help = help->Naechster;
      if( help != NULL ) /* sollte immer der Fall sein */
      {
         help->Naechster = hangel->Naechster;
         hangel->Naechster = newZObjekt->Form.ZusGesObj.KoerperListe;
         newZObjekt->Form.ZusGesObj.KoerperListe = hangel;
      }
      else fprintf( stderr,"Something went terribly wrong (GZObjektApply)\n");
   }
   hangel->OberKoerper = newZObjekt;
   AnzahlKoerper --;
   if( AnzahlKoerper == 0 )
   {
      XtSetSensitive( GZO_Apply, FALSE );
      AnzeigeDarstellung( EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus );
   }
   else
   { 
      if( AnzahlKoerper == 1 )
	 XtSetSensitive( GZO_Next, FALSE );
      hangel = aktuelleWelt->Welt.Koerper;
      while( hangel->Art == ZUSGESOBJ )
      {     
	 if( hangel->Naechster != NULL )
	    hangel = hangel->Naechster;
      }
      HighLight( hangel );
   }
}


/* Diese Routine k"onnte etwas besser strukturiert werden, wenn
   gewisse Annahmen getroffen werden w"urden. Eine dieser Annahmen
   ist es, da"s beim Gruppieren des letzten Objektes die Routine
   verlassen wird, da kein weiteres Element mehr in der Liste ist.
   Es lassen sich mit dieser sinnvollen Annahme einige Unsch"onheiten
   bzw. unntige Schleifen beseitigen.
*/

void GZObjektNext( Widget w, XtPointer muell, XtPointer garbage )
{
   UnHighLight( hangel );
   do
   {
      if( hangel->Naechster != NULL )
         hangel = hangel->Naechster;
      else 
         hangel = aktuelleWelt->Welt.Koerper;
   } while( hangel->Art == ZUSGESOBJ );
   HighLight( hangel );
}


void installGruppiereZusammengestztesObjekt( void )
{
   Widget GZO_paned, GZO_box, GZO_label;
   
   GZO_Shell = XtVaCreatePopupShell("Select ...",   topLevelShellWidgetClass, topLevel, NULL );
   GZO_paned = XtVaCreateManagedWidget("GZO_paned", panedWidgetClass,   GZO_Shell, NULL );
   GZO_label = XtVaCreateManagedWidget("GZO_label", labelWidgetClass,   GZO_paned, NULL );
   GZO_box   = XtVaCreateManagedWidget("GZO_box",   formWidgetClass,    GZO_paned, NULL );
   GZO_Next  = XtVaCreateManagedWidget("GZO_Next",  commandWidgetClass, GZO_box,   NULL );
   GZO_Apply = XtVaCreateManagedWidget("GZO_Apply", commandWidgetClass, GZO_box,   NULL );
   GZO_Done  = XtVaCreateManagedWidget("GZO_Done",  commandWidgetClass, GZO_box,   NULL );
   GZO_Abort = XtVaCreateManagedWidget("GZO_Abort", commandWidgetClass, GZO_box,   NULL );
   
   XtAddCallback( GZO_Next,  XtNcallback, GZObjektNext,  NULL );
   XtAddCallback( GZO_Apply, XtNcallback, GZObjektApply, NULL );
   XtAddCallback( GZO_Abort, XtNcallback, GZObjektAbort, NULL );
   XtAddCallback( GZO_Done,  XtNcallback, GZObjektDone,  NULL );
}
