/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		autils.h
 *  Filetyp:		Header
 ********************************************************************************
 *  Modulname:		autils.c
 *  Version:		5
 *  letzte Aenderung:	Montag, 13. Februar 1995, 12:03:04
 *  Autor:  		Hartmut 
 *  Status:		passt auf das autils.c mit gleicher Version
 *										
 *  imp. Bezeichner:	
 * 
 *  exp. Bezeichner:    keine, nur lokales Headerfile fuer mich
 *  										
 *  Beschreibung:	
 *  -------------	
 *  Lokaler (=privater) Header fuer die Darstellungs- und  Animationsroutinen.
 *  Hier sind alle extern-Prototypen fuer das Modul autils.c definiert.
 *  Jedes Modul, das diese Utility-Routinen benutzen will, muss nur einfach
 *       #include autils.h 
 *  durchfuehren.
 *										
 *  Versionsgeschichte:								
 *  -------------------			
 *  Siehe autils.c
 ********************************************************************************/

#ifndef AUTILS_H
#define AUTILS_H

#include "visualisierung.h"


/***********************************************************************
 *  Farbtabelle, die auf dem momentanen Screen gilt
 ***********************************************************************/

extern Colormap a_colormap;



/***********************************************************************
 *  Fehlerroutine bei Darstellung
 ***********************************************************************/

extern void AFehler(char *fehlertext);



/****************************************************************************
 *  Diese Routinen sind nur fuer die Fehlersuche gedacht, darum auch keine
 *  ordentliche Dokumentation.
 *
 *  DumpMatrix: angegebene 4x4-Matrix ausgeben, dazu den Text
 *  DumpKoerper: Daten zu dem angegebenen Koerper ausgeben
 ***************************************************************************/

extern void DumpMatrix(AMatrix matrix, char *text);
extern void DumpKoerper(TKoerper *k);




/*****************************************************************************
 *  Funktion:       AXKoord TReal2AXKoord(TReal wert);
 *
 *  Parameter:      wert: Real-Wert, der nach AXKoord gewandelt werden soll
 *
 *  Rueckgabewert:  -
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Der angegebene Real-Wert wird in den Typ AXKoord gewandelt. Wird dabei
 *  der maximale Wertebereich von AXKoord ueberschritten, wird der maximale
 *  bzw. minimale Wert selbst angenommen.
 *****************************************************************************/

extern AXKoord TReal2AXKoord(TReal wert);




/*****************************************************************************
 *  Funktion:       void DeleteListe(void *zeiger);
 *  Parameter:      zeiger: Zeiger auf die Liste, die freigegeben werden soll
 *
 *  Rueckgabewert:  -
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Liste mit Bloecken, die mit malloc() reserviert wurden, wieder freigeben.
 *  Dazu muss die Liste derart verkettet sein, dass immer der erste Eintrag
 *  jedes Elements der Zeiger auf das naechste Element ist. Folgen keine wei-
 *  teren Elemente, muss der letzte Zeiger NULL sein. Die Art der Einzelele-
 *  mente ist egal.
 *****************************************************************************/

extern void DeleteListe(void *zeiger);




/*****************************************************************************
 *  Funktion:       void NormiereQuaternion(TQuaternion q);
 *
 *  Parameter:      q:  Quaternion, das normiert werden soll
 *
 *  Rueckgabewert:  q:  ist auch Rueckgabeparameter
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Das Quaternion q wird normiert, so dass q[0]^2+q[1]^2+q[2]^2+q[3]^2=1.
 *  Dies ist aufgrund von Rechenungenauigkeit manchmal nicht der Fall. Da
 *  aber manchmal eine sehr hohe Genauigkeit verlangt werden muss (z.B. in
 *  EulerWinkelFromQuaternion()), kann diese Routine aufgerufen werden.
 *  Danach ist obige Beziehung (Betrag=1) gegeben, falls q[0]^2<=1 ist. Ist
 *  q[0]^2>1, dann bleibt das Quaternion unveraendert.
 *****************************************************************************/

extern void NormiereQuaternion(TQuaternion q);





/*****************************************************************************
 *  Funktion:       void MatrixFromQuaternion(TQuaternion q, AMatrix M);
 *
 *  Parameter:      q:  Quaternion, das in eine Matrix gewandelt werden soll
 *
 *  Rueckgabewert:  M:  Zielmatrix (4x4)
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Das Quaternion q wird (moeglichst effizient) in die Matrix M gewandelt.
 *****************************************************************************/

extern void MatrixFromQuaternion(TQuaternion q, AMatrix M);




/*****************************************************************************
 *  Funktion:       void MatrixFrom_I_Quaternion(TQuaternion q, AMatrix M);
 *
 *  Parameter:      q:  Quaternion, dessen Inverses in eine Matrix gewandelt
 *                      werden soll
 *
 *  Rueckgabewert:  M:  Zielmatrix (4x4)
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Das Quaternion (q^-1) wird (moeglichst effizient) in die Matrix M gewandelt.
 *****************************************************************************/

extern void MatrixFrom_I_Quaternion(TQuaternion q, AMatrix M);





/*****************************************************************************
 *  Funktion:       void AQuaternionMult(TQuaternion a, TQuaternion b, 
 *                                                          TQuaternion x)
 *  Parameter:      a, b: die beiden Quellquaternions
 *
 *  Rueckgabewert:  x:    Zielquaternion, es darf sich dabei NICHT um a
 *                        oder b handeln, da keine Kopie angelegt wird.
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Das Quaternion a wird mit dem Quaternion b nach den Regeln der
 *  Quaternionmultiplikation multipliziert und das Ergebnis in x abgelegt.
 *  ACHTUNG! Da weder von a, noch von b eine Kopie angelegt wird und C bei
 *  Uebergabe von Feldern an Funktionen nur einen Zeiger uebergibt, werden
 *  bei a und b die Originalwerte verwendet. Gibt man als Ziel x also a oder
 *  b selbst an, wird das Ergebnis grob falsch!
 *****************************************************************************/

extern void AQuaternionMult(TQuaternion a, TQuaternion b, TQuaternion x);





/*****************************************************************************
 *  Funktion:       TBoolean MatrixVon2Punkten(TVektor p1, TVektor p2, AMatrix M)
 *
 *  Parameter:      p1, p2: Verbindungspunkte
 *
 *  Rueckgabewert:  TRUE:  es liess sich keine Matrix ausrechnen (Verbindung
 *                         hat Laenge 0)
 *                  FALSE: die berechnete Matrix (4x4) steht in M 
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Es wird die Matrix berechnet, die einen Koerper, der bei (0,0,0) bis
 *  (0,0,1) liegt, an die Position p1 bis p2 transformiert. Dabei wird der
 *  Koerper gestreckt und entsprechend gedreht.
 *  Diese Routine wird z.B. benoetigt, dreidimensional definierte
 *  Verbindungen wie Feder und Daempfer von ihrer Defaultposition an die
 *  entsprechenden Verbindungspunkte zu transformieren.
 *****************************************************************************/

extern TBoolean MatrixVon2Punkten(TVektor p1, TVektor p2, AMatrix M);





/*****************************************************************************
 *  Funktion:       void ANormiereVektor(TVektor v);
 *  Parameter:      v: der zu normierende Vektor
 *
 *  Rueckgabewert:  v: der normierte Vektor
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Der angegebene Vektor wird auf Laenge 1 normiert. Dabei wird immer der
 *  Vektor selbst veraendert!
 *****************************************************************************/

extern void ANormiereVektor(TVektor v);




/*****************************************************************************
 *  Funktion:       void AMatrixMult(AMatrix m1, AMatrix m2, AMatrix ziel);
 *  Parameter:      m1, m2: die beiden Quellmatrizen (4x4; berechnet: m1*m2)
 *
 *  Rueckgabewert:  ziel:   Zielmatrix (4x4), es darf sich dabei NICHT um m1
 *                          oder m2 handeln, da keine Kopie angelegt wird.
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Die Matrix m1 wird mit der Matrix m2 multipliziert und das Ergebnis in
 *  ziel abgelegt. Da weder von m1, noch von m2 eine Kopie angelegt wird und
 *  C bei Uebergabe von Feldern an Funktionen nur einen Zeiger uebergibt,
 *  werden bei m1 und m2 die Originalwerte verwendet. Gibt man als ziel also
 *  m1 oder m2 selbst an, wird das Ergebnis grob falsch!
 *****************************************************************************/

extern void AMatrixMult(AMatrix m1, AMatrix m2, AMatrix ziel);



/*****************************************************************************
 *  Funktion:       void AMatrixMult(AMatrix m1, AMatrix m2, AMatrix ziel);
 *  Parameter:      m1, m2: die beiden Quellmatrizen (4x4; berechnet: m1*m2)
 *
 *  Rueckgabewert:  ziel:   Zielmatrix (4x4), es darf sich dabei NICHT um m1
 *                          oder m2 handeln, da keine Kopie angelegt wird.
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Die Matrix m1 wird mit der Matrix m2 multipliziert und das Ergebnis in
 *  ziel abgelegt. Da weder von m1, noch von m2 eine Kopie angelegt wird und
 *  C bei Uebergabe von Feldern an Funktionen nur einen Zeiger uebergibt,
 *  werden bei m1 und m2 die Originalwerte verwendet. Gibt man als ziel also
 *  m1 oder m2 selbst an, wird das Ergebnis grob falsch!
 *****************************************************************************/

extern void AMatrixMult(AMatrix m1, AMatrix m2, AMatrix ziel);




/*****************************************************************************
 *  Funktion:       void ATransformation(TVektor punkt, AMatrix M, 
 *                                                 TReal x, TReal y, TReal z)
 *  Parameter:      M:     Entsprechende Matrix
 *                  x,y,z: Koordinaten des Punktes vor der Abbildung
 *                            
 *  Rueckgabewert:  punkt: Koordinaten des abgebildeten Punktes
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Multiplikation der Matrix M mit dem Punkt x,y,z, das Ergebnis wird in punkt
 *  abgelegt: punkt = M * (x,y,z)
 *****************************************************************************/


extern void ATransformation(TVektor punkt, AMatrix M, TReal x, TReal y, TReal z);





/*****************************************************************************
 *  Funktion:       void AGetColor(Display *display, Colormap farbtabelle, 
 *                                               XColor *farbe, char *routine)
 *  Parameter:      display,
 *                  farbtabelle,
 *                  farbe        : Parameter wie bei XAllocColor()
 *                  routine      : Name der aufrufenden Routine
 *                            
 *  Rueckgabewert:  punkt: Koordinaten des abgebildeten Punktes
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Es wird versucht, mit XAllocColor() die angegebene Farbe als Read-only
 *  zu allozieren. Wenn dies nicht klappt, wird eine Warnung (Text:
 *  "WARNING! xyz(): Color Lookup Table full, can't allocate color")
 *  ausgegeben und versucht, Schwarz als Farbe zu allozieren. Klappt dies
 *  auch nicht, wird eine Fehlermeldung ausgegeben. In letzterem Fall wird
 *  keine Farbe alloziert, was in einem Programmabbruch bei einem
 *  XFreeColors() enden kann. Ansonsten kann die allozierte Farbe wieder
 *  freigegeben werden.
 *  Anmerkung: die Warnung wird nur ausgegeben, wenn das Flag ColWarningDone
 *  nicht gesetzt ist. Nach einer Ausgabe der Warnung wird das Flag
 *  automatisch gesetzt.
 *****************************************************************************/

extern void AGetColor(Display *display, Colormap farbtabelle, XColor *farbe, char *routine);


/*****************************************************************************
 *  Funktion:       void AClearColWarningFlag(void)
 *
 *  Parameter:      -
 *                            
 *  Rueckgabewert:  -
 *
 *  Importierte Bezeichner: ColWarningDone
 *
 *  Beschreibung:
 *  -------------
 *  Das Flag wird, das angibt, ob schon eine Warnung ueber eine volle Farb-
 *  tabelle erfolgt ist, wird zurueckgesetzt, d.h. die Warnung wird beim
 *  naechsten erfolglosen Aufruf von AGetColor() wieder ausgegeben.
 *****************************************************************************/

extern void AClearColWarningFlag(void);

#endif   /* ifndef AUTILS_H*/

