/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: io.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: io.o
 *  letzte Aenderung	: 13.03.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *    Es werden Funktionen bereitgestellt um die Zustandsstruktur aus einem
 *    File einzulesen bzw. abzuspeichern.
 *    Des Weiteren werden Routinen zum Schreiben und Lesen der Materialtabelle 
 *    zur verfuegung gestellt.
 *  
 *    Die Definition des Fileformates ist in io.c zu finden.
 *  
 *  Exportierte Funktionen/Makros:
 *    TBoolean ReadZustand(TZustand **z, TMaterialTabelle *mt,
 *                         char *fname, FILE *handle);
 *    TBoolean WriteZustand(TZustand *z, char *fname, FILE *handle);
 *    TBoolean WriteMaterialien(TMaterialTabelle *mt, char *fname, FILE *handle);
 *    TBoolean ReadMaterialien(TMaterialTabelle **mt, char *fname, FILE *handle);
 *
 *  Noch zu machen:
 *    siehe io.c
 *    sind auch alle Sonderfaelle wie "out of disk space" beruecksichtigt??
 *
 *  Versionsgeschichte:
 *  15.02.93	Erstellungsdatum
 *  13.03.93    Support zum Lesen und Schreiben von Materialtabellen 
 *  
 ********************************************************************************/
#ifndef IO_H
#define IO_H

#ifndef ZUSTAND_H
#include "zustand.h"
#endif

#ifndef KONFIG_H
#include "konfig.h"
#endif



TBoolean ReadZustand(TZustand **z, TMaterialTabelle *mt, char *fname, FILE *handle);
/****************************************************************************
 * Zweck: Liest Zustandsstruktur in "lesbarer" Form aus einer Datei.
 *        Wenn fname!=NULL wird dazu eine Datei mit Name <fname> aufgemacht
 *        und von dort gelesen. (und danach wieder geschlossen)
 *        ansonsten wird vom Filehandle "handle" gelesen (aber nicht geschlossen).
 *        Somit ist es moeglich den Zustand als teil eines groesseren Files
 *        abzuspeichern.
 *        Die Materialtabelle ist noetig um den Materialtyp festzustellen, da
 *        keine Materialtabelle eingelesen wird!!
 *        Wird "mt"==NULL uebergeben so wird die Zustandsstruktur auf die
 *        Grundmaterialtabelle eingestellt.
 *        Tritt ein Fehler auf so wird im Fehlerkanal stderr eine Meldung
 *        erscheinen.
 *        Wenn fname==NULL muss handle ein gueltigen Filehandle aufweisen!
 *        Ansonsten ist der Inhalt von handle egal.
 *        Die Koerper werden uebrigens mit KoeIniMech(..) initialisiert!
 *        Die Ausgabe von Real-Zahlen erfolgt mit 8 Stelle!!!!!!
 *
 * Rueckgabewert:
 *   *z  => Zustandsstruktur (oder NULL)
 *   TRUE - Lesevorgang fehlerfei =>Zustandsstruktur in z korrekt.
 *   FALSE - Lesevorgang fehlerhaft =>Werte in Zustandsstruktur nicht korrekt belegt.
 *           Die Verzeigerung in z ist allerdings korrekt. Man sollte diesen
 *           Zustand am besten loeschen! (mit free(..) Speicher freigeben nicht 
 *           vergesse)
 *   
 * Seiteneffekte:
 *   keine
 *
 * Beispiel:
 *   #include "io.h"
 *   TZustand *mein_Z;
 *   if (ReadZustand(&mein_Z, NULL, "pendel.afz", NULL)==FALSE) 
 *      printf("Fehler aufgetreten\n"):
 *   
 * Fehler:
 *   Explizite angabe der Masse wird nicht beruecksichtigt.
 *   ansonsten siehe io.c
 *   
 *   
 */

TBoolean WriteZustand(TZustand *z, char *fname, FILE *handle);
/****************************************************************************
 * Zweck:
 *   Schreibt eine 'hoffentlich' korrekte Zustandsstruktur als File ab.
 *   (Materialtabelle wird nicht abgespeicher!)
 *   Falls fname!=NULL so wird extra ein File aufgemacht mit Name <fname>
 *   die Daten abgelegt und wieder geschlossen. Ansonsten wird das
 *   Filehandle handle benutzt (aber nicht mit fclose() geschlossen!)
 *   Eventuel wird beim auftreten eines ernsten Fehlers auch eine Meldung in
 *   stderr  erscheinen. 
 *   Die Zustandsdaten werden uebrigens in einem ASCII-File abgelegt.
 *   Man kann sie sich also auch anschauen und veraendern.
 *   Das Dateiformat ist dazu sehr einfach gehalten.
 *
 *   Wenn ein Filename uebergeben wurde so darf handle=NULL sein.(ist egal)
 *   
 * Rueckgabewert:
 *   TRUE  : Speichervorgang erfolgreich.
 *   FALSE : Fehler aufgetreten
 *   
 * Beispiel:
 *   #include "io.h"
 *   ..
 *   FILE *fh;
 *   fh = fopen("hoppla", "w");
 *   if (WriteZustand(z, NULL, fh)==FALSE) prinft("Fehler aufgetreten!\n");
 *   fclose(fh);
 *   
 * Fehler:
 *   ich denke nicht viele
 *   
 */


TBoolean WriteMaterialien(TMaterialTabelle *mt, char *fname, FILE *handle);
/****************************************************************************
 * Zweck:
 *   Schreibt eine Materialtabelle als Datei ab.
 *   Falls fname!=NULL so wird extra ein File aufgemacht mit Name <fname>
 *   die Daten abgelegt und wieder geschlossen. Ansonsten wird das
 *   Filehandle handle benutzt (aber nicht mit fclose() geschlossen!)
 *   Eventuel wird beim auftreten eines ernsten Fehlers auch eine Meldung in
 *   stderr  erscheinen. 
 *   Das Format der Datei ist in io.c einzusehen. (ASCII wie beim Zustand)
 *
 *   Wenn ein Filename uebergeben wurde so darf handle=NULL sein.(ist egal)
 *   
 * Rueckgabewert:
 *   TRUE  : Speichervorgang erfolgreich.
 *   FALSE : Fehler aufgetreten
 *   
 * Beispiel:
 *   #include "io.h"
 *   ..
 *   FILE *fh;
 *   fh = fopen("no so was!", "w");
 *   if (WriteMaterialien(MaterialTabelle, NULL, fh)==FALSE) prinft("Fehler aufgetreten!\n");
 *   fclose(fh);
 *   
 * Fehler:
 *   Wer weiss das schon?
 *
 * Bemerkung
 *   Bei der Ausgabe von Real-Zahlen werden nur 4 Nachkommastellen ausgegeben.
 *   Das muesse hier eigentlich reichen.
 *   
 *   
 */



TBoolean ReadMaterialien(TMaterialTabelle **mt, char *fname, FILE *handle);
/****************************************************************************
 * Zweck:
 *   Liest Materialtabelle aus der Datei mit Namen "<fname>".(Wenn fname!=NULL)
 *   Ist <fname>==NULL so wird das uebergebene Filehandle benutzt!
 *   Allerdings wird dann die Datei nicht geschlossen wie im 1.Fall.
 *   Falls fname!=NULL so wird der Parameter <handle> nicht benutzt!
 *   Falls in *mt nicht die GrundMaterialtabelle so wird bevor die neue Tabelle
 *   gelesen wird die alte geloescht!
 *   (Falls nichts geloescht werden soll ist in *mt NULL hineinzuschreiben!)
 *   
 * Rueckgabewert:
 *   TRUE  : Ladevorgang erfolgreich.
 *   FALSE : Fehler aufgetreten
 *   
 * Beispiel:
 *   #include "io.h"
 *   ..
 *   if (ReadMaterialien(&(z->MaterialTabelle), "dadada", NULL)==FALSE)
 *       prinft("Fehler aufgetreten!\n");
 *   
 * Fehler:
 *   Rand(DateiLaenge) * Geburtdatum_des_Programmierers - Sommersprossenanzahl
 *
 */


TBoolean WriteKonfiguration(TKonfigFBB *k, char *fname, FILE *handle);
/****************************************************************************
 * Zweck:
 *   Legt die Konfigurationsstruktur k als Datei ab.
 *   Falls fname!=NULL so wird extra ein File aufgemacht mit Name <fname>
 *   die Daten abgelegt und wieder geschlossen. Ansonsten wird das
 *   Filehandle handle benutzt (aber nicht mit fclose() geschlossen!)
 *   Eventuel wird beim auftreten eines ernsten Fehlers auch eine Meldung in
 *   stderr  erscheinen. 
 *   Das Format der Datei ist in io.c einzusehen. (ASCII wie beim Zustand)
 *
 *   Wenn ein Filename uebergeben wurde so darf handle=NULL sein.(ist egal)
 *   
 * Rueckgabewert:
 *   TRUE  : Speichervorgang erfolgreich.
 *   FALSE : Fehler aufgetreten
 *   
 * Beispiel:
 *   Analog zu ReadMaterialien(..)!
 *   
 * Fehler:
 *   # H2O-Molekuele im Universum - |{x | x ist PrimZahl}|
 *   
 */


TBoolean ReadKonfiguration(TKonfigFBB *k, char *fname, FILE *handle);
/****************************************************************************
 * Zweck:
 *   Liest Konfiguration der FBB aus der Datei mit Namen "<fname>". (fname!=NULL)
 *   Ist <fname>==NULL so wird das uebergebene Filehandle benutzt!
 *   Allerdings wird dann die Datei nicht geschlossen wie im 1.Fall.
 *   Falls fname!=NULL so wird der Parameter <handle> nicht benutzt!
 *   Falls in *mt nicht die GrundMaterialtabelle so wird bevor die neue Tabelle
 *   gelesen wird die alte geloescht!
 *   (Falls nichts geloescht werden soll ist in *mt NULL hineinzuschreiben!)
 *   
 * Rueckgabewert:
 *   TRUE  : Ladevorgang erfolgreich.
 *   FALSE : Fehler aufgetreten
 *   
 */

#endif

