/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: vektor.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: vektor.o
 *  letzte Aenderung	: 21.01.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: wurde schon oefters eingebunden
 *  
 *
 *  Exportierte Funktionen/Makros:
 *
 *    Matrix und Vektoroperationen auf den Typen TReal, TVektor, TMatrix aus
 *    "grundtypen.h"
 *
 *    TReal r, f:
 *    TQuaternion q;
 *    TVektor v, v1, v2 , i, j, k;
 *    TMatrix a, m;
 *
 *    r = V_PRODUKT(v1,v2);                     Zielvars: r,v, e1, e2
 *    r = V_BETRAG(v1);
 *    V_SKALAR(v, v1, f);
 *    V_NORM(v, v1);
 *    V_ADD(v, v1, v2);
 *    V_SUB(v, v1, v2);
 *    V_INC(v, v1);
 *    V_DEC(v, v1);
 *    V_ADD(v, v1, v2);
 *    V_MUL(v, v1, v2);
 *    V_LET(v, v1);
 *    V_SET(v, r1, r2, r3);
 *    
 *    MV_MUL(*v, *a, *v1);
 *    MV_MUL2(v, a, v1);
 *    RotMatrix(*m, q);                      liefert Transf. aus Quaternion
 *    EbenenVektoren(i, j, k);               Liefer Rechtssystem zu k, Normiert k 
 *
 *  Beschreibung:
 *    Liefert Makros und Prototypen fuer Vektor- und Matrix-Operationen
 *    und die Umsetzung von Eulerparametern in eine Transformationsmatrix.
 *  
 * 
 *  Versionsgeschichte:
 *  -------------------
 *  02.12.92      RotMatrix(..) aufgenommen
 *  03.12.92      V_INC und V_DEC zwecks Schreibersparnis eingefuehrt
 *  10.01.93      Typ TQuarternion beruecksichtigt
 *  21.01.93      MV_MUL2(..) eingebaut
 *  26.01.93      EbenenVektor(..) eingebaut.
 *  03.03.95      MM_ADD() und MM_TRANS() eingebaut.
 *  
 ********************************************************************************/
#ifndef VEKTOR_H
#define VEKTOR_H

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif


#define V_PRODUKT(a,b) ((a)[0]*(b)[0]+(a)[1]*(b)[1]+(a)[2]*(b)[2])
#define V_BETRAG(a) sqrt((a)[0]*(a)[0]+(a)[1]*(a)[1]+(a)[2]*(a)[2])
#define V_SKALAR(a,b,k) (a)[0]=(b)[0]*(k);(a)[1]=(b)[1]*(k);(a)[2]=(b)[2]*(k);
#define V_NORM(a,b) V_SKALAR(a,b,1.0/V_BETRAG(b))
#define V_ADD(a,b,c) (a)[0]=(b)[0]+(c)[0];(a)[1]=(b)[1]+(c)[1];(a)[2]=(b)[2]+(c)[2];
#define V_SUB(a,b,c) (a)[0]=(b)[0]-(c)[0];(a)[1]=(b)[1]-(c)[1];(a)[2]=(b)[2]-(c)[2];
#define V_INC(a,b) (a)[0]+=(b)[0];(a)[1]+=(b)[1];(a)[2]+=(b)[2];
#define V_DEC(a,b) (a)[0]-=(b)[0];(a)[1]-=(b)[1];(a)[2]-=(b)[2];
#define V_MUL(a,b,c) (a)[0]=(b)[1]*(c)[2]-(b)[2]*(c)[1];(a)[1]=(b)[2]*(c)[0]-(b)[0]*(c)[2];(a)[2]=(b)[0]*(c)[1]-(b)[1]*(c)[0];
#define V_LET(a,b) (a)[0]=(b)[0];(a)[1]=(b)[1];(a)[2]=(b)[2];
#define V_NEG(a,b) (a)[0]=-(b)[0];(a)[1]=-(b)[1];(a)[2]=-(b)[2];
#define V_SET(a,x,y,z) (a)[0]=x;(a)[1]=y;(a)[2]=z;
#define V_ADDSKAL(a,b,k,c) (a)[0]=(b)[0]+(k)*(c)[0];(a)[1]=(b)[1]+(k)*(c)[1];(a)[2]=(b)[2]+(k)*(c)[2];
#define V_SUBSKAL(a,b,k,c) (a)[0]=(b)[0]-(k)*(c)[0];(a)[1]=(b)[1]-(k)*(c)[1];(a)[2]=(b)[2]-(k)*(c)[2];

void MV_MUL(TVektor *x, TMatrix *a, TVektor *b);
void MV_MUL2(TVektor x, TMatrix a, TVektor b);
void RotMatrix(TMatrix Rot, TQuaternion q);
void RotMatrizen(TMatrix Rot, TMatrix Rot1, TQuaternion q);
void EbenenVektoren(TVektor i, TVektor j, TVektor k);
void Q_MUL(TQuaternion x, TQuaternion a, TQuaternion b);
TReal NormGeschw(TVektor v1, TVektor w1, TVektor p1, 
	   TVektor v2, TVektor w2, TVektor p2, TVektor n);
TReal TanGeschw(TVektor t, TVektor v1, TVektor w1, TVektor p1, 
	        TVektor v2, TVektor w2, TVektor p2, TVektor n);

void MultiGeschw(TReal *bt, TVektor t, TReal *bt1, TVektor t1, TReal *bt2, TVektor t2,/*o*/
		TVektor v1, TVektor w1, TVektor p1, 			/* in */
	        TVektor v2, TVektor w2, TVektor p2, TVektor n);

void MM_MUL(TMatrix x, TMatrix a, TMatrix b);
void MM_ADD(TMatrix x, TMatrix a, TMatrix b);
void MM_TRANS(TMatrix x, TMatrix a);

#endif
