/*
 * Functions for testing the RWI/ERB board
 *
 * Requires params.c to be loaded
 *
 */

native void
waitms(int ms)			/* waits ms milliseconds, up to 64K */
{			
  ms += *Mslo;
  if (ms > *Mslo) 
    while (ms >= *Mslo) {}
  else 
    while (ms <= *Mslo) {}
}


native void
t_status(int a)			/* blinks status light for a few seconds */
{
  while (--a) 
    {
      *Porta ^= Led_bit;
      waitms(200);
    }
}

native void
t_buzzer(int a)			/* pulses buzzer for a few seconds */
{
  int b = 1500;
  while (--a) 
    {
      printf("\n %d",a); 
      b -= b/20; 
      *Buzzer = b;
      waitms(100); 
      *Buzzer = 0;
      waitms(100); 
    }
}

