/**
 ** c.y                    
 ** Copyright 1990, 1991 Randy Sargent
 ** All rights reserved    
 **
 ** Modified by Kurt Konolige (1995)
 **/

/* TODO:
   lognot, bitnot.
   real ui
   arrays
   break correctly
   trig in radians
   jpfalse:  like jfalse, only pushes '0' on stack
   jptrue:   like jtrue, only pushes '1' on stack
   lognot, logidn
   assignment optimization
   push garbage optimization
   run-time error handling
   initialization of globals, correct string initialization
   */




/* c compiler:

   pass 0:
     declare types of global symbols:
        variable types
        function types (including return value type and argument types)
	constant types
     define values of global constants
     define locals (local stack offsets set automatically)
   pass 1:
     pretend to generate code;  just keep track of the PC
     set location of global symbols:
       set function locations
       define globals (global addresses set automatically)
     define locals (local stack offsets set automatically)
   pass 2:
     generate code
     define locals (local stack offsets set automatically)


BUGS:
   function pointers aren't implemented
   sizeof(expression) doesn't work (sizeof(type) works)
   */

%{

#include "core.h"

#define yylex module_get_token
#define TRUE 1
#define FALSE 0
    
int parser_verbose= 0;

Type *last_type;
Type *this_type;

#define YYSTYPE yystype
    
%}

%right EQUAL PLUSEQUAL MINUSEQUAL TIMESEQUAL DIVIDEEQUAL BITANDEQUAL BITIOREQUAL BITXOREQUAL LSHIFTEQUAL RSHIFTEQUAL
%left QUESTIONMARK COLON
%left LOGIOR
%left LOGAND
%left BITIOR  
%left BITXOR  
%left BITAND
%left LESSTHAN GREATERTHAN LESSTHANEQUAL GREATERTHANEQUAL EQUALEQUAL NOTEQUAL
%left LSHIFT RSHIFT  
%left PLUS MINUS
%left TIMES DIVIDE MODULO
%right PLUSPLUS MINUSMINUS
%left  LOGNOT BITNOT
%left  HANDLE DEREF
%left  LEFTPAREN RIGHTPAREN LEFTBRACKET

%token NEWLINE
%token FILE_SEPARATOR
  
%token SET_GLOBAL_ADDRESS
%token SET_CODE_ADDRESS
%token CI_STATEMENT

%token BINARY_MODULE
%token BINARY_SUBROUTINE_DEF
%token BINARY_VARIABLE_DEF

%token EXECUTE_ON_STARTUP
%token PERSISTENT
%token START_PROCESS  
%token KILL_PROCESS  
%token DEFER
%token INIT_INTERRUPTS
%token PEEK
%token ARRAY_SIZE
%token PEEKWORD
%token POKE
%token BENCHMARK
%token BITSET
%token BITCLR
%token POKEWORD
%token PRINTF
%token MSECONDS

%token EXCLUSIVE
%token WHENEVER
%token DONE_WHENEVER
%token BEHAVIOR
%token CONNECT
  
%token SIN
%token COS
%token TAN
%token SQRT
%token ATAN
%token LOG10
%token LOGE
%token EXP10
%token EXPE
  
%token NATIVE
%token CONST
%token VOID  
%token CHAR
%token INT
%token LONG
%token FLOAT

%token STRING
%token WHILE
%token FOR
%token IF
%token ELSE
%token RETURN
%token BREAK  

%token SYMBOL
%token FLOATING_POINT
%token INTEGER
%token LONG_INT
  
%token COMMA
%token SEMICOLON
%token RIGHTPAREN
%token LEFTBRACE
%token RIGHTBRACE
%token RIGHTBRACKET

%start file


%%
file :
    /* empty */
  | file top_level_form
  ;

top_level_form :
    directive
  | procedure_definition
  | global_variable_declaration_line
  | expression_only
  | behavior_definition
  | connection_definition
  | binary_module
  | binary_subroutine_def
  | binary_variable_def
  | execute_on_startup
  | FILE_SEPARATOR
  ;

expression_only :
    CI_STATEMENT ci_statement
  ;

directive :
    SET_GLOBAL_ADDRESS INTEGER
        {if (pass==1) define_set_globals_addr($2.i);}
  | SET_CODE_ADDRESS INTEGER
        {spew_set_code_address($2.i);}
  ;

/*****************/
/* BINARY MODULE */
/*****************/

binary_module :
    BINARY_MODULE {spew_binary_module(module_current_module);}
    SEMICOLON
  ;
  
binary_subroutine_def :
    BINARY_SUBROUTINE_DEF SYMBOL INTEGER SEMICOLON
        {spew_binary_subroutine_def($2.s, (long) (unsigned int) $3.i);}
  ;
  
binary_variable_def :
    BINARY_VARIABLE_DEF SYMBOL INTEGER SEMICOLON
        {spew_binary_variable_def($2.s, (long) (unsigned int) $3.i);}
  ;

execute_on_startup :
    EXECUTE_ON_STARTUP statement_or_block
  ;

/************/
/* BEHAVIOR */
/************/

behavior_definition :
  BEHAVIOR SYMBOL
  /*behavior_*/block
  ;

/**************/
/* CONNECTION */
/**************/

connection_definition :
  CONNECT LEFTPAREN lvalue COMMA lvalue RIGHTPAREN
  SEMICOLON
  ;

/*************/
/* PROCEDURE */
/*************/

procedure_definition :
    NATIVE			/* compile it native */
        {  native_flag = 1; }
    proc_definition
        {  native_flag = 0; }
  | proc_definition		/* compile pcodes */
  ;

proc_definition :
    typedec SYMBOL LEFTPAREN 
        {
	    start_procedure_stats();
	    $$.s= define_temp_symbol();
	    spew_jump($$.s);
	    define_begin_block();
	}
    optional_definition_arglist RIGHTPAREN
        {
            define_procedure($1.t, $2.s);
	    spew_begin_procedure($2.s);
	    if (native_flag) code_inline = 1;
            define_begin_block();
        }
    block
        {
            /* implicit "return garbage" at end of every procedure */
	    if (!spew_bitbucket_code) {
		if (pass == 2 && type_id($1.t) != void_id) {
		    /*user_warning((
		      "Function %s may exit through bottom with no return value\n",
				  symbol_name($2.s)));*/
		}
		code_push_garbage($1.t);
		code_sexp_return(0);
	    }
	    define_end_block();
	    spew_end_procedure($2.s);
	    code_inline = 0;
	    define_end_block();
	    spew_label_definition($4.s);
	    report_procedure_stats($2.s);
	}
  ;

optional_definition_arglist :
    /* empty */
  | definition_arglist
  | VOID
  ;

definition_arglist :
    definition_arg
  | definition_arglist COMMA definition_arg
  ;

definition_arg :
    typedec abstract_declarator
      {
	  Symbol *sym= $1.s;
	  Type *real_type;
	  define_procedure_argument(sym);
	  real_type= type_parse_Abstract_declarator((void**) &sym, $2.t);
	  define_push(real_type);
	  
          define_declare_local(sym);
      }
  ;

abstract_declarator :
    abstract_declarator_no_star
      {
	  $$.t= $1.t;
      }
  | TIMES abstract_declarator
      {
	  $$.t= type_Pointer($2.t);
      }
  
abstract_declarator_no_star :
    SYMBOL
      {
	  $$.t= type_Abstract_declarator($1.s);
      }
  | abstract_declarator LEFTBRACKET RIGHTBRACKET
      {
	  $$.t= type_Pointer(type_Array($1.t, -1));
      }
  | abstract_declarator LEFTBRACKET INTEGER RIGHTBRACKET
      {
	  $$.t= type_Pointer(type_Array($1.t, $3.i));
      }
  | LEFTPAREN abstract_declarator RIGHTPAREN
      {
	  $$.t= $2.t;
      }
  ;

constant_declarator :
    constant_declarator_no_star
      {
	  $$.t= $1.t;
      }
  | TIMES constant_declarator
      {
	  $$.t= type_Pointer($2.t);
      }
  
constant_declarator_no_star :
    SYMBOL
      {
	  $$.t= type_Abstract_declarator($1.s);
      }
  | LEFTPAREN constant_declarator RIGHTPAREN
      {
	  $$.t= $2.t;
      }
  ;





/**********************/
/* GLOBAL DECLARATION */
/**********************/

global_variable_declaration_line :
    declaration
  | persistent_declaration
  | constant_declaration
  ;
  						
/***********************/
/* STATEMENT AND BLOCK */
/***********************/

block :
  LEFTBRACE
      {   define_begin_block();   }
  optional_declarations
  optional_statements RIGHTBRACE
      {   define_end_block();    }
  ;

optional_declarations :
  /* empty */
  | declarations
  ;

optional_statements :
  /* empty */
  | statements
  ;

declarations :
    declaration
  | declarations declaration
  ;

declaration :
    typedec local_variable_declaration_list SEMICOLON
  ;

persistent_declaration :
    PERSISTENT typedec persistent_variable_declaration_list SEMICOLON
  ;

constant_declaration :
    CONST typedec constant_variable_declaration_list SEMICOLON
  ;

local_variable_declaration_list :
    local_variable_declaration
  | local_variable_declaration_list COMMA local_variable_declaration
  ;

constant_variable_declaration_list :
    constant_variable_declaration
  | constant_variable_declaration_list COMMA constant_variable_declaration
  ;


persistent_variable_declaration_list :
    persistent_variable_declaration
  | persistent_variable_declaration_list COMMA persistent_variable_declaration
  ;

persistent_variable_declaration :
    abstract_declarator
      {
	  Symbol *sym= (Symbol*) last_type;
	  Type *real_type= type_parse_Abstract_declarator((void**) &sym, $1.t);

	  spew_skip_garbage(real_type);

	  if (symtab_current_level()) {
	      define_declare_local(sym);
	  } else {
	      define_declare_global(sym);
	  }
      }
  ;

constant_variable_declaration :	/* Doesn't generate any code */
    constant_declarator EQUAL
      {
	  $$.s= (Symbol*) last_type;
	  this_type= type_parse_Abstract_declarator((void**) &($$.s), $1.t);
      }
    init_expression
      {
	  define_declare_constant($3.s, this_type); /* declare it a constant */
	  const_assign_sexp($3.s); /* assign it a value */
      }
  ;


local_variable_declaration :
    abstract_declarator EQUAL
      {
	  $$.s= (Symbol*) last_type;
	  this_type= type_parse_Abstract_declarator((void**) &($$.s), $1.t);
      }
    init_expression
      {
	  if (!sexp_stack_empty()) code_sexp_val();
	  if (pass <= 1)
	    {
	      if(type_id(this_type) == pointer_id &&
		 type_id(define_stack_type(0)) == int_id) 
		define_cast(this_type);

	      else if (!type_compatible(this_type, define_stack_type(0)))
		user_error(("Initialization to incorrect type: %s = %s",
			    type_name(this_type), type_name(define_stack_type(0))));
	    }
	  if (symtab_current_level()) {
	    define_declare_local($3.s);
	  } else {
	    define_declare_global($3.s);
	  }
      }
  | abstract_declarator
      {
	  Symbol *sym= (Symbol*) last_type;
	  Type *real_type= type_parse_Abstract_declarator((void**) &sym, $1.t);

	  code_push_garbage(real_type);	  

	  if (symtab_current_level()) {
	      define_declare_local(sym);
	  } else {
	      define_declare_global(sym);
	  }
      }
  ;
  

statements :
    statement_or_block
  | statements statement_or_block
  ;

statement_or_block :
    statement
  | block
  ;

ci_statement :
    expression SEMICOLON  { code_sexp_val(); }
  | statement_not_expression
  | block
  ;

statement :
    expression_void SEMICOLON
  | statement_not_expression
  ;

statement_not_expression :
    control_flow_statement
  | loop_statement
  | conditional_statement
  | robot_statement
  | behavior_statement
  | SEMICOLON
  ;

control_flow_statement :
    RETURN expression SEMICOLON
      {
          code_sexp_return(1);	/* return with value */
      }
  | RETURN SEMICOLON
      {
	  define_push(type_Void());
          code_sexp_return(0);	/* return without value */
      }
  | BREAK SEMICOLON
      {   define_break(0);   }
  ;

loop_statement :
    WHILE
      {
	  define_begin_breakable_block();
	  $$.s= define_temp_symbol();
	  spew_label_definition($$.s);
      }
    LEFTPAREN
      {
	  $$.s= define_temp_symbol();
      }
    expression RIGHTPAREN
      {
	  code_sexp_conditional(0, $4.s);
      }
    statement_or_block
      {
	  code_imm_jump($2.s);
	  spew_label_definition($4.s);
	  define_end_breakable_block();
      }
  | FOR
      {   /* $2.s is after the loop */
	  define_begin_breakable_block();
	  $$.s= define_temp_symbol();
      }
    LEFTPAREN
      {   /* $4.s is body of loop */
	  $$.s= define_temp_symbol();
      }
    optional_expression_void SEMICOLON
      {   /* $7.s is second for expression (test) */
	  $$.s= define_temp_symbol();
	  spew_label_definition($$.s);
      }
    optional_expression SEMICOLON
      {   /* $10.s is third for expression */
	  code_sexp_conditional(0, $2.s); /* after the loop */
	  code_imm_jump($4.s);
	  $$.s= define_temp_symbol();
	  spew_label_definition($$.s);
      }
    optional_expression_void RIGHTPAREN
      {
	  code_imm_jump($7.s); /* test */
	  spew_label_definition($4.s);
      }
    statement_or_block
      { 
	  code_imm_jump($10.s);
	  spew_label_definition($2.s);
	  define_end_breakable_block();
      }
  ;

conditional_statement : 
    IF 
      {
	  $$.s= define_temp_symbol();   /* else */
      }
    LEFTPAREN	  
      {
	  $$.s= define_temp_symbol();   /* end */
      }
    expression
    RIGHTPAREN
      {
          code_sexp_conditional(0,$2.s); /* code test and jump */
      }
    statement_or_block
      {
	  jump_sexp($4.s,$2.s);	         /* save ELSE jump */
      }
    optional_else_clause
      {
	  spew_label_definition($4.s);
      }
    ;

robot_statement :
  /* non-standard c extensions here */
    POKE LEFTPAREN expression COMMA expression RIGHTPAREN SEMICOLON
        {   code_poke(1);  }
  | POKEWORD LEFTPAREN expression COMMA expression RIGHTPAREN SEMICOLON
        {   code_poke(2);   }
  | BITCLR LEFTPAREN expression COMMA
    expression RIGHTPAREN SEMICOLON
        {   code_bit(0); }
  | BITSET LEFTPAREN expression COMMA
    expression RIGHTPAREN SEMICOLON
        {   code_bit(1); }
  | DEFER LEFTPAREN RIGHTPAREN SEMICOLON
        {   code_pcode(Pdefer);  }
  | INIT_INTERRUPTS LEFTPAREN RIGHTPAREN SEMICOLON
        {   code_pcode(Pinitint);  }
  ;

behavior_statement :
    exclusive_statement
  | done_whenever_statement
  ;

exclusive_statement :
     {
	 define_begin_breakable_block();
	 $$.s= define_temp_symbol();
	 spew_label_definition($$.s);
     }
     whenever_or_exclusive_form
     {
	 spew_op(Pdefer);
	 spew_jump($1.s);
	 define_end_breakable_block();
     }
  ;

whenever_or_exclusive_form :
    EXCLUSIVE LEFTBRACE whenever_statements RIGHTBRACE
  | whenever_statement
  ;

whenever_statements :
    whenever_statement
  | whenever_statements whenever_statement
  ;

whenever_statement :
    WHENEVER LEFTPAREN
      { $$.s= define_temp_symbol();   /* end */ }
    expression RIGHTPAREN
      { spew_conditional_jump(Pjfalse, $3.s); }
    statement_or_block
      { spew_label_definition($3.s); }
  ;

done_whenever_statement :
    DONE_WHENEVER SEMICOLON
      {  define_break(0);  }
  | DONE_WHENEVER INTEGER SEMICOLON
      {  define_break($2.i);  }
  | DONE_WHENEVER LEFTPAREN INTEGER RIGHTPAREN SEMICOLON
      {  define_break($3.i);  }
  ;
  
optional_else_clause :   /* 1 shift-reduce conflict */
    /* empty */
      {  code_sexp_jump(0); }
  | ELSE
      {  code_sexp_jump(1); }
    statement_or_block 
  ;
  
/*******************/
/*** EXPRESSIONS ***/
/*******************/

optional_expression_void :
    /* empty */
  | expression_void
  ;

expression_void :
    expression
        {
	    $$= $1;
	    code_sexp_noval();
	}
  | expression_void COMMA expression
        {
	    $$= $1;
	    code_sexp_noval();
	}
  ;
  
optional_expression :
    /* empty */
        {   const_sexp(type_Int(), (eval)(Int)1);   }
  | expression
  ;

init_expression :
    expression
  | LEFTBRACE
        {   spew_begin_array(this_type, 1);   }
    optional_array_init_list
        {   spew_end_array(1);   }
    RIGHTBRACE
  
expression :
    primary
  | infix_expression
        {   $$= $1;   }
  | assignment_operation
        {   $$= $1;   }
  | KILL_PROCESS LEFTPAREN expression RIGHTPAREN
        {   kill_process_sexp();   }
  | BENCHMARK LEFTPAREN RIGHTPAREN
        {   nilop_sexp(benchmark, type_Int()); }
  | PEEK LEFTPAREN expression RIGHTPAREN
        {   peek_sexp(1);  }
  | ARRAY_SIZE LEFTPAREN expression RIGHTPAREN
        {   define_cast(type_Pointer(type_Int()));  spew_peek();   }
  | PEEKWORD LEFTPAREN expression RIGHTPAREN
        {   peek_sexp(2);   }
  | MSECONDS LEFTPAREN RIGHTPAREN
        {   nilop_sexp(mseconds, type_Long()); }
  | PRINTF LEFTPAREN 
       {   call_arg_sexp(); /* marker for # of args */ }	
    optional_expression_list RIGHTPAREN
       {   printf_sexp(); }
  | SIN LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(ssin);   }
  | COS LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(scos);   }
  | TAN LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(stan);   }
  | SQRT LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(ssqrt);   }
  | ATAN LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(satan);   }
  | LOG10 LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(slog10);   }
  | LOGE LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(sloge);   }
  | EXP10 LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(sexp10);   }
  | EXPE LEFTPAREN expression RIGHTPAREN
        {   unop_sexp(sexpe);   }
  
  | LEFTPAREN type RIGHTPAREN expression
        {   cast_sexp($2.t);   }
  ;

expression_list :
    expression
  | expression_list COMMA expression
  ;

optional_expression_list :
    /* empty */
  | expression_list
  ;

optional_array_init_list :
    /* empty */
  | array_init_list
  ;

array_init_list :
    array_init_item
  | array_init_list COMMA array_init_item
  ;

array_init_item :
    INTEGER
       {   spew_continue_array_int($1.i);   }
  | FLOATING_POINT
       {   spew_continue_array_float($1.d);   }
  | LONG_INT
       {   spew_continue_array_long($1.l);   }
  | MINUS INTEGER
       {   spew_continue_array_int(-$2.i);   }
  | MINUS FLOATING_POINT
       {   spew_continue_array_float(-$2.d);   }
  | MINUS LONG_INT
       {   spew_continue_array_long(-$2.l);   }
  ;

constant :
    INTEGER
       {   const_sexp(type_Int(), (eval)$1.i);  }
  | LONG_INT
       {   const_sexp(type_Long(), (eval)$1.l);  }
  | FLOATING_POINT
       {   const_sexp(type_Float(), (eval)$1.d);  }
  | STRING
       {   const_sexp(type_Pointer(type_Array(type_Char(), strlen($1.string))),
		      (eval)(void *)$1.string);  }
   ;						

primary :
    lvalue
       {   val_sexp();   }
  | BITAND lvalue %prec HANDLE
  | constant						
  | LEFTPAREN expression RIGHTPAREN
  | SYMBOL LEFTPAREN		/* function call */
       {   call_arg_sexp(); }	/* marker for # of args */
    optional_expression_list RIGHTPAREN
       {   call_sexp($1.s); }
  | LEFTPAREN TIMES primary RIGHTPAREN LEFTPAREN /* function call */
       {   call_arg_sexp();   }
    optional_expression_list RIGHTPAREN
       {   call_sexp($1.s);   }
  | START_PROCESS LEFTPAREN SYMBOL LEFTPAREN
      {	   call_arg_sexp();  call_arg_sexp();  }
    optional_expression_list RIGHTPAREN
      {    call_sexp($3.s);   }
    optional_ticks_and_stack RIGHTPAREN
      {    start_process_sexp();   } 
  ;

optional_ticks_and_stack :
    /* empty */
      {   
	  const_sexp(type_Int(), (eval)(Int)PROC_DEFAULT_TICKS);
	  const_sexp(type_Int(), (eval)(Int)PSTACK_DEFAULT_SIZE);
      }
  | COMMA expression
      {   
  	  const_sexp(type_Int(), (eval)(Int)PSTACK_DEFAULT_SIZE);
      }
  | COMMA expression COMMA expression
  ;

lvalue :
    SYMBOL
       {   ref_sexp($1.s);  }
  | primary LEFTBRACKET expression RIGHTBRACKET
       {   array_sexp();    }
  | TIMES primary %prec DEREF
  | LEFTPAREN lvalue RIGHTPAREN
  ;

infix_expression :
    expression TIMES expression        {   bop_sexp(times);  }
  | expression DIVIDE expression        {   bop_sexp(divide);  }
  | expression MODULO expression /* a mod b == a - b * (a/b) */
        {   bop_sexp(modulo);  }
  | expression MINUS expression        {   bop_sexp(minus);  }
  | expression PLUS expression        {   bop_sexp(plus);  }

  | expression EQUALEQUAL expression        {   bop_sexp(eequal);  }
  | expression NOTEQUAL expression        {   bop_sexp(nequal);  }
  | expression LESSTHAN expression        {   bop_sexp(lessthan);  }
  | expression GREATERTHAN expression        {   bop_sexp(greaterthan);  }
  | expression LESSTHANEQUAL expression        {   bop_sexp(ltequal);  }
  | expression GREATERTHANEQUAL expression        {   bop_sexp(gtequal);  }

  | expression BITAND expression        {   bop_sexp(bitand);  }
  | expression BITIOR expression        {   bop_sexp(bitior);  }
  | expression BITXOR expression        {   bop_sexp(bitxor);  }


  | expression LSHIFT expression        {   bop_sexp(lshift);  }
  | expression RSHIFT expression        {   bop_sexp(rshift);  }
  
  | MINUS expression        {   unop_sexp(neg);   }
  | PLUS  expression        {   $$= $2;  }

  | expression LOGAND expression        {   bop_sexp(logand);  }
  | expression LOGIOR expression        {   bop_sexp(logior);  }

  | LOGNOT expression        {   unop_sexp(lognot);   }

  | BITNOT expression        {   unop_sexp(bitcomp);   }
  ;

/***************/
/* ASSIGNMENTS */
/***************/

assignment_operation :
    lvalue EQUAL     expression  { assign_sexp(equal,1); }
  | lvalue PLUSEQUAL expression  { assign_sexp(plusequal,1); }
  | lvalue MINUSEQUAL expression  { assign_sexp(minusequal,1); }
  | lvalue TIMESEQUAL expression  { assign_sexp(timesequal,1); }
  | lvalue DIVIDEEQUAL expression  { assign_sexp(divideequal,1); }

  | lvalue BITANDEQUAL expression  { assign_sexp(bitandequal,1); }
  | lvalue BITIOREQUAL expression  { assign_sexp(bitorequal,1); }
  | lvalue BITXOREQUAL expression  { assign_sexp(bitxorequal,1); }
  | lvalue LSHIFTEQUAL expression  { assign_sexp(lshiftequal,1); }
  | lvalue RSHIFTEQUAL expression  { assign_sexp(rshiftequal,1); }

  | PLUSPLUS lvalue    { assign_sexp(plusequal,0); }
  | MINUSMINUS lvalue  { assign_sexp(minusequal,0); }
  | lvalue PLUSPLUS    { asspost_sexp(plusequal); }
  | lvalue MINUSMINUS  { asspost_sexp(minusequal); }
  ;

/********/
/* TYPE */
/********/

typedec :
    type
        {   $$.t= last_type= $1.t;   }

type :
    INT
        {   $$.t= type_Int();   }
  | LONG
        {   $$.t= type_Long();   }
  | FLOAT
        {   $$.t= type_Float();   }
  | VOID
        {   $$.t= type_Void();   }
  | CHAR
        {   $$.t= type_Char();   }
  ;

%%

#undef yylex
#include "ctoken.c"
#define yylex module_get_token
