/**
 ** code.h
 **
 ** Copyright 1995 by Kurt Konolige
 **
 ** The author hereby grants to SRI permission to use this software.
 ** The author also grants to SRI permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by SRI, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor SRI make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Kurt Konolige
 ** Senior Computer Scientist
 ** SRI International
 ** 333 Ravenswood Avenue
 ** Menlo Park, CA 94025
 ** E-mail:  konolige@ai.sri.com
 **
 **/


/* globals */

extern Int native_flag;		/* = 0 for pcode procs, 1 for inline */
extern Int code_inline;		/* = 0 if we're doing pcodes, 1 if inline */


/*
 * Operation symbols
 */

typedef enum
{
  jmp = 0, bra, brz, brnz,
  brgt, brlt, brge, brle,
  cpd, cpdx, cpdi,
  clra, clrb,
  nega, negb, coma, comb, 
  adca, adcb,
  ldd, ldb, lda, ldx, ldy,
  lddi, ldai, ldbi, ldxi, ldyi,
  ldyx, ldby, ldbx, lday, ldax, lddx, lddy,
  std, sta, stb,
  stdy, stay, stby,
  stdx, stax, stbx,
  inx, iny, dex, dey,
  xcdy, xcdx,
  add, addx, addy, addi, 
  addb, addbx, addby, addbi, 
  sub, subx, suby, subi, 
  subb, subbx, subby, subbi, 
  anda, andax, anday, andai,
  andb, andbx, andby, andbi,
  ora, orax, oray, orai, 
  orb, orbx, orby, orbi, 
  eora, eorax, eoray, eorai, 
  eorb, eorbx, eorby, eorbi, 
  psha, pshb, pshx, pshy, 
  pula, pulb, pulx, puly,
  jsr, rts
} mcodes;

typedef struct			/* operation machine codes */
{
  char *name;			/* name of operation */
  Int first;			/* first byte */
  Int second;			/* second byte; zero if none */
} mops;


/*
 * code operand values
 */

typedef struct
{
  Int i;
  Symbol *sym;
  Int which;			/* 0 for int, 1 for sym */
} cval;


/* 
 *  Access functions
 */

void code_mop(mcodes op);	/* stores one machine op */
void code_m2op(mcodes op, Int byte); /* stores one machine op */
void code_sexp(sexp *s, Int push); /* do one s-expression, popping it from sexp stack */
void code_sexp_push(sexp *s);	/* do one s-expression, popping it from sexp stack */
void code_sexp_load(sexp *s);	/* do one s-expression, popping it from sexp stack */
void code_poke(Int size);	/* code a POKE, 2 args */
void code_sexp_conditional(Int branch, Symbol *s); 
void code_sexp_jump(Int jump);
void code_sexp_noval();		/* evals sexp, no return value */
void code_sexp_val();		/* evals sexp, return value */
void code_push_garbage(Type *type); /* set aside space for variables */
void code_imm_jump(Symbol *sym); /* jump to this symbol def */
void code_sexp_return(Int val);	/* val = 1 for return value expression */
void code_pcode(Opcode op);	/* code only in pcodes */
void code_jump(Symbol *sym);	/* jump immediately to this symbolic address */
void code_pop_n(Int n);		/* pops N bytes off stack */
void code_sexp_list(Int n);	/* code n sexps and push on stack, in reverse order */
void code_bit(Int which);	/* 0 for bit clear, 1 for set */
