%{
/******************************/
/*** ctoken.lex             ***/
/*** (C) 1991 Randy Sargent ***/
/******************************/

#include <ctype.h>    
#undef getc
#define getc(x) lexer_getchar()
#ifdef YYLMAX
#undef YYLMAX
#endif
#define YYLMAX 4096
#ifdef YY_INPUT
#undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size) result=lexer_read(buf, max_size);
extern int yy_init, yy_start;
#ifdef yywrap
#undef yywrap
#endif
#define yywrap() lexer_wrap()
void yy_kick_me()
{
#ifdef FLEX_SCANNER
	yy_init= 1;
	yy_start= 0;
#endif
}

%}

%p 4000

%%

\/\*(([^\*])*((\*)*([^\/\*]))?)*(\*)+\/   {
                            char *cp;
                            if (lexer_debug)
                              printf("!!<<comment>>!!\n");
                            for (cp= yytext; *cp; cp++) {
				if (*cp== '\n') lineno++;
			    }
                        }



[0-9]+[lL]?		{
                            if (lexer_debug)
			      printf("decimal number >%s<\n", yytext);
			    sscanf(yytext,"%ld",&yylval.l);
			    if ((yytext[strlen(yytext)-1] | 0x20) == 'l') {
				return (LONG_INT);
			    }
			    else {
				yylval.i= (int) yylval.l;
				return (INTEGER);
			    }
			}

0b[0-1]+[lL]?		{
			    if (lexer_debug)
			      printf("binary number >%s<\n", yytext);
			    yylval.l= binary_to_long(yytext+2);
			    if ((yytext[strlen(yytext)-1] | 0x20) == 'l') {
				return (LONG_INT);
			    }
			    else {
				yylval.i= (int) yylval.l;
				return (INTEGER);
			    }
			}

0x[0-9a-fA-F]+[lL]?	{
                            if (lexer_debug)
			      printf("hex number >%s<\n", yytext);
			    sscanf(yytext+2,"%lx",&yylval.l);
			    if ((yytext[strlen(yytext)-1] | 0x20) == 'l') {
				return (LONG_INT);
			    }
			    else {
				yylval.i= (int) yylval.l;
				return (INTEGER);
			    }
			}

[0-9]*"."[0-9]+([eE][-+]?[0-9]+)?	{
				if (lexer_debug)
				  printf("float >%s<\n", yytext);
                                sscanf(yytext, "%lf", &yylval.d);
				return FLOATING_POINT;
                        }

[0-9]+"."[0-9]*([eE][-+]?[0-9]+)?	{
				if (lexer_debug)
				  printf("float >%s<\n", yytext);
                                sscanf(yytext, "%lf", &yylval.d);
				return FLOATING_POINT;
                        }

[0-9]+[eE][-+]?[0-9]+   {
				if (lexer_debug)
				  printf("float >%s<\n", yytext);
                                sscanf(yytext, "%lf", &yylval.d);
				return FLOATING_POINT;
			}

\"((\\\")|[^\"])*\"	{
                            char *from, *to;
			    if (lexer_debug) printf("string >%s<\n", yytext);
			    for (from= to= yytext; *from; from++, to++) {
				if (*from == '\\') {
				    if (isdigit(from[1])) {
                                        int val;
					sscanf(from + 1, "%3o", &val);
	                                *to= (char) val;
                                        from += 3;
                                    } else {
					switch(from[1]) {
					  case 'n': *to= '\n'; break;
					  case 'r': *to= '\r'; break;
					  case 't': *to= '\t'; break;
					  case 'a': *to= '\a'; break;
					  default:  *to= from[1]; break;
					}
					from++;
				    }
				} else {
				    *to= *from;
				}
			    }
			    *to= 0;
			    yylval.string= string_copy(yytext);
			    return(STRING);
                        }

\'.\'			{
                                if (lexer_debug) printf("char >%s<\n", yytext);
                                yylval.i= yytext[1];
                                return INTEGER;
                        }

[ \t\f]+        {if (lexer_debug) printf("whitespace >%s<\n", yytext); }
\n              {if (lexer_debug) printf("newline\n"); lineno++; }


"_set_global_address"  {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 	return(SET_GLOBAL_ADDRESS);}
"_array_size"        {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 	return(ARRAY_SIZE);}
"_init_interrupts"   {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 	return(INIT_INTERRUPTS);}
"_set_code_address"    {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 	return(SET_CODE_ADDRESS);}
"__ci_statement"    {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 	return(CI_STATEMENT);}

"execute_on_startup" {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(EXECUTE_ON_STARTUP);}
"persistent"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(PERSISTENT);}
"start_process"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(START_PROCESS);}
"kill_process"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(KILL_PROCESS);}
"defer" 	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(DEFER);}
"_benchmark"    {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(BENCHMARK);}
"peek"          {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(PEEK);}
"peekword"      {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(PEEKWORD);}
"poke"          {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(POKE);}
"bit_set"       {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(BITSET);}
"bit_clear"     {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(BITCLR);}
"pokeword"      {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(POKEWORD);}
"mseconds"      {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(MSECONDS);}

"printf"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(PRINTF);}

"sin"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(SIN);}
"cos"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(COS);}
"tan"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(TAN);}
"sqrt"          {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(SQRT);}
"atan"          {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(ATAN);}
"log10"         {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(LOG10);}
"log"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(LOGE);}
"exp10"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(EXP10);}
"exp"           {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(EXPE);}


"native"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(NATIVE);}
"const"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(CONST);}
"void"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(VOID);}
"int"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(INT);}
"long"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(LONG);}
"float"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(FLOAT);}
"char"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(CHAR);}


"while"  	{if (lexer_debug) printf("reserved >%s<\n", yytext);
		 return(WHILE);}
"for"	        {if (lexer_debug) printf("reserved >%s<\n", yytext);
		 return(FOR);}
"if"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(IF);}
"else"	        {if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(ELSE);}
"return"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(RETURN);}
"break"		{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(BREAK);}

"whenever"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(WHENEVER);}
"exclusive"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(EXCLUSIVE);}
"done_whenever"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(DONE_WHENEVER);}
"behavior"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(BEHAVIOR);}
"connect"	{if (lexer_debug) printf("reserved word >%s<\n", yytext);
		 return(CONNECT);}



[A-Za-z\_][A-Za-z0-9\_]*	{
					   if (lexer_debug)
						printf("token >%s<\n", yytext);
					   yylval.s= symbol_create(yytext);
					   return SYMBOL;
                                }


">="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(GREATERTHANEQUAL);}
"<="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LESSTHANEQUAL);}
">"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(GREATERTHAN);}
"<"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LESSTHAN);}
"="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(EQUAL);}
"+"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(PLUS);}
"-"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(MINUS);}
"*"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(TIMES);}
"/"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(DIVIDE);}
"%"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(MODULO);}
"&"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITAND);}
"|"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITIOR);}
"&&"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LOGAND);}
"||"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LOGIOR);}
"^"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITXOR);}
"<<"            {if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LSHIFT);}
">>"            {if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(RSHIFT);}
"~"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITNOT);}
"!"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LOGNOT);}

"=="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(EQUALEQUAL);}
"!="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(NOTEQUAL);}
"++"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(PLUSPLUS);}
"--"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(MINUSMINUS);}

"+="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(PLUSEQUAL);}
"-="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(MINUSEQUAL);}
"*="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(TIMESEQUAL);}
"/="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(DIVIDEEQUAL);}
"&="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITANDEQUAL);}
"|="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITIOREQUAL);}
"^="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(BITXOREQUAL);}
"<<="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LSHIFTEQUAL);}
">>="		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(RSHIFTEQUAL);}



","		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(COMMA);}
";"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(SEMICOLON);}
":"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(COLON);}
"("		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LEFTPAREN);}
")"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(RIGHTPAREN);}
"{"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LEFTBRACE);}
"}"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(RIGHTBRACE);}
"["		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(LEFTBRACKET);}
"]"		{if (lexer_debug) printf("symbol >%s<\n", yytext);
		 return(RIGHTBRACKET);}

%%
