/**
 ** define.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifdef DEFINE_MODULE
#include "define_p.h"
#endif

/*-------------------------------------------------------------------------*/
/* Public Variables                                                        */

extern long current_stack_size;
extern Int define_debug;
extern long current_global_location;

/*-------------------------------------------------------------------------*/
/* Public Functions Begin                                                  */
void        define_begin_block(void);
void        define_begin_breakable_block(void);
void 	    define_binary_subroutine (Symbol *sym);
void 	    define_binary_variable (Symbol *sym);
void        define_break      (Int levels);
void        define_cast       (Type *new_type);
void        define_coerce     (Type *new_type);
void        define_declare_global(Symbol *sym);
void        define_declare_local(Symbol *sym);
void        define_end_block  (void);
void        define_end_block_no_pop(void);
void        define_end_breakable_block(void);
long        define_get_high_water_mark(void);
void        define_get_symbol_addr(Symbol *sym);
void        define_init       (void);
Type *      define_pop        (void);
void        define_procedure  (Type *ret_type, Symbol *sym);
void        define_push       (Type *type);
void        define_set_globals_addr(long a);
void        define_set_low_water_mark(void);
void        define_set_symbol_addr(Symbol *sym, long addr);
Int         define_stack_items(void);
long        define_stack_offset(Int depth);
Type *      define_stack_type (Int depth);
void        define_start_pass (void);
Symbol *    define_temp_symbol(void);
Symbol *    symbol_from_pc    (long pc);
void        define_procedure_argument(Symbol *name);

/* Public Functions End                                                    */
/*-------------------------------------------------------------------------*/
