/**
 ** dep.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

#include CONFIG
#include <table.h>
#include <stringlb.h>
#include <ctype.h>

Table protos;

void read_prototypes(Int n, char *filename)
{
    FILE *in;
    char execbuf[100];
    char pbuf[1000];
    sprintf(execbuf, "/mit/watchmaker/vaxbin/mkptypes %s > /tmp/foop", filename);
    system(execbuf);
    
    in= fopen("/tmp/foop","r");
    if (!in) { printf("Cannot open /tmp/foop for input\n", in); exit(1); }

    /* Only look for lines ending in ; */

    while (1) {
	Int i;
	Int open_paren;
	char *ptr;
	char *type, *name, *args;
	fgets(pbuf, 1000, in);
	i= strlen(pbuf);
	while (i && isspace(pbuf[i-1])) i--;
	if (!i || pbuf[i-1] != ';') continue;
	pbuf[i-2]=0;
	/* Got a line.  Try to parse it */
	ptr= string_find_substring(pbuf, "P_((");
	if (!ptr) {
	    printf("Could not parse line:\n%s\n", pbuf);
	    continue;
	}
	args= string_copy(ptr + 4);
	ptr--;
	*ptr= 0;
	ptr--;
	while (isalnum(*ptr) || *ptr=='_') ptr--;

	ptr++;
	name= string_copy(ptr);
	*ptr= 0;

	type= string_copy(pbuf);

	printf("Got >%s< >%s< >%s<\n", type, name, args);
    }
    fclose(in);
}

void find_dependencies(Int n, char *filename)
{
}

void write_prototypes(Int n, char *filename)
{
}

void main(Int argc, char **argv)
{
    Int i;
    
    for (i= 1; i< argc; i++) {
	char *no_suffix= string_remove_suffix(argv[i]);
	char *dot_c= string_append(no_suffix, ".c");

	read_prototypes(i, dot_c);

	string_free(dot_c);
	string_free(no_suffix);
    }

    for (i= 1; i< argc; i++) {
	char *no_suffix= string_remove_suffix(argv[i]);
	char *dot_c= string_append(no_suffix, ".c");

	find_dependencies(i, dot_c);

	string_free(dot_c);
	string_free(no_suffix);
    }

    for (i= 1; i< argc; i++) {
	char *no_suffix= string_remove_suffix(argv[i]);
	char *dot_h= string_append(no_suffix, ".h");

	write_prototypes(i, dot_h);

	string_free(dot_c);
	string_free(no_suffix);
    }

}
    
    
