/**
 ** lexer.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#define LEXER_MODULE

#include "core.h"

/*-------------------------------------------------------------------------*/
/* Private Variables                                                       */

#define MAX_LEX_LEVEL 10

FILE *lexer_stream[MAX_LEX_LEVEL];
char *lexer_string[MAX_LEX_LEVEL];
Int lexer_string_len[MAX_LEX_LEVEL];
Int lex_level= 0;


/*-------------------------------------------------------------------------*/
/* Public Variables                                                        */

Int lexer_debug= 0;

/*-------------------------------------------------------------------------*/
/* Public Functions                                                        */

Int lexer_wrap(void)
{
    if (--lex_level) {
	if (lexer_debug) printf("lexer pop stream\n");
	lineno= 1;
	return 0;
    } else {
	if (lexer_debug) printf("lexer pop stream, end\n");
	return 1;
    }
}

void lexer_push_stream(FILE *in)
{
    if (lexer_debug) printf("lexer push stream\n");
    lex_level++;
    lexer_stream[lex_level]= in;
    lexer_string[lex_level]= 0;
}

void lexer_push_string(char *in)
{
    if (lexer_debug) printf("lexer push string\n");
    lex_level++;
    lexer_stream[lex_level]= 0;
    lexer_string[lex_level]= in;
    lexer_string_len[lex_level]= strlen(in);
}

long binary_to_long(char *txt)
{
    long ret=0, neg= 0;
    
    if (*txt == '-') {
	neg= 1;
	txt++;
    }
    while(*txt && ((*txt | 0x20) != 'l')) {
	if (*txt == '0') {
	    ret += ret;
	} else if (*txt == '1') {
	    ret += ret + 1;
	} else {
	    die(("Wow! Non binary digit in binary number"));
	}
	txt++;
    }
    if (neg) ret= -ret;
    return ret;
}

Int lexer_getchar(void)
{
    if (lexer_stream[lex_level]) return getc(lexer_stream[lex_level]);
    if (lexer_string[lex_level] && lexer_string_len[lex_level]) {
	lexer_string_len[lex_level]--;
	return *(lexer_string[lex_level]++);
    }
    if (lexer_debug) printf("lexer <EOF>\n");
    return EOF;
}

Int lexer_read(char *buf, Int maxsize)
{
    if (lexer_stream[lex_level]) {
	Int size= fread(buf, 1, maxsize, lexer_stream[lex_level]);
	if (lexer_debug) printf("read file size %ld\n", size);
	return size;
    }
    if (lexer_string[lex_level] && lexer_string_len[lex_level]) {
	Int size= lexer_string_len[lex_level];
	if (size > maxsize) size= maxsize;
	memcpy(buf, lexer_string[lex_level], size);
	lexer_string_len[lex_level] -= size;
	lexer_string[lex_level] += size;
	if (lexer_debug) printf("read string size %ld\n", size);
	return size;
    }
    if (lexer_debug) printf("lexer <EOF>\n");
    return 0;
}

void lexer_reset(void)
{
    if (lexer_debug) printf("lexer reset\n");
    lex_level= 1;
    lexer_string[lex_level]= 0;
    lexer_stream[lex_level]= 0;
    while (yylex()); /* flush old tokens */
    yy_kick_me();
}
    
