/**
 ** lexer.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/*-------------------------------------------------------------------------*/
/* Public Variables                                                        */

extern Int lexer_debug;

/*-------------------------------------------------------------------------*/
/* Public Functions Begin                                                  */
Int         lexer_getchar     (void);
void        lexer_push_stream (FILE *in);
void        lexer_push_string (char *in);
Int         lexer_read        (char *buf, Int maxsize);
void        lexer_reset       (void);
Int         lexer_wrap        (void);
long        binary_to_long    (char *txt);
/* Public Functions End                                                    */
/*-------------------------------------------------------------------------*/
