/**
 ** module.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


typedef enum {
    module_type_c,
    module_type_icb  /* assembly file format */
} Module_type;

typedef struct module_str {
    Module_type type;
    char        *name;
    Growbuf     tokens;  /* for c file */
    Binrec      *binrec1, *binrec2;  /* for icb file */
    struct module_str *next;
} Module;

extern Module *all_modules, *module_current_module;
extern Int module_debug;

void 	    module_set_input  (Module *m);
void 	    module_destroy    (Module *m);
void 	    module_unload     (char *name);
void 	    module_load_c     (char *name);
Module	    *module_create_c   (char *name);
void 	    module_load_icb   (char *name, FILE *in);
Module 	    *module_create_icb (char *name, FILE *in);
Module 	    *module_error_occurred (void);
void        module_start_pass  (void);
Int         module_exists      (char *name);
Int 	    module_get_token  (void);
    
