/*
 * Definitions of important memory locations
 */


/* HC11 locations */

const char *Porta  = 0x1000;
const char *Porte  = 0x100a;
const char *Portg  = 0x1002;

const char *Tmsk1  = 0x1022;
const char *Tctl1  = 0x1020;

const char *Csio1  = 0x1060;	/* reading from the LCD */
const char *Csio1d = 0x1061;	/* writing to the LCD */
const char *Csio2a = 0x1801;	/* writing to general I/O */
const char *Csio2b = 0x1802;	/* writing to sonar multiplexor */
const char *Sonars = 0x1802;

/* system time */
const int  *Mshi   = 0x0e;
const int  *Mslo   = 0x10;
const long *Ms     = 0x0e;

/* piezo buzzer */
const int  *Buzzer = 0x24;
const char Buzzer_bit = (char)0b00010000; 

/* status light mask */
const char Led_bit = (char)0b00001000; 

/* sonar bits */
const char Init_bit = 0b0100;	/* Init sonar pinging */
const char Binh_bit = 0b1000;	/* Suppress echo inhibit */

