/**
 ** parser.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/*-------------------------------------------------------------------------*/
/* Public Variables                                                        */

extern Int lineno, warnings, errors, pass;
extern Int parser_debug;
extern int yydebug;

/*-------------------------------------------------------------------------*/
/* Public Macros                                                           */

#define user_error(args) \
  do { \
     errors++; \
     printf("Error in %s around line %ld:\n\t", module_error_occurred()->name, lineno); \
     printf args ; \
     printf("\n"); \
  } while (0)

#define user_warning(args) \
  do { \
     warnings++; \
     printf("Warning in %s around line %d:\n\t", module_error_occurred()->name, lineno); \
     printf args ; \
     printf("\n"); \
  } while (0)

/*-------------------------------------------------------------------------*/
/* Public Functions Begin                                                  */
void        compile           (Module *m);
void        parser_init       (void);
void        yyerror           (char *message);
/* Public Functions End                                                    */
/*-------------------------------------------------------------------------*/
