/**
 ** ref.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include "core.h"

Ref *ref_all= NULL;

Int ref_debug= 0;

void ref_add(Symbol *sym, long location, Reftype type)
{
    Ref *ref= (Ref *)malloc(sizeof(Ref));
    ref->type= type;
    ref->symbol= sym;
    ref->location= location;
    ref->next= ref_all;
    ref_all=ref;
    if (ref_debug) {
	printf("%s: ref'd by %04lX\n", symbol_name(sym), location);
    }
}

Int ref_word(long loc)		/* returns the word at this location */
{
  Int a = code[loc-code_origin];
  a = (a<<8) + code[1+loc-code_origin];
  return(a);
}

void ref_link(void)
{
    Ref *ref;
    Int addr;
    for (ref= ref_all; ref; ref= ref->next) {
	Value *v= symtab_get(ref->symbol);
	if (!v) {
	    user_error(("Label %s is undefined in pass 2\n",
			symbol_name(ref->symbol)));
	}
	else {
	    switch (value_loctype(v)) {
	      case global_location:
		switch (ref->type) {
		  case two_byte_absolute:
		    addr = ref_word(ref->location) + (Int) value_address(v);
		    spew_write_word(ref->location, addr);
				
		    if (ref_debug) {
			printf("Writing %04lX (%s) into address %04lX\n",
			       addr, symbol_name(ref->symbol),
			       ref->location);
		    }
		    break;
		  case one_byte_absolute:
		  case one_byte_relative:
		  default:
		    die(("Illegal ref type %d in ref_link", ref->type));
		}
		break;
	      default:
		die(("Illegal location type %d in ref_link",
		     value_loctype(v)));
	    }
	}
    }
    ref_clear();
}

void ref_clear(void)
{
    Ref *ref, *next_ref;
    for (ref= ref_all; ref; ref= next_ref) {
	next_ref= ref->next;
	free(ref);
    }
    ref_all= NULL;
}

    
