/**
 ** sem.h
 **
 ** Copyright 1995 by Kurt Konolige
 **
 ** The author hereby grants to SRI permission to use this software.
 ** The author also grants to SRI permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by SRI, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor SRI make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Kurt Konolige
 ** Senior Computer Scientist
 ** SRI International
 ** 333 Ravenswood Avenue
 ** Menlo Park, CA 94025
 ** E-mail:  konolige@ai.sri.com
 **
 **/


/* semantic expression types */

typedef enum {
  bop, unop, nilop,		/* operations */
  cnst, val, peek,		/* constant or reference lookup */
  ref,				/* pointer/reference */
  assign,			/* assignment */
  jump,				/* jump, please */
  callmark, call,		/* function call and argument marker */
  aref, aval			/* array reference */
} etype;

/* semantic expression operators */

typedef enum {
  plus, minus, times, divide, modulo, neg, 
  equal, plusequal, minusequal, timesequal, divideequal,
  bitandequal, bitorequal, bitxorequal, lshiftequal, rshiftequal,
  eequal, nequal, gtequal, ltequal, lessthan, greaterthan, logand, logior, lognot,
  bitior, bitxor, bitand, bitcomp, lshift, rshift,
  float_to_int, float_to_long, int_to_float, int_to_long, long_to_int, long_to_float,
  pointer_to_int, int_to_pointer,
  ssin, scos, stan, ssqrt, satan, slog10, sloge, sexp10, sexpe,
  prntf, mseconds, benchmark, bitset, bitclr, start_process, kill_process
} eop;


/* values */

typedef union {
  Int i;
  long l;
  double d;
  void *p;
} eval;
  


/* semantic expression structure */

typedef struct sexp_str {
  etype exp;			/* what we are */
  eop op;			/* operation */
  eval val;			/* value */
  Type *type;			/* what type we return */
  struct sexp_str *arg1, *arg2;	/* arguments */
  struct sexp_str *next;	/* for a list, if we need it */
} sexp;

/* stack */

extern sexp * sem_stack[];	/* holds pushed s-expressions */
extern int sem_stack_n;		/* pointer */



/* 
 *  Access functions
 */

void bop_sexp(eop op);		/* create it using stack, push it */ 
void assign_sexp(eop op, Int which); /* create it using stack, push it */ 
void asspost_sexp(eop op);	/* create it using stack, push it */ 
void unop_sexp(eop op);		/* create it using stack, push it */
void cast_sexp(Type *type);	/* cast top of stack */
void const_sexp(Type *type, eval val); /* create and push it */
void ref_sexp(Symbol *sym);	/* create and push it */
void val_sexp();		/* dereference */
void peek_sexp(Int size);	/* lookup */
void push_sexp(sexp *exp);
sexp *pop_sexp();
sexp *top_sexp(Int n);		/* return top nth sexp from stack */
void sexp_stack_switch();	/* switches top two entries */
void call_arg_sexp();
void call_sexp(Symbol *sym);
void printf_sexp();		/* expects call marker on sexp stack */
void start_process_sexp();	/* expects two call markers... */
void kill_process_sexp();
void start_procedure_stats();
void report_procedure_stats(Symbol *sym);
char *name_of_eop(eop op);
Int sexp_stack_empty();		/* returns 1 if stack empty */
