/**
 ** spew.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifdef SPEW_MODULE
#include "spew_p.h"
#endif

/*-------------------------------------------------------------------------*/
/* Public Variables                                                        */

extern unsigned char *code;
extern long code_current;
extern Int spew_codegen;
extern Int spew_debug;
extern Int spew_bitbucket_code;
extern char *spew_file_name;
extern Int spew_main;
extern Int spew_msb_first;
extern Int spew_float_type;
extern Int spew_module;
extern Int code_origin;

/*-------------------------------------------------------------------------*/
/* Public Functions Begin                                                  */
void        spew_array_reference(void);
void        spew_begin_array  (Type *array_type, Int write);
void        spew_begin_call   (Symbol *func, Symbol *temp);
void        spew_begin_printf (void);
void        spew_begin_procedure(Symbol *proc);
void        spew_begin_start_process(Symbol *func);
void 	    spew_binary_module (Module *m);
void 	    spew_binary_subroutine_def (Symbol *sym, long addr);
void 	    spew_binary_variable_def (Symbol *sym, long addr);
void        spew_binop        (char op);
void        spew_bit_set_clr  (Opcode op);
void        spew_byte         (Int x);
Type *      spew_check_funcall(Symbol *func);
void        spew_conditional_jump(Opcode op, Symbol *destination);
void        spew_continue_array_float(double d);
void        spew_continue_array_int(Int i);
void        spew_continue_array_long(long l);
void        spew_continue_start_process(Symbol *func);
void        spew_dup          (void);
void        spew_end_array    (Int write);
void        spew_end_call     (Symbol *func, Symbol *temp);
void        spew_end_pass     (void);
void        spew_end_printf   (void);
void        spew_end_procedure(Symbol *proc);
void        spew_end_start_process(Symbol *func);
void        spew_init         (void);
void        spew_jump         (Symbol *destination);
void        spew_kill_process (void);
void        spew_label_definition(Symbol *sym);
void        spew_label_reference(Symbol *sym);
void        spew_op           (Opcode op);
void        spew_peek         (void);
void        spew_poke         (Int pop);
void        spew_pop          (void);
void        spew_pop_op       (Int size);
void        spew_push2        (Int i, Type *t);
void        spew_push_float   (double d);
void        spew_push_garbage (Type *t);
void        spew_push_int     (Int i);
void        spew_push_long    (long l);
void        spew_push_one     (void);
double      spew_read_float   (long board_float);
void        spew_return       (void);
void        spew_set_code_address(long address);
void 	    spew_set_code_origin (long origin);
void 	    spew_skip_garbage (Type *t);
void        spew_speek        (Int stack_index);
void        spew_sprel        (long offset);
void        spew_start_pass   (void);
void        spew_unop         (char op);
void        spew_word         (Int x);
char 	    *opcode_name      (Int op);
void 	    spew_write_word   (long address, Int word);
void 	    spew_write_byte   (long address, Int byte);

/* Public Functions End                                                    */
/*-------------------------------------------------------------------------*/
