/**
 ** spew_p.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/*-------------------------------------------------------------------------*/
/* Private Types                                                           */

typedef struct opdef {
    char    *name;
    Type_id argtype;
    Int     mode;
    char    id;
    Opcode  opcode;
    Int     addr;		/* jumptable address */
} Opdef;

/*-------------------------------------------------------------------------*/
/* Private Constants                                                       */

#define BINOP 1
#define UNOP 2

/*-------------------------------------------------------------------------*/
/* Private Variables                                                       */

Opdef opcodes[]= {
    {"add2"    , int_id, BINOP, '+', -1, 0 /*Padd2*/ },
    {"sub2"    , int_id, BINOP, '-', -1, 0 /*Psub2*/ },
    {"mult2"   , int_id, BINOP, '*', -1, 0 /*Pmult2*/ },
    {"div2"    , int_id, BINOP, '/', -1, 0 /*Pdiv2*/ },
    {"bitand2" , int_id, BINOP, '&', -1, 0 /*Pbitand2*/ },
    {"bitor2"  , int_id, BINOP, '|', -1, 0 /*Pbitor2*/ },
    {"bitxor2" , int_id, BINOP, '^', -1, 0 /*Pbitxor2*/ },
    {"equal2"  , int_id, BINOP, '=', -1, 0 /*Pequal2*/ },
    {"lt2"     , int_id, BINOP, '<', -1, 0 /*Plt2*/ },
    {"gt2"     , int_id, BINOP, '>', -1, 0 /*Pgt2*/ },
    {"lshift"  , int_id, BINOP, 'l', -1, 0 /*Plshift*/ },
    {"lognot2" , int_id, UNOP, '!', -1, 0 /*Plognot2*/ },
    {"logidn2" , int_id, UNOP, '=', -1, 0 /*Plogidn2*/ },
    {"bitnot2" , int_id, UNOP, '~', -1, 0 /*Pbitnot2*/ },
    {"neg2"    , int_id, UNOP, '-', -1, 0 /*Pneg2*/ },
    {"add4"    , long_id, BINOP, '+', -1, 0 /*Padd4*/ },
    {"sub4"    , long_id, BINOP, '-', -1, 0 /*Psub4*/ },
    {"mult4"   , long_id, BINOP, '*', -1, 0 /*Pmult4*/ },
    {"equal4"  , long_id, BINOP, '=', -1, 0 /*Pequal4*/ },
    {"lt4"     , long_id, BINOP, '<', -1, 0 /*Plt4*/ },
    {"gt4"     , long_id, BINOP, '>', -1, 0 /*Pgt4*/ },
    {"neg4"    , long_id, UNOP,  '-', -1, 0 /*Pneg4*/ },
    {"fadd"    , float_id, BINOP, '+', -1, 0 /*Pfadd*/ },
    {"fsub"    , float_id, BINOP, '-', -1, 0 /*Pfsub*/ },
    {"fmult"   , float_id, BINOP, '*', -1, 0 /*Pfmult*/ },
    {"fdiv"    , float_id, BINOP, '/', -1, 0 /*Pfdiv*/ },
    {"fx2y"    , float_id, BINOP, '^', -1, 0 /*Pfx2y*/ },
    {"fequal"  , float_id, BINOP, '=', -1, 0 /*Pfequal*/ },
    {"flt"     , float_id, BINOP, '<', -1, 0 /*Pflt*/ },
    {"fgt"     , float_id, BINOP, '>', -1, 0 /*Pfgt*/ },
    {"fneg"    , float_id, UNOP, '-', -1, 0 /*Pfneg*/ },
    {"fsqrt"   , float_id, UNOP, 'q', -1, 0 /*Pfsqrt*/ },
    {"fexp"    , float_id, UNOP, 'e', -1, 0 /*Pfexp*/ },
    {"f10tx"   , float_id, UNOP, 'E', -1, 0 /*Pf10tx*/ },
    {"fln"     , float_id, UNOP, 'l', -1, 0 /*Pfln*/ },
    {"flog"    , float_id, UNOP, 'L', -1, 0 /*Pflog*/ },
    {"fatan"   , float_id, UNOP, 'a', -1, 0 /*Pfatan*/ },
    {"fsin"    , float_id, UNOP, 's', -1, 0 /*Pfsin*/ },
    {"fcos"    , float_id, UNOP, 'c', -1, 0 /*Pfcos*/ },
    {"ftan"    , float_id, UNOP, 't', -1, 0 /*Pftan*/ },
    {"fl2int" , illegal_id, 0, 0, -1, 0 /*Pfl2int*/ },
    {"int2fl" , illegal_id, 0, 0, -1, 0 /*Pint2fl*/ },
    {"int2lng" , illegal_id, 0, 0, -1, 0 /*Pint2lng*/ },
    {"fl2lng",  illegal_id, 0, 0, -1, 0 /*Pfl2lng*/ },
    {"lng2fl",  illegal_id, 0, 0, -1, 0 /*Plng2fl*/ },
    {"push2"   , illegal_id, 0, 0, -1, 0 /*Ppush2*/ },
    {"push4"   , illegal_id, 0, 0, -1, 0 /*Ppush4*/ },
    {"pushblock", illegal_id, 0, 0, -1, 0 /*Ppushblock*/ },
    {"pop2"    , illegal_id, 0, 0, -1, 0 /*Ppop2*/ },
    {"pop4"    , illegal_id, 0, 0, -1, 0 /*Ppop4*/ },
    {"addsp"   , illegal_id, 0, 0, -1, 0 /*Paddsp*/ },
    {"setsp"   , illegal_id, 0, 0, -1, 0 /*Psetsp*/ },
    {"peeki1"  , illegal_id, 0, 0, -1, 0 /*Ppeeki1*/ },
    {"peeki2"  , illegal_id, 0, 0, -1, 0 /*Ppeeki2*/ },
    {"peeki4"  , illegal_id, 0, 0, -1, 0 /*Ppeeki4*/ },
    {"peek1"   , illegal_id, 0, 0, -1, 0 /*Ppeek1*/ },
    {"peek2"   , illegal_id, 0, 0, -1, 0 /*Ppeek2*/ },
    {"peek4"   , illegal_id, 0, 0, -1, 0 /*Ppeek4*/ },
    {"bitset"  , illegal_id, 0, 0, -1, 0 /*Pbitset*/ },
    {"bitclr"  , illegal_id, 0, 0, -1, 0 /*Pbitclr*/ },
    {"pokei1"  , illegal_id, 0, 0, -1, 0 /*Ppokei1*/ },
    {"pokei2"  , illegal_id, 0, 0, -1, 0 /*Ppokei2*/ },
    {"pokei4"  , illegal_id, 0, 0, -1, 0 /*Ppokei4*/ },
    {"poke1"   , illegal_id, 0, 0, -1, 0 /*Ppoke1*/ },
    {"poke2"   , illegal_id, 0, 0, -1, 0 /*Ppoke2*/ },
    {"poke4"   , illegal_id, 0, 0, -1, 0 /*Ppoke4*/ },
    {"poke1nopop"   , illegal_id, 0, 0, -1, 0 /*Ppoke1nopop*/ },
    {"poke2nopop"   , illegal_id, 0, 0, -1, 0 /*Ppoke2nopop*/ },
    {"poke4nopop"   , illegal_id, 0, 0, -1, 0 /*Ppoke4nopop*/ },
    {"speek2"  , illegal_id, 0, 0, -1, 0 /*Pspeek2*/ },
    {"speek4"  , illegal_id, 0, 0, -1, 0 /*Pspeek4*/ },
    {"spoke2"  , illegal_id, 0, 0, -1, 0 /*Pspoke2*/ },
    {"spoke4"  , illegal_id, 0, 0, -1, 0 /*Pspoke4*/ },
    {"sprel"   , illegal_id, 0, 0, -1, 0 /*Psprel*/ },
    {"checkstack", illegal_id, 0, 0, -1, 0 /*Pcheckstack*/ },
    {"aref1"   , illegal_id, 0, 0, -1, 0 /*Paref1*/ },
    {"aref2"   , illegal_id, 0, 0, -1, 0 /*Paref2*/ },
    {"aref4"   , illegal_id, 0, 0, -1, 0 /*Paref4*/ },
    {"aref_arb", illegal_id, 0, 0, -1, 0 /*Paref_arb*/},
    {"jump"    , illegal_id, 0, 0, -1, 0 /*Pjump*/ },
    {"jumpi"   , illegal_id, 0, 0, -1, 0 /*Pjumpi*/ },
    {"jfalse"  , illegal_id, 0, 0, -1, 0 /*Pjfalse*/ },
    {"jtrue"   , illegal_id, 0, 0, -1, 0 /*Pjtrue*/ },
    {"jpfalse" , illegal_id, 0, 0, -1, 0 /*Pjpfalse*/ },
    {"jptrue"  , illegal_id, 0, 0, -1, 0 /*Pjptrue*/ },
    {"mret0"   , illegal_id, 0, 0, -1, 0 /*Pmret0*/ },
    {"mret2"   , illegal_id, 0, 0, -1, 0 /*Pmret2*/ },
    {"mret4"   , illegal_id, 0, 0, -1, 0 /*Pmret4*/ },
    {"fl2ascii", illegal_id, 0, 0, -1, 0 /*Pfl2ascii*/ },
    {"print2"  , illegal_id, 0, 0, -1, 0 /*Pprintlcd2*/ },
    {"printf"  , illegal_id, 0, 0, -1, 0 /*Pprintf*/ },
    {"printstr", illegal_id, 0, 0, -1, 0 /*Pprintstring*/ },
    {"printchar",illegal_id, 0, 0, -1, 0 /*Pprintchar*/ },
    {"startproc", illegal_id, 0, 0, -1, 0 /*Pstartprocess*/ },
    {"killproc", illegal_id, 0, 0, -1, 0 /*Pkillprocess*/ },
    {"haltnotify", illegal_id, 0, 0, -1, 0 /*Phaltnotify*/ },
    {"defer",   illegal_id, 0, 0, -1, 0 /*Pdefer*/ },
    {"systime", illegal_id, 0, 0, -1, 0 /*Psystime*/ },
    {"loadreg", illegal_id, 0, 0, -1, 0 /*Ploadreg*/ },
    {"fetchreg", illegal_id, 0, 0, -1, 0 /*Pfetchreg*/ },
    {"callml",  illegal_id, 0, 0, -1, 0 /*Pcallml*/ },
    {"bench", illegal_id, 0, 0, -1, 0 /*Pbench*/ },
    {"initint", illegal_id, 0, 0, -1, 0 /*Pinitint*/ },
    {"native",  illegal_id, 0, 0, -1, 0 /*Pnative*/ },

    {0,illegal_id,0,0,0,0 /*Pundefined*/ }
};

