/*
 *  Tests data types, type promotion, constant reduction,
 *  constant pointers, procedure returns, and other stuff 
 */

int a = 12;

native void d0() { return; }

native int d1() { return a; }

native int d2(int x) { a = x; return x; }

native void d3(int x) { a = x; }

native int d4(int x) { a = x; }

int *aa = 0x200;
char *c1 = 0x10;
char *c2 = 0x11;

int *MSHI = 0x12;
int *MSLO = 0x14;
long *MS  = 0x12;

native int d5() { return *MSHI; } 
native int d6() { return 1+*MSHI; } 
int d7() { return 1+*MSHI; }

const int *mshi = 0x12;
const int *mslo = 0x14;

native int d8() { return *mshi; } 
native int d9() { return 1+*mshi; } 
int d10() { return 1+*mshi; }


native int d11() { if (*mshi) return 1; else return 0; }
int d11b() { if (*mshi) return 1; else return 0; }

const int *TCNT = 0x100e;
const int b = 200;
const int *bb = 0x200;
native void d12() { *bb = *TCNT + b; }

native int time1(int n)		/* 11 usecs/loop (4MHz) */
{
  int a, b;

  a = *MSLO;
  while(--n)
    *bb += *TCNT;
  b = *MSLO;
  return b-a;
}

int time1b(int n)		/* 291 usecs/loop (4MHz) */
{
  int a, b;

  a = *MSLO;
  while(--n)
    *bb += *TCNT;
  b = *MSLO;
  return b-a;
}


float fa = 0.0;

native float d13() { return fa; }
native float d14(float x) { return fa+x; }


native int time2(int n)		/* 218 usecs/loop (4MHz) */
{
  int a, b;

  a = *MSLO;
  while(--n)
    fa = fa + (1.0*fa);
  b = *MSLO;
  return b-a;
}

int time2b(int n)		/* 469 usecs/loop (4MHz) */
{				/* Subtracting loop time, it's 251 usecs */
  int a, b;

  a = *MSLO;
  while(--n)
    fa = fa + (1.0*fa);
  b = *MSLO;
  return b-a;
}

native float d15(float n)	/* note type promotion */
{
  return 2*n*n + n/3;
}

float d15b(float n)		/* note type promotion */
{
  return 2*n*n + n/3;
}

native float d16(float n)
{
  return n/3;
}


/* LONGs */

long la;

/* NB:  INT -> LONG doesn't get sign extension...my fix barfed  */

native long d17(int n)
{
  return la + n*la;
}

long d17b(int n)
{
  return la + n*la;
}


/* Some unary operations */

native int d18(int n)
{
  return ~n;
}

native int d19(int n)
{
  return -n;
}

native int d20(int n)
{
  return !n;
}


/* Mixed arithmetic */

native int d21(int n)
{
  return n*n + n/a - a*(n+n);
}

int d21b(int n)
{
  return n*n + n/a - a*(n+n);
}

/* Bit operations */

native int d22(int n)
{
  return a & n;
}

native int d23(int n, int m)
{
  return m | n;
}

native int d24(int n, int m)
{
  return m ^ n;
}

/* Comparison operations */

native int d25(int n)
{
  if (n) return 1; else return 0;
}

native int d25a(int n, int m)
{
  if (n > m) return 1; else return 0;
}

native int d25b(int n, int m)
{
  if ((n*1) < m) return 1; else return 0;
}

native int d25c(int n, int m)
{
  if (n >= (m*1)) return 1; else return 0;
}

native int d25f(int n, int m)
{
  if (n > (m*1)) return 1; else return 0;
}

native int d25d(int n, int m)
{
  if ((n*1) <= (m*1)) return 1; else return 0;
}

native int d25e(int n, int m)
{
  if (n <= m) return 1; else return 0;
}

native int d26a(int n, int m)
{
  return n != m;
}

native int d26b(int n, int m)
{
  return n > m;
}

native int d26c(int n)
{
  return n > 0;
}


/* Logical operations */

native int d27a(int n, int m)
{
  if (n > m && n > 0) return 1; else return 0;
}

native int d27b(int n, int m)
{
  if (n > m || n > 0) return 1; else return 0;
}
