/**
 ** type.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/*-------------------------------------------------------------------------*/
/* Public types                                                            */
   		
typedef enum {
    illegal_id= 0,
    void_id,
    char_id,
    int_id,
    long_id,
    float_id,
    string_id,
    array_id,
    pointer_id,
    func_id,
    label_id,
    char_constant_id,
    int_constant_id,
    float_constant_id,
    undef_id,
    block_id,
    abstract_declarator_id
  } Type_id;

typedef enum {
    pcode_calling_convention= 1,
    ml_calling_convention
  } Calling_convention;

/*-------------------------------------------------------------------------*/
/* Hidden Public types                                                     */

#ifdef TYPE_MODULE
#include "type_p.h"
#else

typedef union type_union Type;

#endif

#include "type.pro"

#define integerp(x) (type_id(x) == int_id)
#define undefp(x) (type_id(x) == undef_id)
#define floatp(x) (type_id(x) == float_id)


