/**
 ** type_p.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/*-------------------------------------------------------------------------*/
/* Private types                                                           */

/*******/
/* Any */
/*******/

typedef struct {
    Type_id type_id;
} Any_type;

/********/
/* Void */
/********/

typedef struct {
    Type_id type_id;
} Void_type;

/*************/
/* Character */
/*************/

typedef struct {
    Type_id type_id;
} Char_type;

/***********/
/* Integer */
/***********/

typedef struct {
    Type_id type_id;
} Int_type;

/********/
/* Long */
/********/

typedef struct {
    Type_id type_id;
} Long_type;

/*************************/
/* Floating point number */
/*************************/

typedef struct {
    Type_id type_id;
} Float_type;

/*********/
/* Array */
/*********/

typedef struct {
    Type_id          type_id;
    Int              size;
    union type_union *elemtype;
} Array_type;

/***********/
/* Pointer */
/***********/

typedef struct {
    Type_id          type_id;
    union type_union *type;
} Pointer_type;

/************/
/* Function */
/************/

typedef struct func_arg_str {
    union type_union   *type;
    Symbol             *name;
} Func_arg;

typedef struct {
    Type_id            type_id;
    Calling_convention calling_convention;
    union type_union   *return_type;
    Int                number_args;
    Func_arg           argument[1];
} Func_type;

/*********/
/* Label */
/*********/

typedef struct {
    Type_id type_id;
} Label_type;

/********************/
/* Integer Constant */
/********************/

typedef struct {
    Type_id type_id;
    Int     value;
} Int_constant_type;

/***************************/
/* Floating Point Constant */
/***************************/

typedef struct {
    Type_id type_id;
    double  value;
} Float_constant_type;

/*********/
/* Block */
/*********/

typedef struct {
    Type_id type_id;
} Block_type;

/*********/
/* Undef */
/*********/

typedef struct {
    Type_id type_id;
} Undef_type;

/***********************/
/* Abstract_declarator */
/***********************/

typedef struct {
    Type_id type_id;
    Symbol  *symbol;
} Abstract_declarator_type;

/********/
/* Type */
/********/

typedef union type_union {
    Any_type             Any;
    Void_type            Void;
    Char_type            Char;
    Int_type             Integer;
    Float_type           Float;
    Array_type           Array;
    Pointer_type         Pointer;
    Func_type            Func;
    Label_type           Label;
    Int_constant_type    Int_constant;
    Float_constant_type  Float_constant;
    Block_type           Block;
    Undef_type           Undef;
    Abstract_declarator_type Abstract_declarator;
} Type;

/*-------------------------------------------------------------------------*/
/* Private Macros                                                          */
		
#define TYPE_ID(type) ((type)->Any.type_id)


