/**
 ** binrec.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG
#include "util.h"

#include "binrec.h"

Int binrec_debug= 0;

Binrec *binrec_create(long addr, long len)
{
    Binrec *ret;
    ret= malloc(sizeof(Binrec));
    if (ret) {
	ret->addr= addr;
	ret->len= len;
	ret->data= malloc((size_t) (len ? len : 1));
	if (!ret->data) return NULL;
	if (binrec_debug) {
	    printf("Binrec %lx: addr %lx, len %ld\n",
		   (long) ret, (long) ret->addr, ret->len);
	}
    }
    return ret;
}

void binrec_destroy(Binrec *r)
{
    free(r->data);
    r->data= NULL;
    free(r);
}

/* Are a and b contiguous when concatenated? */
Int binrec_can_concat(Binrec *a, Binrec *b)
{
    return !a->len || ((a->addr + a->len) == b->addr);
}

Binrec *binrec_concat(Binrec *a, Binrec *b)
{
    Binrec *ret;
    if (!binrec_can_concat(a,b)) die(("Non-contiguous binrecs in concat"));
    ret= binrec_create(a->len ? a->addr : b->addr, a->len + b->len);
    memcpy(ret->data, a->data, (size_t) a->len);
    memcpy(ret->data + a->len, b->data, (size_t) b->len);
    if (binrec_debug) {
	printf("Binrec_concat %lx: addr %lx, len %ld\n",
	       (long) ret, ret->addr, ret->len);
    }
    return ret;
}
