/**
 ** boardsim.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG

#define BOARDSIM 1

#if BOARDSIM

#include <util.h>
#include <iob.h>
#include <board.h>
#include <pcodesim.h>

#include "boardsim.h"

Int boardsim_read_mem(Int address)
{
    Int data= (uchar) MEM1(address);
    if (board_debug) printf("read1 from %04lX is %02lX\n", address, data);
    return data;
}

Int boardsim_read_mem_word(Int address)
{
    Int data= (unsigned) MEM2(address);
    if (board_debug) printf("read2 from %04lX is %04lX\n", address, data);
    return data & 0xffff;
}

long boardsim_read_mem_long(Int address)
{
    long data= (unsigned) MEM4(address);
    if (board_debug) printf("read4 from %04lX is %08lX\n", address, data);
    return data;
}

void boardsim_write_ram(Int address, Int data)
{
    if (board_debug) printf("write1 %02lX to %04lX\n", data, address);
    SET_MEM1(address, (char) data);
}

void boardsim_write_ram_word(Int address, Int data)
{
    if (board_debug) printf("write2 %04lX to %04lX\n", data, address);
    SET_MEM2(address, data);
}
    
void boardsim_clear_and_set_ram(Int address, Int clear, Int set)
{
    SET_MEM1(address, (char) (((Int)MEM1(address)) & ~clear) | set);
}

Int boardsim_process_wait(void)
{
    Int c;
    pcodesim_wakeup();
    while (1) {
	if (pcodesim_execute_some()) return 1;
	c= io_getchar(keyboard_stream, 0);
	if (c >= 0) {
	    if (c == '\n' || c == '\r') return 0;
	    else printf("Press <return> to stop\n");
	}
    }
}

void boardsim_push_pstack(Int data)
{
    Int sp;
    sp= boardsim_read_mem_word(0xfc);
    sp -= 2;
    boardsim_write_ram_word(sp, data);
    boardsim_write_ram_word(0xfc, sp);
}
    
void boardsim_download_block(Int start, Int len, unsigned char *data)
{
    Int i;
    if (board_debug) printf("[");
    for (i= 0; i< len; i++) {
	if (board_debug) printf("%02X ", data[i]);
	SET_MEM1(start+i, data[i]);
    }
}

void boardsim_download(Int start, Int len, unsigned char *data, Int display)
{
    boardsim_download_block(start, len, data);
    if (display) printf("Downloaded %ld bytes (addresses %04lX-%04lX)\n",
			len, start, start + len - 1);
}

void boardsim_reset(Int first_time)
{
    UNUSED(first_time);
    pcodesim_reset();
}

void boardsim_get_version(Int *major, Int *minor)
{
    *major= pcodesim_major_version;
    *minor= pcodesim_minor_version;
}

Int boardsim_get_msb_first(void)
{
#ifdef ODD_ADDRESSES_OK    
    Int i= 1;
    return ! (Int) * (char*) &i;
#else
    return 1;
#endif    
}

Int boardsim_get_float_type(void)
{
    return float_native;
}

#endif
