/**
 ** confexec.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#ifndef CONFEXEC_H
#define CONFEXEC_H

#include <table.h>

/* Configure an executable */


/* Change CONFIGURE_PREFIX_STRLEN if you change the following! */
/* Don't make beginning of string a substring of the middle of the string.
   This way a simpler string search will suffice. */
#define CONFIGURE_PREFIX1 "#CONFIGU"
#define CONFIGURE_PREFIX2 "RATION#"
/* had better be strlen(prefix1)+strlen(prefix2) */
#define CONFIGURE_PREFIX_STRLEN 15

#define CONFIGURE_PADDING "                                                                                  "

#define MAKE_CONFIGURATION(string, descr) \
  "#CONFIGURATION#" string "\000" CONFIGURE_PADDING "\000" descr

#define GET_CONFIGURATION(conf) (conf + CONFIGURE_PREFIX_STRLEN)

#include "confexec.pro"

#endif /* #ifndef CONFEXEC_H */
